/*
 * Decompiled with CFR 0.152.
 */
package com.mna.api.entities.construct.ai.parameter;

import com.mna.api.blocks.DirectionalPoint;
import com.mna.api.entities.construct.ai.parameter.ConstructAITaskParameter;
import com.mna.api.entities.construct.ai.parameter.ConstructParameterTypes;
import com.mojang.datafixers.util.Pair;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.phys.AABB;

public class ConstructTaskAreaParameter
extends ConstructAITaskParameter {
    private AABB area;
    private Pair<DirectionalPoint, DirectionalPoint> points;

    public ConstructTaskAreaParameter(String id) {
        super(id, ConstructParameterTypes.AREA);
    }

    public AABB getArea() {
        return this.area;
    }

    public Pair<DirectionalPoint, DirectionalPoint> getPoints() {
        return this.points;
    }

    public void setPoints(DirectionalPoint firstCorner, DirectionalPoint secondCorner) {
        this.points = new Pair((Object)firstCorner, (Object)secondCorner);
        this.createInclusiveAABB();
    }

    private void createInclusiveAABB() {
        if (this.points != null && this.points.getFirst() != null && this.points.getSecond() != null) {
            this.area = new AABB(((DirectionalPoint)this.points.getFirst()).getPosition(), ((DirectionalPoint)this.points.getSecond()).getPosition()).m_82363_(1.0, 1.0, 1.0);
        }
    }

    @Override
    public void loadData(CompoundTag nbt) {
        super.loadData(nbt);
        DirectionalPoint first = null;
        DirectionalPoint second = null;
        if (nbt.m_128441_("firstPoint")) {
            first = DirectionalPoint.of(nbt.m_128469_("firstPoint"));
        }
        if (nbt.m_128441_("secondPoint")) {
            second = DirectionalPoint.of(nbt.m_128469_("secondPoint"));
        }
        this.points = new Pair((Object)first, (Object)second);
        if (first != null && second != null) {
            this.createInclusiveAABB();
        }
    }

    @Override
    public CompoundTag saveData() {
        CompoundTag tag = super.saveData();
        if (this.points != null) {
            if (this.points.getFirst() != null) {
                tag.m_128365_("firstPoint", (Tag)((DirectionalPoint)this.points.getFirst()).save());
            }
            if (this.points.getSecond() != null) {
                tag.m_128365_("secondPoint", (Tag)((DirectionalPoint)this.points.getSecond()).save());
            }
        }
        return tag;
    }
}

