/*
 * Decompiled with CFR 0.152.
 */
package com.mna.api.blocks.tile.pylon;

import com.mna.api.ManaAndArtificeMod;
import com.mna.api.affinity.Affinity;
import com.mna.api.blocks.PlayerOwnershipRecord;
import com.mna.api.blocks.PylonBlock;
import com.mna.api.blocks.tile.IEldrinConsumerTile;
import com.mna.api.blocks.tile.IPowerRequestStatus;
import com.mna.api.blocks.tile.PowerStatus;
import com.mna.api.blocks.tile.TileEntityWithInventory;
import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.faction.IFaction;
import com.mna.api.gui.ContainerPylon;
import com.mna.api.items.IPositionalItem;
import com.mna.tools.math.MathUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public abstract class PylonTileBase
extends TileEntityWithInventory
implements IEldrinConsumerTile,
IPowerRequestStatus,
MenuProvider {
    public static final HashMap<Character, Integer> lookup = new HashMap();
    public static final int DEFAULT_MAX_BLOCKS_VISITED_PER_TICK = 50;
    public static final int DEFAULT_INVENTORY_SIZE = 2;
    public static final int MAX_RADIUS = 128;
    public static final int MIN_RADIUS = 1;
    protected final int powerUpTicksRequired = 60;
    private AABB currentAffectedArea;
    private PlayerOwnershipRecord owner;
    private BlockPos lastSearchPos;
    private HashMap<Affinity, Float> consumptionAccumulation;
    private HashMap<Affinity, PowerStatus> consumptionStatus;
    private int[] runeword = new int[0];
    private int clearHeightAbove = -1;
    private boolean factionOnly = false;
    protected int powerUpTicks = 0;
    protected float powerMultiplier = 1.0f;
    protected boolean active = false;
    protected boolean isRedstonePowered;
    protected int radius = 32;
    protected int[] color;
    protected boolean mapMakerMode = false;
    protected String errorMessage = null;

    public PylonTileBase(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState, 2);
        this.consumptionAccumulation = new HashMap();
        this.consumptionStatus = new HashMap();
        for (Affinity aff : Affinity.CoreSix()) {
            this.consumptionAccumulation.put(aff, Float.valueOf(0.0f));
            this.consumptionStatus.put(aff, PowerStatus.NOT_REQUESTING);
        }
        this.owner = PlayerOwnershipRecord.of((Player)null);
    }

    public AABB getBounds() {
        if (this.currentAffectedArea == null) {
            this.lastSearchPos = null;
            AABB runeBounds = this.getBoundsFromRunes();
            this.currentAffectedArea = runeBounds == null ? new AABB(this.m_58899_()).m_82400_((double)this.radius) : runeBounds;
            double avgSize = this.currentAffectedArea.m_82309_() / 2.0;
            int factor = (int)Math.floor(avgSize / 16.0);
            this.powerMultiplier = Math.max(0.5f * (float)factor, 0.5f);
            this.onBoundsChanged();
            this.syncAndSave();
        }
        return this.currentAffectedArea;
    }

    public int getClearHeightAbove() {
        return this.clearHeightAbove;
    }

    @Nullable
    public int[] getColor() {
        return this.color;
    }

    @Nullable
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public final int[] getRuneword() {
        return this.runeword;
    }

    protected final PlayerOwnershipRecord getOwnershipData() {
        return this.owner;
    }

    protected PylonBlock getBlock() {
        return (PylonBlock)this.m_58900_().m_60734_();
    }

    protected HashMap<Affinity, Float> getPowerConsumption() {
        HashMap<Affinity, Float> basePowerConsumption = this.getBlock().getPowerConsumption();
        HashMap<Affinity, Float> multipliedPowerConsumption = new HashMap<Affinity, Float>();
        for (Map.Entry<Affinity, Float> entry : basePowerConsumption.entrySet()) {
            multipliedPowerConsumption.put(entry.getKey(), Float.valueOf(entry.getValue().floatValue() * this.powerMultiplier));
        }
        return multipliedPowerConsumption;
    }

    public float getPowerRequestRate(Affinity aff) {
        return this.getBlock().getPowerConsumption().getOrDefault((Object)aff, Float.valueOf(0.0f)).floatValue() * this.powerMultiplier * 20.0f;
    }

    public float getPowerMultiplier() {
        return this.powerMultiplier;
    }

    public int getRadius() {
        return this.radius;
    }

    @Nullable
    private AABB getBoundsFromRunes() {
        this.errorMessage = null;
        Item item = this.m_8020_(0).m_41720_();
        if (item instanceof IPositionalItem) {
            IPositionalItem p1 = (IPositionalItem)item;
            item = this.m_8020_(1).m_41720_();
            if (item instanceof IPositionalItem) {
                IPositionalItem p2 = (IPositionalItem)item;
                BlockPos a = p1.getLocation(this.m_8020_(0));
                BlockPos b = p2.getLocation(this.m_8020_(1));
                if (a != null && b != null) {
                    AABB runeBounds = MathUtils.createInclusiveBB(a, b);
                    if (!runeBounds.m_82390_(Vec3.m_82512_((Vec3i)this.m_58899_()))) {
                        this.errorMessage = "gui.mna.pylon.not_in_bounds";
                    } else if (runeBounds.m_82362_() < 1.0 || runeBounds.m_82376_() < 1.0 || runeBounds.m_82385_() < 1.0) {
                        this.errorMessage = "gui.mna.pylon.bounds_too_small";
                    } else if (runeBounds.m_82362_() > 128.0 || runeBounds.m_82376_() > 128.0 || runeBounds.m_82385_() > 128.0) {
                        this.errorMessage = "gui.mna.pylon.bounds_too_large";
                    } else {
                        return runeBounds;
                    }
                }
            }
        }
        return null;
    }

    public boolean isRadiusUsed() {
        return this.getBoundsFromRunes() == null;
    }

    public float getPowerupPct(float partialTick) {
        float f = this.powerUpTicks;
        Objects.requireNonNull(this);
        return f / 60.0f;
    }

    public final boolean isRedstonePowered() {
        return this.isRedstonePowered;
    }

    public final boolean isFactionOnly() {
        return this.factionOnly;
    }

    public abstract ResourceLocation getIcon();

    public String getFactionCheckboxTooltip() {
        return "gui.mna.pylon.faction_only";
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_()).m_82363_(0.0, (double)this.clearHeightAbove, 0.0);
    }

    public HashMap<Affinity, PowerStatus> powerRequirementStatus() {
        return this.consumptionStatus;
    }

    public void setOwner(Player owner) {
        this.owner = PlayerOwnershipRecord.of(owner);
    }

    public final void setRuneword(String runeword) {
        runeword = runeword.toLowerCase();
        ArrayList<Integer> runes = new ArrayList<Integer>();
        for (int i = 0; i < runeword.length(); ++i) {
            Integer val = lookup.get(Character.valueOf(runeword.charAt(i)));
            if (val != null) {
                runes.add(val);
                continue;
            }
            runes.add(-1);
        }
        int count = 0;
        this.runeword = new int[runes.size()];
        Iterator iterator = runes.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            this.runeword[count++] = i;
        }
    }

    public void setColor(int[] color) {
        if (color != null && this.color != null && color[0] == this.color[0] && color[1] == this.color[1] && color[2] == this.color[2]) {
            this.color = null;
            this.syncAndSave();
            return;
        }
        this.color = color;
        this.syncAndSave();
    }

    public void setRadius(int radius) {
        if (this.radius != (radius = Math.min(Math.max(radius, 1), 128))) {
            this.radius = radius;
            if (this.isRadiusUsed()) {
                this.recalculateBounds();
            }
            if (!this.f_58857_.f_46443_) {
                this.syncAndSave();
            }
        }
    }

    @Override
    public void m_6836_(int index, ItemStack stack) {
        super.m_6836_(index, stack);
        this.recalculateBounds();
    }

    public void setMapMakerMode() {
        this.mapMakerMode = true;
        for (Affinity key : this.consumptionStatus.keySet()) {
            this.consumptionStatus.put(key, PowerStatus.NOT_REQUESTING);
        }
        this.owner = PlayerOwnershipRecord.of((Player)null);
    }

    protected void recalculateClearHeightAbove() {
        int count = 0;
        BlockPos bp = this.m_58899_().m_6630_(3);
        while (count++ < 15 && this.f_58857_.m_8055_(bp).m_60795_()) {
            bp = bp.m_7494_();
        }
        this.clearHeightAbove = count;
    }

    protected boolean tick() {
        boolean wasRedstonePowered = this.isRedstonePowered;
        boolean bl = this.isRedstonePowered = this.f_58857_.m_277086_(this.m_58899_()) > 0;
        if (!wasRedstonePowered && this.isRedstonePowered) {
            for (Affinity key : this.consumptionStatus.keySet()) {
                this.consumptionStatus.put(key, PowerStatus.NOT_REQUESTING);
            }
        }
        if (this.f_58857_.m_5776_()) {
            if (this.clearHeightAbove == -1 || this.f_58857_.m_46467_() % 200L == 0L) {
                this.recalculateClearHeightAbove();
            }
            return false;
        }
        if (this.isRedstonePowered) {
            if (this.powerUpTicks > 0) {
                this.active = false;
                --this.powerUpTicks;
                this.syncAndSave();
            }
            return false;
        }
        if (this.mapMakerMode) {
            this.active = true;
            if (this.powerUpTicks < this.powerUpTicksRequired) {
                ++this.powerUpTicks;
                this.syncAndSave();
            }
            return true;
        }
        if (this.owner == null) {
            return false;
        }
        BlockPos bp = this.m_58899_();
        Vec3 centerVec = Vec3.m_82512_((Vec3i)bp);
        boolean fullConsume = true;
        boolean needsSync = false;
        HashMap<Affinity, Float> powerRequired = this.getPowerConsumption();
        for (Map.Entry<Affinity, Float> entry : powerRequired.entrySet()) {
            if (this.consumptionAccumulation.get((Object)entry.getKey()).floatValue() >= entry.getValue().floatValue()) continue;
            float consumed = this.consume(this.owner, this.m_58904_(), bp, centerVec, entry.getKey(), entry.getValue().floatValue());
            float currentConsumption = this.consumptionAccumulation.get((Object)entry.getKey()).floatValue();
            float newConsumption = currentConsumption + consumed;
            if (newConsumption > 0.0f) {
                this.consumptionAccumulation.put(entry.getKey(), Float.valueOf(newConsumption));
            }
            PowerStatus consumptionStat = this.calculatePowerStatus(entry.getValue().floatValue(), newConsumption);
            if (this.consumptionStatus.get((Object)entry.getKey()) != consumptionStat) {
                this.consumptionStatus.put(entry.getKey(), consumptionStat);
                needsSync = true;
            }
            if (!(newConsumption < entry.getValue().floatValue())) continue;
            fullConsume = false;
        }
        if (fullConsume) {
            for (Map.Entry<Affinity, Float> entry : powerRequired.entrySet()) {
                float current = this.consumptionAccumulation.get((Object)entry.getKey()).floatValue();
                if ((current -= entry.getValue().floatValue()) < 0.0f) {
                    current = 0.0f;
                }
                this.consumptionAccumulation.put(entry.getKey(), Float.valueOf(current));
            }
            this.active = true;
            if (this.powerUpTicks < this.powerUpTicksRequired) {
                ++this.powerUpTicks;
                needsSync = true;
            }
        } else if (this.powerUpTicks > 0) {
            this.active = false;
            --this.powerUpTicks;
            needsSync = true;
        }
        if (needsSync) {
            this.syncAndSave();
        }
        return fullConsume;
    }

    protected void forAllPlayers(boolean requireLoS, Consumer<Player> consumer) {
        Vec3 origin = Vec3.m_82512_((Vec3i)this.m_58899_());
        AABB bounds = this.getBounds();
        this.f_58857_.m_6907_().stream().filter(p -> {
            Vec3 pPos;
            Vec3 originOffset;
            ClipContext cc;
            BlockHitResult bhr;
            if (!bounds.m_82381_(p.m_20191_())) {
                return false;
            }
            if (requireLoS && (bhr = this.f_58857_.m_45547_(cc = new ClipContext(originOffset = origin.m_82549_((pPos = p.m_146892_()).m_82546_(origin).m_82541_()), pPos, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)p))).m_6662_() != HitResult.Type.MISS) {
                return false;
            }
            if (this.isFactionOnly()) {
                IPlayerProgression progression = (IPlayerProgression)p.getCapability(ManaAndArtificeMod.getProgressionCapability()).orElse(null);
                if (progression == null) {
                    return false;
                }
                IFaction tileFaction = this.getOwnershipData().getFaction();
                IFaction playerFaction = progression.getAlliedFaction();
                if (tileFaction != null) {
                    if (playerFaction == null) {
                        return false;
                    }
                    if (!tileFaction.isAlliedTo(playerFaction)) {
                        return false;
                    }
                }
            }
            return true;
        }).forEach(consumer);
    }

    protected boolean forAllBlocks(int maxBlocksCheckedPerTick, BiConsumer<BlockPos, BlockState> consumer) {
        if (consumer == null) {
            return true;
        }
        AABB searchArea = this.getBounds();
        if (searchArea == null) {
            return true;
        }
        if (this.lastSearchPos == null) {
            this.lastSearchPos = new BlockPos((int)searchArea.f_82288_, (int)searchArea.f_82289_, (int)searchArea.f_82290_);
        }
        int x = this.lastSearchPos.m_123341_();
        int y = this.lastSearchPos.m_123342_();
        int z = this.lastSearchPos.m_123343_();
        int count = 0;
        while ((double)x <= searchArea.f_82291_) {
            while ((double)y <= searchArea.f_82292_) {
                while ((double)z <= searchArea.f_82293_) {
                    BlockPos curSearch = new BlockPos(x, y, z);
                    if (!curSearch.equals((Object)this.m_58899_())) {
                        if (this.m_58904_().m_46749_(curSearch)) {
                            consumer.accept(curSearch, this.f_58857_.m_8055_(curSearch));
                        }
                        if (++count >= maxBlocksCheckedPerTick) {
                            this.lastSearchPos = new BlockPos(x, y, z);
                            return false;
                        }
                    }
                    ++z;
                }
                z = (int)searchArea.f_82290_;
                ++y;
            }
            y = (int)searchArea.f_82289_;
            ++x;
        }
        this.lastSearchPos = null;
        return true;
    }

    public final void setFactionOnly(boolean factionOnly) {
        if (this.factionOnly != factionOnly) {
            this.factionOnly = factionOnly;
            if (!this.f_58857_.f_46443_) {
                this.syncAndSave();
            }
            this.onFactionOnlyChanged();
        }
    }

    private final void recalculateBounds() {
        this.currentAffectedArea = null;
        this.currentAffectedArea = this.getBounds();
    }

    protected void onBoundsChanged() {
    }

    protected void onFactionOnlyChanged() {
    }

    public final void syncAndSave() {
        if (!this.m_58904_().m_5776_()) {
            this.m_6596_();
            this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, be -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("powerLevel", this.powerUpTicks);
            tag.m_128405_("radius", this.radius);
            tag.m_128350_("powerMult", this.powerMultiplier);
            tag.m_128379_("active", this.active);
            tag.m_128379_("factionOnly", this.factionOnly);
            if (this.errorMessage != null) {
                tag.m_128359_("errorMessage", this.errorMessage);
            }
            if (this.color != null) {
                tag.m_128385_("color", this.color);
            }
            this.writePowerConsumeStatus(tag, this.consumptionStatus);
            return tag;
        });
    }

    public CompoundTag m_5995_() {
        CompoundTag base = super.m_5995_();
        base.m_128405_("powerLevel", this.powerUpTicks);
        base.m_128405_("radius", this.radius);
        base.m_128350_("powerMult", this.powerMultiplier);
        base.m_128379_("active", this.active);
        base.m_128379_("factionOnly", this.factionOnly);
        base.m_128385_("runeword", this.runeword);
        if (this.errorMessage != null) {
            base.m_128359_("errorMessage", this.errorMessage);
        }
        if (this.color != null) {
            base.m_128385_("color", this.color);
        }
        this.writePowerConsumeStatus(base, this.consumptionStatus);
        return base;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.powerUpTicks = tag.m_128451_("powerLevel");
        this.active = tag.m_128471_("active");
        this.powerMultiplier = tag.m_128457_("powerMult");
        this.factionOnly = tag.m_128471_("factionOnly");
        this.runeword = tag.m_128465_("runeword");
        this.radius = tag.m_128451_("radius");
        this.color = (int[])(tag.m_128441_("color") ? tag.m_128465_("color") : null);
        this.errorMessage = tag.m_128441_("errorMessage") ? tag.m_128461_("errorMessage") : null;
        this.readPowerConsumeStatusList(tag, this.consumptionStatus);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        this.powerUpTicks = tag.m_128451_("powerLevel");
        this.powerMultiplier = tag.m_128457_("powerMult");
        this.active = tag.m_128471_("active");
        this.radius = tag.m_128451_("radius");
        this.factionOnly = tag.m_128471_("factionOnly");
        this.color = (int[])(tag.m_128441_("color") ? tag.m_128465_("color") : null);
        this.errorMessage = tag.m_128441_("errorMessage") ? tag.m_128461_("errorMessage") : null;
        this.readPowerConsumeStatusList(tag, this.consumptionStatus);
    }

    @Override
    public void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("owner_data", (Tag)this.owner.save(this.m_58904_()));
        pTag.m_128385_("runeword", this.runeword);
        pTag.m_128405_("radius", this.radius);
        pTag.m_128405_("powerLevel", this.powerUpTicks);
        pTag.m_128379_("active", this.active);
        pTag.m_128379_("factionOnly", this.factionOnly);
        if (this.color != null) {
            pTag.m_128385_("color", this.color);
        }
        pTag.m_128379_("mapMakerMode", this.mapMakerMode);
    }

    @Override
    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.owner = PlayerOwnershipRecord.of(pTag.m_128469_("owner_data"));
        this.runeword = pTag.m_128465_("runeword");
        this.powerUpTicks = pTag.m_128451_("powerLevel");
        this.active = pTag.m_128471_("active");
        this.factionOnly = pTag.m_128471_("factionOnly");
        this.radius = pTag.m_128451_("radius");
        if (this.color != null) {
            this.color = pTag.m_128465_("color");
        }
        this.mapMakerMode = pTag.m_128471_("mapMakerMode");
        if (this.mapMakerMode) {
            for (Affinity key : this.consumptionStatus.keySet()) {
                this.consumptionStatus.put(key, PowerStatus.NOT_REQUESTING);
            }
        }
    }

    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new ContainerPylon(pContainerId, pPlayerInventory, this);
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"");
    }

    static {
        lookup.put(Character.valueOf(' '), -1);
        lookup.put(Character.valueOf('a'), 0);
        lookup.put(Character.valueOf('b'), 1);
        lookup.put(Character.valueOf('c'), 2);
        lookup.put(Character.valueOf('d'), 17);
        lookup.put(Character.valueOf('e'), 4);
        lookup.put(Character.valueOf('f'), 5);
        lookup.put(Character.valueOf('g'), 6);
        lookup.put(Character.valueOf('h'), 7);
        lookup.put(Character.valueOf('i'), 8);
        lookup.put(Character.valueOf('j'), 22);
        lookup.put(Character.valueOf('k'), 10);
        lookup.put(Character.valueOf('l'), 11);
        lookup.put(Character.valueOf('m'), 12);
        lookup.put(Character.valueOf('n'), 28);
        lookup.put(Character.valueOf('o'), 14);
        lookup.put(Character.valueOf('p'), 15);
        lookup.put(Character.valueOf('q'), 31);
        lookup.put(Character.valueOf('r'), 3);
        lookup.put(Character.valueOf('s'), 18);
        lookup.put(Character.valueOf('t'), 9);
        lookup.put(Character.valueOf('u'), 30);
        lookup.put(Character.valueOf('v'), 3);
        lookup.put(Character.valueOf('w'), 19);
        lookup.put(Character.valueOf('x'), 13);
        lookup.put(Character.valueOf('y'), 24);
        lookup.put(Character.valueOf('z'), 29);
    }
}

