/*
 * Decompiled with CFR 0.152.
 */
package com.mna.advancements.triggers;

import com.google.gson.JsonObject;
import com.mna.api.tools.RLoc;
import java.util.ArrayList;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class StudyDeskRoteTrigger
extends SimpleCriterionTrigger<Instance> {
    private static final ResourceLocation ID = RLoc.create("study_desk_rote");

    public ResourceLocation m_7295_() {
        return ID;
    }

    public Instance createInstance(JsonObject json, ContextAwarePredicate entityPredicate, DeserializationContext conditionsParser) {
        float percent = 0.0f;
        ArrayList<ResourceLocation> parts = new ArrayList<ResourceLocation>();
        if (json.has("progress")) {
            percent = json.get("progress").getAsFloat();
        }
        if (json.has("parts") && json.get("parts").isJsonArray()) {
            json.get("parts").getAsJsonArray().forEach(e -> parts.add(new ResourceLocation(e.getAsString())));
        }
        return new Instance(entityPredicate, parts, percent);
    }

    public void trigger(ServerPlayer player, ResourceLocation part, float progress) {
        this.m_66234_(player, instance -> instance.matches(part, progress));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        private final ArrayList<ResourceLocation> parts;
        private final float percent;

        public Instance(ContextAwarePredicate player, ArrayList<ResourceLocation> parts, float percent) {
            super(ID, player);
            this.parts = parts;
            this.percent = percent;
        }

        public boolean matches(ResourceLocation part, float progress) {
            if (progress < this.percent) {
                return false;
            }
            if (this.parts != null && this.parts.size() > 0) {
                return this.parts.contains(part);
            }
            return true;
        }

        public JsonObject m_7683_(SerializationContext conditions) {
            JsonObject jsonobject = super.m_7683_(conditions);
            return jsonobject;
        }
    }
}

