/*
 * Decompiled with CFR 0.152.
 */
package endorh.lazulib.text;

import endorh.lazulib.text.MutableComponentList;
import java.util.Arrays;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class TextUtil {
    protected static final Pattern NEW_LINE = Pattern.compile("\\R");
    protected static final Pattern FS_PATTERN = Pattern.compile("%(?:(?<index>\\d+)\\$)?(?<flags>[-#+ 0,(<]*)?(?<width>\\d+)?(?<precision>\\.\\d+)?(?<t>[tT])?(?<conversion>[a-zA-Z%])");
    protected static final Pattern FS_INDEX_PATTERN = Pattern.compile("(?<pre>(?<!%)(?:%%)*+%)(?:(?<d>\\d+)\\$)?(?<flags>[-#+ 0,(<]*)(?<pos>[a-zA-Z])");

    public static MutableComponent stc(Object x) {
        return TextUtil.stc(String.valueOf(x));
    }

    public static MutableComponent stc(String str, Object ... args) {
        return TextUtil.stc(String.format(str, args));
    }

    public static MutableComponent stc(String str) {
        return Component.m_237113_((String)str);
    }

    public static MutableComponent ttc(String key, Object ... args) {
        return Component.m_237110_((String)key, (Object[])args);
    }

    public static Optional<MutableComponent> optTtc(String key, Object ... args) {
        return I18n.m_118936_((String)key) ? Optional.of(Component.m_237110_((String)key, (Object[])args)) : Optional.empty();
    }

    public static MutableComponentList splitStc(String str, Object ... args) {
        return TextUtil.splitStc(String.format(str, args));
    }

    public static MutableComponentList splitStc(String str) {
        return new MutableComponentList((MutableComponent[])Arrays.stream(NEW_LINE.split(str)).map(Component::m_237113_).toArray(MutableComponent[]::new));
    }

    public static MutableComponentList splitTtc(String key, Object ... args) {
        return TextUtil.splitTtcImpl(key, false, args);
    }

    public static MutableComponentList optSplitTtc(String key, Object ... args) {
        return TextUtil.splitTtcImpl(key, true, args);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static MutableComponentList splitTtcImpl(String key, boolean optional, Object ... args) {
        if (I18n.m_118936_((String)key)) {
            String f = TextUtil.addExplicitFormatIndexes(Language.m_128107_().m_6834_(key));
            String[] lines = NEW_LINE.split(f);
            MutableComponentList components = new MutableComponentList();
            for (String line : lines) {
                Matcher m = FS_PATTERN.matcher(line);
                MutableComponent built = Component.m_237113_((String)"");
                int cursor = 0;
                while (m.find()) {
                    int i;
                    if (m.group("conversion").equals("%")) {
                        built.m_130946_("%");
                        continue;
                    }
                    int s = m.start();
                    if (s > cursor) {
                        built.m_130946_(line.substring(cursor, s));
                    }
                    if ((i = Integer.parseInt(m.group("index")) - 1) < args.length) {
                        if (args[i] instanceof Component) {
                            built.m_7220_((Component)args[i]);
                        } else {
                            built.m_130946_(String.format(m.group(), args));
                        }
                    }
                    cursor = m.end();
                }
                if (line.length() > cursor) {
                    built.m_130946_(line.substring(cursor));
                }
                components.add(built);
            }
            return components;
        }
        MutableComponentList components = new MutableComponentList();
        if (!optional) {
            components.add(Component.m_237113_((String)key));
        }
        return components;
    }

    public static String addExplicitFormatIndexes(String fmt) {
        Matcher m = FS_INDEX_PATTERN.matcher(fmt);
        StringBuffer sb = new StringBuffer();
        int last_gen = -1;
        int last = -1;
        while (m.find()) {
            String g = m.group("d");
            String f = m.group("flags");
            String rep = g + f;
            if (f.contains("<")) {
                if (last >= 0) {
                    rep = last + 1 + "\\$" + f.replace("<", "");
                }
            } else if (g == null || g.isEmpty()) {
                last = ++last_gen;
                rep = last_gen + 1 + "\\$" + f;
            } else {
                last = Integer.parseInt(g) - 1;
                rep = rep + "\\$";
            }
            m.appendReplacement(sb, "${pre}" + rep + "${pos}");
        }
        m.appendTail(sb);
        return sb.toString();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static MutableComponent subText(Component component, int start) {
        int length = component.getString().length();
        TextUtil.checkBounds(start, length);
        SubTextVisitor visitor = new SubTextVisitor(start, Integer.MAX_VALUE);
        component.m_7451_((FormattedText.StyledContentConsumer)visitor, Style.f_131099_);
        return visitor.getResult();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static MutableComponent subText(Component component, int start, int end) {
        int length = component.getString().length();
        TextUtil.checkBounds(start, length);
        TextUtil.checkBounds(end, length);
        SubTextVisitor visitor = new SubTextVisitor(start, end);
        component.m_7451_((FormattedText.StyledContentConsumer)visitor, Style.f_131099_);
        return visitor.getResult();
    }

    private static void checkBounds(int index, int length) {
        if (index < 0 || index > length) {
            throw new StringIndexOutOfBoundsException(index);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static MutableComponent applyStyle(Component component, Style style, int start) {
        int length = component.getString().length();
        TextUtil.checkBounds(start, length);
        ApplyStyleVisitor visitor = new ApplyStyleVisitor(style, start, Integer.MAX_VALUE);
        component.m_7451_((FormattedText.StyledContentConsumer)visitor, Style.f_131099_);
        return visitor.getResult();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static MutableComponent applyStyle(Component component, Style style, int start, int end) {
        int length = component.getString().length();
        TextUtil.checkBounds(start, length);
        TextUtil.checkBounds(end, length);
        if (start == end) {
            return component.m_6881_();
        }
        ApplyStyleVisitor visitor = new ApplyStyleVisitor(style, start, end);
        component.m_7451_((FormattedText.StyledContentConsumer)visitor, Style.f_131099_);
        return visitor.getResult();
    }

    public static MutableComponent makeLink(String text, String url) {
        return TextUtil.makeLink((Component)TextUtil.stc(text), url);
    }

    public static MutableComponent makeLink(String text, String url, ChatFormatting format) {
        return TextUtil.makeLink((Component)TextUtil.stc(text), url, format);
    }

    public static MutableComponent makeLink(Component text, String url) {
        return TextUtil.makeLink(text, url, ChatFormatting.DARK_AQUA);
    }

    public static MutableComponent makeLink(Component text, String url, ChatFormatting format) {
        return text.m_6881_().m_130938_(style -> style.m_131157_(format).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)TextUtil.ttc("chat.link.open", new Object[0]))).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, url)));
    }

    public static MutableComponent makeCopyLink(String text, String url) {
        return TextUtil.makeCopyLink((Component)TextUtil.stc(text), url);
    }

    public static MutableComponent makeCopyLink(String text, String url, ChatFormatting format) {
        return TextUtil.makeCopyLink((Component)TextUtil.stc(text), url, format);
    }

    public static MutableComponent makeCopyLink(Component text, String url) {
        return TextUtil.makeCopyLink(text, url, ChatFormatting.DARK_AQUA);
    }

    public static MutableComponent makeCopyLink(Component text, String url, ChatFormatting format) {
        return text.m_6879_().m_130938_(style -> style.m_131140_(format).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)TextUtil.ttc("chat.copy.click", new Object[0]))).m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, url)));
    }

    public static MutableComponent makeFileLink(String text, String path) {
        return TextUtil.makeFileLink((Component)TextUtil.stc(text), path);
    }

    public static MutableComponent makeFileLink(String text, String path, ChatFormatting format) {
        return TextUtil.makeFileLink((Component)TextUtil.stc(text), path, format);
    }

    public static MutableComponent makeFileLink(Component text, String path) {
        return TextUtil.makeFileLink(text, path, ChatFormatting.DARK_AQUA);
    }

    public static MutableComponent makeFileLink(Component text, String path, ChatFormatting format) {
        return text.m_6879_().m_130938_(style -> style.m_131140_(format).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)TextUtil.stc(path))).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, path)));
    }

    public static MutableComponent makeCommandLink(String text, String command) {
        return TextUtil.makeCommandLink((Component)TextUtil.stc(text), command);
    }

    public static MutableComponent makeCommandLink(String text, String command, ChatFormatting format) {
        return TextUtil.makeCommandLink((Component)TextUtil.stc(text), command, format);
    }

    public static MutableComponent makeCommandLink(Component text, String command) {
        return TextUtil.makeCommandLink(text, command, ChatFormatting.DARK_AQUA);
    }

    public static MutableComponent makeCommandLink(Component text, String command, ChatFormatting format) {
        return text.m_6881_().m_130938_(style -> style.m_131157_(format).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)TextUtil.ttc("chat.copy", new Object[0]))).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, command)));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class SubTextVisitor
    implements FormattedText.StyledContentConsumer<Boolean> {
        private final int start;
        private final int end;
        private MutableComponent result = null;
        private int length = 0;

        private SubTextVisitor(int start, int end) {
            this.start = start;
            this.end = end;
        }

        private void appendFragment(String fragment, Style style) {
            if (this.result == null) {
                this.result = Component.m_237113_((String)fragment).m_6270_(style);
            } else {
                this.result.m_7220_((Component)Component.m_237113_((String)fragment).m_6270_(style));
            }
        }

        @NotNull
        public Optional<Boolean> m_7164_(@NotNull Style style, @NotNull String text) {
            int l = text.length();
            if (this.length + l > this.end) {
                this.appendFragment(text.substring(Math.max(0, this.start - this.length), this.end - this.length), style);
                return Optional.of(true);
            }
            if (this.length + l >= this.start) {
                this.appendFragment(text.substring(Math.max(0, this.start - this.length)), style);
            }
            this.length += l;
            return Optional.empty();
        }

        public MutableComponent getResult() {
            return this.result != null ? this.result : Component.m_237119_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static final class ApplyStyleVisitor
    implements FormattedText.StyledContentConsumer<Boolean> {
        private final Style style;
        private final int start;
        private final int end;
        private MutableComponent result = null;
        private int length = 0;

        private ApplyStyleVisitor(Style style, int start, int end) {
            this.style = style;
            this.start = start;
            this.end = end;
        }

        @NotNull
        public Optional<Boolean> m_7164_(@NotNull Style style, @NotNull String text) {
            int l = text.length();
            if (l + this.length <= this.start || this.length >= this.end) {
                this.appendFragment(text, style);
            } else {
                int relStart = Math.max(0, this.start - this.length);
                int relEnd = Math.min(l, this.end - this.length);
                if (relStart > 0) {
                    this.appendFragment(text.substring(0, relStart), style);
                }
                if (relEnd > relStart) {
                    this.appendFragment(text.substring(relStart, relEnd), this.style.m_131146_(style));
                }
                if (relEnd < l) {
                    this.appendFragment(text.substring(relEnd), style);
                }
            }
            this.length += l;
            return Optional.empty();
        }

        public MutableComponent getResult() {
            return this.result != null ? this.result : Component.m_237119_();
        }

        private void appendFragment(String fragment, Style style) {
            if (this.result == null) {
                this.result = Component.m_237113_((String)fragment).m_6270_(style);
            } else {
                this.result.m_7220_((Component)Component.m_237113_((String)fragment).m_6270_(style));
            }
        }
    }
}

