/*
 * Decompiled with CFR 0.152.
 */
package endorh.lazulib.sound;

import endorh.lazulib.sound.AudioUtil;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PlayerTickableSound
extends AbstractTickableSoundInstance {
    private static final Logger LOGGER = LogManager.getLogger();
    public final Player player;
    protected IAttenuation attenuationType = IAttenuation.exponential(64.0f);

    public PlayerTickableSound(Player player, SoundEvent soundIn, SoundSource categoryIn) {
        this(player, soundIn, categoryIn, null);
    }

    public PlayerTickableSound(Player player, SoundEvent soundIn, SoundSource categoryIn, @Nullable IAttenuation attenuation) {
        super(soundIn, categoryIn, player.m_217043_());
        this.player = player;
        this.f_119578_ = true;
        this.f_119579_ = 0;
        this.f_119575_ = player.m_20185_();
        this.f_119576_ = player.m_20186_();
        this.f_119577_ = player.m_20189_();
        this.f_119580_ = SoundInstance.Attenuation.NONE;
        if (attenuation != null) {
            this.attenuationType = attenuation;
        }
    }

    public boolean m_7767_() {
        return !this.player.m_20067_();
    }

    public boolean m_7784_() {
        return true;
    }

    public void m_7788_() {
        this.f_119575_ = this.player.m_20185_();
        this.f_119576_ = this.player.m_20186_();
        this.f_119577_ = this.player.m_20189_();
    }

    public final float m_7769_() {
        float vol = this.getVolumeBeforeAttenuation();
        if (this.attenuationType == IAttenuation.NONE) {
            return vol;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return vol;
        }
        Vec3 pos = player.m_20182_();
        double x_d = pos.f_82479_ - this.f_119575_;
        double y_d = pos.f_82480_ - this.f_119576_;
        double z_d = pos.f_82481_ - this.f_119577_;
        float distance = Mth.m_14116_((float)((float)(x_d * x_d + y_d * y_d + z_d * z_d)));
        return this.attenuationType.attenuate(vol, distance);
    }

    public float getVolumeBeforeAttenuation() {
        return this.f_119573_;
    }

    public static interface IAttenuation {
        public static final IAttenuation NONE = (volume, distance) -> volume;

        public float attenuate(float var1, float var2);

        public static IAttenuation linear(float radius) {
            return (volume, distance) -> distance > radius ? 0.0f : volume * (1.0f - distance / radius);
        }

        public static IAttenuation exponential(float radius) {
            return (volume, distance) -> distance > radius ? 0.0f : volume * AudioUtil.fadeOutExp(distance / radius);
        }
    }

    public static class PlayerTickableSubSound
    extends PlayerTickableSound {
        protected Player player;

        public PlayerTickableSubSound(Player player, SoundEvent sound, SoundSource category) {
            this(player, sound, category, null);
        }

        public PlayerTickableSubSound(Player player, SoundEvent sound, SoundSource category, IAttenuation attenuation) {
            super(player, sound, category, attenuation);
            this.player = player;
            this.f_119573_ = 0.0f;
            this.f_119574_ = 1.0f;
        }

        public void play() {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)this);
        }

        public void setVolume(float volume) {
            this.f_119573_ = volume;
        }

        public void setPitch(float pitch) {
            this.f_119574_ = pitch;
        }

        public void finish() {
            this.m_119609_();
        }
    }
}

