/*
 * Decompiled with CFR 0.152.
 */
package endorh.lazulib.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import endorh.lazulib.nbt.JsonToNBTUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.StreamSupport;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraftforge.common.extensions.IForgeRecipeSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NBTInheritingShapedRecipe
extends ShapedRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    public final NonNullList<int[]> nbtSources;
    public final CompoundTag outputTag;
    protected final int recipeWidth;
    protected final int recipeHeight;
    protected final ItemStack result;
    protected final NonNullList<Ingredient> recipeItems;

    public NBTInheritingShapedRecipe(ResourceLocation id, String group, CraftingBookCategory category, int width, int height, NonNullList<int[]> nbtSourcesIn, NonNullList<Ingredient> items, ItemStack output, CompoundTag outputTagIn) {
        super(id, group, category, width, height, items, output);
        this.recipeWidth = width;
        this.recipeHeight = height;
        this.recipeItems = items;
        this.nbtSources = nbtSourcesIn;
        this.outputTag = outputTagIn;
        this.result = output;
    }

    @NotNull
    public ItemStack m_5874_(@NotNull CraftingContainer inv, RegistryAccess r) {
        ItemStack result = super.m_5874_(inv, r).m_41777_();
        result.m_41751_(this.getResultTag(inv));
        return result;
    }

    public Pair<Integer, Integer> findRecipeOffset(@NotNull CraftingContainer inv) {
        int i;
        int j = 0;
        block0: for (i = 0; i <= inv.m_39347_() - this.getRecipeWidth(); ++i) {
            while (j <= inv.m_39346_() - this.getRecipeHeight()) {
                if (this.checkMatch(inv, i, j, true) || this.checkMatch(inv, i, j, false)) break block0;
                ++j;
            }
        }
        return Pair.of((Object)i, (Object)j);
    }

    public CompoundTag getResultTag(@NotNull CraftingContainer inv) {
        Pair<Integer, Integer> offset = this.findRecipeOffset(inv);
        int i = (Integer)offset.getFirst();
        int j = (Integer)offset.getSecond();
        CompoundTag resultTag = this.outputTag.m_6426_();
        String TAG_REPAIR_COST = "RepairCost";
        int repairCost = 0;
        for (int[] nbtSourcePos : this.nbtSources) {
            ItemStack nbtSource = inv.m_8020_(inv.m_39347_() * (nbtSourcePos[1] + j) + nbtSourcePos[0] + i).m_41777_();
            CompoundTag sourceTag = nbtSource.m_41783_();
            if (sourceTag == null) continue;
            repairCost = Math.max(repairCost, sourceTag.m_128451_("RepairCost"));
            resultTag = sourceTag.m_128391_(resultTag);
        }
        if (this.outputTag.m_128425_("RepairCost", 3)) {
            repairCost = this.outputTag.m_128451_("RepairCost");
        }
        if (repairCost != 0) {
            resultTag.m_128405_("RepairCost", repairCost);
        }
        return resultTag;
    }

    protected boolean checkMatch(CraftingContainer inv, int x, int y, boolean xMirror) {
        for (int i = 0; i < inv.m_39347_(); ++i) {
            for (int j = 0; j < inv.m_39346_(); ++j) {
                Ingredient ing;
                int ix = i - x;
                int iy = j - y;
                Ingredient ingredient = ix >= 0 && ix < this.recipeWidth && iy >= 0 && iy < this.recipeHeight ? (xMirror ? (Ingredient)this.recipeItems.get(this.recipeWidth - ix - 1 + iy * this.recipeWidth) : (Ingredient)this.recipeItems.get(ix + iy * this.recipeWidth)) : (ing = Ingredient.f_43901_);
                if (ing.test(inv.m_8020_(i + j * inv.m_39347_()))) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public static class Serializer
    implements RecipeSerializer<NBTInheritingShapedRecipe>,
    IForgeRecipeSerializer<NBTInheritingShapedRecipe> {
        public static final ResourceLocation NAME = new ResourceLocation("lazulib", "nbt_inheriting_shaped_recipe");
        public static int MAX_WIDTH = 3;
        public static int MAX_HEIGHT = 3;

        @NotNull
        public NBTInheritingShapedRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            CraftingBookCategory category = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)json, (String)"category", null), (Enum)CraftingBookCategory.MISC);
            boolean allowUnknown = GsonHelper.m_13855_((JsonObject)json, (String)"allow_unknown_items", (boolean)false);
            Map<String, Ingredient> map = Serializer.deserializeKey(GsonHelper.m_13930_((JsonObject)json, (String)"key"), allowUnknown);
            String[] pat = Serializer.shrink(Serializer.patternFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"pattern")));
            int w = pat[0].length();
            int h = pat.length;
            NonNullList<int[]> nbtSources = Serializer.nbtSourcesFromPattern(pat);
            NonNullList<Ingredient> list = Serializer.deserializeIngredients(pat, map, w, h);
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            CompoundTag outputTag = Serializer.nbtFromJson(json);
            return new NBTInheritingShapedRecipe(recipeId, group, category, w, h, nbtSources, list, output, outputTag);
        }

        @Nullable
        public NBTInheritingShapedRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buf) {
            int w = buf.m_130242_();
            int h = buf.m_130242_();
            String group = buf.m_130136_(Short.MAX_VALUE);
            CraftingBookCategory category = (CraftingBookCategory)buf.m_130066_(CraftingBookCategory.class);
            NonNullList list = NonNullList.m_122780_((int)(w * h), (Object)Ingredient.f_43901_);
            list.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buf));
            ItemStack output = buf.m_130267_();
            int l = buf.m_130242_();
            NonNullList nbtSources = NonNullList.m_122780_((int)l, (Object)new int[]{0, 0});
            for (int i = 0; i < l; ++i) {
                nbtSources.set(i, (Object)buf.m_130100_());
            }
            CompoundTag outputTag = buf.m_130260_();
            return new NBTInheritingShapedRecipe(id, group, category, w, h, (NonNullList<int[]>)nbtSources, (NonNullList<Ingredient>)list, output, outputTag);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buf, @NotNull NBTInheritingShapedRecipe recipe) {
            buf.m_130130_(recipe.recipeWidth);
            buf.m_130130_(recipe.recipeHeight);
            buf.m_130070_(recipe.m_6076_());
            buf.m_130068_((Enum)recipe.m_245232_());
            for (Ingredient ing : recipe.recipeItems) {
                ing.m_43923_(buf);
            }
            buf.m_130055_(recipe.result);
            buf.m_130130_(recipe.nbtSources.size());
            for (int[] nbtSource : recipe.nbtSources) {
                buf.m_130089_(nbtSource);
            }
            buf.m_130079_(recipe.outputTag);
        }

        public static String[] patternFromJson(JsonArray arr) {
            String[] pattern = new String[arr.size()];
            if (pattern.length > MAX_HEIGHT) {
                throw new JsonSyntaxException("Invalid pattern: too many rows, max is " + MAX_HEIGHT);
            }
            if (pattern.length == 0) {
                throw new JsonSyntaxException("Invalid pattern: pattern can't be empty");
            }
            for (int i = 0; i < pattern.length; ++i) {
                String row = GsonHelper.m_13805_((JsonElement)arr.get(i), (String)("pattern[" + i + "]"));
                if (row.length() > MAX_WIDTH) {
                    throw new JsonSyntaxException("Invalid pattern: too many columns, max is" + MAX_WIDTH);
                }
                if (i > 0 && pattern[0].length() != row.length()) {
                    throw new JsonSyntaxException("Invalid pattern: all rows must have the same width");
                }
                pattern[i] = row;
            }
            return pattern;
        }

        public static Map<String, Ingredient> deserializeKey(JsonObject json, boolean allowUnknown) {
            HashMap<String, Ingredient> map = new HashMap<String, Ingredient>();
            for (Map.Entry entry : json.entrySet()) {
                if (((String)entry.getKey()).length() != 1) {
                    throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
                }
                if (" ".equals(entry.getKey())) {
                    throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
                }
                if (((JsonElement)entry.getValue()).isJsonArray() && allowUnknown) {
                    map.put((String)entry.getKey(), Serializer.filterKnownFromList(((JsonElement)entry.getValue()).getAsJsonArray()));
                    continue;
                }
                map.put((String)entry.getKey(), Ingredient.m_43917_((JsonElement)((JsonElement)entry.getValue())));
            }
            map.put(" ", Ingredient.f_43901_);
            return map;
        }

        public static Ingredient filterKnownFromList(JsonArray array) {
            if (array.size() == 0) {
                throw new JsonSyntaxException("Item array cannot be empty, at least one item must be defined");
            }
            List<Ingredient.Value> list = StreamSupport.stream(array.spliterator(), false).map(el -> {
                try {
                    return Ingredient.m_43919_((JsonObject)GsonHelper.m_13918_((JsonElement)el, (String)"item"));
                }
                catch (JsonSyntaxException e) {
                    if (e.getMessage().startsWith("Unknown item")) {
                        return null;
                    }
                    throw e;
                }
            }).filter(Objects::nonNull).toList();
            if (list.size() == 0) {
                throw new JsonSyntaxException("All items from array were unknown, at least one defined item must be known to load the recipe");
            }
            return Ingredient.m_43938_(list.stream());
        }

        public static NonNullList<Ingredient> deserializeIngredients(String[] pattern, Map<String, Ingredient> keys, int w, int h) {
            NonNullList list = NonNullList.m_122780_((int)(w * h), (Object)Ingredient.f_43901_);
            HashSet<String> set = new HashSet<String>(keys.keySet());
            set.remove(" ");
            for (int i = 0; i < pattern.length; ++i) {
                for (int j = 0; j < pattern[i].length(); ++j) {
                    String s = pattern[i].substring(j, j + 1);
                    Ingredient ing = keys.get(s);
                    if (ing == null) {
                        throw new JsonSyntaxException("Pattern references symbol '" + s + "' but it's not defined in the key");
                    }
                    set.remove(s);
                    list.set(j + w * i, (Object)ing);
                }
            }
            if (!set.isEmpty()) {
                throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
            }
            return list;
        }

        public static String[] shrink(String ... pattern) {
            int left = Integer.MAX_VALUE;
            int right = 0;
            int top = 0;
            int bottom = 0;
            for (int i = 0; i < pattern.length; ++i) {
                String row = pattern[i];
                left = Math.min(left, Serializer.firstDifferent(row, ' '));
                int rowRight = Serializer.lastDifferent(row, ' ');
                right = Math.max(right, rowRight);
                if (rowRight < 0) {
                    if (top == i) {
                        ++top;
                    }
                    ++bottom;
                    continue;
                }
                bottom = 0;
            }
            if (pattern.length == bottom) {
                return new String[0];
            }
            String[] shrunk = new String[pattern.length - bottom - top];
            for (int i = 0; i < shrunk.length; ++i) {
                shrunk[i] = pattern[i + top].substring(left, right + 1);
            }
            return shrunk;
        }

        public static int firstDifferent(String str, char chr) {
            int i;
            for (i = 0; i < str.length() && chr == str.charAt(i); ++i) {
            }
            return i;
        }

        public static int lastDifferent(String str, char chr) {
            int i;
            for (i = str.length() - 1; i >= 0 && chr == str.charAt(i); --i) {
            }
            return i;
        }

        public static NonNullList<int[]> nbtSourcesFromPattern(String[] pattern) {
            NonNullList list = NonNullList.m_122779_();
            for (int i = 0; i < pattern.length; ++i) {
                for (int j = 0; j < pattern[i].length(); ++j) {
                    if (!Character.isUpperCase(pattern[i].charAt(j))) continue;
                    list.add((Object)new int[]{j, i});
                }
            }
            return list;
        }

        public static CompoundTag nbtFromJson(JsonObject root) {
            JsonElement tag;
            CompoundTag outTag = new CompoundTag();
            JsonElement res = root.get("result");
            if (res != null && res.isJsonObject() && (tag = res.getAsJsonObject().get("tag")) != null && tag.isJsonObject()) {
                outTag = JsonToNBTUtil.getTagFromJson((JsonElement)tag.getAsJsonObject());
            }
            return outTag;
        }
    }
}

