/*
 * Decompiled with CFR 0.152.
 */
package endorh.lazulib.network;

import endorh.lazulib.network.DistributedPlayerPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public abstract class ValidatedDistributedPlayerPacket
extends DistributedPlayerPacket {
    private boolean invalid = false;
    private boolean propagate = true;

    protected boolean isInvalid() {
        return this.invalid;
    }

    protected void invalidate() {
        this.invalid = true;
    }

    protected void unInvalidate() {
        this.invalid = false;
    }

    protected float validateClamp(float value, float min, float max) {
        if (!this.onServer) {
            return value;
        }
        if (value < min) {
            value = min;
            this.invalid = true;
        } else if (value > max) {
            value = max;
            this.invalid = true;
        }
        return value;
    }

    protected float validateClose(float a, float b, float delta) {
        if (!this.onServer) {
            return a;
        }
        if (Math.abs(a - b) > delta) {
            a = a < b ? b - delta : b + delta;
            this.invalid = true;
        }
        return a;
    }

    protected void setPropagate(boolean propagate) {
        this.propagate = propagate;
    }

    protected boolean getPropagate() {
        return this.propagate;
    }

    @Override
    public final boolean onServerCancellable(Player sender, NetworkEvent.Context ctx) {
        this.onServer(sender, ctx);
        if (this.isInvalid()) {
            this.sendBack();
            return this.propagate;
        }
        return true;
    }
}

