/*
 * Decompiled with CFR 0.152.
 */
package endorh.lazulib.network;

import java.util.HashMap;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public abstract class ServerWorldPacket {
    protected ServerLevel world = null;
    protected ResourceLocation worldLocation = null;
    public static final HashMap<Class<ServerWorldPacket>, SimpleChannel> channelMap = new HashMap();

    protected ServerWorldPacket() {
    }

    public ServerWorldPacket(Level world) {
        this.world = (ServerLevel)world;
        this.worldLocation = world.m_46472_().m_135782_();
    }

    public static PacketRegisterer with(SimpleChannel channel, Supplier<Integer> idSupplier) {
        return new PacketRegisterer(channel, idSupplier);
    }

    public static <T extends ServerWorldPacket> void register(Supplier<T> sup, SimpleChannel channel, int id) {
        Class<?> cls = ((ServerWorldPacket)sup.get()).getClass();
        channelMap.put(cls, channel);
        channel.registerMessage(id, cls, (packet, buffer) -> {
            buffer.m_130085_(packet.worldLocation);
            packet.serialize((FriendlyByteBuf)buffer);
        }, buffer -> {
            ServerWorldPacket packet = (ServerWorldPacket)sup.get();
            packet.worldLocation = buffer.m_130281_();
            packet.deserialize((FriendlyByteBuf)buffer);
            return packet;
        }, (packet, ctxSupplier) -> {
            NetworkEvent.Context ctx = (NetworkEvent.Context)ctxSupplier.get();
            ctx.enqueueWork(() -> {
                if (packet.world != null) {
                    return;
                }
                Minecraft mc = Minecraft.m_91087_();
                ClientLevel world = mc.f_91073_;
                assert (world != null);
                ResourceLocation worldLocation = world.m_46472_().m_135782_();
                if (!worldLocation.equals((Object)packet.worldLocation)) {
                    return;
                }
                packet.onClient(ServerWorldPacket.doCast(world), ctx);
            });
            ctx.setPacketHandled(true);
        }, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Level doCast(ClientLevel world) {
        return world;
    }

    public abstract void onClient(Level var1, NetworkEvent.Context var2);

    public abstract void serialize(FriendlyByteBuf var1);

    public abstract void deserialize(FriendlyByteBuf var1);

    public SimpleChannel getChannel() {
        SimpleChannel channel = channelMap.get(this.getClass());
        if (channel == null) {
            throw new IllegalStateException("Attempted to send non-registered packet");
        }
        return channel;
    }

    public void sendTracking() {
        this.getChannel().send(PacketDistributor.DIMENSION.with(() -> this.world.m_46472_()), (Object)this);
    }

    public void sendTarget(PacketDistributor.PacketTarget target) {
        this.getChannel().send(target, (Object)this);
    }

    public static class PacketRegisterer {
        public final SimpleChannel channel;
        public final Supplier<Integer> idSupplier;

        private PacketRegisterer(SimpleChannel channel, Supplier<Integer> idSupplier) {
            this.channel = channel;
            this.idSupplier = idSupplier;
        }

        public <T extends ServerWorldPacket> PacketRegisterer register(Supplier<T> sup) {
            ServerWorldPacket.register(sup, this.channel, this.idSupplier.get());
            return this;
        }
    }
}

