/*
 * Decompiled with CFR 0.152.
 */
package endorh.lazulib.network;

import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public abstract class ServerPlayerPacket {
    protected UUID playerID = null;
    protected ServerPlayer player = null;
    public static final HashMap<Class<ServerPlayerPacket>, SimpleChannel> channelMap = new HashMap();

    protected ServerPlayerPacket() {
    }

    public ServerPlayerPacket(Player player) {
        this.player = (ServerPlayer)player;
        this.playerID = player.m_20148_();
    }

    public static PacketRegisterer with(SimpleChannel channel, Supplier<Integer> idSupplier) {
        return new PacketRegisterer(channel, idSupplier);
    }

    public static <T extends ServerPlayerPacket> void register(Supplier<T> sup, SimpleChannel channel, int id) {
        Class<?> cls = ((ServerPlayerPacket)sup.get()).getClass();
        channelMap.put(cls, channel);
        channel.registerMessage(id, cls, (packet, buffer) -> {
            buffer.m_130077_(packet.playerID);
            packet.serialize((FriendlyByteBuf)buffer);
        }, buffer -> {
            ServerPlayerPacket packet = (ServerPlayerPacket)sup.get();
            packet.playerID = buffer.m_130259_();
            packet.deserialize((FriendlyByteBuf)buffer);
            return packet;
        }, (packet, ctxSupplier) -> {
            NetworkEvent.Context ctx = (NetworkEvent.Context)ctxSupplier.get();
            ctx.enqueueWork(() -> {
                ClientLevel world = Minecraft.m_91087_().f_91073_;
                assert (world != null);
                packet.onClient(world.m_46003_(packet.playerID), ctx);
            });
            ctx.setPacketHandled(true);
        }, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    protected abstract void onClient(Player var1, NetworkEvent.Context var2);

    protected abstract void serialize(FriendlyByteBuf var1);

    protected abstract void deserialize(FriendlyByteBuf var1);

    public SimpleChannel getChannel() {
        SimpleChannel channel = channelMap.get(this.getClass());
        if (channel == null) {
            throw new IllegalStateException("Attempted to send non-registered packet");
        }
        return channel;
    }

    public void sendTo(ServerPlayer player) {
        this.getChannel().sendTo((Object)this, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public void sendTracking() {
        this.getChannel().send(PacketDistributor.TRACKING_ENTITY.with(() -> this.player), (Object)this);
    }

    public void sendTrackingAndSelf() {
        this.getChannel().send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this.player), (Object)this);
    }

    public void sendTo(PacketDistributor.PacketTarget target) {
        this.getChannel().send(target, (Object)this);
    }

    public static class PacketRegisterer {
        public final SimpleChannel channel;
        public final Supplier<Integer> idSupplier;

        private PacketRegisterer(SimpleChannel channel, Supplier<Integer> idSupplier) {
            this.channel = channel;
            this.idSupplier = idSupplier;
        }

        public <T extends ServerPlayerPacket> PacketRegisterer register(Supplier<T> sup) {
            ServerPlayerPacket.register(sup, this.channel, this.idSupplier.get());
            return this;
        }
    }
}

