/*
 * Decompiled with CFR 0.152.
 */
package endorh.lazulib.network;

import java.util.HashMap;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public abstract class DistributedPlayerPacket {
    protected UUID playerID;
    protected ServerPlayer sender = null;
    protected boolean onServer = false;
    protected boolean bounced = false;
    public static final HashMap<Class<DistributedPlayerPacket>, SimpleChannel> channelMap = new HashMap();
    private static final UUID nil = new UUID(0L, 0L);

    public static PacketRegisterer with(SimpleChannel channel, Supplier<Integer> idSupplier) {
        return new PacketRegisterer(channel, idSupplier);
    }

    public static <T extends DistributedPlayerPacket> void register(Supplier<T> sup, Function<Supplier<Player>, PacketDistributor.PacketTarget> distributor, SimpleChannel channel, int id) {
        Class<?> cls = ((DistributedPlayerPacket)sup.get()).getClass();
        channelMap.put(cls, channel);
        channel.registerMessage(id, cls, (packet, buffer) -> {
            buffer.m_130077_(packet.playerID != null ? packet.playerID : nil);
            packet.serialize((FriendlyByteBuf)buffer);
        }, buffer -> {
            DistributedPlayerPacket packet = (DistributedPlayerPacket)sup.get();
            packet.playerID = buffer.m_130259_();
            if (nil.equals(packet.playerID)) {
                packet.playerID = null;
            }
            packet.deserialize((FriendlyByteBuf)buffer);
            return packet;
        }, (packet, ctxSupplier) -> {
            NetworkEvent.Context ctx = (NetworkEvent.Context)ctxSupplier.get();
            ctx.enqueueWork(() -> {
                if (packet.playerID == null) {
                    packet.onServer = true;
                    ServerPlayer sender = ctx.getSender();
                    assert (sender != null);
                    packet.sender = sender;
                    packet.playerID = sender.m_20148_();
                    if (packet.onServerCancellable((Player)sender, ctx)) {
                        channel.send((PacketDistributor.PacketTarget)distributor.apply(() -> sender), packet);
                    }
                } else {
                    Minecraft mc = Minecraft.m_91087_();
                    ClientLevel world = mc.f_91073_;
                    assert (world != null);
                    Player sender = world.m_46003_(packet.playerID);
                    if (sender == mc.f_91074_) {
                        packet.bounced = true;
                        packet.onBounce(sender, ctx);
                    } else {
                        packet.onClient(sender, ctx);
                    }
                }
            });
            ctx.setPacketHandled(true);
        });
    }

    protected boolean onServerCancellable(Player sender, NetworkEvent.Context ctx) {
        this.onServer(sender, ctx);
        return true;
    }

    protected void onServer(Player sender, NetworkEvent.Context ctx) {
        this.onCommon(sender, ctx);
    }

    protected void onClient(Player sender, NetworkEvent.Context ctx) {
        this.onCommon(sender, ctx);
    }

    protected void onCommon(Player sender, NetworkEvent.Context ctx) {
    }

    protected void onBounce(Player self, NetworkEvent.Context ctx) {
        this.onClient(self, ctx);
    }

    protected abstract void serialize(FriendlyByteBuf var1);

    protected abstract void deserialize(FriendlyByteBuf var1);

    public void send() {
        this.getChannel().sendToServer((Object)this);
    }

    public SimpleChannel getChannel() throws IllegalStateException {
        SimpleChannel channel = channelMap.get(this.getClass());
        if (channel == null) {
            throw new IllegalStateException("Attempted to use a non-registered packet`s channel");
        }
        return channel;
    }

    protected void sendBack() {
        this.getChannel().sendTo((Object)this, this.sender.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static class PacketRegisterer {
        public final SimpleChannel channel;
        public final Supplier<Integer> idSupplier;

        private PacketRegisterer(SimpleChannel channel, Supplier<Integer> idSupplier) {
            this.channel = channel;
            this.idSupplier = idSupplier;
        }

        public <T extends DistributedPlayerPacket> PacketRegisterer registerLocal(Supplier<T> sup) {
            return this.register(sup, playerSupplier -> PacketDistributor.TRACKING_ENTITY.with(((Supplier)playerSupplier)::get));
        }

        public <T extends DistributedPlayerPacket> PacketRegisterer registerGlobal(Supplier<T> sup) {
            return this.register(sup, ignored -> PacketDistributor.ALL.noArg());
        }

        public <T extends DistributedPlayerPacket> PacketRegisterer register(Supplier<T> sup, Function<Supplier<Player>, PacketDistributor.PacketTarget> distributor) {
            DistributedPlayerPacket.register(sup, distributor, this.channel, this.idSupplier.get());
            return this;
        }
    }
}

