/*
 * Decompiled with CFR 0.152.
 */
package endorh.lazulib.network;

import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;

public abstract class ClientPlayerPacket {
    protected UUID playerID;
    protected LocalPlayer player;
    public static final HashMap<Class<ClientPlayerPacket>, SimpleChannel> channelMap = new HashMap();

    protected ClientPlayerPacket() {
    }

    public ClientPlayerPacket(Player player) {
        this.player = (LocalPlayer)player;
        this.playerID = player.m_20148_();
    }

    public static PacketRegisterer with(SimpleChannel channel, Supplier<Integer> idSupplier) {
        return new PacketRegisterer(channel, idSupplier);
    }

    public static <T extends ClientPlayerPacket> void register(Supplier<T> sup, SimpleChannel channel, int id) {
        Class<?> cls = ((ClientPlayerPacket)sup.get()).getClass();
        channelMap.put(cls, channel);
        channel.registerMessage(id, cls, (packet, buffer) -> {
            buffer.m_130077_(packet.playerID);
            packet.serialize((FriendlyByteBuf)buffer);
        }, buffer -> {
            ClientPlayerPacket packet = (ClientPlayerPacket)sup.get();
            packet.playerID = buffer.m_130259_();
            packet.deserialize((FriendlyByteBuf)buffer);
            return packet;
        }, (packet, ctxSupplier) -> {
            NetworkEvent.Context ctx = (NetworkEvent.Context)ctxSupplier.get();
            ctx.enqueueWork(() -> {
                ServerPlayer sender = ctx.getSender();
                packet.onServer((Player)sender, ctx);
            });
            ctx.setPacketHandled(true);
        }, Optional.of(NetworkDirection.PLAY_TO_SERVER));
    }

    public abstract void onServer(Player var1, NetworkEvent.Context var2);

    public abstract void serialize(FriendlyByteBuf var1);

    public abstract void deserialize(FriendlyByteBuf var1);

    public SimpleChannel getChannel() {
        SimpleChannel channel = channelMap.get(this.getClass());
        if (channel == null) {
            throw new IllegalStateException("Attempted to send non-registered packet");
        }
        return channel;
    }

    public void send() {
        this.getChannel().sendToServer((Object)this);
    }

    public static class PacketRegisterer {
        public final SimpleChannel channel;
        public final Supplier<Integer> idSupplier;

        private PacketRegisterer(SimpleChannel channel, Supplier<Integer> idSupplier) {
            this.channel = channel;
            this.idSupplier = idSupplier;
        }

        public <T extends ClientPlayerPacket> PacketRegisterer register(Supplier<T> sup) {
            ClientPlayerPacket.register(sup, this.channel, this.idSupplier.get());
            return this;
        }
    }
}

