/*
 * Decompiled with CFR 0.152.
 */
package endorh.lazulib.math;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import endorh.lazulib.math.Vec3d;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class Vec3f {
    public float x;
    public float y;
    public float z;
    public static final Codec<Vec3f> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("x").forGetter(d -> Float.valueOf(d.x)), (App)Codec.FLOAT.fieldOf("y").forGetter(d -> Float.valueOf(d.y)), (App)Codec.FLOAT.fieldOf("z").forGetter(d -> Float.valueOf(d.z))).apply((Applicative)instance, Vec3f::new));
    public static final float TO_RAD = (float)Math.PI / 180;
    public static final float TO_DEGREES = 57.29578f;
    public static final float PI = (float)Math.PI;
    public static final float PI_HALF = 1.5707964f;
    private static final Random random = new Random();
    public static final Supplier<Vec3f> ZERO = () -> new Vec3f(0.0f, 0.0f, 0.0f);
    public static final Supplier<Vec3f> XP = () -> new Vec3f(1.0f, 0.0f, 0.0f);
    public static final Supplier<Vec3f> YP = () -> new Vec3f(0.0f, 1.0f, 0.0f);
    public static final Supplier<Vec3f> ZP = () -> new Vec3f(0.0f, 0.0f, 1.0f);
    public static final Supplier<Vec3f> XN = () -> new Vec3f(-1.0f, 0.0f, 0.0f);
    public static final Supplier<Vec3f> YN = () -> new Vec3f(0.0f, -1.0f, 0.0f);
    public static final Supplier<Vec3f> ZN = () -> new Vec3f(0.0f, 0.0f, -1.0f);
    public static String defaultFormat = "%+6.3f";

    private Vec3f() {
    }

    public Vec3f(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vec3f(double x, double y, double z) {
        this.x = (float)x;
        this.y = (float)y;
        this.z = (float)z;
    }

    public Vec3f(Vec3f vec) {
        this.x = vec.x;
        this.y = vec.y;
        this.z = vec.z;
    }

    public Vec3f(Vec3i vec) {
        this.x = vec.m_123341_();
        this.y = vec.m_123342_();
        this.z = vec.m_123343_();
    }

    public Vec3f(Vec3i vec, boolean center) {
        if (center) {
            this.x = (float)vec.m_123341_() + 0.5f;
            this.y = (float)vec.m_123342_() + 0.5f;
            this.z = (float)vec.m_123343_() + 0.5f;
        } else {
            this.x = vec.m_123341_();
            this.y = vec.m_123342_();
            this.z = vec.m_123343_();
        }
    }

    public Vec3f(Vector3f vec) {
        this.x = vec.x();
        this.y = vec.y();
        this.z = vec.z();
    }

    public Vec3f(Vec3 vec) {
        this.x = (float)vec.f_82479_;
        this.y = (float)vec.f_82480_;
        this.z = (float)vec.f_82481_;
    }

    public Vec3f(Vec3d vec) {
        this.x = (float)vec.x;
        this.y = (float)vec.y;
        this.z = (float)vec.z;
    }

    public Vec3f(float yaw, float pitch) {
        this(yaw, pitch, true);
    }

    public Vec3f(float yaw, float pitch, boolean degrees) {
        if (degrees) {
            pitch *= (float)Math.PI / 180;
            yaw *= (float)Math.PI / 180;
        }
        float yawCos = (float)Math.cos(yaw);
        float yawSin = (float)Math.sin(yaw);
        float pitCos = (float)Math.cos(pitch);
        float pitSin = (float)Math.sin(pitch);
        this.x = -yawSin * pitCos;
        this.y = -pitSin;
        this.z = yawCos * pitCos;
    }

    public Vec3f(float[] array) {
        try {
            this.x = array[0];
            this.y = array[1];
            this.z = array[2];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Unable to read Vector3 from array, too few elements");
        }
    }

    public Vec3f(List<Float> list) {
        try {
            this.x = list.get(0).floatValue();
            this.y = list.get(1).floatValue();
            this.z = list.get(2).floatValue();
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Unable to read Vector3 from list, too few elements");
        }
    }

    public static Vec3f random() {
        return new Vec3f(random.nextFloat(), random.nextFloat(), random.nextFloat());
    }

    public static Vec3f random(float range) {
        Vec3f res = Vec3f.random();
        res.mul(2.0f * range);
        res.add(-range);
        return res;
    }

    public static Vec3f random(float min, float max) {
        Vec3f res = Vec3f.random();
        res.mul(max - min);
        res.add(min);
        return res;
    }

    public static Vec3f randomUnitary() {
        float u = random.nextFloat() * 2.0f * (float)Math.PI;
        float v = -1.0f + random.nextFloat() * 2.0f;
        float h = (float)Math.sqrt(1.0f - v * v);
        return new Vec3f(Mth.m_14089_((float)u) * h, Mth.m_14031_((float)u) * h, v);
    }

    public static Vec3f randomSpherical() {
        float u = random.nextFloat() * 2.0f * (float)Math.PI;
        float v = -1.0f + random.nextFloat() * 2.0f;
        float r = (float)Math.sqrt(random.nextFloat());
        float h = (float)Math.sqrt(1.0f - v * v);
        return new Vec3f(Mth.m_14089_((float)u) * h * r, Mth.m_14031_((float)u) * h * r, v * r);
    }

    public void add(Vec3f vec) {
        this.x += vec.x;
        this.y += vec.y;
        this.z += vec.z;
    }

    public void add(Vec3f vec, float scale) {
        this.x += vec.x * scale;
        this.y += vec.y * scale;
        this.z += vec.z * scale;
    }

    public void add(float a) {
        this.x += a;
        this.y += a;
        this.z += a;
    }

    public void add(float ax, float ay, float az) {
        this.x += ax;
        this.y += ay;
        this.z += az;
    }

    public void mul(float mx, float my, float mz) {
        this.x *= mx;
        this.y *= my;
        this.z *= mz;
    }

    public void mul(float m) {
        this.x *= m;
        this.y *= m;
        this.z *= m;
    }

    public void sub(Vec3f vec) {
        this.x -= vec.x;
        this.y -= vec.y;
        this.z -= vec.z;
    }

    public void sub(Vec3f vec, float scale) {
        this.x -= vec.x * scale;
        this.y -= vec.y * scale;
        this.z -= vec.z * scale;
    }

    public void clamp(float range) {
        this.clamp(-range, range);
    }

    public void clamp(float mn, float mx) {
        this.x = Math.max(mn, Math.min(mx, this.x));
        this.y = Math.max(mn, Math.min(mx, this.y));
        this.z = Math.max(mn, Math.min(mx, this.z));
    }

    public float dot(Vec3f vec) {
        return this.x * vec.x + this.y * vec.y + this.z * vec.z;
    }

    public void cross(Vec3f vec) {
        float x = this.x;
        float y = this.y;
        float z = this.z;
        this.x = y * vec.z - z * vec.y;
        this.y = z * vec.x - x * vec.z;
        this.z = x * vec.y - y * vec.x;
    }

    public void crossReverse(Vec3f vec) {
        float x = this.x;
        float y = this.y;
        float z = this.z;
        this.x = vec.y * z - vec.z * y;
        this.y = vec.z * x - vec.x * z;
        this.z = vec.x * y - vec.y * x;
    }

    public float normSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public float norm() {
        return Mth.m_14116_((float)(this.x * this.x + this.y * this.y + this.z * this.z));
    }

    public float hNormSquared() {
        return this.x * this.x + this.z * this.z;
    }

    public float hNorm() {
        return Mth.m_14116_((float)(this.x * this.x + this.z * this.z));
    }

    public float distance(Vec3f other) {
        return Mth.m_14116_((float)this.distanceSquared(other));
    }

    public float distanceSquared(Vec3f other) {
        float x_d = this.x - other.x;
        float y_d = this.y - other.y;
        float z_d = this.z - other.z;
        return x_d * x_d + y_d * y_d + z_d * z_d;
    }

    public void unitary() {
        float i = 1.0f / this.norm();
        this.x *= i;
        this.y *= i;
        this.z *= i;
    }

    public boolean isZero() {
        return this.normSquared() < 1.0E-8f;
    }

    public boolean isZero(double epsilon) {
        return (double)this.normSquared() < epsilon * epsilon;
    }

    public Vector3f toVector3f() {
        return new Vector3f(this.x, this.y, this.z);
    }

    public Vec3 toVector3d() {
        return new Vec3((double)this.x, (double)this.y, (double)this.z);
    }

    public Vec3i toVector3i() {
        return new Vec3i(Math.round(this.x), Math.round(this.y), Math.round(this.z));
    }

    public Vec3d toVec3d() {
        return new Vec3d((double)this.x, (double)this.y, this.z);
    }

    public int pack() {
        return (Math.round(this.x * 255.0f) & 0xFF) << 16 | (Math.round(this.y * 255.0f) & 0xFF) << 8 | Math.round(this.z * 255.0f) & 0xFF;
    }

    public static Vec3f unpack(int packed) {
        return new Vec3f((float)(packed >> 16 & 0xFF) / 255.0f, (float)(packed >> 8 & 0xFF) / 255.0f, (float)(packed & 0xFF) / 255.0f);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeFloat(this.x);
        buf.writeFloat(this.y);
        buf.writeFloat(this.z);
    }

    public static Vec3f read(FriendlyByteBuf buf) {
        return new Vec3f(buf.readFloat(), buf.readFloat(), buf.readFloat());
    }

    public static Vec3f readCommand(StringReader reader) throws CommandSyntaxException {
        double x = reader.readFloat();
        reader.expect(' ');
        double y = reader.readFloat();
        reader.expect(' ');
        double z = reader.readFloat();
        return new Vec3f(x, y, z);
    }

    public String writeCommand() {
        return String.format("%.3f %.3f %.3f", Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z));
    }

    public CompoundTag toNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128350_("x", this.x);
        nbt.m_128350_("y", this.y);
        nbt.m_128350_("z", this.z);
        return nbt;
    }

    public static Vec3f fromNBT(CompoundTag nbt) {
        return new Vec3f(nbt.m_128457_("x"), nbt.m_128457_("y"), nbt.m_128457_("z"));
    }

    public void readNBT(CompoundTag nbt) {
        this.x = nbt.m_128457_("x");
        this.y = nbt.m_128457_("y");
        this.z = nbt.m_128457_("z");
    }

    public void lerp(Vec3f vec, float t) {
        float r = 1.0f - t;
        this.x = this.x * r + vec.x * t;
        this.y = this.y * r + vec.y * t;
        this.z = this.z * r + vec.z * t;
    }

    public static Vec3f average(Collection<Vec3f> vectors) {
        Vec3f res = ZERO.get();
        int n = 0;
        for (Vec3f vec : vectors) {
            res.add(vec);
            ++n;
        }
        res.mul(1.0f / (float)n);
        return res;
    }

    public float[] asArray() {
        return new float[]{this.x, this.y, this.z};
    }

    public List<Float> asList() {
        ArrayList<Float> l = new ArrayList<Float>();
        l.add(Float.valueOf(this.x));
        l.add(Float.valueOf(this.y));
        l.add(Float.valueOf(this.z));
        return l;
    }

    public float getPitch() {
        return -((float)Math.asin(this.y)) * 57.29578f;
    }

    public float getYaw() {
        return -((float)Math.atan2(this.x, this.z)) * 57.29578f;
    }

    public Vec3f copy() {
        return new Vec3f(this);
    }

    public void transform(Quaternionf quaternion) {
        Quaternionf q = new Quaternionf((Quaternionfc)quaternion);
        q.mul((Quaternionfc)new Quaternionf(this.x, this.y, this.z, 0.0f));
        Quaternionf qc = new Quaternionf((Quaternionfc)quaternion);
        qc.conjugate();
        q.mul((Quaternionfc)qc);
        this.x = q.x;
        this.y = q.y;
        this.z = q.z;
    }

    public Quaternionf rotation(float angle) {
        assert ((float)Float.compare(this.norm(), 1.0f) == 0.0f);
        float s = Mth.m_14031_((float)(angle * 0.5f));
        return new Quaternionf(this.x * s, this.y * s, this.z * s, Mth.m_14089_((float)(angle * 0.5f)));
    }

    public Quaternionf rotationDegrees(float degrees) {
        return this.rotation(degrees * ((float)Math.PI / 180));
    }

    public void rotateAlongVec(Vec3f axis, float angle) {
        assert ((float)Float.compare(axis.norm(), 1.0f) == 0.0f);
        this.transform(axis.rotation(angle));
    }

    public void rotateAlongVecDegrees(Vec3f axis, float degrees) {
        assert ((float)Float.compare(axis.norm(), 1.0f) == 0.0f);
        this.transform(axis.rotationDegrees(degrees));
    }

    public void rotateAlongOrtVec(Vec3f axis, float angle) {
        assert ((float)Float.compare(axis.norm(), 1.0f) == 0.0f);
        Vec3f cross = axis.copy();
        cross.cross(this);
        cross.mul(Mth.m_14031_((float)angle));
        this.mul(Mth.m_14089_((float)angle));
        this.add(cross);
    }

    public void rotateAlongOrtVecDegrees(Vec3f axis, float degrees) {
        this.rotateAlongOrtVec(axis, degrees * ((float)Math.PI / 180));
    }

    public float angle(Vec3f vec) {
        return (float)Math.acos(Mth.m_14036_((float)this.dot(vec), (float)-1.0f, (float)1.0f)) / (this.norm() * vec.norm());
    }

    public float angleDegrees(Vec3f vec) {
        return this.angle(vec) * 57.29578f;
    }

    public float angleUnitary(Vec3f vec) {
        return (float)Math.acos(Mth.m_14036_((float)this.dot(vec), (float)-1.0f, (float)1.0f));
    }

    public float angleUnitaryDegrees(Vec3f vec) {
        return this.angleUnitary(vec) * 57.29578f;
    }

    public float angleUnitary(Vec3f vec, Vec3f axis) {
        float angle = (float)Math.acos(Mth.m_14036_((float)this.dot(vec), (float)-1.0f, (float)1.0f));
        Vec3f compare = axis.copy();
        compare.cross(this);
        return vec.dot(compare) > 0.0f ? angle : (float)Math.PI * 2 - angle;
    }

    public float angleUnitaryDegrees(Vec3f vec, Vec3f axis) {
        return this.angleUnitary(vec, axis) * 57.29578f;
    }

    public float angleProjected(Vec3f vec, Vec3f axis) {
        Vec3f this_p = this.copy();
        Vec3f vec_p = vec.copy();
        this_p.sub(axis, this_p.dot(axis));
        vec_p.sub(axis, vec_p.dot(axis));
        if (this_p.isZero() || vec_p.isZero()) {
            return 0.0f;
        }
        this_p.unitary();
        vec_p.unitary();
        return this_p.angleUnitary(vec_p, axis);
    }

    public float angleProjectedDegrees(Vec3f vec, Vec3f axis) {
        return this.angleProjected(vec, axis) * 57.29578f;
    }

    public void mirror(Vec3f axis) {
        float d = this.dot(axis) * 2.0f;
        this.x = d * axis.x - this.x;
        this.y = d * axis.y - this.y;
        this.z = d * axis.z - this.z;
    }

    public void reflect(Vec3f axis) {
        float d = this.dot(axis) * 2.0f;
        this.x -= d * axis.x;
        this.y -= d * axis.y;
        this.z -= d * axis.z;
    }

    public Vec3f orthogonal() {
        return new Vec3f(this.y - this.z, this.z - this.x, this.x - this.y);
    }

    public Vec3f orthogonalUnitary() {
        if (this.isZero()) {
            return XP.get();
        }
        Vec3f v = new Vec3f(this.y - this.z, this.z - this.x, this.x - this.y);
        v.unitary();
        return v;
    }

    public Vec3f[] orthogonalPair() {
        Vec3f u = new Vec3f(this.y - this.z, this.z - this.x, this.x - this.y);
        Vec3f v = u.copy();
        v.cross(this);
        return new Vec3f[]{u, v};
    }

    public Vec3f[] orthogonalUnitaryPair() {
        Vec3f[] ret = this.orthogonalPair();
        ret[0].unitary();
        ret[1].unitary();
        return ret;
    }

    public void set(Vec3i vec) {
        this.x = vec.m_123341_();
        this.y = vec.m_123342_();
        this.z = vec.m_123343_();
    }

    public void set(Vector3f vec) {
        this.x = vec.x();
        this.y = vec.y();
        this.z = vec.z();
    }

    public void set(Vec3 vec) {
        this.x = (float)vec.f_82479_;
        this.y = (float)vec.f_82480_;
        this.z = (float)vec.f_82481_;
    }

    public void set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void set(double x, double y, double z) {
        this.x = (float)x;
        this.y = (float)y;
        this.z = (float)z;
    }

    public void set(Vec3f vec) {
        this.x = vec.x;
        this.y = vec.y;
        this.z = vec.z;
    }

    public void set(Vec3d vec) {
        this.x = (float)vec.x;
        this.y = (float)vec.y;
        this.z = (float)vec.z;
    }

    public void set(float yaw, float pitch) {
        this.set(yaw, pitch, true);
    }

    public void set(float yaw, float pitch, boolean degrees) {
        if (degrees) {
            pitch *= (float)Math.PI / 180;
            yaw *= (float)Math.PI / 180;
        }
        float yawCos = (float)Math.cos(yaw);
        float yawSin = (float)Math.sin(yaw);
        float pitCos = (float)Math.cos(pitch);
        float pitSin = (float)Math.sin(pitch);
        this.x = -yawSin * pitCos;
        this.y = -pitSin;
        this.z = yawCos * pitCos;
    }

    public void setRandom() {
        this.x = random.nextFloat();
        this.y = random.nextFloat();
        this.z = random.nextFloat();
    }

    public void setRandom(float range) {
        this.setRandom();
        this.mul(2.0f * range);
        this.add(-range);
    }

    public void setRandom(float min, float max) {
        this.setRandom();
        this.mul(max - min);
        this.add(min);
    }

    public void setRandomUnitary() {
        float u = random.nextFloat() * 2.0f * (float)Math.PI;
        float v = -1.0f + random.nextFloat() * 2.0f;
        float h = (float)Math.sqrt(1.0f - v * v);
        this.x = Mth.m_14089_((float)u) * h;
        this.y = Mth.m_14031_((float)u) * h;
        this.z = v;
    }

    public void setRandomSpherical() {
        float u = random.nextFloat() * 2.0f * (float)Math.PI;
        float v = -1.0f + random.nextFloat() * 2.0f;
        float r = (float)Math.sqrt(random.nextFloat());
        float h = (float)Math.sqrt(1.0f - v * v);
        this.x = Mth.m_14089_((float)u) * h * r;
        this.y = Mth.m_14031_((float)u) * h * r;
        this.z = v * r;
    }

    public void setOrthogonal(Vec3f other) {
        this.sub(other, this.dot(other));
    }

    public void setOrthogonalUnitary(Vec3f other) {
        if (other.isZero() && this.isZero()) {
            this.x = 1.0f;
            this.y = 0.0f;
            this.z = 0.0f;
        } else {
            this.sub(other, this.dot(other));
            if (this.isZero()) {
                this.x = other.y - other.z;
                this.y = other.z - other.x;
                this.z = other.x - other.y;
            }
            this.unitary();
        }
    }

    public void setOrthogonal(Vec3f u, Vec3f v) {
        u.set(this.y - this.z, this.z - this.x, this.x - this.y);
        v.set(u);
        v.cross(this);
    }

    public void setOrthogonalUnitary(Vec3f u, Vec3f v) {
        u.set(this.y - this.z, this.z - this.x, this.x - this.y);
        u.unitary();
        v.set(u);
        v.cross(this);
        v.unitary();
    }

    public static Vec3f forAxis(Direction.Axis axis) {
        if (axis == null) {
            return ZERO.get();
        }
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> XP.get();
            case Direction.Axis.Y -> YP.get();
            case Direction.Axis.Z -> ZP.get();
        };
    }

    public static Vec3f forDirection(Direction direction) {
        if (direction == null) {
            return ZERO.get();
        }
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> YP.get();
            case Direction.DOWN -> YN.get();
            case Direction.EAST -> XP.get();
            case Direction.WEST -> XN.get();
            case Direction.SOUTH -> ZP.get();
            case Direction.NORTH -> ZN.get();
        };
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            Vec3f v = (Vec3f)obj;
            if (Float.compare(v.x, this.x) != 0) {
                return false;
            }
            if (Float.compare(v.y, this.y) != 0) {
                return false;
            }
            return Float.compare(v.z, this.z) == 0;
        }
        return false;
    }

    public int hashCode() {
        int i = Float.floatToIntBits(this.x);
        i = 31 * i + Float.floatToIntBits(this.y);
        return 31 * i + Float.floatToIntBits(this.z);
    }

    public Stream<Float> stream() {
        return Stream.of(Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z));
    }

    public String toString() {
        return this.toString(defaultFormat);
    }

    public String toString(String fmt) {
        return "[" + String.format(fmt, Float.valueOf(this.x)) + ", " + String.format(fmt, Float.valueOf(this.y)) + ", " + String.format(fmt, Float.valueOf(this.z)) + "]";
    }
}

