/*
 * Decompiled with CFR 0.152.
 */
package endorh.lazulib.math;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;

public class MathParser {
    public static final Map<String, Double> UNICODE_MATH_NAMES;
    public static final Map<Map.Entry<String, Integer>, ExpressionFunc<Double>> UNICODE_MATH_FUNCTIONS;
    public static final OperatorHierarchy<Double> UNICODE_MATH_OPERATOR_HIERARCHY;
    private static final Random random;

    private static <K, V> Map<K, V> nullMap(Set<K> set) {
        HashMap<K, Object> map = new HashMap<K, Object>();
        for (K k : set) {
            map.put(k, null);
        }
        return map;
    }

    private static boolean b(double d) {
        return !Double.isNaN(d) && Math.round(d) != 0L;
    }

    private static double d(boolean b) {
        return b ? 1.0 : 0.0;
    }

    private static double d(long l) {
        return l;
    }

    private static long l(double d) {
        return (long)d;
    }

    private static int i(double d) {
        return (int)d;
    }

    public static boolean anyNaN(double[] ... values) {
        double[][] dArray = values;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[] list;
            for (double d : list = dArray[i]) {
                if (!Double.isNaN(d)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean allNaN(double[] ... values) {
        double[][] dArray = values;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[] list;
            for (double d : list = dArray[i]) {
                if (Double.isNaN(d)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean anyNaN(double ... values) {
        for (double d : values) {
            if (!Double.isNaN(d)) continue;
            return true;
        }
        return false;
    }

    public static boolean allNaN(double ... values) {
        for (double d : values) {
            if (Double.isNaN(d)) continue;
            return false;
        }
        return true;
    }

    static {
        random = new Random();
        OperatorHierarchy.Builder o = new OperatorHierarchy.Builder();
        o.addGroup(new RightAssociativeTernaryOperatorParser()).add("? :", (a, b, c) -> () -> MathParser.b((Double)a.eval()) ? (Double)b.eval() : (Double)c.eval(), new String[0]).add("\bif\b \belse\b", (a, b, c) -> () -> MathParser.b((Double)b.eval()) ? (Double)a.eval() : (Double)c.eval(), new String[0]);
        o.addGroup(new LeftAssociativeBinaryOperatorParser()).add("||", (a, b) -> () -> MathParser.d(MathParser.b((Double)a.eval()) || MathParser.b((Double)b.eval())), "\u2228", "\bor\b");
        o.addGroup(new LeftAssociativeBinaryOperatorParser()).add("\u22bb", (a, b) -> () -> MathParser.d(MathParser.b((Double)a.eval()) != MathParser.b((Double)b.eval())), "\bxor\b");
        o.addGroup(new LeftAssociativeBinaryOperatorParser()).add("&&", (a, b) -> () -> MathParser.d(MathParser.b((Double)a.eval()) && MathParser.b((Double)b.eval())), "\u2227", "\band\b");
        o.addGroup(new PrefixUnaryOperatorParser()).add("!", x -> () -> MathParser.d(!MathParser.b((Double)x.eval())), "\u00ac");
        o.addGroup(new LeftJoinedBinaryOperatorParser((a, b) -> () -> MathParser.d(MathParser.b((Double)a.eval()) && MathParser.b((Double)b.eval())))).add("==", (a, b) -> () -> MathParser.d(((Double)a.eval()).doubleValue() == ((Double)b.eval()).doubleValue()), "=").add("\u2260", (a, b) -> () -> MathParser.d(((Double)a.eval()).doubleValue() != ((Double)b.eval()).doubleValue()), "!=").add("\u2264", (a, b) -> () -> MathParser.d((Double)a.eval() <= (Double)b.eval()), "<=").add("\u2265", (a, b) -> () -> MathParser.d((Double)a.eval() >= (Double)b.eval()), ">=").add("<", (a, b) -> () -> MathParser.d((Double)a.eval() < (Double)b.eval()), "\u2268").add(">", (a, b) -> () -> MathParser.d((Double)a.eval() > (Double)b.eval()), "\u2269").dec("\u2248", (lu, ru, ld, rd) -> {
            if (!MathParser.allNaN(lu, ru, ld)) {
                return null;
            }
            if (MathParser.anyNaN(rd)) {
                return (a, b) -> () -> MathParser.d(Double.compare((Double)a.eval(), (Double)b.eval()) == 0);
            }
            double pow = Math.pow(10.0, rd);
            return (a, b) -> () -> MathParser.d(Double.compare((double)Math.round((Double)a.eval() * pow) / pow, (double)Math.round((Double)b.eval() * pow) / pow) == 0);
        }, new String[0]);
        o.addGroup(new LeftAssociativeBinaryOperatorParser()).add("?:", (a, b) -> () -> Double.isFinite((Double)a.eval()) ? (Double)a.eval() : (Double)b.eval(), new String[0]);
        o.addGroup(new LeftAssociativeBinaryOperatorParser()).add("\t|\t", (a, b) -> () -> MathParser.d(MathParser.l((Double)a.eval()) | MathParser.l((Double)b.eval())), "\u00a6");
        o.addGroup(new LeftAssociativeBinaryOperatorParser()).add("\u2295", (a, b) -> () -> MathParser.d(MathParser.l((Double)a.eval()) ^ MathParser.l((Double)b.eval())), new String[0]);
        o.addGroup(new LeftAssociativeBinaryOperatorParser()).add("&", (a, b) -> () -> MathParser.d(MathParser.l((Double)a.eval()) & MathParser.l((Double)b.eval())), new String[0]);
        o.addGroup(new LeftAssociativeBinaryOperatorParser()).add("<<", (a, b) -> () -> MathParser.d(MathParser.l((Double)a.eval()) << (int)MathParser.l((Double)b.eval())), new String[0]).add(">>>", (a, b) -> () -> MathParser.d(MathParser.l((Double)a.eval()) >>> (int)MathParser.l((Double)b.eval())), new String[0]).add(">>", (a, b) -> () -> MathParser.d(MathParser.l((Double)a.eval()) >> (int)MathParser.l((Double)b.eval())), new String[0]);
        o.addGroup(new LeftAssociativeBinaryOperatorParser()).add("+", (a, b) -> () -> (Double)a.eval() + (Double)b.eval(), new String[0]).add("-", (a, b) -> () -> (Double)a.eval() - (Double)b.eval(), new String[0]);
        o.addGroup(new LeftAssociativeBinaryOperatorParser()).add("*", (a, b) -> () -> (Double)a.eval() * (Double)b.eval(), "\u22c5", "\u00b7").add("\u00f7", (a, b) -> () -> ((Double)a.eval() - (Double)a.eval() % (Double)b.eval()) / (Double)b.eval(), "//").add("/", (a, b) -> () -> (Double)a.eval() / (Double)b.eval(), new String[0]).add("%", (a, b) -> () -> (Double)a.eval() % (Double)b.eval(), new String[0]);
        o.addGroup(new PrefixUnaryOperatorParser()).add("+", x -> x, new String[0]).add("-", x -> () -> -((Double)x.eval()).doubleValue(), new String[0]).add("~", x -> () -> MathParser.d(MathParser.l((Double)x.eval()) ^ 0xFFFFFFFFFFFFFFFFL), new String[0]);
        o.addGroup(new PrefixUnaryOperatorParser()).dec("\u221a", (lu, ru, ld, rd) -> !MathParser.allNaN(ru, ld, rd) ? null : (MathParser.anyNaN(lu) ? x -> () -> Math.sqrt((Double)x.eval()) : x -> () -> Math.pow((Double)x.eval(), 1.0 / lu)), new String[0]).add("\u221b", x -> () -> Math.cbrt((Double)x.eval()), new String[0]).add("\u221c", x -> () -> Math.pow((Double)x.eval(), 0.25), new String[0]);
        o.addGroup(new SurroundingUnaryOperatorParser()).add("( )", x -> x, new String[0]).add("| |", x -> () -> Math.abs((Double)x.eval()), new String[0]).add("\u230a \u230b", x -> () -> Math.floor((Double)x.eval()), new String[0]).add("\u2308 \u2309", x -> () -> Math.ceil((Double)x.eval()), new String[0]).add("\u230a \u2309", x -> () -> MathParser.d(Math.round((Double)x.eval())), new String[0]);
        o.addGroup(new RightAssociativeBinaryOperatorParser()).add("^-", (a, b) -> () -> Math.pow((Double)a.eval(), -((Double)b.eval()).doubleValue()), new String[0]).add("^", (a, b) -> () -> Math.pow((Double)a.eval(), (Double)b.eval()), new String[0]);
        o.setDecoratorFactory((lu, ru, ld, rd) -> MathParser.allNaN(lu, ru, ld, rd) ? x -> x : (!MathParser.allNaN(lu, ld, rd) ? null : x -> () -> Math.pow((Double)x.eval(), ru)));
        UNICODE_MATH_OPERATOR_HIERARCHY = o.build();
        UNICODE_MATH_NAMES = new ExpressionNamespaceBuilder<Double>().add("\u03c0", Math.PI).add("e", Math.E).add("NaN", Double.NaN).add("\u221e", Double.POSITIVE_INFINITY).build();
        UNICODE_MATH_FUNCTIONS = new ExpressionFuncMapBuilder<Double>().add("sqrt", Math::sqrt).add("cbrt", Math::cbrt).add("sin", Math::sin).add("cos", Math::cos).add("tan", Math::tan).add("sec", x -> 1.0 / Math.cos(x)).add("csc", x -> 1.0 / Math.sin(x)).add("cot", x -> 1.0 / Math.tan(x)).add("asin", Math::asin).add("acos", Math::acos).add("atan", Math::atan).add("asec", x -> Math.acos(1.0 / x)).add("acsc", x -> Math.asin(1.0 / x)).add("acot", x -> Math.atan(1.0 / x)).add("atan", Math::atan2).add("atan2", Math::atan2).add("rad", Math::toRadians).add("deg", Math::toDegrees).add("sind", x -> Math.sin(Math.toRadians(x))).add("cosd", x -> Math.cos(Math.toRadians(x))).add("tand", x -> Math.tan(Math.toRadians(x))).add("secd", x -> 1.0 / Math.cos(Math.toRadians(x))).add("cscd", x -> 1.0 / Math.sin(Math.toRadians(x))).add("cotd", x -> 1.0 / Math.tan(Math.toRadians(x))).add("asind", x -> Math.toDegrees(Math.asin(x))).add("acosd", x -> Math.toDegrees(Math.acos(x))).add("atand", x -> Math.toDegrees(Math.atan(x))).add("asecd", x -> Math.toDegrees(Math.acos(1.0 / x))).add("acscd", x -> Math.toDegrees(Math.asin(1.0 / x))).add("acotd", x -> Math.toDegrees(Math.atan(1.0 / x))).add("atand", (y, x) -> Math.toDegrees(Math.atan2(y, x))).add("sinh", Math::sinh).add("cosh", Math::cosh).add("tanh", Math::tanh).add("sech", x -> 1.0 / Math.cosh(x)).add("csch", x -> 1.0 / Math.sinh(x)).add("tanh", x -> 1.0 / Math.tanh(x)).add("asinh", x -> Math.log(x + Math.sqrt(x * x + 1.0))).add("acosh", x -> Math.log(x + Math.sqrt(x * x - 1.0))).add("atanh", x -> Math.log((1.0 + x) / (1.0 - x)) / 2.0).add("acoth", x -> Math.log((x + 1.0) / (x - 1.0)) / 2.0).add("asech", x -> Math.log((1.0 + Math.sqrt(1.0 - x * x)) / x)).add("acsch", x -> Math.log((1.0 + Math.sqrt(x * x + 1.0)) / x)).add("exp", Math::exp).add("ln", Math::log).add("log", Math::log).add("log2", x -> Math.log(x) / Math.log(2.0)).add("log10", Math::log10).add("log1p", Math::log1p).add("mod", (a, b) -> a < 0.0 ? a % b + b : a % b).add("rem", (a, b) -> a % b).add("abs", x -> Math.abs(x)).add("max", (a, b) -> Math.max(a, b)).add("min", (a, b) -> Math.min(a, b)).add("clamp", (x, min, max) -> Math.min(max, Math.max(min, x))).add("lerp", (t, min, max) -> t * max + (1.0 - t) * min).add("clampLerp", (t, min, max) -> t <= 0.0 ? min : (t >= 1.0 ? max : t * max + (1.0 - t) * min)).add("sign", x -> Math.signum(x)).add("copySign", (x, y) -> Math.copySign(x, y)).add("flipSign", (x, y) -> Math.copySign(x, x * y)).add("relu", x -> Math.max(0.0, x)).add("sigmoid", x -> 1.0 / (1.0 + Math.exp(-x.doubleValue()))).add("rect", x -> Math.abs(x) > 0.5 ? 0.0 : (Math.abs(x) == 0.5 ? 0.5 : 1.0)).add("round", x -> MathParser.d(Math.round(x))).add("floor", Math::floor).add("ceil", Math::ceil).add("sinc", x -> x == 0.0 ? 1.0 : Math.sin(Math.PI * x) / (Math.PI * x)).add("cosc", x -> x == 0.0 ? 0.0 : Math.cos(Math.PI * x) / x - Math.sin(Math.PI * x) / (Math.PI * x * x)).add("isNaN", x -> MathParser.d(Double.isNaN(x))).add("isFinite", x -> MathParser.d(Double.isFinite(x))).add("isInfinite", x -> MathParser.d(Double.isInfinite(x))).add("rand", Math::random).add("rand", d -> random.nextDouble() * d).add("rand", (a, b) -> a + random.nextDouble() * (b - a)).add("randGaussian", () -> random.nextGaussian()).add("randGaussian", s -> random.nextGaussian() * s).add("randGaussian", (m, s) -> m + random.nextGaussian() * s).add("randInt", i -> MathParser.d(random.nextInt(MathParser.i(i)))).add("randInt", (a, b) -> a + (double)random.nextInt(MathParser.i(b - a))).add("quadInOut", t -> t <= 0.0 ? 0.0 : (t <= 0.5 ? 2.0 * t * t : (t < 1.0 ? -1.0 + (4.0 - 2.0 * t) * t : 1.0))).add("quadIn", t -> t <= 0.0 ? 0.0 : (t < 1.0 ? t * t : 1.0)).add("quadOut", t -> t <= 0.0 ? 0.0 : (t < 1.0 ? 2.0 * t - t * t : 1.0)).build();
    }

    public static interface UnaryOperator<T>
    extends Operator<T> {
        @Override
        default public ExpressionNode<T> apply(ExpressionNode<T> ... inputs) {
            return this.apply(inputs[0]);
        }

        public ExpressionNode<T> apply(ExpressionNode<T> var1);
    }

    @FunctionalInterface
    public static interface ExpressionNode<T> {
        public T eval();
    }

    public static interface BinaryOperator<T>
    extends Operator<T> {
        @Override
        default public ExpressionNode<T> apply(ExpressionNode<T> ... inputs) {
            return this.apply(inputs[0], inputs[1]);
        }

        public ExpressionNode<T> apply(ExpressionNode<T> var1, ExpressionNode<T> var2);
    }

    public static class OperatorHierarchy<T> {
        private final List<Map.Entry<OperatorParser<T, ?>, LinkedHashMap<String, Operator<T>>>> list;
        private final DecoratedOperator<T, ? extends UnaryOperator<T>> decoratorFactory;
        private final Set<Character> operatorCharacters;

        public OperatorHierarchy(List<Map.Entry<OperatorParser<T, ?>, LinkedHashMap<String, Operator<T>>>> operators, DecoratedOperator<T, ? extends UnaryOperator<T>> decoratorFactory) {
            this.list = operators;
            this.decoratorFactory = decoratorFactory;
            this.operatorCharacters = new HashSet<Character>();
            for (Map.Entry<OperatorParser<T, ?>, LinkedHashMap<String, Operator<T>>> entry : operators) {
                for (String str : entry.getValue().keySet()) {
                    str = str.replaceAll("\\s", "");
                    for (int i = 0; i < str.length(); ++i) {
                        this.operatorCharacters.add(Character.valueOf(str.charAt(i)));
                    }
                }
            }
        }

        public Map.Entry<OperatorParser<T, ?>, LinkedHashMap<String, Operator<T>>> get(int i) {
            return this.list.get(i);
        }

        public int size() {
            return this.list.size();
        }

        public DecoratedOperator<T, ? extends UnaryOperator<T>> getDecoratorFactory() {
            return this.decoratorFactory;
        }

        public boolean use(char ch) {
            return this.operatorCharacters.contains(Character.valueOf(ch));
        }

        public List<Map.Entry<OperatorParser<T, ?>, LinkedHashMap<String, Operator<T>>>> copyList() {
            return new ArrayList(this.list);
        }

        public static class Builder<T> {
            private final List<Map.Entry<OperatorParser<T, ?>, LinkedHashMap<String, Operator<T>>>> list = new ArrayList();
            private DecoratedOperator<T, UnaryOperator<T>> decoratorFactory = null;
            private int caret = -1;

            public DecoratedOperator<T, UnaryOperator<T>> getDecoratorFactory() {
                return this.decoratorFactory;
            }

            public void setDecoratorFactory(DecoratedOperator<T, UnaryOperator<T>> decorator) {
                this.decoratorFactory = decorator;
            }

            public <O extends Operator<T>> GroupBuilder<T, O> addGroup(OperatorParser<T, O> parserFactory) {
                Pair p = Pair.of(parserFactory, new LinkedHashMap());
                this.list.add((Map.Entry<OperatorParser<T, ?>, LinkedHashMap<String, Operator<T>>>)p);
                this.caret = this.list.size() - 1;
                return new GroupBuilder(p);
            }

            public <O extends Operator<T>> GroupBuilder<T, O> insertGroup(int i, OperatorParser<T, O> parserFactory, Class<O> cls) {
                Pair p = Pair.of(parserFactory, new LinkedHashMap());
                this.list.add(i, (Map.Entry<OperatorParser<T, ?>, LinkedHashMap<String, Operator<T>>>)p);
                this.caret = i;
                return new GroupBuilder(p);
            }

            public OperatorHierarchy<T> build() {
                return new OperatorHierarchy<T>(this.list, this.decoratorFactory);
            }

            public static class GroupBuilder<T, O extends Operator<T>> {
                private final Map.Entry<OperatorParser<T, O>, LinkedHashMap<String, Operator<T>>> entry;

                public GroupBuilder(Map.Entry<OperatorParser<T, O>, LinkedHashMap<String, Operator<T>>> entry) {
                    this.entry = entry;
                }

                public GroupBuilder<T, O> add(String name, O op, String ... aliases) {
                    LinkedHashMap<String, Operator<T>> map = this.entry.getValue();
                    map.put(name, (Operator<T>)op);
                    for (String alias : aliases) {
                        map.put(alias, (Operator<T>)op);
                    }
                    return this;
                }

                public GroupBuilder<T, O> dec(String name, DecoratedOperator<T, O> op, String ... aliases) {
                    LinkedHashMap<String, Operator<T>> map = this.entry.getValue();
                    map.put(name, op);
                    for (String alias : aliases) {
                        map.put(alias, op);
                    }
                    return this;
                }
            }
        }
    }

    public static class RightAssociativeTernaryOperatorParser<T>
    extends TernaryOperatorParser<T> {
        @Override
        public ExpressionNode<T> parse(LinkedHashMap<String, Operator<T>> operators) {
            int p;
            ExpressionNode x = this.e.next();
            block0: while (true) {
                p = this.e.pos;
                double[] pre = this.e.eatScript();
                for (Map.Entry<String, Operator<T>> pair : operators.entrySet()) {
                    String[] split = pair.getKey().split(" ");
                    if (split.length != 2) {
                        throw new IllegalArgumentException("Ternary operator with " + split.length + " parts, must be 2");
                    }
                    Operator<T> op = pair.getValue();
                    if (split[0].equals(split[1])) {
                        throw new IllegalArgumentException("Ternary operator pairs must be different, used '" + this.e.displayName(split[0]) + "' for both");
                    }
                    if (!this.e.eatString(split[0])) continue;
                    if (op instanceof DecoratedOperator) {
                        op = this.decorate(op, pre);
                    }
                    if (!(op instanceof TernaryOperator)) {
                        throw new IllegalArgumentException("Used non-ternary operator with ternary operator builder");
                    }
                    ExpressionNode a = x;
                    ExpressionNode<T> b = this.parse(operators);
                    if (!this.e.eatString(split[1])) {
                        throw this.e.parseException("Missing right pair for ternary operator: '" + this.e.displayName(split[0]) + "', expected: '" + this.e.displayName(split[1]) + "'");
                    }
                    ExpressionNode<T> c = this.parse(operators);
                    x = this.apply(op, a, b, c);
                    continue block0;
                }
                break;
            }
            this.e.setCursor(p);
            return x;
        }
    }

    public static abstract class OperatorParser<T, O extends Operator<T>> {
        protected InternalExpressionParser<T> e;

        public OperatorParser<T, O> init(InternalExpressionParser<T> e) {
            this.e = e;
            return this;
        }

        public abstract ExpressionNode<T> parse(LinkedHashMap<String, Operator<T>> var1);

        protected final Operator<T> decorate(Operator<T> op, double[] pre) {
            return this.e.decorate((DecoratedOperator)op).decorate(this.e, pre);
        }

        @SafeVarargs
        protected final ExpressionNode<T> apply(Operator<T> op, ExpressionNode<T> ... inputs) {
            return this.e.decorate(op).apply(inputs);
        }
    }

    public static interface TernaryOperator<T>
    extends Operator<T> {
        @Override
        default public ExpressionNode<T> apply(ExpressionNode<T> ... inputs) {
            return this.apply(inputs[0], inputs[1], inputs[2]);
        }

        public ExpressionNode<T> apply(ExpressionNode<T> var1, ExpressionNode<T> var2, ExpressionNode<T> var3);
    }

    @FunctionalInterface
    public static interface Operator<T> {
        public ExpressionNode<T> apply(ExpressionNode<T> ... var1);
    }

    public static class LeftAssociativeBinaryOperatorParser<T>
    extends BinaryOperatorParser<T, BinaryOperator<T>> {
        @Override
        public ExpressionNode<T> parse(LinkedHashMap<String, Operator<T>> operators) {
            int p;
            ExpressionNode x = this.e.next();
            block0: while (true) {
                p = this.e.pos;
                double[] pre = this.e.eatScript();
                for (Map.Entry<String, Operator<T>> pair : operators.entrySet()) {
                    Operator<T> op = pair.getValue();
                    if (!this.e.eatString(pair.getKey())) continue;
                    if (op instanceof DecoratedOperator) {
                        op = this.decorate(op, pre);
                    } else if (!MathParser.allNaN(pre)) {
                        throw this.e.scriptParseException(pre);
                    }
                    if (!(op instanceof BinaryOperator)) {
                        throw new IllegalArgumentException("Used non-binary operator with binary operator builder");
                    }
                    ExpressionNode a = x;
                    ExpressionNode b = this.e.next();
                    x = this.apply(op, a, b);
                    continue block0;
                }
                break;
            }
            this.e.setCursor(p);
            return x;
        }
    }

    public static class PrefixUnaryOperatorParser<T>
    extends UnaryOperatorParser<T, UnaryOperator<T>> {
        @Override
        public ExpressionNode<T> parse(LinkedHashMap<String, Operator<T>> operators) {
            int p = this.e.pos;
            double[] pre = this.e.eatScript();
            for (Map.Entry<String, Operator<T>> pair : operators.entrySet()) {
                Operator<T> op = pair.getValue();
                if (!this.e.eatString(pair.getKey())) continue;
                if (op instanceof DecoratedOperator) {
                    op = this.decorate(op, pre);
                }
                if (!(op instanceof UnaryOperator)) {
                    throw new IllegalArgumentException("Used non-unary operator on prefix unary operator builder'");
                }
                return this.apply(op, this.e.next());
            }
            this.e.setCursor(p);
            return this.e.next();
        }
    }

    public static class LeftJoinedBinaryOperatorParser<T>
    extends BinaryOperatorParser<T, BinaryOperator<T>> {
        protected final BinaryOperator<T> joiner;

        public LeftJoinedBinaryOperatorParser(BinaryOperator<T> joiner) {
            this.joiner = joiner;
        }

        @Override
        public ExpressionNode<T> parse(LinkedHashMap<String, Operator<T>> operators) {
            int p;
            ExpressionNode x = null;
            ExpressionNode a = this.e.next();
            block0: while (true) {
                p = this.e.pos;
                double[] pre = this.e.eatScript();
                for (Map.Entry<String, Operator<T>> pair : operators.entrySet()) {
                    Operator<T> op = pair.getValue();
                    if (!this.e.eatString(pair.getKey())) continue;
                    if (op instanceof DecoratedOperator) {
                        op = this.decorate(op, pre);
                    } else if (!MathParser.allNaN(pre)) {
                        throw this.e.scriptParseException(pre);
                    }
                    if (!(op instanceof BinaryOperator)) {
                        throw new IllegalArgumentException("Used non-binary operator with comparator (binary) operator builder");
                    }
                    ExpressionNode b = this.e.next();
                    ExpressionNode<T> c = this.apply(op, a, b);
                    a = b;
                    x = x != null ? this.apply(this.joiner, x, c) : c;
                    continue block0;
                }
                break;
            }
            this.e.setCursor(p);
            return x != null ? x : a;
        }
    }

    public static interface DecoratedOperator<T, O extends Operator<T>>
    extends OperatorFactory<T, O> {
        @Override
        default public O get(double ... args) {
            return this.get(args[0], args[1], args[2], args[3]);
        }

        public O get(double var1, double var3, double var5, double var7);

        default public O get(double[] pre, double[] pos) {
            if (pos == null) {
                return this.get(pre[0], Double.NaN, pre[1], Double.NaN);
            }
            return this.get(pre[0], pos[0], pre[1], pos[1]);
        }

        default public O decorate(InternalExpressionParser<T> e, double[] pre) {
            int p = e.pos;
            double[] pos = e.eatScript();
            O op = this.get(pre, pos);
            if (op == null) {
                op = this.get(pre, (double[])null);
                e.setCursor(p);
            }
            if (op == null) {
                throw e.scriptParseException(pre, pos);
            }
            return op;
        }
    }

    public static class SurroundingUnaryOperatorParser<T>
    extends UnaryOperatorParser<T, UnaryOperator<T>> {
        @Override
        public ExpressionNode<T> parse(LinkedHashMap<String, Operator<T>> operators) {
            int start = this.e.pos;
            double[] pre = this.e.eatScript();
            for (Map.Entry<String, Operator<T>> pair : operators.entrySet()) {
                Operator<T> op;
                ExpressionNode x;
                block5: {
                    String[] split = pair.getKey().split(" ");
                    if (!this.e.eatString(split[0])) continue;
                    x = this.e.first();
                    if (!this.e.eatString(split[1])) {
                        for (Map.Entry<String, Operator<T>> entry : operators.entrySet()) {
                            String[] sp = entry.getKey().split(" ");
                            if (!split[0].equals(sp[0]) || !this.e.eatString(sp[1])) continue;
                            pair = entry;
                            break block5;
                        }
                        throw this.e.parseException("Missing closing right pair for surrounding unary operator: '" + split[0] + "', expected '" + split[1] + "'");
                    }
                }
                if ((op = pair.getValue()) instanceof DecoratedOperator) {
                    return this.apply(this.decorate(op, pre), x);
                }
                if (!(op instanceof UnaryOperator)) {
                    throw new IllegalArgumentException("Tried to use non-unary operator with SurroundingUnaryOperatorParser");
                }
                return this.e.decorate(this.apply(op, x), pre);
            }
            this.e.setCursor(start);
            return this.e.next();
        }
    }

    public static class RightAssociativeBinaryOperatorParser<T>
    extends BinaryOperatorParser<T, BinaryOperator<T>> {
        @Override
        public ExpressionNode<T> parse(LinkedHashMap<String, Operator<T>> operators) {
            int p;
            Stack stack = new Stack();
            Stack<BinaryOperator> ops = new Stack<BinaryOperator>();
            stack.add(this.e.next());
            block0: while (true) {
                p = this.e.pos;
                double[] pre = this.e.eatScript();
                for (Map.Entry<String, Operator<T>> pair : operators.entrySet()) {
                    Operator<T> op = pair.getValue();
                    if (!this.e.eatString(pair.getKey())) continue;
                    if (op instanceof DecoratedOperator) {
                        op = this.decorate(op, pre);
                    } else if (!MathParser.allNaN(pre)) {
                        throw this.e.scriptParseException(pre);
                    }
                    if (!(op instanceof BinaryOperator)) {
                        throw new IllegalArgumentException("Used non-binary operator with binary operator builder");
                    }
                    ops.add((BinaryOperator)op);
                    stack.add(this.e.next());
                    continue block0;
                }
                break;
            }
            this.e.setCursor(p);
            if (stack.size() == 1) {
                return (ExpressionNode)stack.pop();
            }
            ExpressionNode x = (ExpressionNode)stack.pop();
            while (!stack.empty()) {
                assert (!ops.empty());
                x = this.apply((Operator)ops.pop(), (ExpressionNode)stack.pop(), x);
            }
            assert (ops.empty());
            return x;
        }
    }

    public static class ExpressionNamespaceBuilder<T> {
        private Map<String, T> map = new HashMap<String, T>();

        public ExpressionNamespaceBuilder<T> add(String name, T value) {
            if (this.map == null) {
                throw new IllegalStateException("Cannot reuse built namespace builder");
            }
            this.map.put(name, value);
            return this;
        }

        public Map<String, T> build() {
            Map<String, T> ret = this.map;
            this.map = null;
            return ret;
        }
    }

    public static class ExpressionFuncMapBuilder<T> {
        private Map<Map.Entry<String, Integer>, ExpressionFunc<T>> map = new HashMap<Map.Entry<String, Integer>, ExpressionFunc<T>>();
        private Map<Map.Entry<String, Integer>, ExpressionFunc<T>> lastMap = null;

        public ExpressionFuncMapBuilder<T> add(String name, ExpressionFunc<T> func) {
            if (this.map == null) {
                this.map = new HashMap<Map.Entry<String, Integer>, ExpressionFunc<T>>(this.lastMap);
            }
            this.map.put((Map.Entry<String, Integer>)Pair.of((Object)name, (Object)func.getNumberOfArguments()), func);
            return this;
        }

        public ExpressionFuncMapBuilder<T> add(String name, Func0<T> func) {
            return this.add(name, (ExpressionFunc<T>)func);
        }

        public ExpressionFuncMapBuilder<T> add(String name, Func1<T> func) {
            return this.add(name, (ExpressionFunc<T>)func);
        }

        public ExpressionFuncMapBuilder<T> add(String name, Func2<T> func) {
            return this.add(name, (ExpressionFunc<T>)func);
        }

        public ExpressionFuncMapBuilder<T> add(String name, Func3<T> func) {
            return this.add(name, (ExpressionFunc<T>)func);
        }

        public ExpressionFuncMapBuilder<T> add(String name, Func4<T> func) {
            return this.add(name, (ExpressionFunc<T>)func);
        }

        public ExpressionFuncMapBuilder<T> add(String name, Func5<T> func) {
            return this.add(name, (ExpressionFunc<T>)func);
        }

        public Map<Map.Entry<String, Integer>, ExpressionFunc<T>> build() {
            this.lastMap = this.map;
            this.map = null;
            return this.lastMap;
        }
    }

    public static interface Func1<T>
    extends ExpressionFunc<T> {
        @Override
        default public int getNumberOfArguments() {
            return 1;
        }

        @Override
        default public T eval(T ... inputs) {
            return this.eval(inputs[0]);
        }

        public T eval(T var1);
    }

    public static interface Func2<T>
    extends ExpressionFunc<T> {
        @Override
        default public int getNumberOfArguments() {
            return 2;
        }

        @Override
        default public T eval(T ... inputs) {
            return this.eval(inputs[0], inputs[1]);
        }

        public T eval(T var1, T var2);
    }

    public static interface Func3<T>
    extends ExpressionFunc<T> {
        @Override
        default public int getNumberOfArguments() {
            return 3;
        }

        @Override
        default public T eval(T ... inputs) {
            return this.eval(inputs[0], inputs[1], inputs[2]);
        }

        public T eval(T var1, T var2, T var3);
    }

    public static interface Func0<T>
    extends ExpressionFunc<T> {
        @Override
        default public int getNumberOfArguments() {
            return 0;
        }

        @Override
        default public T eval(T ... inputs) {
            return this.eval();
        }

        public T eval();
    }

    public static class NameNotDefinedException
    extends RuntimeException {
        public NameNotDefinedException(String name) {
            super("The name \"" + name + "\" is not defined");
        }
    }

    public static class KeyNotDefinedException
    extends RuntimeException {
        public KeyNotDefinedException(Object key) {
            super("The key \"" + key + "\" is not defined");
        }
    }

    public static class FixedNamespaceSet<V> {
        private final Map<String, Map<String, V>> values = new HashMap<String, Map<String, V>>();
        private final Map<String, Map<String, V>> initial = new HashMap<String, Map<String, V>>();
        private final Map<String, Pair<String, String>> shortcuts;
        public final String separator;
        public final String defaultNamespace;

        public static <V> FixedNamespaceSet<V> of(@Nonnull Set<String> namespace) {
            return FixedNamespaceSet.of(MathParser.nullMap(namespace));
        }

        public static <V> FixedNamespaceSet<V> of(@Nonnull Set<String> namespace, @Nonnull String defaultNamespace) {
            return FixedNamespaceSet.of(MathParser.nullMap(namespace), defaultNamespace);
        }

        public static <V> FixedNamespaceSet<V> of(@Nonnull Set<String> namespace, @Nonnull String defaultNamespace, @Nonnull String separator) {
            return FixedNamespaceSet.of(MathParser.nullMap(namespace), defaultNamespace, separator);
        }

        public static <V> FixedNamespaceSet<V> of(@Nonnull Map<String, V> namespace) {
            return FixedNamespaceSet.of(namespace, "", ":");
        }

        public static <V> FixedNamespaceSet<V> of(@Nonnull Map<String, V> namespace, @Nonnull String defaultNamespace) {
            return FixedNamespaceSet.of(namespace, defaultNamespace, ":");
        }

        public static <V> FixedNamespaceSet<V> of(@Nonnull Map<String, V> namespace, @Nonnull String defaultNamespace, @Nonnull String separator) {
            HashMap<String, Map<String, Map>> set = new HashMap<String, Map<String, Map>>();
            for (String name : namespace.keySet()) {
                String nm;
                String ns;
                if (name.contains(separator)) {
                    int i = name.indexOf(separator);
                    ns = name.substring(0, i);
                    nm = name.substring(i + separator.length());
                } else {
                    ns = defaultNamespace;
                    nm = name;
                }
                set.computeIfAbsent(ns, s -> new HashMap()).put(nm, namespace.get(name));
            }
            return new FixedNamespaceSet<V>(set, defaultNamespace, separator);
        }

        public FixedNamespaceSet() {
            this(new HashMap<String, Map<String, V>>(), "", ":");
        }

        public FixedNamespaceSet(Map<String, Map<String, V>> namespaces) {
            this(namespaces, "", ":");
        }

        public FixedNamespaceSet(Map<String, Map<String, V>> namespaces, String defaultNamespace) {
            this(namespaces, defaultNamespace, ":");
        }

        public FixedNamespaceSet(Map<String, Map<String, V>> namespaces, String defaultNamespace, String separator) {
            for (String namespace : namespaces.keySet()) {
                this.values.put(namespace, new HashMap<String, V>(namespaces.get(namespace)));
                this.initial.put(namespace, new HashMap<String, V>(namespaces.get(namespace)));
            }
            this.separator = separator;
            this.defaultNamespace = defaultNamespace;
            HashMap<String, Integer> nameCounts = new HashMap<String, Integer>();
            HashMap<String, String> last = new HashMap<String, String>();
            for (String string : this.initial.keySet()) {
                for (String name : this.initial.get(string).keySet()) {
                    nameCounts.put(name, nameCounts.getOrDefault(name, 0) + 1);
                    if (name.equals(defaultNamespace)) continue;
                    last.put(name, string);
                }
            }
            this.shortcuts = new HashMap<String, Pair<String, String>>();
            for (Map.Entry entry : nameCounts.entrySet()) {
                String key = (String)entry.getKey();
                if ((Integer)entry.getValue() != 1 || !last.containsKey(key)) continue;
                this.shortcuts.put(key, (Pair<String, String>)Pair.of((Object)((String)last.get(key)), (Object)key));
            }
        }

        public FixedNamespaceSet(FixedNamespaceSet<V> source) {
            this(source, source.defaultNamespace, source.separator);
        }

        public FixedNamespaceSet(FixedNamespaceSet<V> source, String defaultNamespace) {
            this(source, defaultNamespace, source.separator);
        }

        public FixedNamespaceSet(FixedNamespaceSet<V> source, String defaultNamespace, String separator) {
            this(source.initial, defaultNamespace, separator);
            this.values.putAll(source.values);
        }

        public void putAll(Map<String, Map<String, V>> source) {
            for (String namespace : source.keySet()) {
                Map<String, V> space = this.getNamespace(namespace);
                for (Map.Entry<String, V> entry : source.get(namespace).entrySet()) {
                    if (!space.containsKey(entry.getKey())) {
                        throw new NameNotDefinedException(namespace + this.separator + entry.getKey());
                    }
                    space.put(entry.getKey(), entry.getValue());
                }
            }
        }

        public void putFrom(Map<String, V> source) {
            for (String name : source.keySet()) {
                Pair<String, String> split = this.split(name);
                if (!this.containsName((String)split.getLeft(), (String)split.getRight())) {
                    throw new NameNotDefinedException(name);
                }
                this.set((String)split.getLeft(), (String)split.getRight(), source.get(name));
            }
        }

        public void putAll(FixedNamespaceSet<V> source) {
            for (String namespace : source.initial.keySet()) {
                Map<String, V> space = this.getNamespace(namespace);
                Map<String, V> src = source.values.get(namespace);
                for (String name : src.keySet()) {
                    if (!space.containsKey(name)) {
                        throw new NameNotDefinedException(namespace + this.separator + name);
                    }
                    space.put(name, src.get(name));
                }
            }
        }

        public void setAll(Map<String, Map<String, V>> source) {
            for (String namespace : this.values.keySet()) {
                if (!source.containsKey(namespace)) continue;
                Map<String, V> dest = this.values.get(namespace);
                Map<String, V> space = source.get(namespace);
                for (String name : dest.keySet()) {
                    if (!space.containsKey(name)) continue;
                    dest.put(name, space.get(name));
                }
            }
        }

        public void setFrom(Map<String, V> source) {
            for (String name : source.keySet()) {
                Pair<String, String> split = this.split(name);
                if (!this.containsName((String)split.getLeft(), (String)split.getRight())) continue;
                this.set((String)split.getLeft(), (String)split.getRight(), source.get(name));
            }
        }

        public void setAll(FixedNamespaceSet<V> source) {
            for (String namespace : this.values.keySet()) {
                if (!source.values.containsKey(namespace)) continue;
                Map<String, V> dest = this.values.get(namespace);
                Map<String, V> space = source.values.get(namespace);
                for (String name : dest.keySet()) {
                    if (!space.containsKey(name)) continue;
                    dest.put(name, space.get(name));
                }
            }
        }

        public void set(String namespace, String name, V value) {
            Map<String, V> space = this.getNamespace(namespace);
            if (!space.containsKey(name)) {
                throw new NameNotDefinedException(name);
            }
            space.put(name, value);
        }

        public void set(String name, V value) {
            Pair<String, String> split = this.split(name);
            this.set((String)split.getLeft(), (String)split.getRight(), value);
        }

        public V get(String namespace, String name) {
            Map<String, V> space = this.getNamespace(namespace);
            if (!space.containsKey(name)) {
                throw new NameNotDefinedException(name);
            }
            return space.get(name);
        }

        public V get(String name) {
            Pair<String, String> split = this.split(name);
            return this.get((String)split.getLeft(), (String)split.getRight());
        }

        public boolean containsNamespace(String namespace) {
            return this.values.containsKey(namespace);
        }

        public boolean containsName(String namespace, String name) {
            return this.containsNamespace(namespace) && this.getNamespace(namespace).containsKey(name);
        }

        public boolean containsName(String name) {
            Pair<String, String> split = this.split(name);
            return this.containsName((String)split.getLeft(), (String)split.getRight());
        }

        public boolean containsValue(V value) {
            for (Map<String, V> space : this.values.values()) {
                if (!space.containsValue(value)) continue;
                return true;
            }
            return false;
        }

        public boolean containsValue(String namespace, V value) {
            return this.getNamespace(namespace).containsValue(value);
        }

        public Pair<String, String> split(String name) {
            if (name.contains(this.separator)) {
                int i = name.indexOf(this.separator);
                return Pair.of((Object)name.substring(0, i), (Object)name.substring(i + this.separator.length()));
            }
            if (this.shortcuts.containsKey(name)) {
                return this.shortcuts.get(name);
            }
            return Pair.of((Object)this.defaultNamespace, (Object)name);
        }

        public Set<String> namespaceSet() {
            return this.values.keySet();
        }

        public Set<String> nameSet(String namespace) {
            return this.getNamespace(namespace).keySet();
        }

        public Collection<V> values(String namespace) {
            return this.getNamespace(namespace).values();
        }

        public Collection<V> values() {
            ArrayList<V> c = new ArrayList<V>();
            for (String namespace : this.values.keySet()) {
                c.addAll(this.values.get(namespace).values());
            }
            return c;
        }

        public void reset(String namespace) {
            this.getNamespace(namespace).putAll(this.initial.get(namespace));
        }

        public void reset() {
            for (String namespace : this.initial.keySet()) {
                this.values.get(namespace).putAll(this.initial.get(namespace));
            }
        }

        public FixedNamespaceSet<V> copy() {
            return new FixedNamespaceSet<V>(this);
        }

        public FixedNamespaceSet<V> copyWith(Map<String, Map<String, V>> extra) {
            HashMap<String, Map<String, HashMap<String, V>>> initial = new HashMap<String, Map<String, HashMap<String, V>>>();
            for (String namespace : extra.keySet()) {
                initial.put(namespace, new HashMap<String, V>(extra.get(namespace)));
            }
            for (String namespace : this.initial.keySet()) {
                initial.put(namespace, new HashMap<String, V>(this.initial.get(namespace)));
            }
            FixedNamespaceSet<V> set = new FixedNamespaceSet<V>(initial, this.defaultNamespace, this.separator);
            set.setAll(this.values);
            return set;
        }

        public Map<String, Pair<String, String>> getShortcuts() {
            return Collections.unmodifiableMap(this.shortcuts);
        }

        private Map<String, V> getNamespace(String namespace) {
            if (!this.values.containsKey(namespace)) {
                throw new NameNotDefinedException(namespace);
            }
            return this.values.get(namespace);
        }
    }

    public static class FixedNamespace<K, V> {
        private final Map<K, V> values;
        private final Map<K, V> initial;

        public FixedNamespace() {
            this(new HashMap());
        }

        public FixedNamespace(@Nonnull Map<K, V> namespace) {
            this.initial = new HashMap<K, V>(namespace);
            this.values = new HashMap<K, V>(namespace);
        }

        public FixedNamespace(@Nonnull FixedNamespace<K, V> source) {
            this.values = new HashMap<K, V>(source.values);
            this.initial = new HashMap<K, V>(source.values);
        }

        public void putAll(Map<K, V> source) {
            for (K key : source.keySet()) {
                if (!this.initial.containsKey(key)) {
                    throw new KeyNotDefinedException(key);
                }
                this.values.put(key, source.get(key));
            }
        }

        public void putAll(FixedNamespace<K, V> source) {
            for (K key : source.initial.keySet()) {
                if (!this.initial.containsKey(key)) {
                    throw new KeyNotDefinedException(key);
                }
                this.values.put(key, source.get(key));
            }
        }

        public void setAll(Map<K, V> source) {
            for (K key : this.initial.keySet()) {
                if (!source.containsKey(key)) continue;
                this.values.put(key, source.get(key));
            }
        }

        public void setAll(FixedNamespace<K, V> source) {
            for (K key : this.initial.keySet()) {
                if (!source.contains(key)) continue;
                this.values.put(key, source.get(key));
            }
        }

        public void set(K key, V value) {
            if (!this.initial.containsKey(key)) {
                throw new KeyNotDefinedException(key);
            }
            this.values.put(key, value);
        }

        public V get(K key) {
            if (!this.initial.containsKey(key)) {
                throw new KeyNotDefinedException(key);
            }
            return this.values.get(key);
        }

        public boolean contains(K key) {
            return this.initial.containsKey(key);
        }

        public boolean containsValue(V value) {
            return this.values.containsValue(value);
        }

        public void reset() {
            this.values.putAll(this.initial);
        }

        public Set<K> keySet() {
            return this.initial.keySet();
        }

        public Collection<V> values() {
            return this.values.values();
        }

        public FixedNamespace<K, V> copy() {
            return new FixedNamespace<K, V>(this);
        }

        public FixedNamespace<K, V> copyWith(Map<K, V> extra) {
            HashMap<K, V> initial = new HashMap<K, V>(extra);
            initial.putAll(this.initial);
            FixedNamespace<K, V> namespace = new FixedNamespace<K, V>(initial);
            namespace.setAll(this.values);
            return namespace;
        }
    }

    public static interface Func5<T>
    extends ExpressionFunc<T> {
        @Override
        default public int getNumberOfArguments() {
            return 5;
        }

        @Override
        default public T eval(T ... inputs) {
            return this.eval(inputs[0], inputs[1], inputs[2], inputs[3], inputs[4]);
        }

        public T eval(T var1, T var2, T var3, T var4, T var5);
    }

    public static interface Func4<T>
    extends ExpressionFunc<T> {
        @Override
        default public int getNumberOfArguments() {
            return 4;
        }

        @Override
        default public T eval(T ... inputs) {
            return this.eval(inputs[0], inputs[1], inputs[2], inputs[3]);
        }

        public T eval(T var1, T var2, T var3, T var4);
    }

    public static interface ExpressionFunc<T> {
        public int getNumberOfArguments();

        public T eval(T ... var1);
    }

    public static abstract class TernaryOperatorParser<T>
    extends OperatorParser<T, TernaryOperator<T>> {
    }

    public static abstract class BinaryOperatorParser<T, O extends BinaryOperator<T>>
    extends OperatorParser<T, O> {
    }

    public static class PostfixUnaryOperatorParser<T>
    extends UnaryOperatorParser<T, UnaryOperator<T>> {
        @Override
        public ExpressionNode<T> parse(LinkedHashMap<String, Operator<T>> operators) {
            ExpressionNode x = this.e.next();
            int p = this.e.pos;
            double[] pre = this.e.eatScript();
            for (Map.Entry<String, Operator<T>> pair : operators.entrySet()) {
                Operator<T> op = pair.getValue();
                if (!this.e.eatString(pair.getKey())) continue;
                if (op instanceof DecoratedOperator) {
                    op = this.decorate(op, pre);
                }
                if (!(op instanceof UnaryOperator)) {
                    throw new IllegalArgumentException("Used non-unary operator on postfix unary operator builder'");
                }
                return this.apply(op, x);
            }
            this.e.setCursor(p);
            return x;
        }
    }

    public static abstract class UnaryOperatorParser<T, O extends UnaryOperator<T>>
    extends OperatorParser<T, O> {
    }

    public static interface OperatorFactory<T, O extends Operator<T>>
    extends Operator<T> {
        public O get(double ... var1);

        @Override
        default public ExpressionNode<T> apply(ExpressionNode<T> ... inputs) {
            throw new IllegalAccessError("Operator factory cannot be used as operator");
        }
    }

    public static class InternalDoubleExpressionParser
    extends InternalExpressionParser<Double> {
        public InternalDoubleExpressionParser(String expression, FixedNamespaceSet<Double> namespace, FixedNamespace<Map.Entry<String, Integer>, ExpressionFunc<Double>> functions, OperatorHierarchy<Double> operators, ExpressionParser<Double> parser) {
            super(expression, namespace, functions, operators, parser);
        }

        @Override
        public ExpressionNode<Double> parseNode() {
            int p = this.pos;
            double[] pre = this.eatScript();
            int start = this.pos;
            String digit = this.eatNumber();
            if (digit != null) {
                double x_val = this.parseDouble(digit, start);
                return this.decorate(() -> x_val, pre);
            }
            this.setCursor(p);
            return null;
        }
    }

    public static class UnicodeMathDoubleExpressionParser
    extends DoubleExpressionParser {
        public UnicodeMathDoubleExpressionParser(String ... names) {
            this(Arrays.stream(names).collect(Collectors.toSet()), null, null);
        }

        public UnicodeMathDoubleExpressionParser() {
            this((Map<String, Double>)null, null, null);
        }

        public UnicodeMathDoubleExpressionParser(Set<String> namespace) {
            this(namespace, null, null);
        }

        public UnicodeMathDoubleExpressionParser(Set<String> namespace, @Nullable Map<Map.Entry<String, Integer>, ExpressionFunc<Double>> functions) {
            this(namespace, functions, null);
        }

        public UnicodeMathDoubleExpressionParser(Set<String> namespace, @Nullable Map<Map.Entry<String, Integer>, ExpressionFunc<Double>> functions, @Nullable OperatorHierarchy<Double> operators) {
            this(MathParser.nullMap(namespace), functions, operators);
        }

        public UnicodeMathDoubleExpressionParser(@Nullable Map<String, Double> namespace) {
            this(namespace, null, null);
        }

        public UnicodeMathDoubleExpressionParser(@Nullable Map<String, Double> namespace, @Nullable Map<Map.Entry<String, Integer>, ExpressionFunc<Double>> functions) {
            this(namespace, functions, null);
        }

        public UnicodeMathDoubleExpressionParser(@Nullable Map<String, Double> namespace, @Nullable Map<Map.Entry<String, Integer>, ExpressionFunc<Double>> functions, @Nullable OperatorHierarchy<Double> operators) {
            this(namespace != null ? FixedNamespaceSet.of(namespace) : null, functions != null ? new FixedNamespace<Map.Entry<String, Integer>, ExpressionFunc<Double>>(functions) : null, operators);
        }

        public UnicodeMathDoubleExpressionParser(@Nullable FixedNamespaceSet<Double> namespaceSet) {
            this(namespaceSet, null, null);
        }

        public UnicodeMathDoubleExpressionParser(@Nullable FixedNamespaceSet<Double> namespaceSet, @Nullable FixedNamespace<Map.Entry<String, Integer>, ExpressionFunc<Double>> functions) {
            this(namespaceSet, functions, null);
        }

        public UnicodeMathDoubleExpressionParser(@Nullable FixedNamespaceSet<Double> namespaceSet, @Nullable FixedNamespace<Map.Entry<String, Integer>, ExpressionFunc<Double>> functions, @Nullable OperatorHierarchy<Double> operators) {
            FixedNamespace<Map.Entry<String, Integer>, ExpressionFunc<Double>> fixedNamespace;
            FixedNamespaceSet<Double> fixedNamespaceSet;
            String defaultNamespace = namespaceSet != null ? namespaceSet.defaultNamespace : "";
            HashMap<String, Map<String, Map<String, Double>>> mathNames = new HashMap<String, Map<String, Map<String, Double>>>();
            mathNames.put(defaultNamespace, UNICODE_MATH_NAMES);
            if (namespaceSet != null) {
                fixedNamespaceSet = namespaceSet.copyWith(mathNames);
            } else {
                FixedNamespaceSet<Double> fixedNamespaceSet2;
                fixedNamespaceSet = fixedNamespaceSet2;
                super(mathNames);
            }
            this.namespaceSet = fixedNamespaceSet;
            if (functions != null) {
                fixedNamespace = functions.copyWith(UNICODE_MATH_FUNCTIONS);
            } else {
                FixedNamespace<Map.Entry<String, Integer>, ExpressionFunc<Double>> fixedNamespace2;
                fixedNamespace = fixedNamespace2;
                super(UNICODE_MATH_FUNCTIONS);
            }
            this.functions = fixedNamespace;
            this.operators = operators != null ? operators : UNICODE_MATH_OPERATOR_HIERARCHY;
        }
    }

    public static class DoubleExpressionParser
    extends ExpressionParser<Double> {
        public FixedNamespaceSet<Double> namespaceSet = null;
        public FixedNamespace<Map.Entry<String, Integer>, ExpressionFunc<Double>> functions = null;
        public OperatorHierarchy<Double> operators = null;

        public DoubleExpressionParser() {
        }

        public DoubleExpressionParser(@Nullable FixedNamespaceSet<Double> namespaceSet, @Nullable FixedNamespace<Map.Entry<String, Integer>, ExpressionFunc<Double>> functions, OperatorHierarchy<Double> operators) {
            this.namespaceSet = namespaceSet != null ? namespaceSet : new FixedNamespaceSet();
            this.functions = functions != null ? functions : new FixedNamespace();
            this.operators = operators;
        }

        @Override
        public ParsedExpression<Double> parse(String expression) {
            if (this.operators == null) {
                this.operators = new OperatorHierarchy(new ArrayList(), null);
            }
            return new InternalDoubleExpressionParser(expression, this.namespaceSet, this.functions, this.operators, this).parse();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DoubleExpressionParser that = (DoubleExpressionParser)o;
            return Objects.equals(this.namespaceSet, that.namespaceSet) && Objects.equals(this.functions, that.functions) && Objects.equals(this.operators, that.operators);
        }

        public int hashCode() {
            return Objects.hash(this.namespaceSet, this.functions, this.operators);
        }
    }

    public static class ComputedExpressionNode<T>
    implements ExpressionNode<T> {
        public final T value;

        public ComputedExpressionNode(T value) {
            this.value = value;
        }

        @Override
        public T eval() {
            return this.value;
        }
    }

    public static abstract class ExpressionParser<T> {
        public abstract ParsedExpression<T> parse(String var1);

        @Nullable
        public ParsedExpression<T> tryParse(String expression) {
            try {
                return this.parse(expression);
            }
            catch (ParseException e) {
                return null;
            }
        }

        public static class ParseException
        extends RuntimeException {
            protected ParseException(String message, String expression, int pos) {
                super(ParseException.addContextInfo(message, expression, pos));
            }

            private static String addContextInfo(String message, String expr, int pos) {
                if (expr.length() <= 40) {
                    return message + "\n\tparsing expression: '" + expr + "'\n\t" + ParseException.spaces("parsing expression: '") + ParseException.spaces(pos) + "^\n\tat pos: " + pos;
                }
                return message + "\n\tparsing expression: '" + (pos > 20 ? "..." : "") + expr.substring(Math.max(0, pos - 20), Math.min(expr.length(), pos + 20)) + (pos + 20 < expr.length() ? "..." : "") + "'\n\t" + ParseException.spaces("parsing expression: '") + ParseException.spaces(pos > 20 ? 23 : pos) + "^\n\tat pos: " + pos;
            }

            protected static String spaces(String str) {
                return ParseException.spaces(str.length());
            }

            protected static String spaces(int n) {
                return " ".repeat(Math.max(0, n));
            }

            public static class FunctionParseException
            extends ParseException {
                public final String functionName;
                public final int parameterCount;

                protected FunctionParseException(String name, int parameterCount, String expression, int pos) {
                    super("Unknown function: \"" + name + "\" with " + parameterCount + " parameters", expression, pos);
                    this.functionName = name;
                    this.parameterCount = parameterCount;
                }
            }

            public static class NameParseException
            extends ParseException {
                public final String name;

                protected NameParseException(String name, String expression, int pos) {
                    super("Unknown name: \"" + name + "\"", expression, pos);
                    this.name = name;
                }
            }

            public static class ScriptParseException
            extends ParseException {
                protected ScriptParseException(String message, String expression, int pos) {
                    super(message, expression, pos);
                }
            }
        }
    }

    public static abstract class InternalExpressionParser<T> {
        protected static final Set<Character> scriptCharacters;
        public final String expression;
        public final FixedNamespaceSet<T> namespaceSet;
        public final FixedNamespace<Map.Entry<String, Integer>, ExpressionFunc<T>> functions;
        public final OperatorHierarchy<T> operators;
        public final ExpressionParser<T> parser;
        protected int pos = -1;
        protected int depth = -1;
        protected char ch = '\u0000';

        public InternalExpressionParser(String expression, FixedNamespaceSet<T> namespaceSet, FixedNamespace<Map.Entry<String, Integer>, ExpressionFunc<T>> functions, OperatorHierarchy<T> operators, ExpressionParser<T> parser) {
            this.expression = expression;
            this.operators = operators;
            this.namespaceSet = namespaceSet.copy();
            this.functions = functions.copy();
            this.parser = parser;
        }

        public ParsedExpression<T> parse() throws ExpressionParser.ParseException {
            ExpressionNode<T> parsed = this.parseRoot();
            return new ParsedExpression<T>(this.expression, this.namespaceSet, this.functions, parsed, this.parser);
        }

        protected void nextChar() {
            this.ch = ++this.pos < this.expression.length() ? this.expression.charAt(this.pos) : (char)'\u0000';
        }

        protected void setCursor(int p) {
            this.pos = p;
            this.ch = this.pos < this.expression.length() ? this.expression.charAt(this.pos) : (char)'\u0000';
        }

        protected boolean peek(char charToPeek) {
            if (this.pos + 1 < this.expression.length()) {
                return this.expression.charAt(this.pos + 1) == charToPeek;
            }
            return false;
        }

        protected boolean eat(char charToEat) {
            this.eatWhitespace();
            if (this.ch == charToEat) {
                this.nextChar();
                return true;
            }
            return false;
        }

        protected void eatWhitespace() {
            while (Character.isWhitespace(this.ch)) {
                this.nextChar();
            }
        }

        protected boolean isWord(char ch) {
            return !Character.isWhitespace(ch) && !this.operators.use(ch) && !scriptCharacters.contains(Character.valueOf(ch));
        }

        protected boolean eatString(String str) {
            this.eatWhitespace();
            int n = str.length();
            if ('\b' == str.charAt(0)) {
                if (this.pos > 0 && this.isWord(this.expression.charAt(this.pos - 1))) {
                    return false;
                }
                --n;
                str = str.substring(1);
            } else if ('\t' == str.charAt(0)) {
                if (this.pos == 0 || !Character.isWhitespace(this.expression.charAt(this.pos - 1))) {
                    return false;
                }
                --n;
                str = str.substring(1);
            }
            int end_char = 0;
            if ('\b' == str.charAt(n - 1)) {
                end_char = 8;
            } else if ('\t' == str.charAt(n - 1)) {
                end_char = 9;
            }
            if (end_char != 0) {
                str = str.substring(0, n - 1);
                --n;
            }
            if (this.pos + n <= this.expression.length() && str.equals(this.expression.substring(this.pos, this.pos + n))) {
                this.setCursor(this.pos + n);
                return switch (end_char) {
                    case 8 -> {
                        if (!this.isWord(this.ch)) {
                            yield true;
                        }
                        yield false;
                    }
                    case 9 -> Character.isWhitespace(this.ch);
                    default -> true;
                };
            }
            return false;
        }

        protected String displayName(String op_sequence) {
            return op_sequence.replace("\b", "");
        }

        protected String eatNumber() {
            this.eatWhitespace();
            if (this.ch >= '0' && this.ch <= '9' || this.ch == '.') {
                int start = this.pos;
                while (this.ch >= '0' && this.ch <= '9') {
                    this.nextChar();
                }
                if (this.ch == '.') {
                    this.nextChar();
                }
                while (this.ch >= '0' && this.ch <= '9') {
                    this.nextChar();
                }
                if (this.ch == 'e' || this.ch == 'E') {
                    this.nextChar();
                    if (this.ch == '+' || this.ch == '-') {
                        this.nextChar();
                    }
                    while (this.ch >= '0' && this.ch <= '9') {
                        this.nextChar();
                    }
                }
                return this.expression.substring(start, this.pos);
            }
            return null;
        }

        protected String eatName() {
            if (this.eat('`')) {
                int start = this.pos;
                while (this.ch != '`') {
                    this.nextChar();
                }
                this.nextChar();
                return this.expression.substring(start, this.pos - 1);
            }
            if (this.ch >= 'a' && this.ch <= 'z' || this.ch >= 'A' && this.ch <= 'Z' || this.ch > '\u007f' && this.isWord(this.ch)) {
                int start = this.pos;
                while (this.ch >= 'a' && this.ch <= 'z' || this.ch >= 'A' && this.ch <= 'Z' || this.ch >= '0' && this.ch <= '9' || this.ch == '_' || this.ch > '\u007f' && this.isWord(this.ch)) {
                    this.nextChar();
                }
                return this.expression.substring(start, this.pos);
            }
            return null;
        }

        protected String eatSuperscript() {
            this.eatWhitespace();
            StringBuilder e = new StringBuilder();
            if (this.ch == '\u207a') {
                e.append('+');
                this.nextChar();
            } else if (this.ch == '\u207b') {
                e.append('-');
                this.nextChar();
            }
            block6: while (true) {
                switch (this.ch) {
                    case '\u2070': {
                        e.append('0');
                        break;
                    }
                    case '\u00b9': {
                        e.append('1');
                        break;
                    }
                    case '\u00b2': {
                        e.append('2');
                        break;
                    }
                    case '\u00b3': {
                        e.append('3');
                        break;
                    }
                    default: {
                        if (this.ch < '\u2074' || this.ch > '\u2079') break block6;
                        e.append(this.ch - 8304);
                    }
                }
                this.nextChar();
            }
            return e.length() > 0 ? e.toString() : null;
        }

        protected String eatSubscript() {
            this.eatWhitespace();
            StringBuilder e = new StringBuilder();
            if (this.ch == '\u208a') {
                e.append('+');
                this.nextChar();
            } else if (this.ch == '\u208b') {
                e.append('-');
                this.nextChar();
            }
            while (this.ch >= '\u2080' && this.ch <= '\u2089') {
                e.append(this.ch - 8320);
                this.nextChar();
            }
            return e.length() > 0 ? e.toString() : null;
        }

        protected double[] eatScript() {
            this.eatWhitespace();
            double[] tuple = new double[]{Double.NaN, Double.NaN};
            int start = this.pos;
            String sub = this.eatSubscript();
            if (sub != null) {
                tuple[1] = this.parseDouble(sub, start);
                start = this.pos;
                String sup = this.eatSuperscript();
                if (sup != null) {
                    tuple[0] = this.parseDouble(sup, start);
                }
            } else {
                String sup = this.eatSuperscript();
                if (sup != null) {
                    tuple[0] = this.parseDouble(sup, start);
                    start = this.pos;
                    sub = this.eatSubscript();
                    if (sub != null) {
                        tuple[1] = this.parseDouble(sub, start);
                    }
                }
            }
            return tuple;
        }

        protected <O extends Operator<T>> O decorate(O operator) {
            return operator;
        }

        protected ExpressionNode<T> decorate(ExpressionNode<T> node, double[] pre) {
            if (this.operators.decoratorFactory != null) {
                return this.decorate(this.operators.decoratorFactory.decorate(this, pre)).apply(node);
            }
            if (!MathParser.allNaN(pre)) {
                throw this.scriptParseException(pre);
            }
            return node;
        }

        protected ExpressionNode<T> parseRoot() {
            try {
                this.nextChar();
                this.depth = -1;
                ExpressionNode<T> x = this.next();
                if (this.pos < this.expression.length()) {
                    throw this.parseException("Unexpected: " + this.ch);
                }
                return x;
            }
            catch (StackOverflowError e) {
                throw new ExpressionParser.ParseException("Stack overflow, the expression is too complex to be parsed", this.expression, this.pos);
            }
        }

        protected ExpressionNode<T> first() {
            int prev = this.depth;
            this.depth = -1;
            ExpressionNode<T> x = this.next();
            this.depth = prev;
            return x;
        }

        protected ExpressionNode<T> next() {
            if (++this.depth < this.operators.size()) {
                ExpressionNode<T> x = this.operators.get(this.depth).getKey().init(this).parse(this.operators.get(this.depth).getValue());
                --this.depth;
                return x;
            }
            ExpressionNode<T> x = this.parseFactor();
            --this.depth;
            return x;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public ExpressionNode<T> parseFactor() {
            void var1_4;
            ExpressionNode<T> expressionNode = this.parseNode();
            if (expressionNode != null) {
                return expressionNode;
            }
            double[] pre = this.eatScript();
            int start = this.pos;
            String name = this.eatName();
            if (name == null) throw this.parseException("Unexpected: '" + this.ch + "'", this.pos);
            if (this.eat('(')) {
                ArrayList<ExpressionNode<T>> in = new ArrayList<ExpressionNode<T>>();
                if (!this.eat(')')) {
                    in.add(this.first());
                    while (!this.eat(')')) {
                        if (!this.eat(',')) {
                            throw this.parseException("Expecting comma or end parenthesis in function call, got: '" + this.ch + "'");
                        }
                        in.add(this.first());
                    }
                }
                int n = in.size();
                Pair signature = Pair.of((Object)name, (Object)n);
                ExpressionNode[] arr = new ExpressionNode[n];
                in.toArray(arr);
                if (!this.functions.contains((Map.Entry<String, Integer>)signature)) {
                    throw this.functionParseException(name, n, start);
                }
                ExpressionNode<Object> expressionNode2 = this.decorate(() -> this.callFunction((Pair<String, Integer>)signature, arr), pre);
                return var1_4;
            } else {
                if (!this.namespaceSet.containsName(name)) throw this.nameParseException(name, start);
                ExpressionNode<Object> expressionNode3 = this.decorate(() -> this.getName(name), pre);
            }
            return var1_4;
        }

        public abstract ExpressionNode<T> parseNode();

        protected T getName(String name) {
            T value;
            if (this.namespaceSet.containsName(name) && (value = this.namespaceSet.get(name)) != null) {
                return value;
            }
            throw new ParsedExpression.EvalException("Name '" + name + "' was defined at parse time, but not present at runtime");
        }

        protected T callFunction(Pair<String, Integer> signature, ExpressionNode<T>[] params) {
            A[] args = Arrays.stream(params).map(ExpressionNode::eval).toArray(Object[]::new);
            return this.functions.get((Map.Entry<String, Integer>)signature).eval(args);
        }

        public ExpressionParser.ParseException parseException(String msg) {
            return new ExpressionParser.ParseException(msg, this.expression, this.pos);
        }

        public ExpressionParser.ParseException parseException(String msg, int pos) {
            return new ExpressionParser.ParseException(msg, this.expression, pos);
        }

        public ExpressionParser.ParseException.NameParseException nameParseException(String name) {
            return this.nameParseException(name, this.pos);
        }

        public ExpressionParser.ParseException.NameParseException nameParseException(String name, int pos) {
            return new ExpressionParser.ParseException.NameParseException(name, this.expression, pos);
        }

        public ExpressionParser.ParseException.FunctionParseException functionParseException(String name, int parameterCount) {
            return this.functionParseException(name, parameterCount, this.pos);
        }

        public ExpressionParser.ParseException.FunctionParseException functionParseException(String name, int parameterCount, int pos) {
            return new ExpressionParser.ParseException.FunctionParseException(name, parameterCount, this.expression, pos);
        }

        public ExpressionParser.ParseException.ScriptParseException scriptParseException(double[] pre, double[] pos) {
            if (MathParser.allNaN(new double[][]{pre, pos})) {
                return new ExpressionParser.ParseException.ScriptParseException("Expected subscript or superscript", this.expression, this.pos);
            }
            return new ExpressionParser.ParseException.ScriptParseException("Unexpected subscript or superscript", this.expression, this.pos);
        }

        public ExpressionParser.ParseException scriptParseException(double[] pre) {
            return this.scriptParseException(pre, new double[]{Double.NaN, Double.NaN});
        }

        protected Double parseDouble(String literal, int pos) {
            try {
                return Double.parseDouble(literal);
            }
            catch (NumberFormatException e) {
                throw this.parseException("Malformed number literal: '" + literal + "'", pos);
            }
        }

        static {
            int i;
            HashSet<Character> c = new HashSet<Character>();
            c.add(Character.valueOf('\u2070'));
            c.add(Character.valueOf('\u00b9'));
            c.add(Character.valueOf('\u00b2'));
            c.add(Character.valueOf('\u00b3'));
            for (i = 4; i <= 11; ++i) {
                c.add(Character.valueOf((char)(8304 + i)));
            }
            for (i = 0; i <= 11; ++i) {
                c.add(Character.valueOf((char)(8320 + i)));
            }
            scriptCharacters = c;
        }
    }

    public static class ParsedExpression<T> {
        private final String expression;
        private final FixedNamespaceSet<T> namespaceSet;
        private final FixedNamespace<Map.Entry<String, Integer>, ExpressionFunc<T>> functions;
        private final ExpressionNode<T> parsed;
        private final ExpressionParser<T> parser;

        public ParsedExpression(String expression, FixedNamespaceSet<T> namespaceSet, FixedNamespace<Map.Entry<String, Integer>, ExpressionFunc<T>> functions, ExpressionNode<T> parsed, ExpressionParser<T> parser) {
            this.expression = expression;
            this.namespaceSet = namespaceSet;
            this.functions = functions;
            this.parsed = parsed;
            this.parser = parser;
        }

        public T eval() {
            return this.parsed.eval();
        }

        public T eval(Map<String, T> namespace) {
            this.namespaceSet.setFrom(namespace);
            T r = this.parsed.eval();
            this.namespaceSet.reset();
            return r;
        }

        public T eval(Map<String, T> namespace, Collection<? extends Map.Entry<String, ? extends ExpressionFunc<T>>> functions) {
            this.namespaceSet.setFrom(namespace);
            for (Map.Entry<String, ExpressionFunc<T>> e : functions) {
                ExpressionFunc<T> func = e.getValue();
                this.functions.set((Map.Entry<String, Integer>)Pair.of((Object)e.getKey(), (Object)func.getNumberOfArguments()), func);
            }
            T r = this.parsed.eval();
            this.namespaceSet.reset();
            this.functions.reset();
            return r;
        }

        public T eval(Map<String, T> namespace, Map<Map.Entry<String, Integer>, ExpressionFunc<T>> functions) {
            this.namespaceSet.setFrom(namespace);
            this.functions.setAll(functions);
            T r = this.parsed.eval();
            this.namespaceSet.reset();
            this.functions.reset();
            return r;
        }

        public T evalX(Map<String, Map<String, T>> namespace) {
            this.namespaceSet.setAll(namespace);
            T r = this.parsed.eval();
            this.namespaceSet.reset();
            this.functions.reset();
            return r;
        }

        public T evalX(Map<String, Map<String, T>> namespace, Collection<? extends Map.Entry<String, ? extends ExpressionFunc<T>>> functions) {
            this.namespaceSet.setAll(namespace);
            for (Map.Entry<String, ExpressionFunc<T>> e : functions) {
                ExpressionFunc<T> func = e.getValue();
                this.functions.set((Map.Entry<String, Integer>)Pair.of((Object)e.getKey(), (Object)func.getNumberOfArguments()), func);
            }
            T r = this.parsed.eval();
            this.namespaceSet.reset();
            this.functions.reset();
            return r;
        }

        public T evalX(Map<String, Map<String, T>> namespace, Map<Map.Entry<String, Integer>, ExpressionFunc<T>> functions) {
            this.namespaceSet.setAll(namespace);
            this.functions.setAll(functions);
            T r = this.parsed.eval();
            this.namespaceSet.reset();
            this.functions.reset();
            return r;
        }

        public T eval(FixedNamespaceSet<T> namespaceSet) {
            this.namespaceSet.setAll(namespaceSet);
            T r = this.parsed.eval();
            this.namespaceSet.reset();
            return r;
        }

        public T eval(FixedNamespace<Map.Entry<String, Integer>, ExpressionFunc<T>> functions) {
            this.functions.setAll(functions);
            T r = this.parsed.eval();
            this.functions.reset();
            return r;
        }

        public T eval(FixedNamespaceSet<T> namespaceSet, FixedNamespace<Map.Entry<String, Integer>, ExpressionFunc<T>> functions) {
            this.namespaceSet.setAll(namespaceSet);
            this.functions.setAll(functions);
            T r = this.parsed.eval();
            this.namespaceSet.reset();
            this.functions.reset();
            return r;
        }

        public String toString() {
            return this.expression;
        }

        public String getExpression() {
            return this.expression;
        }

        public ExpressionParser<T> getParser() {
            return this.parser;
        }

        public FixedNamespaceSet<T> getNamespaceSet() {
            return this.namespaceSet;
        }

        public FixedNamespace<Map.Entry<String, Integer>, ExpressionFunc<T>> getFunctions() {
            return this.functions;
        }

        public static class EvalException
        extends RuntimeException {
            public EvalException(String message) {
                super(message);
            }
        }
    }
}

