/*
 * Decompiled with CFR 0.152.
 */
package endorh.lazulib.math;

import endorh.lazulib.math.MathParser;
import endorh.lazulib.text.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.lang3.tuple.Pair;

public class MathHighlighter {
    public static final Map<String, ChatFormatting> UNICODE_MATH_COLORED_NAMESPACE;
    public static final Map<Map.Entry<String, Integer>, ChatFormatting> UNICODE_MATH_COLORED_FUNCTIONS;
    public static final MathParser.OperatorHierarchy<MutableComponent> UNICODE_MATH_SYNTAX_HIGHLIGHT_OPERATOR_HIERARCHY;

    static {
        UNICODE_MATH_SYNTAX_HIGHLIGHT_OPERATOR_HIERARCHY = new SyntaxHighlightOperatorHierarchy.Builder<Double>(MathParser.UNICODE_MATH_OPERATOR_HIERARCHY).build();
        UNICODE_MATH_COLORED_NAMESPACE = new HashMap<String, ChatFormatting>();
        for (String string : MathParser.UNICODE_MATH_NAMES.keySet()) {
            UNICODE_MATH_COLORED_NAMESPACE.put(string, ChatFormatting.AQUA);
        }
        UNICODE_MATH_COLORED_FUNCTIONS = new HashMap<Map.Entry<String, Integer>, ChatFormatting>();
        for (Map.Entry entry : MathParser.UNICODE_MATH_FUNCTIONS.keySet()) {
            UNICODE_MATH_COLORED_FUNCTIONS.put(entry, ChatFormatting.DARK_AQUA);
        }
    }

    public static class SyntaxHighlightOperatorHierarchy
    extends MathParser.OperatorHierarchy<MutableComponent> {
        public SyntaxHighlightOperatorHierarchy(List<Map.Entry<MathParser.OperatorParser<MutableComponent, ?>, LinkedHashMap<String, MathParser.Operator<MutableComponent>>>> operators, MathParser.DecoratedOperator<MutableComponent, ? extends MathParser.UnaryOperator<MutableComponent>> decoratorFactory) {
            super(operators, decoratorFactory);
        }

        public static class Builder<T> {
            public final MathParser.OperatorHierarchy<T> hierarchy;

            public Builder(MathParser.OperatorHierarchy<T> hierarchy) {
                this.hierarchy = hierarchy;
            }

            public SyntaxHighlightOperatorHierarchy build() {
                ArrayList list = new ArrayList();
                for (Map.Entry<MathParser.OperatorParser<T, ?>, LinkedHashMap<String, MathParser.Operator<T>>> group : this.hierarchy.copyList()) {
                    Pair<MathParser.OperatorParser<MutableComponent, ?>, Function<String, MathParser.Operator<MutableComponent>>> translation = this.translate(group.getKey());
                    LinkedHashMap<String, MathParser.Operator> map = new LinkedHashMap<String, MathParser.Operator>();
                    for (String key : group.getValue().keySet()) {
                        map.put(key, (MathParser.Operator)((Function)translation.getRight()).apply(key));
                    }
                    list.add((Map.Entry<MathParser.OperatorParser<MutableComponent, ?>, LinkedHashMap<String, MathParser.Operator<MutableComponent>>>)Pair.of((Object)((MathParser.OperatorParser)translation.getLeft()), map));
                }
                return new SyntaxHighlightOperatorHierarchy(list, (MathParser.DecoratedOperator<MutableComponent, ? extends MathParser.UnaryOperator<MutableComponent>>)this.getDecorator());
            }

            protected Pair<MathParser.OperatorParser<MutableComponent, ?>, Function<String, MathParser.Operator<MutableComponent>>> translate(MathParser.OperatorParser<T, ?> parser) {
                if (parser instanceof MathParser.UnaryOperatorParser) {
                    if (parser instanceof MathParser.PrefixUnaryOperatorParser) {
                        return Pair.of(new MathParser.PrefixUnaryOperatorParser(), PrefixUnarySyntaxHighlightOperator::new);
                    }
                    if (parser instanceof MathParser.PostfixUnaryOperatorParser) {
                        return Pair.of(new MathParser.PostfixUnaryOperatorParser(), PostfixUnarySyntaxHighlightOperator::new);
                    }
                    if (parser instanceof MathParser.SurroundingUnaryOperatorParser) {
                        return Pair.of(new MathParser.SurroundingUnaryOperatorParser(), SurroundingUnarySyntaxHighlightOperator::new);
                    }
                    throw new IllegalArgumentException("Unsupported UnaryOperatorParser type: " + parser.getClass().getName());
                }
                if (parser instanceof MathParser.BinaryOperatorParser) {
                    return Pair.of(new MathParser.LeftAssociativeBinaryOperatorParser(), BinarySyntaxHighlightOperator::new);
                }
                if (parser instanceof MathParser.TernaryOperatorParser) {
                    return Pair.of(new MathParser.RightAssociativeBinaryOperatorParser(), TernarySyntaxHighlightOperator::new);
                }
                throw new IllegalArgumentException("Unsupported OperatorParser type: " + parser.getClass().getName());
            }

            protected DecoratedThemedOperator<MutableComponent, UnaryThemedOperator<MutableComponent>> getDecorator() {
                return new DecoratedThemedOperator<MutableComponent, UnaryThemedOperator<MutableComponent>>(){

                    @Override
                    public UnaryThemedOperator<MutableComponent> get(final double lu, final double ru, final double ld, final double rd) {
                        return new UnaryThemedOperator<MutableComponent>(){

                            @Override
                            public MathParser.ExpressionNode<MutableComponent> apply(MathParser.ExpressionNode<MutableComponent> x) {
                                MutableComponent d = TextUtil.stc("");
                                if (!Double.isNaN(lu)) {
                                    d = d.m_7220_((Component)TextUtil.stc(this.superscript(lu)).m_130940_(this.theme.scriptColor));
                                }
                                if (!Double.isNaN(ld)) {
                                    d = d.m_7220_((Component)TextUtil.stc(this.subscript(ld)).m_130940_(this.theme.scriptColor));
                                }
                                d = d.m_7220_((Component)x.eval());
                                if (!Double.isNaN(rd)) {
                                    d = d.m_7220_((Component)TextUtil.stc(this.subscript(rd)).m_130940_(this.theme.scriptColor));
                                }
                                if (!Double.isNaN(ru)) {
                                    d = d.m_7220_((Component)TextUtil.stc(this.superscript(ru)).m_130940_(this.theme.scriptColor));
                                }
                                MutableComponent r = d;
                                return () -> r;
                            }
                        };
                    }
                };
            }

            protected String subscript(double d) {
                if (Double.isNaN(d)) {
                    return "";
                }
                String l = String.format("%d", (long)d);
                StringBuilder builder = new StringBuilder();
                int off = 8272;
                l.chars().forEach(ch -> {
                    if (ch == 45) {
                        builder.append('\u208b');
                    } else if (ch >= 48 && ch <= 57) {
                        builder.append(8272 + (char)ch);
                    } else {
                        throw new IllegalStateException("Invalid number literal: '" + l + "'");
                    }
                });
                return builder.toString();
            }

            protected String superscript(double d) {
                if (Double.isNaN(d)) {
                    return "";
                }
                String l = String.format("%d", (long)d);
                StringBuilder builder = new StringBuilder();
                int off = 8256;
                l.chars().forEach(i -> {
                    if (i == 45) {
                        builder.append('\u207b');
                    } else {
                        if (i < 48 || i > 57) {
                            throw new IllegalStateException("Invalid number literal: '" + l + "'");
                        }
                        char ch = (char)i;
                        switch (ch) {
                            case '1': {
                                builder.append('\u00b9');
                                break;
                            }
                            case '2': {
                                builder.append('\u00b2');
                                break;
                            }
                            case '3': {
                                builder.append('\u00b3');
                                break;
                            }
                            default: {
                                builder.append(8256 + ch);
                            }
                        }
                    }
                });
                return builder.toString();
            }
        }
    }

    public static class TernarySyntaxHighlightOperator
    extends TernaryThemedOperator<MutableComponent> {
        public final String l;
        public final String r;

        public TernarySyntaxHighlightOperator(String s) {
            String[] sp = s.split(" ");
            this.l = TernarySyntaxHighlightOperator.clean(sp[0]);
            this.r = TernarySyntaxHighlightOperator.clean(sp[1]);
        }

        public TernarySyntaxHighlightOperator(String l, String r) {
            this.l = TernarySyntaxHighlightOperator.clean(l);
            this.r = TernarySyntaxHighlightOperator.clean(r);
        }

        @Override
        public MathParser.ExpressionNode<MutableComponent> apply(MathParser.ExpressionNode<MutableComponent> a, MathParser.ExpressionNode<MutableComponent> b, MathParser.ExpressionNode<MutableComponent> c) {
            return () -> ((MutableComponent)a.eval()).m_7220_((Component)TextUtil.stc(this.l).m_130940_(this.theme.operatorColor)).m_7220_((Component)b.eval()).m_7220_((Component)TextUtil.stc(this.r).m_130940_(this.theme.operatorColor)).m_7220_((Component)c.eval());
        }
    }

    public static class BinarySyntaxHighlightOperator
    extends BinaryThemedOperator<MutableComponent> {
        public final String o;

        public BinarySyntaxHighlightOperator(String o) {
            this.o = BinarySyntaxHighlightOperator.clean(o);
        }

        @Override
        public MathParser.ExpressionNode<MutableComponent> apply(MathParser.ExpressionNode<MutableComponent> a, MathParser.ExpressionNode<MutableComponent> b) {
            return () -> ((MutableComponent)a.eval()).m_7220_((Component)TextUtil.stc(this.o).m_130940_(this.theme.operatorColor)).m_7220_((Component)b.eval());
        }
    }

    public static class SurroundingUnarySyntaxHighlightOperator
    extends UnaryThemedOperator<MutableComponent> {
        public final String l;
        public final String r;

        public SurroundingUnarySyntaxHighlightOperator(String s) {
            String[] sp = s.split(" ");
            this.l = SurroundingUnarySyntaxHighlightOperator.clean(sp[0]);
            this.r = SurroundingUnarySyntaxHighlightOperator.clean(sp[1]);
        }

        public SurroundingUnarySyntaxHighlightOperator(String l, String r) {
            this.l = SurroundingUnarySyntaxHighlightOperator.clean(l);
            this.r = SurroundingUnarySyntaxHighlightOperator.clean(r);
        }

        @Override
        public MathParser.ExpressionNode<MutableComponent> apply(MathParser.ExpressionNode<MutableComponent> a) {
            return () -> TextUtil.stc(this.l).m_130940_(this.theme.operatorColor).m_7220_((Component)a.eval()).m_7220_((Component)TextUtil.stc(this.r).m_130940_(this.theme.operatorColor));
        }
    }

    public static class PostfixUnarySyntaxHighlightOperator
    extends UnaryThemedOperator<MutableComponent> {
        public final String o;

        public PostfixUnarySyntaxHighlightOperator(String o) {
            this.o = PostfixUnarySyntaxHighlightOperator.clean(o);
        }

        @Override
        public MathParser.ExpressionNode<MutableComponent> apply(MathParser.ExpressionNode<MutableComponent> a) {
            return () -> ((MutableComponent)a.eval()).m_7220_((Component)TextUtil.stc(this.o).m_130940_(this.theme.operatorColor));
        }
    }

    public static class PrefixUnarySyntaxHighlightOperator
    extends UnaryThemedOperator<MutableComponent> {
        public final String o;

        public PrefixUnarySyntaxHighlightOperator(String o) {
            this.o = PrefixUnarySyntaxHighlightOperator.clean(o);
        }

        @Override
        public MathParser.ExpressionNode<MutableComponent> apply(MathParser.ExpressionNode<MutableComponent> a) {
            return () -> TextUtil.stc(this.o).m_130940_(this.theme.operatorColor).m_7220_((Component)a.eval());
        }
    }

    public static abstract class DecoratedThemedOperator<T, O extends ThemedOperator<T>>
    implements MathParser.DecoratedOperator<T, O> {
        public HighlighterColorTheme theme;

        public void init(HighlighterColorTheme theme) {
            this.theme = theme;
        }
    }

    public static abstract class TernaryThemedOperator<T>
    extends ThemedOperator<T>
    implements MathParser.TernaryOperator<T> {
    }

    public static abstract class BinaryThemedOperator<T>
    extends ThemedOperator<T>
    implements MathParser.BinaryOperator<T> {
    }

    public static abstract class UnaryThemedOperator<T>
    extends ThemedOperator<T>
    implements MathParser.UnaryOperator<T> {
    }

    public static abstract class ThemedOperator<T>
    implements MathParser.Operator<T> {
        public HighlighterColorTheme theme;

        public void init(HighlighterColorTheme theme) {
            this.theme = theme;
        }

        protected static String clean(String key) {
            return key.replace('\b', ' ').replace('\t', ' ');
        }
    }

    public static class InternalUnicodeMathSyntaxHighlightParser
    extends MathParser.InternalExpressionParser<MutableComponent> {
        private final HighlighterColorTheme colorTheme;
        private final MathParser.FixedNamespaceSet<ChatFormatting> namespaceSetColors;
        private final MathParser.FixedNamespace<Map.Entry<String, Integer>, ChatFormatting> functionColors;
        private final Map<String, MutableComponent> translations;
        private final boolean allowMissingNames;

        public InternalUnicodeMathSyntaxHighlightParser(String expression, MathParser.FixedNamespaceSet<ChatFormatting> namespaceSetColors, MathParser.FixedNamespace<Map.Entry<String, Integer>, ChatFormatting> functionColors, MathParser.OperatorHierarchy<MutableComponent> operators, MathParser.ExpressionParser<MutableComponent> parser, @Nullable Map<String, MutableComponent> translations, @Nullable HighlighterColorTheme colorTheme, boolean allowMissingNames) {
            super(expression, new MathParser.FixedNamespaceSet(), new MathParser.FixedNamespace(), operators, parser);
            this.namespaceSetColors = namespaceSetColors;
            this.functionColors = functionColors;
            this.translations = translations != null ? translations : new HashMap();
            this.colorTheme = colorTheme != null ? colorTheme.copy() : new HighlighterColorTheme();
            this.allowMissingNames = allowMissingNames;
        }

        public ChatFormatting getNameColor(String name) {
            if (this.namespaceSetColors.containsName(name)) {
                ChatFormatting color = this.namespaceSetColors.get(name);
                return color != null ? color : this.colorTheme.getNameColor(name);
            }
            return this.colorTheme.getNameColor(name);
        }

        public ChatFormatting getFunctionColor(Map.Entry<String, Integer> signature) {
            if (this.functionColors.contains(signature)) {
                ChatFormatting color = this.functionColors.get(signature);
                return color != null ? color : this.colorTheme.functionColor;
            }
            return this.colorTheme.functionColor;
        }

        public StyleableParsedExpression parse() throws MathParser.ExpressionParser.ParseException {
            MathParser.ExpressionNode<MutableComponent> parsed = this.parseRoot();
            return new StyleableParsedExpression(this.expression, this.namespaceSet, this.functions, parsed, this.parser, this.colorTheme);
        }

        @Override
        protected <O extends MathParser.Operator<MutableComponent>> O decorate(O operator) {
            if (operator instanceof ThemedOperator) {
                ((ThemedOperator)operator).init(this.colorTheme);
            }
            return super.decorate(operator);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public MathParser.ExpressionNode<MutableComponent> parseFactor() {
            MathParser.ExpressionNode<MutableComponent> x = this.parseNode();
            if (x != null) {
                return x;
            }
            double[] pre = this.eatScript();
            int start = this.pos;
            String name = this.eatName();
            if (name == null) throw this.parseException("Unexpected: '" + this.ch + "'", this.pos);
            if (this.eat('(')) {
                ArrayList argsList = new ArrayList();
                if (!this.eat(')')) {
                    argsList.add(this.first());
                    while (!this.eat(')')) {
                        if (!this.eat(',')) {
                            throw this.parseException("Expecting comma or end parenthesis in function call, got: '" + this.ch + "'");
                        }
                        argsList.add(this.first());
                    }
                }
                int n = argsList.size();
                MathParser.ExpressionNode[] a = new MathParser.ExpressionNode[n];
                MathParser.ExpressionNode[] args = argsList.toArray(a);
                Pair signature = Pair.of((Object)name, (Object)n);
                if (this.allowMissingNames) return this.decorate(() -> this.makeCall((Pair<String, Integer>)signature, args), pre);
                if (this.functionColors.contains((Map.Entry<String, Integer>)signature)) return this.decorate(() -> this.makeCall((Pair<String, Integer>)signature, args), pre);
                throw this.functionParseException(name, n, start);
            }
            if (this.allowMissingNames) return this.decorate(() -> this.makeName(name), pre);
            if (!this.namespaceSetColors.containsName(name)) throw this.nameParseException(name, start);
            return this.decorate(() -> this.makeName(name), pre);
        }

        protected MutableComponent makeName(String name) {
            return this.translations.containsKey(name) ? this.translations.get(name).m_6879_().m_130940_(this.getNameColor(name)) : TextUtil.stc(name).m_130940_(this.getNameColor(name));
        }

        protected MutableComponent makeCall(Pair<String, Integer> signature, MathParser.ExpressionNode<MutableComponent>[] args) {
            MutableComponent r = TextUtil.stc((String)signature.getKey()).m_130940_(this.getFunctionColor((Map.Entry<String, Integer>)signature)).m_7220_((Component)TextUtil.stc("(").m_130940_(this.colorTheme.braceColor));
            for (int i = 0; i < args.length - 1; ++i) {
                r = r.m_7220_((Component)args[i].eval()).m_7220_((Component)TextUtil.stc(", ").m_130940_(this.colorTheme.operatorColor));
            }
            return r.m_7220_((Component)args[args.length - 1].eval()).m_7220_((Component)TextUtil.stc(")").m_130940_(this.colorTheme.braceColor));
        }

        @Override
        public MathParser.ExpressionNode<MutableComponent> parseNode() {
            int p = this.pos;
            double[] pre = this.eatScript();
            int start = this.pos;
            String digit = this.eatNumber();
            if (digit != null) {
                this.parseDouble(digit, start);
                return this.decorate(() -> TextUtil.stc(digit).m_130940_(this.colorTheme.numberColor), pre);
            }
            this.setCursor(p);
            return null;
        }
    }

    public static class StyleableParsedExpression
    extends MathParser.ParsedExpression<MutableComponent> {
        public final HighlighterColorTheme colorTheme;

        public StyleableParsedExpression(String expression, MathParser.FixedNamespaceSet<MutableComponent> namespaceSet, MathParser.FixedNamespace<Map.Entry<String, Integer>, MathParser.ExpressionFunc<MutableComponent>> functions, MathParser.ExpressionNode<MutableComponent> parsed, MathParser.ExpressionParser<MutableComponent> parser, HighlighterColorTheme colorTheme) {
            super(expression, namespaceSet, functions, parsed, parser);
            this.colorTheme = colorTheme;
        }
    }

    public static class UnicodeMathSyntaxHighlightParser
    extends MathParser.ExpressionParser<MutableComponent> {
        public MathParser.FixedNamespaceSet<ChatFormatting> namespaceSetColors;
        public MathParser.FixedNamespace<Map.Entry<String, Integer>, ChatFormatting> functionColors;
        public MathParser.OperatorHierarchy<MutableComponent> operators;
        public Map<String, MutableComponent> translations;
        public HighlighterColorTheme colorTheme;
        public boolean allowMissingNames;

        public ChatFormatting getNameColor(String name) {
            if (this.namespaceSetColors.containsName(name)) {
                ChatFormatting color = this.namespaceSetColors.get(name);
                return color != null ? color : this.colorTheme.getNameColor(name);
            }
            return this.colorTheme.getNameColor(name);
        }

        public UnicodeMathSyntaxHighlightParser(String ... names) {
            this(Arrays.stream(names).collect(Collectors.toSet()), null, null, null, null);
        }

        public UnicodeMathSyntaxHighlightParser() {
            this((Map<String, ChatFormatting>)null, null, null, null, null);
        }

        public UnicodeMathSyntaxHighlightParser(Set<String> namespace) {
            this(namespace, null, null, null, null);
        }

        public UnicodeMathSyntaxHighlightParser(Set<String> namespace, @Nullable Map<String, MutableComponent> translations) {
            this(namespace, translations, null, null, null);
        }

        public UnicodeMathSyntaxHighlightParser(Set<String> namespace, @Nullable Map<String, MutableComponent> translations, @Nullable Map<Map.Entry<String, Integer>, ChatFormatting> functions) {
            this(namespace, translations, functions, null, null);
        }

        public UnicodeMathSyntaxHighlightParser(Set<String> namespace, @Nullable Map<String, MutableComponent> translations, @Nullable Map<Map.Entry<String, Integer>, ChatFormatting> functionColors, @Nullable MathParser.OperatorHierarchy<MutableComponent> operators) {
            this(namespace, translations, functionColors, operators, null);
        }

        public UnicodeMathSyntaxHighlightParser(Set<String> namespace, @Nullable Map<String, MutableComponent> translations, @Nullable Map<Map.Entry<String, Integer>, ChatFormatting> functionColors, @Nullable MathParser.OperatorHierarchy<MutableComponent> operators, HighlighterColorTheme colorTheme) {
            this(UnicodeMathSyntaxHighlightParser.nullMap(namespace), translations, functionColors, operators, colorTheme);
        }

        public UnicodeMathSyntaxHighlightParser(Set<String> namespace, @Nullable Map<String, MutableComponent> translations, @Nullable Map<Map.Entry<String, Integer>, ChatFormatting> functionColors, @Nullable MathParser.OperatorHierarchy<MutableComponent> operators, HighlighterColorTheme colorTheme, boolean allowMissingNames) {
            this(UnicodeMathSyntaxHighlightParser.nullMap(namespace), translations, functionColors, operators, colorTheme, allowMissingNames);
        }

        private static Map<String, ChatFormatting> nullMap(Set<String> namespace) {
            HashMap<String, ChatFormatting> map = new HashMap<String, ChatFormatting>();
            for (String name : namespace) {
                map.put(name, null);
            }
            return map;
        }

        public UnicodeMathSyntaxHighlightParser(@Nullable Map<String, ChatFormatting> namespaceColors) {
            this(namespaceColors, null, null, null, null);
        }

        public UnicodeMathSyntaxHighlightParser(@Nullable Map<String, ChatFormatting> namespaceColors, @Nullable Map<String, MutableComponent> translations) {
            this(namespaceColors, translations, null, null, null);
        }

        public UnicodeMathSyntaxHighlightParser(@Nullable Map<String, ChatFormatting> namespaceColors, @Nullable Map<String, MutableComponent> translations, @Nullable Map<Map.Entry<String, Integer>, ChatFormatting> functionColors) {
            this(namespaceColors, translations, functionColors, null, null);
        }

        public UnicodeMathSyntaxHighlightParser(@Nullable Map<String, ChatFormatting> namespaceColors, @Nullable Map<String, MutableComponent> translations, @Nullable Map<Map.Entry<String, Integer>, ChatFormatting> functionColors, @Nullable MathParser.OperatorHierarchy<MutableComponent> operators) {
            this(namespaceColors, translations, functionColors, operators, null);
        }

        public UnicodeMathSyntaxHighlightParser(@Nullable Map<String, ChatFormatting> namespaceColors, @Nullable Map<String, MutableComponent> translations, @Nullable Map<Map.Entry<String, Integer>, ChatFormatting> functionColors, @Nullable MathParser.OperatorHierarchy<MutableComponent> operators, @Nullable HighlighterColorTheme colorTheme) {
            this(namespaceColors, translations, functionColors, operators, colorTheme, true);
        }

        public UnicodeMathSyntaxHighlightParser(@Nullable Map<String, ChatFormatting> namespaceColors, @Nullable Map<String, MutableComponent> translations, @Nullable Map<Map.Entry<String, Integer>, ChatFormatting> functionColors, @Nullable MathParser.OperatorHierarchy<MutableComponent> operators, @Nullable HighlighterColorTheme colorTheme, boolean allowMissingNames) {
            this(namespaceColors != null ? MathParser.FixedNamespaceSet.of(namespaceColors) : null, translations, functionColors != null ? new MathParser.FixedNamespace<Map.Entry<String, Integer>, ChatFormatting>(functionColors) : null, operators, colorTheme, allowMissingNames);
        }

        public UnicodeMathSyntaxHighlightParser(@Nullable MathParser.FixedNamespaceSet<ChatFormatting> namespaceSetColors, @Nullable Map<String, MutableComponent> translations, @Nullable MathParser.FixedNamespace<Map.Entry<String, Integer>, ChatFormatting> functionColors, @Nullable MathParser.OperatorHierarchy<MutableComponent> operators, @Nullable HighlighterColorTheme colorTheme) {
            this(namespaceSetColors, translations, functionColors, operators, colorTheme, true);
        }

        public UnicodeMathSyntaxHighlightParser(@Nullable MathParser.FixedNamespaceSet<ChatFormatting> namespaceSetColors, @Nullable Map<String, MutableComponent> translations, @Nullable MathParser.FixedNamespace<Map.Entry<String, Integer>, ChatFormatting> functionColors, @Nullable MathParser.OperatorHierarchy<MutableComponent> operators, @Nullable HighlighterColorTheme colorTheme, boolean allowMissingNames) {
            MathParser.FixedNamespace<Map.Entry<String, Integer>, ChatFormatting> fixedNamespace;
            MathParser.FixedNamespaceSet<ChatFormatting> fixedNamespaceSet;
            String defaultNamespace = namespaceSetColors != null ? namespaceSetColors.defaultNamespace : "";
            HashMap<String, Map<String, Map<String, ChatFormatting>>> mathNames = new HashMap<String, Map<String, Map<String, ChatFormatting>>>();
            mathNames.put(defaultNamespace, UNICODE_MATH_COLORED_NAMESPACE);
            if (namespaceSetColors != null) {
                fixedNamespaceSet = namespaceSetColors.copyWith(mathNames);
            } else {
                MathParser.FixedNamespaceSet<ChatFormatting> fixedNamespaceSet2;
                fixedNamespaceSet = fixedNamespaceSet2;
                super(mathNames);
            }
            this.namespaceSetColors = fixedNamespaceSet;
            if (functionColors != null) {
                fixedNamespace = functionColors.copyWith(UNICODE_MATH_COLORED_FUNCTIONS);
            } else {
                MathParser.FixedNamespace<Map.Entry<String, Integer>, ChatFormatting> fixedNamespace2;
                fixedNamespace = fixedNamespace2;
                super(UNICODE_MATH_COLORED_FUNCTIONS);
            }
            this.functionColors = fixedNamespace;
            this.operators = operators != null ? operators : UNICODE_MATH_SYNTAX_HIGHLIGHT_OPERATOR_HIERARCHY;
            this.translations = translations != null ? translations : new HashMap();
            this.colorTheme = colorTheme != null ? colorTheme : new HighlighterColorTheme();
            this.allowMissingNames = allowMissingNames;
        }

        @Override
        public MathParser.ParsedExpression<MutableComponent> parse(String expression) {
            return new InternalUnicodeMathSyntaxHighlightParser(expression, this.namespaceSetColors, this.functionColors, this.operators, this, this.translations, this.colorTheme, this.allowMissingNames).parse();
        }
    }

    public static class HighlighterColorTheme {
        public ChatFormatting numberColor = ChatFormatting.AQUA;
        public ChatFormatting braceColor = ChatFormatting.GOLD;
        public ChatFormatting operatorColor = ChatFormatting.GOLD;
        public ChatFormatting functionColor = ChatFormatting.WHITE;
        public ChatFormatting scriptColor = ChatFormatting.AQUA;
        public ChatFormatting[] nameColors = new ChatFormatting[]{ChatFormatting.DARK_GREEN, ChatFormatting.DARK_RED, ChatFormatting.BLUE, ChatFormatting.YELLOW, ChatFormatting.LIGHT_PURPLE, ChatFormatting.DARK_PURPLE, ChatFormatting.RED, ChatFormatting.GREEN};

        public ChatFormatting getNameColor(String name) {
            int hash = name.hashCode() % this.nameColors.length;
            if (hash < 0) {
                hash += this.nameColors.length;
            }
            return this.nameColors[hash];
        }

        public void set(HighlighterColorTheme source) {
            if (source.numberColor != null) {
                this.numberColor = source.numberColor;
            }
            if (source.braceColor != null) {
                this.braceColor = source.braceColor;
            }
            if (source.operatorColor != null) {
                this.operatorColor = source.operatorColor;
            }
            if (source.functionColor != null) {
                this.functionColor = source.functionColor;
            }
            if (source.scriptColor != null) {
                this.scriptColor = source.scriptColor;
            }
            if (source.nameColors != null) {
                this.nameColors = (ChatFormatting[])source.nameColors.clone();
            }
        }

        public HighlighterColorTheme copy() {
            HighlighterColorTheme theme = new HighlighterColorTheme();
            theme.numberColor = this.numberColor;
            theme.braceColor = this.braceColor;
            theme.operatorColor = this.operatorColor;
            theme.functionColor = this.functionColor;
            theme.scriptColor = this.scriptColor;
            theme.nameColors = (ChatFormatting[])this.nameColors.clone();
            return theme;
        }
    }
}

