/*
 * Decompiled with CFR 0.152.
 */
package endorh.lazulib.common;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ObfuscationReflectionUtil {
    private static final Logger LOGGER = LogManager.getLogger();

    public static <T, C> Optional<T> getStaticFieldValue(Class<C> clazz, String srgName) {
        return ObfuscationReflectionUtil.getField(clazz, srgName).map(f -> {
            if (!Modifier.isStatic(f.getModifiers())) {
                LOGGER.warn("Cannot get static field value from non static field " + f.getDeclaringClass().getName() + "$" + f.getName());
                return null;
            }
            try {
                f.setAccessible(true);
                return f.get(null);
            }
            catch (IllegalAccessException e) {
                return null;
            }
        });
    }

    @Nullable
    public static <T, C> T getStaticFieldValueOrLog(Class<C> clazz, String srgName, @Nullable String mcpName, @Nullable Consumer<String> logger) {
        return ObfuscationReflectionUtil.getStaticFieldValueOrLog(clazz, srgName, mcpName, logger, "");
    }

    @Nullable
    public static <T, C> T getStaticFieldValueOrLog(Class<C> clazz, String srgName, @Nullable String mcpName, @Nullable Consumer<String> logger, @Nullable String logExtra) {
        return (T)ObfuscationReflectionUtil.getStaticFieldValue(clazz, srgName).orElseGet(() -> {
            if (logger != null) {
                logger.accept("Could not get value of static field \"" + clazz.getName() + "$" + srgName + (String)(mcpName != null ? " (MCP " + mcpName + ")" : "") + (String)(logExtra != null && !logExtra.isEmpty() ? ": " + logExtra : ""));
            }
            return null;
        });
    }

    @Nullable
    public static <T> Field getFieldOrLog(Class<T> clazz, String srgName, @Nullable String mcpName, @Nullable Consumer<String> logger) {
        return ObfuscationReflectionUtil.getFieldOrLog(clazz, srgName, mcpName, logger, "");
    }

    @Nullable
    public static <T> Field getFieldOrLog(Class<T> clazz, String srgName, @Nullable String mcpName, @Nullable Consumer<String> logger, @Nullable String logExtra) {
        return ObfuscationReflectionUtil.getField(clazz, srgName).orElseGet(() -> {
            if (logger != null) {
                logger.accept("Unable to find field " + clazz.getSimpleName() + "#" + srgName + (String)(mcpName != null ? " (MCP " + mcpName + ")" : "") + (String)(logExtra != null && !logExtra.isEmpty() ? ": " + logExtra : ""));
            }
            return null;
        });
    }

    @Nullable
    public static <T> Method getMethodOrLog(Class<T> clazz, String srgName, @Nullable String mcpName, @Nullable Consumer<String> logger, Class<?> ... parameterTypes) {
        return ObfuscationReflectionUtil.getMethodOrLog(clazz, srgName, mcpName, logger, "", parameterTypes);
    }

    @Nullable
    public static <T> Method getMethodOrLog(Class<T> clazz, String srgName, @Nullable String mcpName, @Nullable Consumer<String> logger, @Nullable String logExtra, Class<?> ... parameterTypes) {
        return ObfuscationReflectionUtil.getMethod(clazz, srgName, parameterTypes).orElseGet(() -> {
            if (logger != null) {
                logger.accept("Unable to find method " + clazz.getSimpleName() + "#" + srgName + "(" + Arrays.stream(parameterTypes).map(Class::getSimpleName).collect(Collectors.joining(", ")) + ")" + (String)(mcpName != null ? " (MCP " + mcpName + ")" : "") + (String)(logExtra != null && !logExtra.isEmpty() ? ": " + logExtra : ""));
            }
            return null;
        });
    }

    @Nullable
    public static <T> Constructor<T> getConstructorOrLog(Class<T> clazz, Consumer<String> logger, Class<?> ... parameterTypes) {
        return ObfuscationReflectionUtil.getConstructorOrLog(clazz, logger, "", parameterTypes);
    }

    @Nullable
    public static <T> Constructor<T> getConstructorOrLog(Class<T> clazz, Consumer<String> logger, String logExtra, Class<?> ... parameterTypes) {
        return ObfuscationReflectionUtil.getConstructor(clazz, parameterTypes).orElseGet(() -> {
            logger.accept("Unable to find constructor for class " + clazz.getName() + " with parameters (" + Arrays.stream(parameterTypes).map(Class::getSimpleName).collect(Collectors.joining(", ")) + ")" + (String)(!logExtra.isEmpty() ? ": " + logExtra : ""));
            return null;
        });
    }

    public static <T> Optional<Field> getField(Class<T> clazz, String srgName) {
        try {
            Field result = ObfuscationReflectionHelper.findField(clazz, (String)srgName);
            result.setAccessible(true);
            return Optional.of(result);
        }
        catch (ObfuscationReflectionHelper.UnableToFindFieldException e) {
            return Optional.empty();
        }
    }

    public static <T> Optional<Method> getMethod(Class<T> clazz, String srgName, Class<?> ... parameterTypes) {
        try {
            Method result = ObfuscationReflectionHelper.findMethod(clazz, (String)srgName, (Class[])parameterTypes);
            result.setAccessible(true);
            return Optional.of(result);
        }
        catch (ObfuscationReflectionHelper.UnableToFindMethodException e) {
            return Optional.empty();
        }
    }

    public static <T> Optional<Constructor<T>> getConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        try {
            Constructor result = ObfuscationReflectionHelper.findConstructor(clazz, (Class[])parameterTypes);
            result.setAccessible(true);
            return Optional.of(result);
        }
        catch (ObfuscationReflectionHelper.UnknownConstructorException e) {
            return Optional.empty();
        }
    }

    public static <C, V> SoftField<C, V> getSoftField(Class<C> clazz, String srgName) {
        return ObfuscationReflectionUtil.getSoftField(clazz, srgName, null, null, null, null);
    }

    public static <C, V> SoftField<C, V> getSoftField(Class<C> clazz, String srgName, @Nullable String mcpName) {
        return ObfuscationReflectionUtil.getSoftField(clazz, srgName, mcpName, null, null, null);
    }

    public static <C, V> SoftField<C, V> getSoftField(Class<C> clazz, String srgName, @Nullable String mcpName, @Nullable Consumer<String> logger) {
        return ObfuscationReflectionUtil.getSoftField(clazz, srgName, mcpName, logger, null, null);
    }

    public static <C, V> SoftField<C, V> getSoftField(Class<C> clazz, String srgName, @Nullable String mcpName, @Nullable Consumer<String> logger, @Nullable String logExtra) {
        return ObfuscationReflectionUtil.getSoftField(clazz, srgName, mcpName, logger, logExtra, null);
    }

    public static <C, V> SoftField<C, V> getSoftField(Class<C> clazz, String srgName, @Nullable String mcpName, @Nullable Consumer<String> logger, @Nullable String fetchLogExtra, @Nullable String logExtra) {
        Field field = ObfuscationReflectionUtil.getFieldOrLog(clazz, srgName, mcpName, logger, fetchLogExtra);
        return new SoftField(clazz, clazz.getSimpleName() + "#" + srgName + (String)(mcpName != null ? " (MCP: " + mcpName + ")" : ""), field, logger, logExtra != null ? logExtra : fetchLogExtra);
    }

    public static <C, R> SoftMethod<C, R> getSoftMethod(Class<C> clazz, String srgName, Class<?> ... parameterTypes) {
        return ObfuscationReflectionUtil.getSoftMethod(clazz, srgName, null, null, null, null, parameterTypes);
    }

    public static <C, R> SoftMethod<C, R> getSoftMethod(Class<C> clazz, String srgName, String mcpName, Class<?> ... parameterTypes) {
        return ObfuscationReflectionUtil.getSoftMethod(clazz, srgName, mcpName, null, null, null, parameterTypes);
    }

    public static <C, R> SoftMethod<C, R> getSoftMethod(Class<C> clazz, String srgName, String mcpName, @Nullable Consumer<String> logger, Class<?> ... parameterTypes) {
        return ObfuscationReflectionUtil.getSoftMethod(clazz, srgName, mcpName, logger, null, null, parameterTypes);
    }

    public static <C, R> SoftMethod<C, R> getSoftMethod(Class<C> clazz, String srgName, String mcpName, @Nullable Consumer<String> logger, @Nullable String logExtra, Class<?> ... parameterTypes) {
        return ObfuscationReflectionUtil.getSoftMethod(clazz, srgName, mcpName, logger, null, logExtra, parameterTypes);
    }

    public static <C, R> SoftMethod<C, R> getSoftMethod(Class<C> clazz, String srgName, String mcpName, @Nullable Consumer<String> logger, @Nullable String fetchLogExtra, @Nullable String logExtra, Class<?> ... parameterTypes) {
        Method method = ObfuscationReflectionUtil.getMethodOrLog(clazz, srgName, mcpName, logger, fetchLogExtra, parameterTypes);
        return new SoftMethod(clazz, clazz.getSimpleName() + "#" + srgName + " (MCP: " + mcpName + ")", method, logger, logExtra != null ? logExtra : fetchLogExtra);
    }

    public static <C> SoftConstructor<C> getSoftConstructor(Class<C> clazz, Class<?> ... parameterTypes) {
        return ObfuscationReflectionUtil.getSoftConstructor(clazz, null, null, null, parameterTypes);
    }

    public static <C> SoftConstructor<C> getSoftConstructor(Class<C> clazz, @Nullable Consumer<String> logger, Class<?> ... parameterTypes) {
        return ObfuscationReflectionUtil.getSoftConstructor(clazz, logger, null, null, parameterTypes);
    }

    public static <C> SoftConstructor<C> getSoftConstructor(Class<C> clazz, @Nullable Consumer<String> logger, @Nullable String logExtra, Class<?> ... parameterTypes) {
        return ObfuscationReflectionUtil.getSoftConstructor(clazz, logger, null, logExtra, parameterTypes);
    }

    public static <C> SoftConstructor<C> getSoftConstructor(Class<C> clazz, @Nullable Consumer<String> logger, @Nullable String fetchLogExtra, @Nullable String logExtra, Class<?> ... parameterTypes) {
        Constructor<C> constructor = ObfuscationReflectionUtil.getConstructorOrLog(clazz, logger, fetchLogExtra, parameterTypes);
        return new SoftConstructor<C>(clazz, constructor, logger, logExtra != null ? logExtra : "");
    }

    public static class SoftField<C, V> {
        public final Class<C> clazz;
        protected final String name;
        @Nullable
        public final Field field;
        @Nullable
        public Consumer<String> logger;
        @Nullable
        public String logExtra;

        protected SoftField(Class<C> clazz, String name, @Nullable Field field, @Nullable Consumer<String> logger, @Nullable String logExtra) {
            this.clazz = clazz;
            this.name = name;
            this.field = field;
            this.logger = logger;
            this.logExtra = logExtra;
            if (this.field != null) {
                this.field.setAccessible(true);
            }
        }

        @Nullable
        public V get(@Nullable C self) {
            if (this.field == null) {
                this.log(this.getUnavailableErrorMessage());
            } else {
                try {
                    return (V)this.field.get(self);
                }
                catch (ClassCastException | IllegalAccessException | IllegalArgumentException e) {
                    this.log(this.getReadErrorMessage(e));
                }
            }
            return null;
        }

        public boolean set(@Nullable C self, V value) {
            if (this.field == null) {
                this.log(this.getUnavailableErrorMessage());
            } else {
                try {
                    this.field.set(self, value);
                    return true;
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    this.log(this.getWriteErrorMessage(e));
                }
            }
            return false;
        }

        protected void log(String msg) {
            if (this.logger != null && msg != null) {
                this.logger.accept(msg);
            }
        }

        @Nullable
        protected String getUnavailableErrorMessage() {
            return null;
        }

        @Nullable
        protected String getReadErrorMessage(Exception e) {
            return "Could not access field " + this.name + (String)(!this.getLogExtra().isEmpty() ? ": " + this.logExtra : "") + "\n  Details: " + e.getMessage();
        }

        @Nullable
        protected String getWriteErrorMessage(Exception e) {
            return "Could not modify field " + this.name + (String)(!this.getLogExtra().isEmpty() ? ": " + this.logExtra : "") + "\n  Details: " + e.getMessage();
        }

        @Nonnull
        protected String getLogExtra() {
            return this.logExtra != null ? this.logExtra : "";
        }
    }

    public static class SoftMethod<C, R> {
        public final Class<C> clazz;
        public final String name;
        @Nullable
        public final Method method;
        @Nullable
        public Consumer<String> logger;
        @Nullable
        public String logExtra;

        protected SoftMethod(Class<C> clazz, String name, @Nullable Method method, @Nullable Consumer<String> logger, @Nullable String logExtra) {
            this.clazz = clazz;
            this.name = name;
            this.method = method;
            this.logger = logger;
            this.logExtra = logExtra;
            if (this.method != null) {
                this.method.setAccessible(true);
            }
        }

        @Nullable
        public R invoke(C self, Object ... args) {
            if (this.method == null) {
                this.log(this.getUnavailableErrorMessage());
            } else {
                try {
                    return (R)this.method.invoke(self, args);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    this.log(this.getInvokeErrorMessage(e));
                }
            }
            return null;
        }

        public boolean testInvoke(C self, Object ... args) {
            if (this.method == null) {
                this.log(this.getUnavailableErrorMessage());
            } else {
                try {
                    this.method.invoke(self, args);
                    return true;
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    this.log(this.getInvokeErrorMessage(e));
                }
            }
            return false;
        }

        protected void log(String msg) {
            if (this.logger != null && msg != null) {
                this.logger.accept(msg);
            }
        }

        @Nullable
        protected String getUnavailableErrorMessage() {
            return null;
        }

        @Nullable
        protected String getInvokeErrorMessage(Exception e) {
            return "Could not invoke method " + this.name + (String)(!this.getLogExtra().isEmpty() ? ": " + this.logExtra : "") + "\n  Details: " + e.getMessage();
        }

        @Nonnull
        protected String getLogExtra() {
            return this.logExtra != null ? this.logExtra : "";
        }
    }

    public static class SoftConstructor<C> {
        public final Class<C> clazz;
        public final Constructor<C> constructor;
        public final String name;
        @Nullable
        public Consumer<String> logger;
        @Nullable
        public String logExtra;

        protected SoftConstructor(Class<C> clazz, Constructor<C> constructor, @Nullable Consumer<String> logger, @Nullable String logExtra) {
            this.clazz = clazz;
            this.constructor = constructor;
            this.name = clazz.getSimpleName();
            this.logger = logger;
            this.logExtra = logExtra;
            if (this.constructor != null) {
                this.constructor.setAccessible(true);
            }
        }

        @Nullable
        public C newInstance(Object ... args) {
            if (this.constructor == null) {
                this.log(this.getUnavailableErrorMessage());
            } else {
                try {
                    return this.constructor.newInstance(args);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                    this.log(this.getConstructionErrorMessage(e));
                }
            }
            return null;
        }

        protected void log(@Nullable String msg) {
            if (this.logger != null && msg != null) {
                this.logger.accept(msg);
            }
        }

        @Nullable
        protected String getUnavailableErrorMessage() {
            return null;
        }

        @Nullable
        protected String getConstructionErrorMessage(Exception e) {
            return "Could not create instance of class " + this.name + (String)(!this.getLogExtra().isEmpty() ? ": " + this.logExtra : "") + "\n  Details: " + e.getMessage();
        }

        @Nonnull
        protected String getLogExtra() {
            return this.logExtra != null ? this.logExtra : "";
        }
    }
}

