/*
 * Decompiled with CFR 0.152.
 */
package endorh.lazulib.common;

import java.awt.Color;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;

public class ColorUtil {
    private static final float[] originHSB = new float[3];
    private static final float[] targetHSB = new float[3];

    public static float hsbDistance(Color a, Color b) {
        float[] a_hsb = Color.RGBtoHSB(a.getRed(), a.getGreen(), a.getBlue(), null);
        float[] b_hsb = Color.RGBtoHSB(b.getRed(), b.getGreen(), b.getBlue(), null);
        float[] diff = new float[]{Math.min((a_hsb[0] - b_hsb[0] + 1.0f) % 1.0f, (b_hsb[0] - a_hsb[0] + 1.0f) % 1.0f), Math.abs(a_hsb[1] - b_hsb[1]), Math.abs(a_hsb[2] - b_hsb[2])};
        return diff[0] * diff[0] * 2.0f + diff[1] * diff[1] + diff[2] * diff[2];
    }

    public static Optional<DyeColor> closestDyeColor(Color color) {
        return Arrays.stream(DyeColor.values()).min(Comparator.comparingDouble(dye -> ColorUtil.hsbDistance(color, new Color(dye.m_41071_()))));
    }

    public static Optional<ChatFormatting> closestTextColor(Color color) {
        return Arrays.stream(ChatFormatting.values()).filter(ChatFormatting::m_126664_).min(Comparator.comparingDouble(fmt -> ColorUtil.hsbDistance(color, new Color(fmt.m_126665_()))));
    }

    public static int mix(List<Integer> colors) {
        return ColorUtil.mix(colors.stream().mapToInt(t -> t).toArray());
    }

    public static int mix(int ... colors) {
        return ColorUtil.mix((Color[])Arrays.stream(colors).mapToObj(Color::new).toArray(Color[]::new)).getRGB();
    }

    public static Color mix(Color ... colors) {
        int n = colors.length;
        if (n == 0) {
            return Color.black;
        }
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        float a = 0.0f;
        for (Color c : colors) {
            r += (float)c.getRed() / 255.0f;
            g += (float)c.getGreen() / 255.0f;
            b += (float)c.getBlue() / 255.0f;
            a += (float)c.getAlpha() / 255.0f;
        }
        return new Color(r / (float)n, g / (float)n, b / (float)n, a / (float)n);
    }

    public static Color multiply(Color color, Color mask) {
        return ColorUtil.multiply(color, (float)mask.getRed() / 255.0f, (float)mask.getGreen() / 255.0f, (float)mask.getBlue() / 255.0f, (float)mask.getAlpha() / 255.0f);
    }

    public static Color multiply(Color color, float mask) {
        return ColorUtil.multiply(color, mask, mask, mask, 1.0f);
    }

    public static Color multiply(Color color, float r, float g, float b) {
        return ColorUtil.multiply(color, r, g, b, 1.0f);
    }

    public static Color multiply(Color color, float r, float g, float b, float a) {
        return new Color(Mth.m_14045_((int)Math.round((float)color.getRed() * r), (int)0, (int)255), Mth.m_14045_((int)Math.round((float)color.getGreen() * g), (int)0, (int)255), Mth.m_14045_((int)Math.round((float)color.getBlue() * b), (int)0, (int)255), Mth.m_14045_((int)Math.round((float)color.getAlpha() * a), (int)0, (int)255));
    }

    public static ChatFormatting textColorFromDye(DyeColor color) {
        return switch (color) {
            default -> throw new IncompatibleClassChangeError();
            case DyeColor.WHITE -> ChatFormatting.WHITE;
            case DyeColor.ORANGE -> ChatFormatting.GOLD;
            case DyeColor.MAGENTA -> ChatFormatting.LIGHT_PURPLE;
            case DyeColor.LIGHT_BLUE -> ChatFormatting.AQUA;
            case DyeColor.YELLOW -> ChatFormatting.YELLOW;
            case DyeColor.LIME -> ChatFormatting.GREEN;
            case DyeColor.PINK -> ChatFormatting.LIGHT_PURPLE;
            case DyeColor.GRAY -> ChatFormatting.DARK_GRAY;
            case DyeColor.LIGHT_GRAY -> ChatFormatting.GRAY;
            case DyeColor.CYAN -> ChatFormatting.DARK_AQUA;
            case DyeColor.PURPLE -> ChatFormatting.DARK_PURPLE;
            case DyeColor.BLUE -> ChatFormatting.BLUE;
            case DyeColor.BROWN -> ChatFormatting.DARK_RED;
            case DyeColor.GREEN -> ChatFormatting.DARK_GREEN;
            case DyeColor.RED -> ChatFormatting.RED;
            case DyeColor.BLACK -> ChatFormatting.BLACK;
        };
    }

    public static ChatFormatting discardBlack(ChatFormatting fmt) {
        if (fmt == ChatFormatting.BLACK) {
            return ChatFormatting.DARK_GRAY;
        }
        return fmt;
    }

    public static Color lerp(float t, Color origin, Color target) {
        float r = 1.0f - t;
        return new Color((float)origin.getRed() * r + (float)target.getRed() * t, (float)origin.getGreen() * r + (float)target.getGreen() * t, (float)origin.getBlue() * r + (float)target.getBlue() * t);
    }

    public static Color hsbLerp(float t, Color origin, Color target) {
        float r = 1.0f - t;
        Color.RGBtoHSB(origin.getRed(), origin.getGreen(), origin.getBlue(), originHSB);
        Color.RGBtoHSB(target.getRed(), target.getGreen(), target.getBlue(), targetHSB);
        if (originHSB[0] - targetHSB[0] > 180.0f) {
            targetHSB[0] = targetHSB[0] + 360.0f;
        }
        if (targetHSB[0] - originHSB[0] > 180.0f) {
            originHSB[0] = originHSB[0] + 360.0f;
        }
        return Color.getHSBColor(originHSB[0] * r + targetHSB[0] * t, originHSB[1] * r + targetHSB[1] * t, originHSB[2] * r + targetHSB[2] * t);
    }

    public static void hsbLerp(float t, float[] origin, float[] target, float[] dest) {
        float r = 1.0f - t;
        float diff = origin[0] - target[0];
        float targetHue = diff > 180.0f ? target[0] + 360.0f : target[0];
        float originHue = diff < -180.0f ? origin[0] + 360.0f : origin[0];
        dest[0] = originHue * r + targetHue * t;
        dest[1] = origin[1] * r + target[1] * t;
        dest[2] = origin[2] * r + target[2] * t;
    }

    public static void hsbLerpToRgb(float t, float[] origin, float[] target, float[] dest) {
        ColorUtil.hsbLerp(t, origin, target, dest);
        ColorUtil.HSBtoRGB(dest, dest);
    }

    public static void HSBtoRGB(float[] hsb, float[] rgb) {
        if (hsb[1] == 0.0f) {
            rgb[1] = rgb[2] = hsb[2];
            rgb[0] = rgb[2];
        } else {
            float hue = (hsb[0] - (float)Math.floor(hsb[0])) * 6.0f;
            float f = hue - (float)Math.floor(hue);
            float p = hsb[2] * (1.0f - hsb[1]);
            float q = hsb[2] * (1.0f - hsb[1] * f);
            float t = hsb[2] * (1.0f - hsb[1] * (1.0f - f));
            switch ((int)hue) {
                case 0: {
                    rgb[0] = hsb[2];
                    rgb[1] = t;
                    rgb[2] = p;
                    break;
                }
                case 1: {
                    rgb[0] = q;
                    rgb[1] = hsb[2];
                    rgb[2] = p;
                    break;
                }
                case 2: {
                    rgb[0] = p;
                    rgb[1] = hsb[2];
                    rgb[2] = t;
                    break;
                }
                case 3: {
                    rgb[0] = p;
                    rgb[1] = q;
                    rgb[2] = hsb[2];
                    break;
                }
                case 4: {
                    rgb[0] = t;
                    rgb[1] = p;
                    rgb[2] = hsb[2];
                    break;
                }
                case 5: {
                    rgb[0] = hsb[2];
                    rgb[1] = p;
                    rgb[2] = q;
                }
            }
        }
    }

    public static int getTextureDiffuseColor(DyeColor color) {
        float[] colors = color.m_41068_();
        return 0xFF000000 | ((int)(colors[0] * 255.0f + 0.5f) & 0xFF) << 24 | ((int)(colors[1] * 255.0f + 0.5f) & 0xFF) << 16 | (int)(colors[2] * 255.0f + 0.5f) & 0xFF;
    }
}

