/*
 * Decompiled with CFR 0.152.
 */
package endorh.lazulib.command;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import endorh.lazulib.text.TextUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public class QualifiedNameArgumentType
implements ArgumentType<String> {
    private static final SimpleCommandExceptionType MISSING_QUALIFIER = new SimpleCommandExceptionType((Message)TextUtil.ttc("commands.lazulib.error.missing_qualifier", new Object[0]));
    private static final SimpleCommandExceptionType UNEXPECTED_QUALIFIER = new SimpleCommandExceptionType((Message)TextUtil.ttc("commands.lazulib.error.unexpected_qualifier", new Object[0]));
    private static final SimpleCommandExceptionType UNEXPECTED_SEPARATOR = new SimpleCommandExceptionType((Message)TextUtil.ttc("commands.lazulib.error.unexpected_separator", new Object[0]));
    protected final QualifiedNameType type;
    protected static final Pattern SPLIT = Pattern.compile("(?<=\\S)(?!\\S)|(?<=\\s)(?!\\s)");

    public static QualifiedNameArgumentType optionallyQualified() {
        return new QualifiedNameArgumentType(QualifiedNameType.OPTIONALLY_QUALIFIED_NAME);
    }

    public static QualifiedNameArgumentType qualified() {
        return new QualifiedNameArgumentType(QualifiedNameType.QUALIFIED_NAME);
    }

    public static QualifiedNameArgumentType unqualified() {
        return new QualifiedNameArgumentType(QualifiedNameType.UNQUALIFIED_NAME);
    }

    private QualifiedNameArgumentType(QualifiedNameType type) {
        this.type = type;
    }

    public static String getName(CommandContext<?> context, String name) {
        return (String)context.getArgument(name, String.class);
    }

    public String parse(StringReader reader) throws CommandSyntaxException {
        String name = SPLIT.split(reader.getString().substring(reader.getCursor()), 2)[0];
        reader.setCursor(reader.getCursor() + name.length());
        if (!this.type.optionalQualifier && !name.contains(":")) {
            throw MISSING_QUALIFIER.createWithContext((ImmutableStringReader)reader);
        }
        if (!this.type.allowQualifier && name.contains(":")) {
            throw UNEXPECTED_QUALIFIER.createWithContext((ImmutableStringReader)reader);
        }
        if (name.contains(":") && name.substring(name.indexOf(58) + 1).contains(":")) {
            throw UNEXPECTED_SEPARATOR.createWithContext((ImmutableStringReader)reader);
        }
        return name;
    }

    public Collection<String> getExamples() {
        if (!this.type.allowQualifier) {
            return Arrays.asList("name", "hyphened-name");
        }
        if (this.type.optionalQualifier) {
            return Arrays.asList("name", "qualified:name");
        }
        return Arrays.asList("qualified:name", "qualified:hyphened-name");
    }

    public static enum QualifiedNameType {
        UNQUALIFIED_NAME(false, true),
        QUALIFIED_NAME(true, false),
        OPTIONALLY_QUALIFIED_NAME(true, true);

        public final boolean allowQualifier;
        public final boolean optionalQualifier;

        private QualifiedNameType(boolean allowQualifier, boolean optionalQualifier) {
            this.allowQualifier = allowQualifier;
            this.optionalQualifier = optionalQualifier;
        }

        public String getJsonName() {
            String name = this.name().toLowerCase();
            return name.substring(0, name.length() - 5);
        }
    }

    public static class Info
    implements ArgumentTypeInfo<QualifiedNameArgumentType, Template> {
        public void serializeToNetwork(Template template, FriendlyByteBuf buf) {
            buf.m_130068_((Enum)template.type);
        }

        @NotNull
        public Template deserializeFromNetwork(@NotNull FriendlyByteBuf buf) {
            return new Template((QualifiedNameType)buf.m_130066_(QualifiedNameType.class));
        }

        public void serializeToJson(@NotNull Template template, @NotNull JsonObject obj) {
            obj.addProperty("type", template.type.getJsonName());
        }

        @NotNull
        public Template unpack(@NotNull QualifiedNameArgumentType type) {
            return new Template(type.type);
        }

        public class Template
        implements ArgumentTypeInfo.Template<QualifiedNameArgumentType> {
            final QualifiedNameType type;

            public Template(QualifiedNameType type) {
                this.type = type;
            }

            @NotNull
            public QualifiedNameArgumentType instantiate(@NotNull CommandBuildContext ctx) {
                return new QualifiedNameArgumentType(this.type);
            }

            @NotNull
            public ArgumentTypeInfo<QualifiedNameArgumentType, ?> m_213709_() {
                return Info.this;
            }
        }
    }
}

