/*
 * Decompiled with CFR 0.152.
 */
package endorh.lazulib.capability;

import endorh.lazulib.capability.ISerializableCapability;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SerializableCapabilityWrapperProvider<C extends ISerializableCapability>
implements ICapabilitySerializable<CompoundTag> {
    private final Capability<C> capability;
    private final Direction side;
    private final C instance;

    public SerializableCapabilityWrapperProvider(Capability<C> capability, C instance) {
        this(capability, null, instance);
    }

    public SerializableCapabilityWrapperProvider(Capability<C> capability, @Nullable Direction side, C instance) {
        this.capability = capability;
        this.side = side;
        this.instance = instance;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return cap == this.capability && side == this.side ? LazyOptional.of(() -> this.instance).cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        return this.instance.serializeCapability();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.instance.deserializeCapability(nbt);
    }
}

