/*
 * Decompiled with CFR 0.152.
 */
package endorh.lazulib.animation;

import endorh.lazulib.animation.Easing;

public class ToggleAnimator {
    protected float progress;
    protected float target;
    protected float lastProgress;
    protected long lastChange = 0L;
    protected long length;
    protected float min = 0.0f;
    protected float max = 1.0f;
    protected Easing.EasingFunction easing = Easing::linear;

    public static ToggleAnimator of(Easing.EasingFunction interpolation) {
        return new ToggleAnimator(interpolation);
    }

    public static ToggleAnimator of(long lengthMs, Easing.EasingFunction interpolation) {
        return new ToggleAnimator(lengthMs, interpolation);
    }

    public static ToggleAnimator linear() {
        return ToggleAnimator.of(Easing::linear);
    }

    public static ToggleAnimator linear(long lengthMs) {
        return ToggleAnimator.of(lengthMs, Easing::linear);
    }

    public static ToggleAnimator quadOut() {
        return ToggleAnimator.of(Easing::quadOut);
    }

    public static ToggleAnimator quadOut(long lengthMs) {
        return ToggleAnimator.of(lengthMs, Easing::quadOut);
    }

    public static ToggleAnimator bezier(float x1, float y1, float x2, float y2) {
        return ToggleAnimator.of(Easing.cubicBezier(x1, y1, x2, y2));
    }

    public ToggleAnimator() {
        this(250L);
    }

    public ToggleAnimator(long length) {
        this(0.0f, length);
    }

    public ToggleAnimator(float progress, long length) {
        this.lastProgress = this.progress = progress;
        this.target = this.progress;
        this.length = length;
    }

    public ToggleAnimator(Easing.EasingFunction interpolation) {
        this();
        this.easing = interpolation;
    }

    public ToggleAnimator(long length, Easing.EasingFunction interpolation) {
        this(length);
        this.easing = interpolation;
    }

    public float getRawProgress() {
        float len;
        long time = System.currentTimeMillis();
        if ((float)(time - this.lastChange) < (len = (float)this.length * Math.abs(this.target - this.lastProgress))) {
            float t = (float)(time - this.lastChange) / len;
            this.progress = this.lastProgress * (1.0f - t) + this.target * t;
            return this.progress;
        }
        this.progress = this.target;
        return this.progress;
    }

    public float getUnitProgress() {
        return this.easing.apply(Float.valueOf(this.getRawProgress())).floatValue();
    }

    public float getProgress() {
        return this.mapRange(this.getUnitProgress());
    }

    public float mapRange(float in) {
        return this.min + in * (this.max - this.min);
    }

    public void setTargetRaw(boolean onOff) {
        this.setTargetRaw(onOff ? 1.0f : 0.0f);
    }

    public void setTargetRaw(float target) {
        this.lastProgress = this.getRawProgress();
        this.target = target;
        this.lastChange = System.currentTimeMillis();
    }

    public void setTarget(boolean onOff) {
        this.setTarget(onOff ? 1.0f : 0.0f);
    }

    public void setTarget(float target) {
        this.lastProgress = this.getUnitProgress();
        this.target = target;
        this.lastChange = System.currentTimeMillis();
    }

    public void toggle() {
        this.setTargetRaw((double)this.target <= 0.5);
    }

    public void resetTarget() {
        this.resetTarget(true);
    }

    public void resetTarget(boolean onOff) {
        this.target = onOff ? 1.0f : 0.0f;
        this.lastProgress = 1.0f - this.target;
        this.lastChange = System.currentTimeMillis();
    }

    public void resetTarget(float target) {
        this.target = target;
        this.lastProgress = 0.0f;
        this.lastChange = System.currentTimeMillis();
    }

    public void stopAndSet(float target) {
        this.target = target;
        this.lastProgress = 1.0f;
        this.lastChange = System.currentTimeMillis() - this.length;
    }

    public void stopAndSet(boolean target) {
        this.stopAndSet(target ? 1.0f : 0.0f);
    }

    public boolean isInProgress() {
        return (float)(System.currentTimeMillis() - this.lastChange) < (float)this.length * Math.abs(this.target - this.lastProgress);
    }

    public long getLastChange() {
        return this.lastChange;
    }

    public float getTarget() {
        return this.target;
    }

    public float getRangeMin() {
        return this.min;
    }

    public void setRangeMin(float min) {
        this.min = min;
    }

    public float getRangeMax() {
        return this.max;
    }

    public void setRangeMax(float max) {
        this.max = max;
    }

    public void setRange(float min, float max) {
        this.min = min;
        this.max = max;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public Easing.EasingFunction getEasing() {
        return this.easing;
    }

    public void setEasing(Easing.EasingFunction easing) {
        this.easing = easing;
    }
}

