/*
 * Decompiled with CFR 0.152.
 */
package Shadow.shadowed.com.github.curiousoddman.rgxgen.iterators;

import Shadow.shadowed.com.github.curiousoddman.rgxgen.iterators.StringIterator;
import Shadow.shadowed.com.github.curiousoddman.rgxgen.util.Util;
import java.util.NoSuchElementException;
import java.util.OptionalInt;
import java.util.TreeMap;

public class CaseVariationIterator
implements StringIterator {
    private final String aOriginalValue;
    private final StringBuilder aValue;
    private final TreeMap<Integer, Boolean> aSwitchableCharPositions;
    private int aCurrentPos;
    private boolean hasNext;

    public CaseVariationIterator(String value) {
        this.aOriginalValue = value;
        this.aValue = new StringBuilder(value.toLowerCase());
        this.aSwitchableCharPositions = new TreeMap();
        OptionalInt currentPos = Util.indexOfNextCaseSensitiveCharacter(this.aValue, 0);
        while (currentPos.isPresent()) {
            this.aSwitchableCharPositions.put(currentPos.getAsInt(), true);
            currentPos = Util.indexOfNextCaseSensitiveCharacter(this.aValue, currentPos.getAsInt() + 1);
        }
        this.reset();
    }

    @Override
    public String next() {
        if (!this.hasNext) {
            throw new NoSuchElementException("No more variations");
        }
        if (this.aSwitchableCharPositions.isEmpty()) {
            this.hasNext = false;
            return this.aOriginalValue;
        }
        if (this.aCurrentPos < 0) {
            this.aCurrentPos = this.aSwitchableCharPositions.firstKey();
            return this.aValue.toString();
        }
        char currentChar = this.aValue.charAt(this.aCurrentPos);
        if (Character.isLowerCase(currentChar)) {
            this.aValue.setCharAt(this.aCurrentPos, Character.toUpperCase(currentChar));
            this.aSwitchableCharPositions.put(this.aCurrentPos, false);
            this.hasNext = this.aSwitchableCharPositions.values().stream().anyMatch(v -> v);
        } else {
            while (Character.isUpperCase(this.aValue.charAt(this.aCurrentPos))) {
                this.aValue.setCharAt(this.aCurrentPos, Character.toLowerCase(this.aValue.charAt(this.aCurrentPos)));
                this.aSwitchableCharPositions.put(this.aCurrentPos, true);
                this.aCurrentPos = this.aSwitchableCharPositions.ceilingKey(this.aCurrentPos + 1);
            }
            this.aValue.setCharAt(this.aCurrentPos, Character.toUpperCase(this.aValue.charAt(this.aCurrentPos)));
            this.aSwitchableCharPositions.put(this.aCurrentPos, false);
            this.aCurrentPos = this.aSwitchableCharPositions.firstKey();
        }
        return this.aValue.toString();
    }

    @Override
    public void reset() {
        this.aValue.replace(0, this.aOriginalValue.length(), this.aOriginalValue.toLowerCase());
        this.hasNext = true;
        this.aCurrentPos = -1;
    }

    @Override
    public String current() {
        return this.aValue.toString();
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }
}

