/*
 * Decompiled with CFR 0.152.
 */
package Shadow.shadowed.com.florianingerl.util.regex;

import Shadow.shadowed.com.florianingerl.util.regex.ASCII;
import Shadow.shadowed.com.florianingerl.util.regex.Capture;
import Shadow.shadowed.com.florianingerl.util.regex.CaptureTreeNode;
import Shadow.shadowed.com.florianingerl.util.regex.Matcher;
import Shadow.shadowed.com.florianingerl.util.regex.PatternSyntaxException;
import Shadow.shadowed.com.florianingerl.util.regex.UnicodeProp;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Spliterators;
import java.util.Stack;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class Pattern
implements Serializable {
    public static final int UNIX_LINES = 1;
    public static final int CASE_INSENSITIVE = 2;
    public static final int COMMENTS = 4;
    public static final int MULTILINE = 8;
    public static final int LITERAL = 16;
    public static final int DOTALL = 32;
    public static final int UNICODE_CASE = 64;
    public static final int UNICODE_CHARACTER_CLASS = 256;
    private static final long serialVersionUID = 5073258162644648461L;
    private String pattern;
    private int flags;
    private boolean inLookaround;
    private volatile transient boolean compiled = false;
    private transient String normalizedPattern;
    transient Node root;
    transient Node matchRoot;
    private transient Node matchRootSetter;
    transient int[] buffer;
    static Map<String, Class<? extends CustomNode>> plugins = new HashMap<String, Class<? extends CustomNode>>();
    volatile transient Map<String, Integer> groupIndices;
    volatile transient Map<Integer, String> groupNames;
    volatile transient Set<Object> recursivelyCalledGroups;
    private transient ArrayList<GroupHeadAndTail> groupHeadAndTailNodes;
    private transient List<Runnable> groupExistsChecks;
    private transient List<Runnable> lookbehindHasMaxChecks;
    private transient List<Runnable> curlyDeterministicChecks;
    private transient List<Runnable> groupCalledRecursivelyChecks;
    private transient int[] temp;
    transient int capturingGroupCount;
    transient int localCount;
    private transient int cursor;
    private transient int patternLength;
    private transient boolean hasSupplementary;
    static final int MAX_REPS = Integer.MAX_VALUE;
    static final int GREEDY = 0;
    static final int LAZY = 1;
    static final int POSSESSIVE = 2;
    static Node lookbehindEnd = new Node(){

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            return i == matcher.lookbehindTo;
        }
    };
    static Node accept = new Node();
    static Node lastAccept = new LastNode();

    private void setMatchRoot(Node node) {
        if (this.matchRootSetter == null) {
            this.matchRootSetter = new Node(){

                @Override
                void setNext(Node a) {
                    Pattern.this.matchRoot = a;
                    if (a != null) {
                        a.previous = (Node)this;
                    }
                }
            };
        }
        this.matchRootSetter.setNext(node);
    }

    public static Pattern compile(String regex) {
        return new Pattern(regex, 0);
    }

    public static Pattern compile(String regex, int flags) {
        return new Pattern(regex, flags);
    }

    public static void installPlugin(String name, Class<? extends CustomNode> clazz) {
        plugins.put(name, clazz);
    }

    public static void uninstallPlugin(String name) {
        plugins.remove(name);
    }

    public String pattern() {
        return this.pattern;
    }

    public String toString() {
        return this.pattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Matcher matcher(CharSequence input) {
        if (!this.compiled) {
            Pattern pattern = this;
            synchronized (pattern) {
                if (!this.compiled) {
                    this.compile();
                }
            }
        }
        Matcher m = new Matcher(this, input);
        return m;
    }

    public int flags() {
        return this.flags;
    }

    public static boolean matches(String regex, CharSequence input) {
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(input);
        return m.matches();
    }

    public String[] split(CharSequence input, int limit) {
        int resultSize;
        int index = 0;
        boolean matchLimited = limit > 0;
        ArrayList<String> matchList = new ArrayList<String>();
        Matcher m = this.matcher(input);
        while (m.find()) {
            String match;
            if (!matchLimited || matchList.size() < limit - 1) {
                if (index == 0 && index == m.start() && m.start() == m.end()) continue;
                match = input.subSequence(index, m.start()).toString();
                matchList.add(match);
                index = m.end();
                continue;
            }
            if (matchList.size() != limit - 1) continue;
            match = input.subSequence(index, input.length()).toString();
            matchList.add(match);
            index = m.end();
        }
        if (index == 0) {
            return new String[]{input.toString()};
        }
        if (!matchLimited || matchList.size() < limit) {
            matchList.add(input.subSequence(index, input.length()).toString());
        }
        if (limit == 0) {
            for (resultSize = matchList.size(); resultSize > 0 && ((String)matchList.get(resultSize - 1)).equals(""); --resultSize) {
            }
        }
        String[] result = new String[resultSize];
        return matchList.subList(0, resultSize).toArray(result);
    }

    public String[] split(CharSequence input) {
        return this.split(input, 0);
    }

    public static String quote(String s) {
        int slashEIndex = s.indexOf("\\E");
        if (slashEIndex == -1) {
            return "\\Q" + s + "\\E";
        }
        StringBuilder sb = new StringBuilder(s.length() * 2);
        sb.append("\\Q");
        slashEIndex = 0;
        int current = 0;
        while ((slashEIndex = s.indexOf("\\E", current)) != -1) {
            sb.append(s.substring(current, slashEIndex));
            current = slashEIndex + 2;
            sb.append("\\E\\\\E\\Q");
        }
        sb.append(s.substring(current, s.length()));
        sb.append("\\E");
        return sb.toString();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.capturingGroupCount = 1;
        this.localCount = 0;
        this.compiled = false;
        if (this.pattern.length() == 0) {
            this.root = new Start(lastAccept);
            this.setMatchRoot(lastAccept);
            this.compiled = true;
        }
    }

    private Pattern(String p, int f) {
        this.pattern = p;
        this.flags = f;
        if ((this.flags & 0x100) != 0) {
            this.flags |= 0x40;
        }
        int saveFlags = this.flags;
        this.capturingGroupCount = 1;
        this.localCount = 0;
        if (this.pattern.length() > 0) {
            this.compile();
        } else {
            this.root = new Start(lastAccept);
            this.setMatchRoot(lastAccept);
        }
        this.flags = saveFlags;
    }

    private String composeOneStep(String input) {
        int len = Pattern.countChars(input, 0, 2);
        String firstTwoCharacters = input.substring(0, len);
        String result = Normalizer.normalize(firstTwoCharacters, Normalizer.Form.NFC);
        if (result.equals(firstTwoCharacters)) {
            return null;
        }
        String remainder = input.substring(len);
        return result + remainder;
    }

    private void RemoveQEQuoting() {
        int pLen = this.patternLength;
        int i = 0;
        while (i < pLen - 1) {
            if (this.temp[i] != 92) {
                ++i;
                continue;
            }
            if (this.temp[i + 1] == 81) break;
            i += 2;
        }
        if (i >= pLen - 1) {
            return;
        }
        int j = i;
        int[] newtemp = new int[j + 3 * (pLen - (i += 2)) + 2];
        System.arraycopy(this.temp, 0, newtemp, 0, j);
        boolean inQuote = true;
        boolean beginQuote = true;
        while (i < pLen) {
            int c;
            if (!ASCII.isAscii(c = this.temp[i++]) || ASCII.isAlpha(c)) {
                newtemp[j++] = c;
            } else if (ASCII.isDigit(c)) {
                if (beginQuote) {
                    newtemp[j++] = 92;
                    newtemp[j++] = 120;
                    newtemp[j++] = 51;
                }
                newtemp[j++] = c;
            } else if (c != 92) {
                if (inQuote) {
                    newtemp[j++] = 92;
                }
                newtemp[j++] = c;
            } else if (inQuote) {
                if (this.temp[i] == 69) {
                    ++i;
                    inQuote = false;
                } else {
                    newtemp[j++] = 92;
                    newtemp[j++] = 92;
                }
            } else {
                if (this.temp[i] == 81) {
                    ++i;
                    inQuote = true;
                    beginQuote = true;
                    continue;
                }
                newtemp[j++] = c;
                if (i != pLen) {
                    newtemp[j++] = this.temp[i++];
                }
            }
            beginQuote = false;
        }
        this.patternLength = j;
        this.temp = Arrays.copyOf(newtemp, j + 2);
    }

    private void compile() {
        int c;
        this.normalizedPattern = this.pattern;
        this.patternLength = this.normalizedPattern.length();
        this.temp = new int[this.patternLength + 2];
        this.hasSupplementary = false;
        int count = 0;
        for (int x = 0; x < this.patternLength; x += Character.charCount(c)) {
            c = this.normalizedPattern.codePointAt(x);
            if (Pattern.isSupplementary(c)) {
                this.hasSupplementary = true;
            }
            this.temp[count++] = c;
        }
        this.patternLength = count;
        if (!this.has(16)) {
            this.RemoveQEQuoting();
        }
        this.buffer = new int[32];
        this.groupIndices = null;
        this.groupNames = null;
        if (this.has(16)) {
            this.setMatchRoot(this.newSlice(this.temp, this.patternLength, this.hasSupplementary));
            this.matchRoot.setNext(lastAccept);
        } else {
            this.setMatchRoot(this.expr(lastAccept));
            if (this.patternLength != this.cursor) {
                if (this.peek() == 41) {
                    throw this.error("Unmatched closing ')'");
                }
                throw this.error("Unexpected internal error");
            }
        }
        for (Runnable r : this.groupExistsChecks()) {
            r.run();
        }
        for (Runnable r : this.groupCalledRecursivelyChecks()) {
            r.run();
        }
        for (Runnable r : this.lookbehindHasMaxChecks()) {
            r.run();
        }
        for (Runnable r : this.curlyDeterministicChecks()) {
            r.run();
        }
        if (this.matchRoot instanceof Slice) {
            this.root = BnM.optimize(this.matchRoot);
            if (this.root == this.matchRoot) {
                this.root = this.hasSupplementary ? new StartS(this.matchRoot) : new Start(this.matchRoot);
            }
        } else {
            this.root = this.matchRoot instanceof Begin ? this.matchRoot : (this.hasSupplementary ? new StartS(this.matchRoot) : new Start(this.matchRoot));
        }
        this.temp = null;
        this.buffer = null;
        this.patternLength = 0;
        this.compiled = true;
    }

    Map<String, Integer> groupIndices() {
        if (this.groupIndices == null) {
            this.groupIndices = new HashMap<String, Integer>(2);
        }
        return this.groupIndices;
    }

    Map<Integer, String> groupNames() {
        if (this.groupNames == null) {
            this.groupNames = new HashMap<Integer, String>();
        }
        return this.groupNames;
    }

    List<Runnable> groupExistsChecks() {
        if (this.groupExistsChecks == null) {
            this.groupExistsChecks = new LinkedList<Runnable>();
        }
        return this.groupExistsChecks;
    }

    List<Runnable> lookbehindHasMaxChecks() {
        if (this.lookbehindHasMaxChecks == null) {
            this.lookbehindHasMaxChecks = new LinkedList<Runnable>();
        }
        return this.lookbehindHasMaxChecks;
    }

    List<Runnable> curlyDeterministicChecks() {
        if (this.curlyDeterministicChecks == null) {
            this.curlyDeterministicChecks = new LinkedList<Runnable>();
        }
        return this.curlyDeterministicChecks;
    }

    List<Runnable> groupCalledRecursivelyChecks() {
        if (this.groupCalledRecursivelyChecks == null) {
            this.groupCalledRecursivelyChecks = new LinkedList<Runnable>();
        }
        return this.groupCalledRecursivelyChecks;
    }

    Set<Object> recursivelyCalledGroups() {
        if (this.recursivelyCalledGroups == null) {
            this.recursivelyCalledGroups = new HashSet<Object>();
        }
        return this.recursivelyCalledGroups;
    }

    private boolean has(int f) {
        return (this.flags & f) != 0;
    }

    private void accept(int ch, String s) {
        int testChar = this.temp[this.cursor++];
        if (this.has(4)) {
            testChar = this.parsePastWhitespace(testChar);
        }
        if (ch != testChar) {
            throw this.error(s);
        }
    }

    private void mark(int c) {
        this.temp[this.patternLength] = c;
    }

    private int peek() {
        int ch = this.temp[this.cursor];
        if (this.has(4)) {
            ch = this.peekPastWhitespace(ch);
        }
        return ch;
    }

    private int read() {
        int ch = this.temp[this.cursor++];
        if (this.has(4)) {
            ch = this.parsePastWhitespace(ch);
        }
        return ch;
    }

    private int next() {
        int ch = this.temp[++this.cursor];
        if (this.has(4)) {
            ch = this.peekPastWhitespace(ch);
        }
        return ch;
    }

    private int nextEscaped() {
        int ch = this.temp[++this.cursor];
        return ch;
    }

    private int peekPastWhitespace(int ch) {
        while (ASCII.isSpace(ch) || ch == 35) {
            while (ASCII.isSpace(ch)) {
                ch = this.temp[++this.cursor];
            }
            if (ch != 35) continue;
            ch = this.peekPastLine();
        }
        return ch;
    }

    private int parsePastWhitespace(int ch) {
        while (ASCII.isSpace(ch) || ch == 35) {
            while (ASCII.isSpace(ch)) {
                ch = this.temp[this.cursor++];
            }
            if (ch != 35) continue;
            ch = this.parsePastLine();
        }
        return ch;
    }

    private int parsePastLine() {
        int ch = this.temp[this.cursor++];
        while (ch != 0 && !this.isLineSeparator(ch)) {
            ch = this.temp[this.cursor++];
        }
        return ch;
    }

    private int peekPastLine() {
        int ch = this.temp[++this.cursor];
        while (ch != 0 && !this.isLineSeparator(ch)) {
            ch = this.temp[++this.cursor];
        }
        return ch;
    }

    private boolean isLineSeparator(int ch) {
        if (this.has(1)) {
            return ch == 10;
        }
        return ch == 10 || ch == 13 || (ch | 1) == 8233 || ch == 133;
    }

    private int skip() {
        int i = this.cursor;
        int ch = this.temp[i + 1];
        this.cursor = i + 2;
        return ch;
    }

    private void unread() {
        --this.cursor;
    }

    private PatternSyntaxException error(String s) {
        return this.error(s, this.cursor - 1);
    }

    private PatternSyntaxException error(String s, int index) {
        return new PatternSyntaxException(s, this.normalizedPattern, index);
    }

    private boolean findSupplementary(int start, int end) {
        for (int i = start; i < end; ++i) {
            if (!Pattern.isSupplementary(this.temp[i])) continue;
            return true;
        }
        return false;
    }

    private static final boolean isSupplementary(int ch) {
        return ch >= 65536 || Character.isSurrogate((char)ch);
    }

    private Node expr(Node end) {
        Node prev = null;
        Node firstTail = null;
        Branch branch = null;
        BranchConn branchConn = null;
        while (true) {
            Node node = this.sequence(end);
            Node nodeTail = this.root;
            if (prev == null) {
                prev = node;
                firstTail = nodeTail;
            } else {
                if (branchConn == null) {
                    branchConn = new BranchConn();
                    branchConn.setNext(end);
                }
                if (node == end) {
                    node = null;
                } else {
                    nodeTail.setNext(branchConn);
                }
                if (prev == branch) {
                    branch.add(node);
                } else {
                    if (prev == end) {
                        prev = null;
                    } else {
                        firstTail.setNext(branchConn);
                    }
                    branch = new Branch(prev, node, branchConn);
                    prev = branch;
                }
            }
            if (this.peek() != 124) {
                return prev;
            }
            this.next();
        }
    }

    private Node expr2(Node end) {
        Node node = this.sequence(end);
        if (this.peek() != 124) {
            this.root = null;
            return node;
        }
        this.next();
        this.root = this.sequence(end);
        return node;
    }

    private Node sequence(Node end) {
        Node head = null;
        Node tail = null;
        Node node = null;
        block12: while (true) {
            int ch = this.peek();
            switch (ch) {
                case 40: {
                    node = this.group0();
                    if (node == null) continue block12;
                    if (head == null) {
                        head = node;
                    } else {
                        tail.setNext(node);
                    }
                    tail = this.root;
                    continue block12;
                }
                case 91: {
                    node = this.clazz(true);
                    break;
                }
                case 92: {
                    ch = this.nextEscaped();
                    if (ch == 112 || ch == 80) {
                        boolean oneLetter = true;
                        boolean comp = ch == 80;
                        ch = this.next();
                        if (ch != 123) {
                            this.unread();
                        } else {
                            oneLetter = false;
                        }
                        node = this.family(oneLetter, comp);
                        break;
                    }
                    if (ch == 99 || ch == 67) {
                        this.next();
                        this.accept(123, "Exptected {pluginName}");
                        node = this.custom();
                        break;
                    }
                    this.unread();
                    node = this.atom();
                    break;
                }
                case 94: {
                    this.next();
                    if (this.has(8)) {
                        if (this.has(1)) {
                            node = new UnixCaret();
                            break;
                        }
                        node = new Caret();
                        break;
                    }
                    node = new Begin();
                    break;
                }
                case 36: {
                    this.next();
                    if (this.has(1)) {
                        node = new UnixDollar(this.has(8));
                        break;
                    }
                    node = new Dollar(this.has(8));
                    break;
                }
                case 46: {
                    this.next();
                    if (this.has(32)) {
                        node = new All();
                        break;
                    }
                    if (this.has(1)) {
                        node = new UnixDot();
                        break;
                    }
                    node = new Dot();
                    break;
                }
                case 41: 
                case 124: {
                    break block12;
                }
                case 93: 
                case 125: {
                    node = this.atom();
                    break;
                }
                case 42: 
                case 43: 
                case 63: {
                    this.next();
                    throw this.error("Dangling meta character '" + (char)ch + "'");
                }
                case 0: {
                    if (this.cursor >= this.patternLength) break block12;
                }
                default: {
                    node = this.atom();
                }
            }
            node = this.closure(node, node);
            if (head == null) {
                head = tail = node;
                continue;
            }
            tail.setNext(node);
            tail = node;
        }
        if (head == null) {
            return end;
        }
        tail.setNext(end);
        this.root = tail;
        return head;
    }

    private Node atom() {
        int first = 0;
        int prev = -1;
        boolean hasSupplementary = false;
        int ch = this.peek();
        block6: while (true) {
            switch (ch) {
                case 42: 
                case 43: 
                case 63: 
                case 123: {
                    if (first <= true) break block6;
                    this.cursor = prev;
                    --first;
                    break block6;
                }
                case 36: 
                case 40: 
                case 41: 
                case 46: 
                case 91: 
                case 94: 
                case 124: {
                    break block6;
                }
                case 92: {
                    ch = this.nextEscaped();
                    if (ch == 112 || ch == 80) {
                        if (first > 0) {
                            this.unread();
                            break block6;
                        }
                        boolean comp = ch == 80;
                        boolean oneLetter = true;
                        ch = this.next();
                        if (ch != 123) {
                            this.unread();
                        } else {
                            oneLetter = false;
                        }
                        return this.family(oneLetter, comp);
                    }
                    this.unread();
                    prev = this.cursor;
                    ch = this.escape(false, first == 0, false);
                    if (ch >= 0) {
                        this.append(ch, first);
                        ++first;
                        if (Pattern.isSupplementary(ch)) {
                            hasSupplementary = true;
                        }
                        ch = this.peek();
                        continue block6;
                    }
                    if (first == 0) {
                        return this.root;
                    }
                    this.cursor = prev;
                    break block6;
                }
                case 0: {
                    if (this.cursor >= this.patternLength) break block6;
                }
                default: {
                    prev = this.cursor;
                    this.append(ch, first);
                    ++first;
                    if (Pattern.isSupplementary(ch)) {
                        hasSupplementary = true;
                    }
                    ch = this.next();
                    continue block6;
                }
            }
            break;
        }
        if (first == 1) {
            return this.newSingle(this.buffer[0]);
        }
        return this.newSlice(this.buffer, first, hasSupplementary);
    }

    private void append(int ch, int len) {
        if (len >= this.buffer.length) {
            int[] tmp = new int[len + len];
            System.arraycopy(this.buffer, 0, tmp, 0, len);
            this.buffer = tmp;
        }
        this.buffer[len] = ch;
    }

    private Node ref(int refNum) {
        boolean done = false;
        block3: while (!done) {
            int ch = this.peek();
            switch (ch) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    int newRefNum = refNum * 10 + (ch - 48);
                    if (this.capturingGroupCount - 1 < newRefNum) {
                        done = true;
                        continue block3;
                    }
                    refNum = newRefNum;
                    this.read();
                    continue block3;
                }
            }
            done = true;
        }
        if (!this.isGroupDefined(refNum)) {
            int index = this.cursor - 1;
            int groupNumber = refNum;
            this.groupExistsChecks().add(() -> {
                if (!this.isGroupDefined(groupNumber)) {
                    throw this.error("Backreference to non-existent capturing group " + groupNumber, index);
                }
            });
        }
        if (this.has(2)) {
            return new CIBackRef(refNum, this.has(64));
        }
        return new BackRef(refNum);
    }

    private int escape(boolean inclass, boolean create, boolean isrange) {
        int ch = this.skip();
        switch (ch) {
            case 48: {
                return this.o();
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                if (inclass) break;
                if (create) {
                    this.root = this.ref(ch - 48);
                }
                return -1;
            }
            case 65: {
                if (inclass) break;
                if (create) {
                    this.root = new Begin();
                }
                return -1;
            }
            case 66: {
                if (inclass) break;
                if (create) {
                    this.root = new Bound(Bound.NONE, this.has(256));
                }
                return -1;
            }
            case 67: {
                break;
            }
            case 68: {
                if (create) {
                    this.root = this.has(256) ? new Utype(UnicodeProp.DIGIT).complement() : new Ctype(1024).complement();
                }
                return -1;
            }
            case 69: 
            case 70: {
                break;
            }
            case 71: {
                if (inclass) break;
                if (create) {
                    this.root = new LastMatch();
                }
                return -1;
            }
            case 72: {
                if (create) {
                    this.root = new HorizWS().complement();
                }
                return -1;
            }
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                break;
            }
            case 82: {
                if (inclass) break;
                if (create) {
                    this.root = new LineEnding();
                }
                return -1;
            }
            case 83: {
                if (create) {
                    this.root = this.has(256) ? new Utype(UnicodeProp.WHITE_SPACE).complement() : new Ctype(2048).complement();
                }
                return -1;
            }
            case 84: 
            case 85: {
                break;
            }
            case 86: {
                if (create) {
                    this.root = new VertWS().complement();
                }
                return -1;
            }
            case 87: {
                if (create) {
                    this.root = this.has(256) ? new Utype(UnicodeProp.WORD).complement() : new Ctype(67328).complement();
                }
                return -1;
            }
            case 88: 
            case 89: {
                break;
            }
            case 90: {
                if (inclass) break;
                if (create) {
                    this.root = this.has(1) ? new UnixDollar(false) : new Dollar(false);
                }
                return -1;
            }
            case 97: {
                return 7;
            }
            case 98: {
                if (inclass) break;
                if (create) {
                    this.root = new Bound(Bound.BOTH, this.has(256));
                }
                return -1;
            }
            case 99: {
                return this.c();
            }
            case 100: {
                if (create) {
                    this.root = this.has(256) ? new Utype(UnicodeProp.DIGIT) : new Ctype(1024);
                }
                return -1;
            }
            case 101: {
                return 27;
            }
            case 102: {
                return 12;
            }
            case 103: {
                break;
            }
            case 104: {
                if (create) {
                    this.root = new HorizWS();
                }
                return -1;
            }
            case 105: 
            case 106: {
                break;
            }
            case 107: {
                if (inclass) break;
                if (this.read() != 60) {
                    throw this.error("\\k is not followed by '<' for named capturing group");
                }
                String name = this.groupname(this.read());
                if (create) {
                    if (this.isGroupDefined(name)) {
                        this.root = this.has(2) ? new CIBackRef(this.groupIndices().get(name), this.has(64)) : new BackRef(this.groupIndices().get(name));
                    } else {
                        BackRefBase brb;
                        if (this.has(2)) {
                            brb = new CIBackRef(this.has(64));
                            this.root = brb;
                        } else {
                            brb = new BackRef();
                            this.root = brb;
                        }
                        int index = this.cursor - 1;
                        this.groupExistsChecks().add(() -> {
                            if (!this.isGroupDefined(name)) {
                                throw this.error("Backreference to non-existent named capturing group '" + name + "'", index);
                            }
                            brb.groupIndex = this.groupIndices().get(name);
                        });
                    }
                }
                return -1;
            }
            case 108: 
            case 109: {
                break;
            }
            case 110: {
                return 10;
            }
            case 111: 
            case 112: 
            case 113: {
                break;
            }
            case 114: {
                return 13;
            }
            case 115: {
                if (create) {
                    this.root = this.has(256) ? new Utype(UnicodeProp.WHITE_SPACE) : new Ctype(2048);
                }
                return -1;
            }
            case 116: {
                return 9;
            }
            case 117: {
                return this.u();
            }
            case 118: {
                if (isrange) {
                    return 11;
                }
                if (create) {
                    this.root = new VertWS();
                }
                return -1;
            }
            case 119: {
                if (create) {
                    this.root = this.has(256) ? new Utype(UnicodeProp.WORD) : new Ctype(67328);
                }
                return -1;
            }
            case 120: {
                return this.x();
            }
            case 121: {
                break;
            }
            case 122: {
                if (inclass) break;
                if (create) {
                    this.root = new End();
                }
                return -1;
            }
            default: {
                return ch;
            }
        }
        throw this.error("Illegal/unsupported escape sequence");
    }

    private CharProperty clazz(boolean consume) {
        CharProperty prev = null;
        CharProperty node = null;
        BitClass bits = new BitClass();
        boolean include = true;
        boolean firstInClass = true;
        int ch = this.next();
        block7: while (true) {
            switch (ch) {
                case 94: {
                    if (!firstInClass || this.temp[this.cursor - 1] != 91) break;
                    ch = this.next();
                    include = !include;
                    continue block7;
                }
                case 91: {
                    firstInClass = false;
                    node = this.clazz(true);
                    prev = prev == null ? node : Pattern.union(prev, node);
                    ch = this.peek();
                    continue block7;
                }
                case 38: {
                    firstInClass = false;
                    ch = this.next();
                    if (ch == 38) {
                        ch = this.next();
                        CharProperty rightNode = null;
                        while (ch != 93 && ch != 38) {
                            if (ch == 91) {
                                rightNode = rightNode == null ? this.clazz(true) : Pattern.union(rightNode, this.clazz(true));
                            } else {
                                this.unread();
                                rightNode = this.clazz(false);
                            }
                            ch = this.peek();
                        }
                        if (rightNode != null) {
                            node = rightNode;
                        }
                        if (prev == null) {
                            if (rightNode == null) {
                                throw this.error("Bad class syntax");
                            }
                            prev = rightNode;
                            continue block7;
                        }
                        prev = Pattern.intersection(prev, node);
                        continue block7;
                    }
                    this.unread();
                    break;
                }
                case 0: {
                    firstInClass = false;
                    if (this.cursor < this.patternLength) break;
                    throw this.error("Unclosed character class");
                }
                case 93: {
                    firstInClass = false;
                    if (prev == null) break;
                    if (consume) {
                        this.next();
                    }
                    return prev;
                }
                default: {
                    firstInClass = false;
                }
            }
            node = this.range(bits);
            if (include) {
                if (prev == null) {
                    prev = node;
                } else if (prev != node) {
                    prev = Pattern.union(prev, node);
                }
            } else if (prev == null) {
                prev = node.complement();
            } else if (prev != node) {
                prev = Pattern.setDifference(prev, node);
            }
            ch = this.peek();
        }
    }

    private CharProperty bitsOrSingle(BitClass bits, int ch) {
        if (ch < 256 && (!this.has(2) || !this.has(64) || ch != 255 && ch != 181 && ch != 73 && ch != 105 && ch != 83 && ch != 115 && ch != 75 && ch != 107 && ch != 197 && ch != 229)) {
            return bits.add(ch, this.flags());
        }
        return this.newSingle(ch);
    }

    private CharProperty range(BitClass bits) {
        int ch = this.peek();
        if (ch == 92) {
            ch = this.nextEscaped();
            if (ch == 112 || ch == 80) {
                boolean comp = ch == 80;
                boolean oneLetter = true;
                ch = this.next();
                if (ch != 123) {
                    this.unread();
                } else {
                    oneLetter = false;
                }
                return this.family(oneLetter, comp);
            }
            boolean isrange = this.temp[this.cursor + 1] == 45;
            this.unread();
            ch = this.escape(true, true, isrange);
            if (ch == -1) {
                return (CharProperty)this.root;
            }
        } else {
            this.next();
        }
        if (ch >= 0) {
            if (this.peek() == 45) {
                int endRange = this.temp[this.cursor + 1];
                if (endRange == 91) {
                    return this.bitsOrSingle(bits, ch);
                }
                if (endRange != 93) {
                    this.next();
                    int m = this.peek();
                    if (m == 92) {
                        m = this.escape(true, false, true);
                    } else {
                        this.next();
                    }
                    if (m < ch) {
                        throw this.error("Illegal character range");
                    }
                    if (this.has(2)) {
                        return this.caseInsensitiveRangeFor(ch, m);
                    }
                    return Pattern.rangeFor(ch, m);
                }
            }
            return this.bitsOrSingle(bits, ch);
        }
        throw this.error("Unexpected character '" + (char)ch + "'");
    }

    private CustomNode custom() {
        int i = this.cursor;
        this.mark(125);
        while (this.read() != 125) {
        }
        this.mark(0);
        int j = this.cursor;
        if (j > this.patternLength) {
            throw this.error("Unclosed custom plugin");
        }
        if (i + 1 >= j) {
            throw this.error("Empty character family");
        }
        String[] name = new String(this.temp, i, j - i - 1).split(",");
        Class<? extends CustomNode> clazz = plugins.get(name[0]);
        if (clazz == null) {
            throw this.error("Plugin " + name[0] + " hasn't been installed!");
        }
        try {
            Class[] parameterTypes = new Class[name.length - 1];
            Object[] parameters = new String[name.length - 1];
            for (int k = 0; k < parameterTypes.length; ++k) {
                parameterTypes[k] = String.class;
                parameters[k] = name[k + 1];
            }
            Constructor<? extends CustomNode> constructor = clazz.getConstructor(parameterTypes);
            return constructor.newInstance(parameters);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw this.error("Plugin " + name + " can't be used!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CharProperty family(boolean singleLetter, boolean maybeComplement) {
        int i;
        String name;
        this.next();
        CharProperty node = null;
        if (singleLetter) {
            int c = this.temp[this.cursor];
            name = !Character.isSupplementaryCodePoint(c) ? String.valueOf((char)c) : new String(this.temp, this.cursor, 1);
            this.read();
        } else {
            i = this.cursor;
            this.mark(125);
            while (this.read() != 125) {
            }
            this.mark(0);
            int j = this.cursor;
            if (j > this.patternLength) {
                throw this.error("Unclosed character family");
            }
            if (i + 1 >= j) {
                throw this.error("Empty character family");
            }
            name = new String(this.temp, i, j - i - 1);
        }
        i = name.indexOf(61);
        if (i != -1) {
            String value = name.substring(i + 1);
            if ("sc".equals(name = name.substring(0, i).toLowerCase(Locale.ENGLISH)) || "script".equals(name)) {
                node = this.unicodeScriptPropertyFor(value);
            } else if ("blk".equals(name) || "block".equals(name)) {
                node = this.unicodeBlockPropertyFor(value);
            } else {
                if (!"gc".equals(name)) {
                    if (!"general_category".equals(name)) throw this.error("Unknown Unicode property {name=<" + name + ">, value=<" + value + ">}");
                }
                node = this.charPropertyNodeFor(value);
            }
        } else if (name.startsWith("In")) {
            node = this.unicodeBlockPropertyFor(name.substring(2));
        } else if (name.startsWith("Is")) {
            UnicodeProp uprop = UnicodeProp.forName(name = name.substring(2));
            if (uprop != null) {
                node = new Utype(uprop);
            }
            if (node == null) {
                node = CharPropertyNames.charPropertyFor(name);
            }
            if (node == null) {
                node = this.unicodeScriptPropertyFor(name);
            }
        } else {
            UnicodeProp uprop;
            if (this.has(256) && (uprop = UnicodeProp.forPOSIXName(name)) != null) {
                node = new Utype(uprop);
            }
            if (node == null) {
                node = this.charPropertyNodeFor(name);
            }
        }
        if (!maybeComplement) return node;
        if (!(node instanceof Category)) {
            if (!(node instanceof Block)) return node.complement();
        }
        this.hasSupplementary = true;
        return node.complement();
    }

    private CharProperty unicodeScriptPropertyFor(String name) {
        Character.UnicodeScript script;
        try {
            script = Character.UnicodeScript.forName(name);
        }
        catch (IllegalArgumentException iae) {
            throw this.error("Unknown character script name {" + name + "}");
        }
        return new Script(script);
    }

    private CharProperty unicodeBlockPropertyFor(String name) {
        Character.UnicodeBlock block;
        try {
            block = Character.UnicodeBlock.forName(name);
        }
        catch (IllegalArgumentException iae) {
            throw this.error("Unknown character block name {" + name + "}");
        }
        return new Block(block);
    }

    private CharProperty charPropertyNodeFor(String name) {
        CharProperty p = CharPropertyNames.charPropertyFor(name);
        if (p == null) {
            throw this.error("Unknown character property name {" + name + "}");
        }
        return p;
    }

    static boolean isCharOfGroupname(int ch) {
        return ASCII.isLower(ch) || ASCII.isUpper(ch) || ASCII.isDigit(ch) || ASCII.isUnderscore(ch);
    }

    private String groupname(int ch) {
        StringBuilder sb = new StringBuilder();
        sb.append(Character.toChars(ch));
        while (Pattern.isCharOfGroupname(ch = this.read())) {
            sb.append(Character.toChars(ch));
        }
        if (sb.length() == 0) {
            throw this.error("Named capturing group has zero-length name");
        }
        if (ch != 62) {
            throw this.error("Named capturing group is missing trailing '>'");
        }
        return sb.toString();
    }

    static boolean isFirstCharOfGroupname(int ch) {
        return ASCII.isLower(ch) || ASCII.isUpper(ch);
    }

    private Node group0() {
        Node head = null;
        Node tail = null;
        int save = this.flags;
        boolean ila = this.inLookaround;
        this.root = null;
        int ch = this.next();
        if (ch == 63) {
            ch = this.next();
            this.read();
            switch (ch) {
                case 58: {
                    head = this.createGroup(true);
                    tail = this.root;
                    head.setNext(this.expr(tail));
                    break;
                }
                case 33: 
                case 61: {
                    head = this.createGroup(true);
                    tail = this.root;
                    this.inLookaround = true;
                    head.setNext(this.expr(tail));
                    this.inLookaround = ila;
                    if (ch == 61) {
                        head = tail = new Pos(head);
                        break;
                    }
                    head = tail = new Neg(head);
                    break;
                }
                case 62: {
                    head = tail = new AtomicGroup(this.expr(accept));
                    break;
                }
                case 60: {
                    BehindBase bb;
                    ch = this.read();
                    if (Pattern.isFirstCharOfGroupname(ch)) {
                        String name = this.groupname(ch);
                        if (this.groupIndices().containsKey(name)) {
                            throw this.error("Named capturing group <" + name + "> is already defined");
                        }
                        head = this.createGroup(false);
                        tail = this.root;
                        int group = this.capturingGroupCount - 1;
                        this.groupIndices().put(name, group);
                        this.groupNames().put(group, name);
                        head.setNext(this.expr(tail));
                        RecursiveGroupCall rgc = new RecursiveGroupCall(group, false, this.inLookaround);
                        this.groupCalledRecursivelyChecks().add(() -> {
                            if (this.recursivelyCalledGroups().contains(group) || this.recursivelyCalledGroups().contains(name) || rgc.getPrevious() == null) {
                                return;
                            }
                            GroupHeadAndTail ghat = this.groupHeadAndTailNodes().get(group);
                            ghat.groupTail.setNext(rgc.getNext());
                            rgc.getPrevious().setNext(ghat.groupHead);
                        });
                        head = tail = rgc;
                        break;
                    }
                    int start = this.cursor;
                    head = this.createGroup(true);
                    tail = this.root;
                    this.inLookaround = true;
                    head.setNext(this.expr(tail));
                    this.inLookaround = ila;
                    tail.setNext(lookbehindEnd);
                    boolean hasSupplementary = this.findSupplementary(start, this.patternLength);
                    Node cond = head;
                    if (ch == 61) {
                        bb = hasSupplementary ? new BehindS(cond) : new Behind(cond);
                    } else if (ch == 33) {
                        bb = hasSupplementary ? new NotBehindS(cond) : new NotBehind(cond);
                    } else {
                        throw this.error("Unknown look-behind group", this.cursor - 2);
                    }
                    this.lookbehindHasMaxChecks().add(() -> {
                        TreeInfo info = new TreeInfo();
                        cond.study(info);
                        if (!info.maxValid) {
                            throw this.error("Look-behind group does not have an obvious maximum length");
                        }
                        bb.setMinMaxLength(info.maxLength, info.minLength);
                    });
                    head = tail = bb;
                    break;
                }
                case 40: {
                    Conditional conditional;
                    if (this.doesDEFINEFollow()) {
                        this.expr(accept);
                        this.accept(41, "Unclosed DEFINE construct");
                        return null;
                    }
                    String groupName = null;
                    int groupNumber = this.doesGroupNumberFollowBefore(41);
                    if (groupNumber != -1) {
                        conditional = new ConditionalGP(groupNumber);
                        if (!this.isGroupDefined(groupNumber)) {
                            int index = this.cursor - 1;
                            this.groupExistsChecks().add(() -> {
                                if (!this.isGroupDefined(groupNumber)) {
                                    throw this.error("capturing group < " + groupNumber + " > does not exist", index);
                                }
                            });
                        }
                    } else {
                        groupName = this.doesGroupNameFollowBefore(41);
                        if (groupName != null) {
                            if (this.isGroupDefined(groupName)) {
                                conditional = new ConditionalGP(this.groupIndices.get(groupName));
                            } else {
                                ConditionalGP cgp = new ConditionalGP();
                                int index = this.cursor - 1;
                                String gn = groupName;
                                this.groupExistsChecks().add(() -> {
                                    if (!this.isGroupDefined(gn)) {
                                        throw this.error("named capturing group < " + gn + " > does not exist", index);
                                    }
                                    cgp.groupNumber = this.groupIndices.get(gn);
                                });
                                conditional = cgp;
                            }
                        } else {
                            this.accept(63, "Unkown condition");
                            this.accept(61, "Unkown condition");
                            Pos pos = new Pos(this.expr(accept));
                            this.accept(41, "Unclosed condition");
                            conditional = new ConditionalLookahead(pos);
                        }
                    }
                    head = this.createGroup(true);
                    tail = this.root;
                    conditional.setYes(this.expr2(tail));
                    conditional.setNot(this.root);
                    head.setNext(conditional);
                    head.getNext().setNext(tail);
                    break;
                }
                case 36: 
                case 64: {
                    throw this.error("Unknown group type");
                }
                default: {
                    this.unread();
                    if (this.peek() == 39) {
                        this.read();
                        String groupName = this.doesGroupNameFollowBefore(39);
                        if (groupName == null || this.peek() != 41) {
                            throw this.error("Unknown recursion syntax");
                        }
                        this.recursivelyCalledGroups().add(groupName);
                        if (this.isGroupDefined(groupName)) {
                            head = tail = new RecursiveGroupCall(this.groupIndices.get(groupName), true, this.inLookaround);
                            break;
                        }
                        RecursiveGroupCall rcg = new RecursiveGroupCall(true, this.inLookaround);
                        int index = this.cursor - 1;
                        this.groupExistsChecks().add(0, () -> {
                            if (!this.isGroupDefined(groupName)) {
                                throw this.error("Recursion to non-existent named capturing group '" + groupName + "'", index);
                            }
                            rcg.setGroupNumber(this.groupIndices.get(groupName));
                        });
                        head = tail = rcg;
                        break;
                    }
                    int groupNumber = this.doesGroupNumberFollowBefore(41);
                    if (groupNumber != -1) {
                        this.unread();
                        this.recursivelyCalledGroups().add(groupNumber);
                        if (this.isGroupDefined(groupNumber)) {
                            head = tail = new RecursiveGroupCall(groupNumber, true, this.inLookaround);
                            break;
                        }
                        RecursiveGroupCall rgc = new RecursiveGroupCall(true, this.inLookaround);
                        head = tail = rgc;
                        int index = this.cursor - 1;
                        this.groupExistsChecks().add(0, () -> {
                            if (!this.isGroupDefined(groupNumber)) {
                                throw this.error("Recursion to non-existent capturing group " + groupNumber, index);
                            }
                            rgc.setGroupNumber(groupNumber);
                        });
                        break;
                    }
                    this.addFlag();
                    ch = this.read();
                    if (ch == 41) {
                        return null;
                    }
                    if (ch != 58) {
                        throw this.error("Unknown inline modifier");
                    }
                    head = this.createGroup(true);
                    tail = this.root;
                    head.setNext(this.expr(tail));
                    break;
                }
            }
        } else {
            head = this.createGroup(false);
            tail = this.root;
            int groupNumber = this.capturingGroupCount - 1;
            head.setNext(this.expr(tail));
            RecursiveGroupCall rgc = new RecursiveGroupCall(groupNumber, false, this.inLookaround);
            this.groupCalledRecursivelyChecks().add(() -> {
                if (this.recursivelyCalledGroups().contains(groupNumber)) {
                    return;
                }
                GroupHeadAndTail ghat = this.groupHeadAndTailNodes().get(groupNumber);
                ghat.groupTail.setNext(rgc.getNext());
                rgc.getPrevious().setNext(ghat.groupHead);
            });
            head = tail = rgc;
        }
        this.accept(41, "Unclosed group");
        this.flags = save;
        Node node = this.closure(head, tail);
        if (node == head) {
            this.root = tail;
            return node;
        }
        if (head == tail) {
            this.root = node;
            return node;
        }
        this.root = node;
        return node;
    }

    private String doesGroupNameFollowBefore(int closing) {
        int ch = this.peek();
        int save = this.cursor;
        if (Pattern.isFirstCharOfGroupname(ch)) {
            StringBuilder sb = new StringBuilder();
            while (Pattern.isCharOfGroupname(ch = this.read())) {
                sb.append(Character.toChars(ch));
            }
            if (ch != closing) {
                this.cursor = save;
                return null;
            }
            return sb.toString();
        }
        return null;
    }

    private boolean isGroupDefined(String groupName) {
        return this.groupIndices().containsKey(groupName);
    }

    private boolean doesDEFINEFollow() {
        int save = this.cursor;
        this.peek();
        int[] define = new int[]{68, 69, 70, 73, 78, 69};
        for (int i = 0; i < define.length; ++i) {
            if (this.cursor < this.temp.length && this.temp[this.cursor++] == define[i]) continue;
            this.cursor = save;
            return false;
        }
        this.accept(41, "Expected ) after DEFINE!");
        return true;
    }

    private int doesGroupNumberFollowBefore(int closing) {
        int ch;
        int number = 0;
        int save = this.cursor;
        while (ASCII.isDigit(ch = this.read())) {
            number = number * 10 + ch - 48;
        }
        if (number <= 0 || ch != closing) {
            this.cursor = save;
            return -1;
        }
        return number;
    }

    private boolean isGroupDefined(int groupNumber) {
        return groupNumber < this.capturingGroupCount;
    }

    private Node createGroup(boolean anonymous) {
        int localIndex = this.localCount++;
        int groupIndex = 0;
        if (!anonymous) {
            groupIndex = this.capturingGroupCount++;
        }
        GroupHead head = new GroupHead(localIndex, groupIndex, this.inLookaround);
        GroupTail tail = new GroupTail(localIndex, groupIndex);
        this.root = tail;
        if (!anonymous) {
            this.groupHeadAndTailNodes().add(new GroupHeadAndTail(head, tail));
        }
        return head;
    }

    private ArrayList<GroupHeadAndTail> groupHeadAndTailNodes() {
        if (this.groupHeadAndTailNodes == null) {
            this.groupHeadAndTailNodes = new ArrayList(10);
            this.groupHeadAndTailNodes.add(null);
        }
        return this.groupHeadAndTailNodes;
    }

    private void addFlag() {
        int ch = this.peek();
        while (true) {
            switch (ch) {
                case 105: {
                    this.flags |= 2;
                    break;
                }
                case 109: {
                    this.flags |= 8;
                    break;
                }
                case 115: {
                    this.flags |= 0x20;
                    break;
                }
                case 100: {
                    this.flags |= 1;
                    break;
                }
                case 117: {
                    this.flags |= 0x40;
                    break;
                }
                case 120: {
                    this.flags |= 4;
                    break;
                }
                case 85: {
                    this.flags |= 0x140;
                    break;
                }
                case 45: {
                    ch = this.next();
                    this.subFlag();
                }
                default: {
                    return;
                }
            }
            ch = this.next();
        }
    }

    private void subFlag() {
        int ch = this.peek();
        while (true) {
            switch (ch) {
                case 105: {
                    this.flags &= 0xFFFFFFFD;
                    break;
                }
                case 109: {
                    this.flags &= 0xFFFFFFF7;
                    break;
                }
                case 115: {
                    this.flags &= 0xFFFFFFDF;
                    break;
                }
                case 100: {
                    this.flags &= 0xFFFFFFFE;
                    break;
                }
                case 117: {
                    this.flags &= 0xFFFFFFBF;
                    break;
                }
                case 120: {
                    this.flags &= 0xFFFFFFFB;
                    break;
                }
                case 85: {
                    this.flags &= 0xFFFFFEBF;
                }
                default: {
                    return;
                }
            }
            ch = this.next();
        }
    }

    Navigator createNavigator(Node endNode) {
        if (endNode instanceof Navigator) {
            return (Navigator)endNode;
        }
        Navigator nav = new Navigator(this.localCount++);
        nav.setNext(endNode.getNext());
        endNode.setNext(nav);
        return nav;
    }

    private boolean isDeterministic(Node node) {
        TreeInfo info = new TreeInfo();
        node.study(info);
        return info.deterministic;
    }

    private int getType(int modifier) {
        if (modifier == 63) {
            this.next();
            return 1;
        }
        if (modifier == 43) {
            this.next();
            return 2;
        }
        return 0;
    }

    private Node closure(Node beginNode, Node endNode) {
        int type;
        int cmax;
        int cmin;
        int ch = this.peek();
        switch (ch) {
            case 63: {
                cmin = 0;
                cmax = 1;
                ch = this.next();
                type = this.getType(ch);
                break;
            }
            case 42: {
                cmin = 0;
                cmax = Integer.MAX_VALUE;
                ch = this.next();
                type = this.getType(ch);
                break;
            }
            case 43: {
                ch = this.next();
                cmin = 1;
                cmax = Integer.MAX_VALUE;
                type = this.getType(ch);
                break;
            }
            case 123: {
                ch = this.temp[this.cursor + 1];
                if (ASCII.isDigit(ch)) {
                    this.skip();
                    cmin = 0;
                    do {
                        cmin = cmin * 10 + (ch - 48);
                    } while (ASCII.isDigit(ch = this.read()));
                    cmax = cmin;
                    if (ch == 44) {
                        ch = this.read();
                        cmax = Integer.MAX_VALUE;
                        if (ch != 125) {
                            cmax = 0;
                            while (ASCII.isDigit(ch)) {
                                cmax = cmax * 10 + (ch - 48);
                                ch = this.read();
                            }
                        }
                    }
                    if (ch != 125) {
                        throw this.error("Unclosed counted closure");
                    }
                    if ((cmin | cmax | cmax - cmin) < 0) {
                        throw this.error("Illegal repetition range");
                    }
                    ch = this.peek();
                    type = this.getType(ch);
                    break;
                }
                throw this.error("Illegal repetition");
            }
            default: {
                return beginNode;
            }
        }
        CurlyBase cb = new CurlyBase(beginNode, cmin, cmax, type);
        this.curlyDeterministicChecks().add(() -> {
            CurlyBase curly = null;
            curly = this.isDeterministic(cb.beginNode) ? new DeterministicCurly(cb.beginNode, cb.cmin, cb.cmax, cb.type) : new Curly(cb.beginNode, cb.cmin, cb.cmax, cb.type);
            curly.setNext(cb.getNext());
            cb.getPrevious().setNext(curly);
        });
        return cb;
    }

    private int c() {
        if (this.cursor < this.patternLength) {
            return this.read() ^ 0x40;
        }
        throw this.error("Illegal control escape sequence");
    }

    private int o() {
        int n = this.read();
        if ((n - 48 | 55 - n) >= 0) {
            int m = this.read();
            if ((m - 48 | 55 - m) >= 0) {
                int o = this.read();
                if ((o - 48 | 55 - o) >= 0 && (n - 48 | 51 - n) >= 0) {
                    return (n - 48) * 64 + (m - 48) * 8 + (o - 48);
                }
                this.unread();
                return (n - 48) * 8 + (m - 48);
            }
            this.unread();
            return n - 48;
        }
        throw this.error("Illegal octal escape sequence");
    }

    private int x() {
        int n = this.read();
        if (ASCII.isHexDigit(n)) {
            int m = this.read();
            if (ASCII.isHexDigit(m)) {
                return ASCII.toDigit(n) * 16 + ASCII.toDigit(m);
            }
        } else if (n == 123 && ASCII.isHexDigit(this.peek())) {
            int ch = 0;
            while (ASCII.isHexDigit(n = this.read())) {
                if ((ch = (ch << 4) + ASCII.toDigit(n)) <= 0x10FFFF) continue;
                throw this.error("Hexadecimal codepoint is too big");
            }
            if (n != 125) {
                throw this.error("Unclosed hexadecimal escape sequence");
            }
            return ch;
        }
        throw this.error("Illegal hexadecimal escape sequence");
    }

    private int cursor() {
        return this.cursor;
    }

    private void setcursor(int pos) {
        this.cursor = pos;
    }

    private int uxxxx() {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            int ch = this.read();
            if (!ASCII.isHexDigit(ch)) {
                throw this.error("Illegal Unicode escape sequence");
            }
            n = n * 16 + ASCII.toDigit(ch);
        }
        return n;
    }

    private int u() {
        int n = this.uxxxx();
        if (Character.isHighSurrogate((char)n)) {
            int n2;
            int cur = this.cursor();
            if (this.read() == 92 && this.read() == 117 && Character.isLowSurrogate((char)(n2 = this.uxxxx()))) {
                return Character.toCodePoint((char)n, (char)n2);
            }
            this.setcursor(cur);
        }
        return n;
    }

    private static final int countChars(CharSequence seq, int index, int lengthInCodePoints) {
        if (lengthInCodePoints == 1 && !Character.isHighSurrogate(seq.charAt(index))) {
            assert (index >= 0 && index < seq.length());
            return 1;
        }
        int length = seq.length();
        int x = index;
        if (lengthInCodePoints >= 0) {
            assert (index >= 0 && index < length);
            for (int i = 0; x < length && i < lengthInCodePoints; ++i) {
                if (!Character.isHighSurrogate(seq.charAt(x++)) || x >= length || !Character.isLowSurrogate(seq.charAt(x))) continue;
                ++x;
            }
            return x - index;
        }
        assert (index >= 0 && index <= length);
        if (index == 0) {
            return 0;
        }
        int len = -lengthInCodePoints;
        for (int i = 0; x > 0 && i < len; ++i) {
            if (!Character.isLowSurrogate(seq.charAt(--x)) || x <= 0 || !Character.isHighSurrogate(seq.charAt(x - 1))) continue;
            --x;
        }
        return index - x;
    }

    private static final int countCodePoints(CharSequence seq) {
        int length = seq.length();
        int n = 0;
        int i = 0;
        while (i < length) {
            ++n;
            if (!Character.isHighSurrogate(seq.charAt(i++)) || i >= length || !Character.isLowSurrogate(seq.charAt(i))) continue;
            ++i;
        }
        return n;
    }

    private CharProperty newSingle(int ch) {
        if (this.has(2)) {
            int upper;
            int lower;
            if (this.has(64)) {
                int lower2;
                int upper2 = Character.toUpperCase(ch);
                if (upper2 != (lower2 = Character.toLowerCase(upper2))) {
                    return new SingleU(lower2);
                }
            } else if (ASCII.isAscii(ch) && (lower = ASCII.toLower(ch)) != (upper = ASCII.toUpper(ch))) {
                return new SingleI(lower, upper);
            }
        }
        if (Pattern.isSupplementary(ch)) {
            return new SingleS(ch);
        }
        return new Single(ch);
    }

    private Node newSlice(int[] buf, int count, boolean hasSupplementary) {
        int[] tmp = new int[count];
        if (this.has(2)) {
            if (this.has(64)) {
                for (int i = 0; i < count; ++i) {
                    tmp[i] = Character.toLowerCase(Character.toUpperCase(buf[i]));
                }
                return hasSupplementary ? new SliceUS(tmp) : new SliceU(tmp);
            }
            for (int i = 0; i < count; ++i) {
                tmp[i] = ASCII.toLower(buf[i]);
            }
            return hasSupplementary ? new SliceIS(tmp) : new SliceI(tmp);
        }
        for (int i = 0; i < count; ++i) {
            tmp[i] = buf[i];
        }
        return hasSupplementary ? new SliceS(tmp) : new Slice(tmp);
    }

    private static boolean inRange(int lower, int ch, int upper) {
        return lower <= ch && ch <= upper;
    }

    private static CharProperty rangeFor(final int lower, final int upper) {
        return new CharProperty(){

            @Override
            boolean isSatisfiedBy(int ch) {
                return Pattern.inRange(lower, ch, upper);
            }
        };
    }

    private CharProperty caseInsensitiveRangeFor(final int lower, final int upper) {
        if (this.has(64)) {
            return new CharProperty(){

                @Override
                boolean isSatisfiedBy(int ch) {
                    if (Pattern.inRange(lower, ch, upper)) {
                        return true;
                    }
                    int up = Character.toUpperCase(ch);
                    return Pattern.inRange(lower, up, upper) || Pattern.inRange(lower, Character.toLowerCase(up), upper);
                }
            };
        }
        return new CharProperty(){

            @Override
            boolean isSatisfiedBy(int ch) {
                return Pattern.inRange(lower, ch, upper) || ASCII.isAscii(ch) && (Pattern.inRange(lower, ASCII.toUpper(ch), upper) || Pattern.inRange(lower, ASCII.toLower(ch), upper));
            }
        };
    }

    private static CharProperty union(final CharProperty lhs, final CharProperty rhs) {
        return new CharProperty(){

            @Override
            boolean isSatisfiedBy(int ch) {
                return lhs.isSatisfiedBy(ch) || rhs.isSatisfiedBy(ch);
            }
        };
    }

    private static CharProperty intersection(final CharProperty lhs, final CharProperty rhs) {
        return new CharProperty(){

            @Override
            boolean isSatisfiedBy(int ch) {
                return lhs.isSatisfiedBy(ch) && rhs.isSatisfiedBy(ch);
            }
        };
    }

    private static CharProperty setDifference(final CharProperty lhs, final CharProperty rhs) {
        return new CharProperty(){

            @Override
            boolean isSatisfiedBy(int ch) {
                return !rhs.isSatisfiedBy(ch) && lhs.isSatisfiedBy(ch);
            }
        };
    }

    private static boolean hasBaseCharacter(Matcher matcher, int i, CharSequence seq) {
        int start = !matcher.transparentBounds ? matcher.from : 0;
        for (int x = i; x >= start; --x) {
            int ch = Character.codePointAt(seq, x);
            if (Character.isLetterOrDigit(ch)) {
                return true;
            }
            if (Character.getType(ch) == 6) continue;
            return false;
        }
        return false;
    }

    public Predicate<String> asPredicate() {
        return s -> this.matcher((CharSequence)s).find();
    }

    public Stream<String> splitAsStream(final CharSequence input) {
        class MatcherIterator
        implements Iterator<String> {
            private final Matcher matcher;
            private int current;
            private String nextElement;
            private int emptyElementCount;

            MatcherIterator() {
                this.matcher = Pattern.this.matcher(input);
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.emptyElementCount == 0) {
                    String n = this.nextElement;
                    this.nextElement = null;
                    return n;
                }
                --this.emptyElementCount;
                return "";
            }

            @Override
            public boolean hasNext() {
                if (this.nextElement != null || this.emptyElementCount > 0) {
                    return true;
                }
                if (this.current == input.length()) {
                    return false;
                }
                while (this.matcher.find()) {
                    this.nextElement = input.subSequence(this.current, this.matcher.start()).toString();
                    this.current = this.matcher.end();
                    if (!this.nextElement.isEmpty()) {
                        return true;
                    }
                    if (this.current <= 0) continue;
                    ++this.emptyElementCount;
                }
                this.nextElement = input.subSequence(this.current, input.length()).toString();
                this.current = input.length();
                if (!this.nextElement.isEmpty()) {
                    return true;
                }
                this.emptyElementCount = 0;
                this.nextElement = null;
                return false;
            }
        }
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new MatcherIterator(), 272), false);
    }

    private static class CharPropertyNames {
        private static final HashMap<String, CharPropertyFactory> map = new HashMap();

        private CharPropertyNames() {
        }

        static CharProperty charPropertyFor(String name) {
            CharPropertyFactory m = map.get(name);
            return m == null ? null : m.make();
        }

        private static void defCategory(String name, final int typeMask) {
            map.put(name, new CharPropertyFactory(){

                @Override
                CharProperty make() {
                    return new Category(typeMask);
                }
            });
        }

        private static void defRange(String name, final int lower, final int upper) {
            map.put(name, new CharPropertyFactory(){

                @Override
                CharProperty make() {
                    return Pattern.rangeFor(lower, upper);
                }
            });
        }

        private static void defCtype(String name, final int ctype) {
            map.put(name, new CharPropertyFactory(){

                @Override
                CharProperty make() {
                    return new Ctype(ctype);
                }
            });
        }

        private static void defClone(String name, final CloneableProperty p) {
            map.put(name, new CharPropertyFactory(){

                @Override
                CharProperty make() {
                    return p.clone();
                }
            });
        }

        static {
            CharPropertyNames.defCategory("Cn", 1);
            CharPropertyNames.defCategory("Lu", 2);
            CharPropertyNames.defCategory("Ll", 4);
            CharPropertyNames.defCategory("Lt", 8);
            CharPropertyNames.defCategory("Lm", 16);
            CharPropertyNames.defCategory("Lo", 32);
            CharPropertyNames.defCategory("Mn", 64);
            CharPropertyNames.defCategory("Me", 128);
            CharPropertyNames.defCategory("Mc", 256);
            CharPropertyNames.defCategory("Nd", 512);
            CharPropertyNames.defCategory("Nl", 1024);
            CharPropertyNames.defCategory("No", 2048);
            CharPropertyNames.defCategory("Zs", 4096);
            CharPropertyNames.defCategory("Zl", 8192);
            CharPropertyNames.defCategory("Zp", 16384);
            CharPropertyNames.defCategory("Cc", 32768);
            CharPropertyNames.defCategory("Cf", 65536);
            CharPropertyNames.defCategory("Co", 262144);
            CharPropertyNames.defCategory("Cs", 524288);
            CharPropertyNames.defCategory("Pd", 0x100000);
            CharPropertyNames.defCategory("Ps", 0x200000);
            CharPropertyNames.defCategory("Pe", 0x400000);
            CharPropertyNames.defCategory("Pc", 0x800000);
            CharPropertyNames.defCategory("Po", 0x1000000);
            CharPropertyNames.defCategory("Sm", 0x2000000);
            CharPropertyNames.defCategory("Sc", 0x4000000);
            CharPropertyNames.defCategory("Sk", 0x8000000);
            CharPropertyNames.defCategory("So", 0x10000000);
            CharPropertyNames.defCategory("Pi", 0x20000000);
            CharPropertyNames.defCategory("Pf", 0x40000000);
            CharPropertyNames.defCategory("L", 62);
            CharPropertyNames.defCategory("M", 448);
            CharPropertyNames.defCategory("N", 3584);
            CharPropertyNames.defCategory("Z", 28672);
            CharPropertyNames.defCategory("C", 884736);
            CharPropertyNames.defCategory("P", 1643118592);
            CharPropertyNames.defCategory("S", 0x1E000000);
            CharPropertyNames.defCategory("LC", 14);
            CharPropertyNames.defCategory("LD", 574);
            CharPropertyNames.defRange("L1", 0, 255);
            map.put("all", new CharPropertyFactory(){

                @Override
                CharProperty make() {
                    return new All();
                }
            });
            CharPropertyNames.defRange("ASCII", 0, 127);
            CharPropertyNames.defCtype("Alnum", 1792);
            CharPropertyNames.defCtype("Alpha", 768);
            CharPropertyNames.defCtype("Blank", 16384);
            CharPropertyNames.defCtype("Cntrl", 8192);
            CharPropertyNames.defRange("Digit", 48, 57);
            CharPropertyNames.defCtype("Graph", 5888);
            CharPropertyNames.defRange("Lower", 97, 122);
            CharPropertyNames.defRange("Print", 32, 126);
            CharPropertyNames.defCtype("Punct", 4096);
            CharPropertyNames.defCtype("Space", 2048);
            CharPropertyNames.defRange("Upper", 65, 90);
            CharPropertyNames.defCtype("XDigit", 32768);
            CharPropertyNames.defClone("javaLowerCase", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int ch) {
                    return Character.isLowerCase(ch);
                }
            });
            CharPropertyNames.defClone("javaUpperCase", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int ch) {
                    return Character.isUpperCase(ch);
                }
            });
            CharPropertyNames.defClone("javaAlphabetic", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int ch) {
                    return Character.isAlphabetic(ch);
                }
            });
            CharPropertyNames.defClone("javaIdeographic", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int ch) {
                    return Character.isIdeographic(ch);
                }
            });
            CharPropertyNames.defClone("javaTitleCase", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int ch) {
                    return Character.isTitleCase(ch);
                }
            });
            CharPropertyNames.defClone("javaDigit", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int ch) {
                    return Character.isDigit(ch);
                }
            });
            CharPropertyNames.defClone("javaDefined", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int ch) {
                    return Character.isDefined(ch);
                }
            });
            CharPropertyNames.defClone("javaLetter", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int ch) {
                    return Character.isLetter(ch);
                }
            });
            CharPropertyNames.defClone("javaLetterOrDigit", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int ch) {
                    return Character.isLetterOrDigit(ch);
                }
            });
            CharPropertyNames.defClone("javaJavaIdentifierStart", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int ch) {
                    return Character.isJavaIdentifierStart(ch);
                }
            });
            CharPropertyNames.defClone("javaJavaIdentifierPart", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int ch) {
                    return Character.isJavaIdentifierPart(ch);
                }
            });
            CharPropertyNames.defClone("javaUnicodeIdentifierStart", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int ch) {
                    return Character.isUnicodeIdentifierStart(ch);
                }
            });
            CharPropertyNames.defClone("javaUnicodeIdentifierPart", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int ch) {
                    return Character.isUnicodeIdentifierPart(ch);
                }
            });
            CharPropertyNames.defClone("javaIdentifierIgnorable", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int ch) {
                    return Character.isIdentifierIgnorable(ch);
                }
            });
            CharPropertyNames.defClone("javaSpaceChar", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int ch) {
                    return Character.isSpaceChar(ch);
                }
            });
            CharPropertyNames.defClone("javaWhitespace", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int ch) {
                    return Character.isWhitespace(ch);
                }
            });
            CharPropertyNames.defClone("javaISOControl", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int ch) {
                    return Character.isISOControl(ch);
                }
            });
            CharPropertyNames.defClone("javaMirrored", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int ch) {
                    return Character.isMirrored(ch);
                }
            });
        }

        private static abstract class CloneableProperty
        extends CharProperty
        implements Cloneable {
            private CloneableProperty() {
            }

            public CloneableProperty clone() {
                try {
                    return (CloneableProperty)super.clone();
                }
                catch (CloneNotSupportedException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }

        private static abstract class CharPropertyFactory {
            private CharPropertyFactory() {
            }

            abstract CharProperty make();
        }
    }

    static final class BnMS
    extends BnM {
        int lengthInChars;

        BnMS(int[] src, int[] lastOcc, int[] optoSft, Node next) {
            super(src, lastOcc, optoSft, next);
            for (int x = 0; x < this.buffer.length; ++x) {
                this.lengthInChars += Character.charCount(this.buffer[x]);
            }
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int[] src = this.buffer;
            int patternLength = src.length;
            int last = matcher.to - this.lengthInChars;
            block0: while (i <= last) {
                int j = Pattern.countChars(seq, i, patternLength);
                int x = patternLength - 1;
                while (j > 0) {
                    int ch = Character.codePointBefore(seq, i + j);
                    if (ch != src[x]) {
                        int n = Math.max(x + 1 - this.lastOcc[ch & 0x7F], this.optoSft[x]);
                        i += Pattern.countChars(seq, i, n);
                        continue block0;
                    }
                    j -= Character.charCount(ch);
                    --x;
                }
                matcher.first = i;
                boolean ret = this.getNext().match(matcher, i + this.lengthInChars, seq);
                if (ret) {
                    matcher.first = i;
                    matcher.setGroup0(seq, matcher.first, matcher.last);
                    return true;
                }
                i += Pattern.countChars(seq, i, 1);
            }
            matcher.hitEnd = true;
            return false;
        }
    }

    static class BnM
    extends Node {
        int[] buffer;
        int[] lastOcc;
        int[] optoSft;

        static Node optimize(Node node) {
            int i;
            if (!(node instanceof Slice)) {
                return node;
            }
            int[] src = ((Slice)node).buffer;
            int patternLength = src.length;
            if (patternLength < 4) {
                return node;
            }
            int[] lastOcc = new int[128];
            int[] optoSft = new int[patternLength];
            for (i = 0; i < patternLength; ++i) {
                lastOcc[src[i] & 0x7F] = i + 1;
            }
            block1: for (i = patternLength; i > 0; --i) {
                int j;
                for (j = patternLength - 1; j >= i; --j) {
                    if (src[j] != src[j - i]) continue block1;
                    optoSft[j - 1] = i;
                }
                while (j > 0) {
                    optoSft[--j] = i;
                }
            }
            optoSft[patternLength - 1] = 1;
            if (node instanceof SliceS) {
                return new BnMS(src, lastOcc, optoSft, node.getNext());
            }
            return new BnM(src, lastOcc, optoSft, node.getNext());
        }

        BnM(int[] src, int[] lastOcc, int[] optoSft, Node next) {
            this.buffer = src;
            this.lastOcc = lastOcc;
            this.optoSft = optoSft;
            this.setNext(next);
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int[] src = this.buffer;
            int patternLength = src.length;
            int last = matcher.to - patternLength;
            block0: while (i <= last) {
                for (int j = patternLength - 1; j >= 0; --j) {
                    char ch = seq.charAt(i + j);
                    if (ch == src[j]) continue;
                    i += Math.max(j + 1 - this.lastOcc[ch & 0x7F], this.optoSft[j]);
                    continue block0;
                }
                matcher.first = i;
                boolean ret = this.getNext().match(matcher, i + patternLength, seq);
                if (ret) {
                    matcher.first = i;
                    matcher.setGroup0(seq, matcher.first, matcher.last);
                    return true;
                }
                ++i;
            }
            matcher.hitEnd = true;
            return false;
        }

        @Override
        boolean study(TreeInfo info) {
            info.minLength += this.buffer.length;
            info.maxValid = false;
            return this.getNext().study(info);
        }
    }

    static final class Bound
    extends Node {
        static int LEFT = 1;
        static int RIGHT = 2;
        static int BOTH = 3;
        static int NONE = 4;
        int type;
        boolean useUWORD;

        Bound(int n, boolean useUWORD) {
            this.type = n;
            this.useUWORD = useUWORD;
        }

        boolean isWord(int ch) {
            return this.useUWORD ? UnicodeProp.WORD.is(ch) : ch == 95 || Character.isLetterOrDigit(ch);
        }

        int check(Matcher matcher, int i, CharSequence seq) {
            int ch;
            boolean left = false;
            int startIndex = matcher.from;
            int endIndex = matcher.to;
            if (matcher.transparentBounds) {
                startIndex = 0;
                endIndex = matcher.getTextLength();
            }
            if (i > startIndex) {
                ch = Character.codePointBefore(seq, i);
                left = this.isWord(ch) || Character.getType(ch) == 6 && Pattern.hasBaseCharacter(matcher, i - 1, seq);
            }
            boolean right = false;
            if (i < endIndex) {
                ch = Character.codePointAt(seq, i);
                right = this.isWord(ch) || Character.getType(ch) == 6 && Pattern.hasBaseCharacter(matcher, i, seq);
            } else {
                matcher.hitEnd = true;
                matcher.requireEnd = true;
            }
            return left ^ right ? (right ? LEFT : RIGHT) : NONE;
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            return (this.check(matcher, i, seq) & this.type) > 0 && this.getNext().match(matcher, i, seq);
        }
    }

    static final class NotBehindS
    extends NotBehind {
        NotBehindS(Node cond) {
            super(cond);
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int rmaxChars = Pattern.countChars(seq, i, -this.rmax);
            int rminChars = Pattern.countChars(seq, i, -this.rmin);
            int savedFrom = matcher.from;
            int savedLBT = matcher.lookbehindTo;
            boolean conditionMatched = false;
            int startIndex = !matcher.transparentBounds ? matcher.from : 0;
            int from = Math.max(i - rmaxChars, startIndex);
            matcher.lookbehindTo = i;
            if (matcher.transparentBounds) {
                matcher.from = 0;
            }
            int save = matcher.captureTreeMode ? matcher.captureTreeNode.children.size() : -1;
            int[] savedGroups = Arrays.copyOf(matcher.groups, matcher.groups.length);
            for (int j = i - rminChars; !conditionMatched && j >= from; j -= j > from ? Pattern.countChars(seq, j, -1) : 1) {
                conditionMatched = this.cond.match(matcher, j, seq);
            }
            matcher.from = savedFrom;
            matcher.lookbehindTo = savedLBT;
            if (conditionMatched) {
                matcher.groups = savedGroups;
                if (matcher.captureTreeMode) {
                    matcher.captureTreeNode.shrinkChildrenTo(save);
                }
            }
            return !conditionMatched && this.getNext().match(matcher, i, seq);
        }
    }

    static class NotBehind
    extends BehindBase {
        NotBehind(Node cond) {
            super(cond);
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int savedLBT = matcher.lookbehindTo;
            int savedFrom = matcher.from;
            boolean conditionMatched = false;
            int startIndex = !matcher.transparentBounds ? matcher.from : 0;
            int from = Math.max(i - this.rmax, startIndex);
            matcher.lookbehindTo = i;
            if (matcher.transparentBounds) {
                matcher.from = 0;
            }
            int save = matcher.captureTreeMode ? matcher.captureTreeNode.children.size() : -1;
            int[] savedGroups = Arrays.copyOf(matcher.groups, matcher.groups.length);
            for (int j = i - this.rmin; !conditionMatched && j >= from; --j) {
                conditionMatched = this.cond.match(matcher, j, seq);
            }
            matcher.from = savedFrom;
            matcher.lookbehindTo = savedLBT;
            if (conditionMatched) {
                matcher.groups = savedGroups;
                if (matcher.captureTreeMode) {
                    matcher.captureTreeNode.shrinkChildrenTo(save);
                }
            }
            return !conditionMatched && this.getNext().match(matcher, i, seq);
        }
    }

    static final class BehindS
    extends Behind {
        BehindS(Node cond) {
            super(cond);
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int rmaxChars = Pattern.countChars(seq, i, -this.rmax);
            int rminChars = Pattern.countChars(seq, i, -this.rmin);
            int savedFrom = matcher.from;
            int startIndex = !matcher.transparentBounds ? matcher.from : 0;
            boolean conditionMatched = false;
            int from = Math.max(i - rmaxChars, startIndex);
            int savedLBT = matcher.lookbehindTo;
            matcher.lookbehindTo = i;
            if (matcher.transparentBounds) {
                matcher.from = 0;
            }
            int save = matcher.captureTreeMode ? matcher.captureTreeNode.children.size() : -1;
            int[] savedGroups = Arrays.copyOf(matcher.groups, matcher.groups.length);
            for (int j = i - rminChars; !conditionMatched && j >= from; j -= j > from ? Pattern.countChars(seq, j, -1) : 1) {
                conditionMatched = this.cond.match(matcher, j, seq);
            }
            matcher.from = savedFrom;
            matcher.lookbehindTo = savedLBT;
            if (conditionMatched && !(conditionMatched = this.getNext().match(matcher, i, seq))) {
                matcher.groups = savedGroups;
                if (matcher.captureTreeMode) {
                    matcher.captureTreeNode.shrinkChildrenTo(save);
                }
            }
            return conditionMatched;
        }
    }

    static class Behind
    extends BehindBase {
        Behind(Node cond) {
            super(cond);
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int savedFrom = matcher.from;
            boolean conditionMatched = false;
            int startIndex = !matcher.transparentBounds ? matcher.from : 0;
            int from = Math.max(i - this.rmax, startIndex);
            int savedLBT = matcher.lookbehindTo;
            matcher.lookbehindTo = i;
            if (matcher.transparentBounds) {
                matcher.from = 0;
            }
            int save = matcher.captureTreeMode ? matcher.captureTreeNode.children.size() : -1;
            int[] savedGroups = Arrays.copyOf(matcher.groups, matcher.groups.length);
            for (int j = i - this.rmin; !conditionMatched && j >= from; --j) {
                conditionMatched = this.cond.match(matcher, j, seq);
            }
            matcher.from = savedFrom;
            matcher.lookbehindTo = savedLBT;
            if (conditionMatched && !(conditionMatched = this.getNext().match(matcher, i, seq))) {
                matcher.groups = savedGroups;
                if (matcher.captureTreeMode) {
                    matcher.captureTreeNode.shrinkChildrenTo(save);
                }
            }
            return conditionMatched;
        }
    }

    static class BehindBase
    extends LookaroundBase {
        int rmax;
        int rmin;

        BehindBase(Node cond) {
            super(cond);
        }

        void setMinMaxLength(int rmax, int rmin) {
            this.rmax = rmax;
            this.rmin = rmin;
        }
    }

    static final class Neg
    extends LookaroundBase {
        Neg(Node cond) {
            super(cond);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int savedTo = matcher.to;
            boolean conditionMatched = false;
            int save = matcher.captureTreeMode ? matcher.captureTreeNode.children.size() : -1;
            int[] savedGroups = Arrays.copyOf(matcher.groups, matcher.groups.length);
            if (matcher.transparentBounds) {
                matcher.to = matcher.getTextLength();
            }
            try {
                if (i < matcher.to) {
                    conditionMatched = !this.cond.match(matcher, i, seq);
                } else {
                    matcher.requireEnd = true;
                    conditionMatched = !this.cond.match(matcher, i, seq);
                }
            }
            finally {
                matcher.to = savedTo;
            }
            if (!conditionMatched) {
                matcher.groups = savedGroups;
                if (matcher.captureTreeMode) {
                    matcher.captureTreeNode.shrinkChildrenTo(save);
                }
            }
            return conditionMatched && this.getNext().match(matcher, i, seq);
        }
    }

    static final class Pos
    extends LookaroundBase {
        Pos(Node cond) {
            super(cond);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int savedTo = matcher.to;
            boolean conditionMatched = false;
            int save = matcher.captureTreeMode ? matcher.captureTreeNode.children.size() : -1;
            int[] savedGroups = Arrays.copyOf(matcher.groups, matcher.groups.length);
            if (matcher.transparentBounds) {
                matcher.to = matcher.getTextLength();
            }
            try {
                conditionMatched = this.cond.match(matcher, i, seq);
            }
            finally {
                matcher.to = savedTo;
            }
            if (conditionMatched && !(conditionMatched &= this.getNext().match(matcher, i, seq))) {
                matcher.groups = savedGroups;
                if (matcher.captureTreeMode) {
                    matcher.captureTreeNode.shrinkChildrenTo(save);
                }
            }
            return conditionMatched;
        }
    }

    static class LookaroundBase
    extends Node {
        Node cond;

        LookaroundBase(Node cond) {
            new Node(){

                @Override
                void setNext(Node a) {
                    cond = a;
                    a.previous = (Node)this;
                }
            }.setNext(cond);
        }
    }

    static final class ConditionalLookahead
    extends Conditional {
        Pos cond;

        ConditionalLookahead(Pos cond) {
            this.cond = cond;
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int save = matcher.captureTreeMode ? matcher.captureTreeNode.children.size() : -1;
            int[] savedGroups = Arrays.copyOf(matcher.groups, matcher.groups.length);
            if (this.cond.match(matcher, i, seq)) {
                if (!this.yes.match(matcher, i, seq)) {
                    matcher.groups = savedGroups;
                    if (matcher.captureTreeMode) {
                        matcher.captureTreeNode.shrinkChildrenTo(save);
                    }
                    return false;
                }
                return true;
            }
            if (this.not != null) {
                return this.not.match(matcher, i, seq);
            }
            return this.getNext().match(matcher, i, seq);
        }
    }

    static final class ConditionalGP
    extends Conditional {
        int groupNumber;

        ConditionalGP(int groupNumber) {
            this.groupNumber = groupNumber;
        }

        public ConditionalGP() {
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (matcher.groups[this.groupNumber * 2] != -1) {
                return this.yes.match(matcher, i, seq);
            }
            if (this.not != null) {
                return this.not.match(matcher, i, seq);
            }
            return this.getNext().match(matcher, i, seq);
        }
    }

    static class Conditional
    extends Node {
        Node yes;
        Node not;

        Conditional() {
        }

        void setYes(Node yes) {
            new Node(){

                @Override
                void setNext(Node a) {
                    yes = a;
                    if (a != null) {
                        a.previous = (Node)this;
                    }
                }
            }.setNext(yes);
        }

        void setNot(Node not) {
            new Node(){

                @Override
                void setNext(Node a) {
                    not = a;
                    if (a != null) {
                        a.previous = (Node)this;
                    }
                }
            }.setNext(not);
        }

        @Override
        boolean study(TreeInfo info) {
            int minL = info.minLength;
            int maxL = info.maxLength;
            boolean maxV = info.maxValid;
            int minL2 = Integer.MAX_VALUE;
            int maxL2 = -1;
            info.reset();
            this.yes.study(info);
            minL2 = Math.min(minL2, info.minLength);
            maxL2 = Math.max(maxL2, info.maxLength);
            maxV &= info.maxValid;
            if (this.not != null) {
                info.reset();
                this.not.study(info);
                minL2 = Math.min(minL2, info.minLength);
                maxL2 = Math.max(maxL2, info.maxLength);
                maxV &= info.maxValid;
            } else {
                info.reset();
                this.getNext().study(info);
                minL2 = Math.min(minL2, info.minLength);
            }
            info.minLength = minL + minL2;
            info.maxLength = maxL + maxL2;
            info.maxValid = maxV;
            info.deterministic = false;
            return false;
        }
    }

    static class CIBackRef
    extends BackRefBase {
        boolean doUnicodeCase;

        CIBackRef(int groupCount, boolean doUnicodeCase) {
            super(groupCount);
            this.doUnicodeCase = doUnicodeCase;
        }

        CIBackRef(boolean doUnicodeCase) {
            this.doUnicodeCase = doUnicodeCase;
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int j = matcher.groups[this.groupIndex * 2];
            int k = matcher.groups[this.groupIndex * 2 + 1];
            int groupSize = k - j;
            if (j < 0) {
                return false;
            }
            if (i + groupSize > matcher.to) {
                matcher.hitEnd = true;
                return false;
            }
            int x = i;
            for (int index = 0; index < groupSize; ++index) {
                int cc2;
                int cc1;
                int c2;
                int c1 = Character.codePointAt(seq, x);
                if (c1 != (c2 = Character.codePointAt(seq, j)) && (this.doUnicodeCase ? (cc1 = Character.toUpperCase(c1)) != (cc2 = Character.toUpperCase(c2)) && Character.toLowerCase(cc1) != Character.toLowerCase(cc2) : ASCII.toLower(c1) != ASCII.toLower(c2))) {
                    return false;
                }
                int count = Character.charCount(c1);
                x += count;
                matcher.activity += count;
                j += Character.charCount(c2);
            }
            return this.getNext().match(matcher, i + groupSize, seq);
        }

        @Override
        boolean study(TreeInfo info) {
            info.maxValid = false;
            return this.getNext().study(info);
        }
    }

    static class BackRef
    extends BackRefBase {
        BackRef(int groupCount) {
            super(groupCount);
        }

        BackRef() {
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int j = matcher.groups[this.groupIndex * 2];
            int k = matcher.groups[this.groupIndex * 2 + 1];
            int groupSize = k - j;
            if (j < 0) {
                return false;
            }
            if (i + groupSize > matcher.to) {
                matcher.hitEnd = true;
                return false;
            }
            for (int index = 0; index < groupSize; ++index) {
                if (seq.charAt(i + index) != seq.charAt(j + index)) {
                    return false;
                }
                ++matcher.activity;
            }
            return this.getNext().match(matcher, i + groupSize, seq);
        }

        @Override
        boolean study(TreeInfo info) {
            info.maxValid = false;
            return this.getNext().study(info);
        }
    }

    static class BackRefBase
    extends Node {
        int groupIndex;

        BackRefBase(int groupCount) {
            this.groupIndex = groupCount;
        }

        BackRefBase() {
        }
    }

    final class RecursiveGroupCall
    extends Node {
        private GroupHead groupHead;
        private GroupTail groupTail;
        private boolean recursion;
        private boolean inLookaround;

        RecursiveGroupCall(int groupNumber, boolean recursion, boolean inLookaround) {
            this(recursion, inLookaround);
            this.setGroupNumber(groupNumber);
        }

        RecursiveGroupCall(boolean recursion, boolean inLookaround) {
            this.recursion = recursion;
            this.inLookaround = inLookaround;
        }

        void setGroupNumber(int groupNumber) {
            GroupHeadAndTail ghat = (GroupHeadAndTail)Pattern.this.groupHeadAndTailNodes().get(groupNumber);
            this.groupHead = ghat.groupHead;
            this.groupTail = ghat.groupTail;
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            InternalRecursiveGroupCall ircc = new InternalRecursiveGroupCall();
            return ircc.match(matcher, i, seq);
        }

        @Override
        boolean study(TreeInfo info) {
            if (info.recursive.containsKey(this.groupTail.groupIndex) && info.recursive.get(this.groupTail.groupIndex).booleanValue()) {
                info.maxValid = false;
                info.minLength = 0xFFFFFFF;
                return false;
            }
            info.recursive.put(this.groupTail.groupIndex, true);
            this.groupHead.study(info);
            info.recursive.put(this.groupTail.groupIndex, false);
            info.deterministic = false;
            return this.getNext().study(info);
        }

        private class InternalRecursiveGroupCall
        extends Node {
            boolean first = true;
            Node groupTailsNext;
            int[] savedGroups;
            int[] savedRecursion = new int[3];

            private InternalRecursiveGroupCall() {
            }

            @Override
            boolean match(Matcher matcher, int i, CharSequence seq) {
                if (this.first) {
                    this.first = false;
                    for (int k = 0; k < 3; ++k) {
                        this.savedRecursion[k] = matcher.recursions[((RecursiveGroupCall)RecursiveGroupCall.this).groupHead.groupIndex * 3 + k];
                    }
                    if (matcher.recursions[((RecursiveGroupCall)RecursiveGroupCall.this).groupHead.groupIndex * 3] == i) {
                        int activity = matcher.activity - matcher.recursions[((RecursiveGroupCall)RecursiveGroupCall.this).groupHead.groupIndex * 3 + 1];
                        if (activity <= matcher.recursions[((RecursiveGroupCall)RecursiveGroupCall.this).groupHead.groupIndex * 3 + 2]) {
                            return false;
                        }
                        matcher.recursions[((RecursiveGroupCall)RecursiveGroupCall.this).groupHead.groupIndex * 3 + 2] = activity;
                    }
                    matcher.recursions[((RecursiveGroupCall)RecursiveGroupCall.this).groupHead.groupIndex * 3] = i;
                    matcher.recursions[((RecursiveGroupCall)RecursiveGroupCall.this).groupHead.groupIndex * 3 + 1] = matcher.activity;
                    this.groupTailsNext = RecursiveGroupCall.this.groupTail.getNext(matcher);
                    RecursiveGroupCall.this.groupTail.setNext(matcher, this);
                    if (RecursiveGroupCall.this.recursion) {
                        this.savedGroups = matcher.groups;
                        matcher.groups = new int[matcher.groups.length];
                        Arrays.fill(matcher.groups, -1);
                    }
                    boolean r = RecursiveGroupCall.this.groupHead.match(matcher, i, seq);
                    RecursiveGroupCall.this.groupTail.setNext(matcher, this.groupTailsNext);
                    if (RecursiveGroupCall.this.recursion) {
                        matcher.groups = this.savedGroups;
                    }
                    for (int k = 0; k < 3; ++k) {
                        matcher.recursions[((RecursiveGroupCall)RecursiveGroupCall.this).groupHead.groupIndex * 3 + k] = this.savedRecursion[k];
                    }
                    return r;
                }
                RecursiveGroupCall.this.groupTail.setNext(matcher, this.groupTailsNext);
                if (matcher.captureTreeMode) {
                    CaptureTreeNode t = matcher.captureTreeNode.children.getLast();
                    t.recursion = RecursiveGroupCall.this.recursion;
                    t.inLookaround = RecursiveGroupCall.this.inLookaround;
                }
                int saveStart = -1;
                int saveEnd = -1;
                int[] z = null;
                if (RecursiveGroupCall.this.recursion) {
                    saveStart = this.savedGroups[((RecursiveGroupCall)RecursiveGroupCall.this).groupHead.groupIndex * 2];
                    saveEnd = this.savedGroups[((RecursiveGroupCall)RecursiveGroupCall.this).groupHead.groupIndex * 2 + 1];
                    this.savedGroups[((RecursiveGroupCall)RecursiveGroupCall.this).groupHead.groupIndex * 2] = matcher.groups[((RecursiveGroupCall)RecursiveGroupCall.this).groupHead.groupIndex * 2];
                    this.savedGroups[((RecursiveGroupCall)RecursiveGroupCall.this).groupHead.groupIndex * 2 + 1] = matcher.groups[((RecursiveGroupCall)RecursiveGroupCall.this).groupHead.groupIndex * 2 + 1];
                    z = matcher.groups;
                    matcher.groups = this.savedGroups;
                }
                int[] y = new int[3];
                for (int k = 0; k < 3; ++k) {
                    y[k] = matcher.recursions[((RecursiveGroupCall)RecursiveGroupCall.this).groupHead.groupIndex * 3 + k];
                    matcher.recursions[((RecursiveGroupCall)RecursiveGroupCall.this).groupHead.groupIndex * 3 + k] = this.savedRecursion[k];
                }
                boolean r = RecursiveGroupCall.this.getNext().match(matcher, i, seq);
                if (RecursiveGroupCall.this.recursion) {
                    if (!r) {
                        matcher.groups[((RecursiveGroupCall)RecursiveGroupCall.this).groupHead.groupIndex * 2] = saveStart;
                        matcher.groups[((RecursiveGroupCall)RecursiveGroupCall.this).groupHead.groupIndex * 2 + 1] = saveEnd;
                    }
                    matcher.groups = z;
                }
                RecursiveGroupCall.this.groupTail.setNext(matcher, this);
                for (int k = 0; k < 3; ++k) {
                    matcher.recursions[((RecursiveGroupCall)RecursiveGroupCall.this).groupHead.groupIndex * 3 + k] = y[k];
                }
                return r;
            }
        }
    }

    static class GroupHeadAndTail {
        GroupHead groupHead;
        GroupTail groupTail;

        GroupHeadAndTail(GroupHead groupHead, GroupTail groupTail) {
            this.groupHead = groupHead;
            this.groupTail = groupTail;
        }
    }

    static final class GroupTail
    extends Navigator {
        int groupIndex;

        GroupTail(int localCount, int groupCount) {
            super(localCount);
            this.groupIndex = groupCount;
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int tmp = matcher.localVector.get(this.localIndex).pop();
            CaptureTreeNode t = null;
            int saveStart = matcher.groups[this.groupIndex * 2];
            int saveEnd = matcher.groups[this.groupIndex * 2 + 1];
            if (this.groupIndex > 0) {
                matcher.groups[this.groupIndex * 2] = tmp;
                matcher.groups[this.groupIndex * 2 + 1] = i;
                if (matcher.captureTreeMode) {
                    Capture c;
                    matcher.captureTreeNode.capture = c = new Capture(seq, tmp, i);
                    t = matcher.captureTreeNode;
                    matcher.captureTreeNode = t.parent;
                }
            }
            boolean r = this.getNext(matcher).match(matcher, i, seq);
            if (this.groupIndex > 0) {
                if (t != null) {
                    matcher.captureTreeNode = t;
                }
                if (!r) {
                    matcher.groups[this.groupIndex * 2] = saveStart;
                    matcher.groups[this.groupIndex * 2 + 1] = saveEnd;
                    if (t != null) {
                        t.capture = null;
                    }
                }
            }
            matcher.localVector.get(this.localIndex).push(tmp);
            return r;
        }

        @Override
        boolean study(TreeInfo info) {
            info.deterministic = false;
            return this.getNext().study(info);
        }
    }

    static final class GroupHead
    extends Node {
        int localIndex;
        int groupIndex;
        boolean inLookaround;

        GroupHead(int localCount, int groupCount, boolean inLookaround) {
            this.localIndex = localCount;
            this.groupIndex = groupCount;
            this.inLookaround = inLookaround;
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            CaptureTreeNode t = null;
            if (this.groupIndex > 0 && matcher.captureTreeMode) {
                t = new CaptureTreeNode();
                t.recursion = false;
                t.inLookaround = this.inLookaround;
                t.groupNumber = this.groupIndex;
                t.parent = matcher.captureTreeNode;
                matcher.captureTreeNode.children.add(t);
                matcher.captureTreeNode = t;
            }
            matcher.localVector.get(this.localIndex).push(i);
            boolean r = this.getNext().match(matcher, i, seq);
            matcher.localVector.get(this.localIndex).pop();
            if (t != null) {
                matcher.captureTreeNode = t.parent;
                if (!r) {
                    matcher.captureTreeNode.children.remove(t);
                }
            }
            return r;
        }
    }

    static final class AtomicGroup
    extends Node {
        private Node atom;

        AtomicGroup(Node atom) {
            new Node(){

                @Override
                public void setNext(Node a) {
                    atom = a;
                    a.previous = (Node)this;
                }
            }.setNext(atom);
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int save;
            int[] saveGroups = Arrays.copyOf(matcher.groups, matcher.groups.length);
            int n = save = matcher.captureTreeMode ? matcher.captureTreeNode.children.size() : -1;
            if (!this.atom.match(matcher, i, seq)) {
                return false;
            }
            i = matcher.last;
            boolean r = this.getNext().match(matcher, i, seq);
            if (!r) {
                matcher.groups = saveGroups;
                if (matcher.captureTreeMode) {
                    matcher.captureTreeNode.shrinkChildrenTo(save);
                }
            }
            return r;
        }

        @Override
        boolean study(TreeInfo info) {
            this.atom.study(info);
            return this.getNext().study(info);
        }
    }

    static final class Branch
    extends Node {
        Node[] atoms = new Node[2];
        int size = 0;
        Node conn;

        Branch(Node first, Node second, Node branchConn) {
            this.conn = branchConn;
            this.add(first);
            this.add(second);
        }

        void add(Node node) {
            if (this.size >= this.atoms.length) {
                Node[] tmp = new Node[this.atoms.length * 2];
                System.arraycopy(this.atoms, 0, tmp, 0, this.atoms.length);
                this.atoms = tmp;
            }
            final int i = this.size++;
            new Node(){

                @Override
                public void setNext(Node a) {
                    atoms[i] = a;
                    if (a != null) {
                        a.previous = (Node)this;
                    }
                }
            }.setNext(node);
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            for (int n = 0; n < this.size; ++n) {
                if (!(this.atoms[n] == null ? this.conn.getNext().match(matcher, i, seq) : this.atoms[n].match(matcher, i, seq))) continue;
                return true;
            }
            return false;
        }

        @Override
        boolean study(TreeInfo info) {
            int minL = info.minLength;
            int maxL = info.maxLength;
            boolean maxV = info.maxValid;
            int minL2 = Integer.MAX_VALUE;
            int maxL2 = -1;
            for (int n = 0; n < this.size; ++n) {
                info.reset();
                if (this.atoms[n] != null) {
                    this.atoms[n].study(info);
                }
                minL2 = Math.min(minL2, info.minLength);
                maxL2 = Math.max(maxL2, info.maxLength);
                maxV &= info.maxValid;
            }
            info.reset();
            this.conn.getNext().study(info);
            info.minLength += (minL += minL2);
            info.maxLength += (maxL += maxL2);
            info.maxValid &= maxV;
            info.deterministic = false;
            return false;
        }

        @Override
        Node getNext() {
            return this.conn;
        }
    }

    static final class BranchConn
    extends Node {
        BranchConn() {
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            return this.getNext().match(matcher, i, seq);
        }

        @Override
        boolean study(TreeInfo info) {
            return info.deterministic;
        }
    }

    class Curly
    extends CurlyBase {
        Navigator endNode;

        Curly(Node beginNode, int cmin, int cmax, int type) {
            super(beginNode, cmin, cmax, type);
        }

        @Override
        void setBeginNode(Node beginNode) {
            super.setBeginNode(beginNode);
            Node end = this.findEndNode(beginNode);
            this.endNode = Pattern.this.createNavigator(end);
        }

        Node findEndNode(Node beginNode) {
            Node end = beginNode;
            while (end.getNext() != null && end.getNext() != accept) {
                end = end.getNext();
            }
            return end;
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (this.type == 0) {
                Repeater mgr = new Repeater(this.getNext(), this.cmax - this.cmin, true);
                Repeater mr = new Repeater(mgr, this.cmin, false);
                return mr.match(matcher, i, seq);
            }
            if (this.type == 1) {
                MaxLazyRepeater mlr = new MaxLazyRepeater(this.cmax - this.cmin);
                Repeater mr = new Repeater(mlr, this.cmin, false);
                return mr.match(matcher, i, seq);
            }
            Repeater mr = new Repeater(accept, this.cmin, false);
            int save = matcher.captureTreeMode ? matcher.captureTreeNode.children.size() : -1;
            int[] savedGroups = Arrays.copyOf(matcher.groups, matcher.groups.length);
            if (!mr.match(matcher, i, seq)) {
                return false;
            }
            i = matcher.last;
            for (int j = this.cmin; j < this.cmax && this.beginNode.match(matcher, i, seq); ++j) {
                i = matcher.last;
            }
            if (this.getNext().match(matcher, i, seq)) {
                return true;
            }
            matcher.groups = savedGroups;
            if (matcher.captureTreeMode) {
                matcher.captureTreeNode.shrinkChildrenTo(save);
            }
            return false;
        }

        private class Repeater
        extends Node {
            private int counter;
            private Node initialEndNext;
            private boolean isMax;
            private int beginIndex = -1;

            Repeater(Node next, int counter, boolean isMax) {
                this.setNext(next);
                this.counter = counter;
                this.isMax = isMax;
            }

            @Override
            public boolean match(Matcher matcher, int i, CharSequence seq) {
                if (this.initialEndNext == null) {
                    this.initialEndNext = Curly.this.endNode.getNext(matcher);
                }
                if (this.counter == 0 || this.beginIndex >= i) {
                    Node oldEndNext = Curly.this.endNode.getNext(matcher);
                    Curly.this.endNode.setNext(matcher, this.initialEndNext);
                    boolean r = this.getNext().match(matcher, i, seq);
                    Curly.this.endNode.setNext(matcher, oldEndNext);
                    return r;
                }
                --this.counter;
                Node oldEndNext = Curly.this.endNode.getNext(matcher);
                Curly.this.endNode.setNext(matcher, this);
                int oldBeginIndex = this.beginIndex;
                this.beginIndex = i;
                boolean r = Curly.this.beginNode.match(matcher, i, seq);
                ++this.counter;
                Curly.this.endNode.setNext(matcher, oldEndNext);
                this.beginIndex = oldBeginIndex;
                if (this.isMax) {
                    r = r || this.getNext().match(matcher, i, seq);
                }
                return r;
            }
        }

        private class MaxLazyRepeater
        extends Node {
            private int counter;
            private Node initialEndNext;
            private int beginIndex = -1;

            MaxLazyRepeater(int cmax) {
                this.counter = cmax;
            }

            @Override
            boolean match(Matcher matcher, int i, CharSequence seq) {
                if (this.beginIndex >= i) {
                    return false;
                }
                if (this.initialEndNext == null) {
                    this.initialEndNext = Curly.this.endNode.getNext(matcher);
                }
                Node oldEndNodeNext = Curly.this.endNode.getNext(matcher);
                Curly.this.endNode.setNext(matcher, this.initialEndNext);
                boolean r = Curly.this.getNext().match(matcher, i, seq);
                Curly.this.endNode.setNext(matcher, oldEndNodeNext);
                if (r) {
                    return true;
                }
                if (this.counter == 0) {
                    return false;
                }
                --this.counter;
                oldEndNodeNext = Curly.this.endNode.getNext(matcher);
                Curly.this.endNode.setNext(matcher, this);
                int oldBeginIndex = this.beginIndex;
                this.beginIndex = i;
                r = Curly.this.beginNode.match(matcher, i, seq);
                ++this.counter;
                Curly.this.endNode.setNext(matcher, oldEndNodeNext);
                this.beginIndex = oldBeginIndex;
                return r;
            }
        }
    }

    static class DeterministicCurly
    extends CurlyBase {
        DeterministicCurly(Node beginNode, int cmin, int cmax, int type) {
            super(beginNode, cmin, cmax, type);
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int j;
            for (j = 0; j < this.cmin; ++j) {
                if (!this.beginNode.match(matcher, i, seq)) {
                    return false;
                }
                i = matcher.last;
            }
            if (this.type == 0) {
                Stack<Integer> backtrack = new Stack<Integer>();
                backtrack.push(i);
                while (j < this.cmax && this.beginNode.match(matcher, i, seq) && i != matcher.last) {
                    i = matcher.last;
                    backtrack.push(i);
                    ++j;
                }
                while (!backtrack.isEmpty()) {
                    i = (Integer)backtrack.pop();
                    if (!this.getNext().match(matcher, i, seq)) continue;
                    return true;
                }
                return false;
            }
            if (this.type == 1) {
                while (true) {
                    if (this.getNext().match(matcher, i, seq)) {
                        return true;
                    }
                    if (j >= this.cmax) {
                        return false;
                    }
                    if (!this.beginNode.match(matcher, i, seq)) {
                        return false;
                    }
                    if (i == matcher.last) {
                        return false;
                    }
                    i = matcher.last;
                    ++j;
                }
            }
            while (j < this.cmax && this.beginNode.match(matcher, i, seq)) {
                i = matcher.last;
                ++j;
            }
            return this.getNext().match(matcher, i, seq);
        }
    }

    static class CurlyBase
    extends Node {
        Node beginNode;
        int type;
        int cmin;
        int cmax;

        CurlyBase(Node beginNode, int cmin, int cmax, int type) {
            new Node(){

                @Override
                public void setNext(Node a) {
                    this.setBeginNode(a);
                    if (a != null) {
                        a.previous = (Node)this;
                    }
                }
            }.setNext(beginNode);
            this.cmin = cmin;
            this.cmax = cmax;
            this.type = type;
        }

        void setBeginNode(Node beginNode) {
            this.beginNode = beginNode;
        }

        @Override
        boolean study(TreeInfo info) {
            int minL = info.minLength;
            int maxL = info.maxLength;
            boolean maxV = info.maxValid;
            boolean detm = info.deterministic;
            info.reset();
            this.beginNode.study(info);
            int temp = info.minLength * this.cmin + minL;
            if (temp < minL) {
                temp = 0xFFFFFFF;
            }
            info.minLength = temp;
            if (maxV & info.maxValid) {
                info.maxLength = temp = info.maxLength * this.cmax + maxL;
                if (temp < maxL) {
                    info.maxValid = false;
                }
            } else {
                info.maxValid = false;
            }
            info.deterministic = info.deterministic && this.cmin == this.cmax ? detm : false;
            return this.getNext().study(info);
        }
    }

    static final class UnixDot
    extends CharProperty {
        UnixDot() {
        }

        @Override
        boolean isSatisfiedBy(int ch) {
            return ch != 10;
        }
    }

    static final class Dot
    extends CharProperty {
        Dot() {
        }

        @Override
        boolean isSatisfiedBy(int ch) {
            return ch != 10 && ch != 13 && (ch | 1) != 8233 && ch != 133;
        }
    }

    static final class All
    extends CharProperty {
        All() {
        }

        @Override
        boolean isSatisfiedBy(int ch) {
            return true;
        }
    }

    static final class SliceUS
    extends SliceIS {
        SliceUS(int[] buf) {
            super(buf);
        }

        @Override
        int toLower(int c) {
            return Character.toLowerCase(Character.toUpperCase(c));
        }
    }

    static class SliceIS
    extends SliceNode {
        SliceIS(int[] buf) {
            super(buf);
        }

        int toLower(int c) {
            return ASCII.toLower(c);
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int[] buf = this.buffer;
            int x = i;
            for (int j = 0; j < buf.length; ++j) {
                if (x >= matcher.to) {
                    matcher.hitEnd = true;
                    return false;
                }
                int c = Character.codePointAt(seq, x);
                if (buf[j] != c && buf[j] != this.toLower(c)) {
                    return false;
                }
                int count = Character.charCount(c);
                if ((x += count) > matcher.to) {
                    matcher.hitEnd = true;
                    return false;
                }
                matcher.activity += count;
            }
            return this.getNext().match(matcher, x, seq);
        }
    }

    static final class SliceS
    extends SliceNode {
        SliceS(int[] buf) {
            super(buf);
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int[] buf = this.buffer;
            int x = i;
            for (int j = 0; j < buf.length; ++j) {
                if (x >= matcher.to) {
                    matcher.hitEnd = true;
                    return false;
                }
                int c = Character.codePointAt(seq, x);
                if (buf[j] != c) {
                    return false;
                }
                int count = Character.charCount(c);
                if ((x += count) > matcher.to) {
                    matcher.hitEnd = true;
                    return false;
                }
                matcher.activity += count;
            }
            return this.getNext().match(matcher, x, seq);
        }
    }

    static final class SliceU
    extends SliceNode {
        SliceU(int[] buf) {
            super(buf);
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int[] buf = this.buffer;
            int len = buf.length;
            for (int j = 0; j < len; ++j) {
                if (i + j >= matcher.to) {
                    matcher.hitEnd = true;
                    return false;
                }
                char c = seq.charAt(i + j);
                if (buf[j] != c && buf[j] != Character.toLowerCase(Character.toUpperCase((int)c))) {
                    return false;
                }
                ++matcher.activity;
            }
            return this.getNext().match(matcher, i + len, seq);
        }
    }

    static class SliceI
    extends SliceNode {
        SliceI(int[] buf) {
            super(buf);
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int[] buf = this.buffer;
            int len = buf.length;
            for (int j = 0; j < len; ++j) {
                if (i + j >= matcher.to) {
                    matcher.hitEnd = true;
                    return false;
                }
                char c = seq.charAt(i + j);
                if (buf[j] != c && buf[j] != ASCII.toLower(c)) {
                    return false;
                }
                ++matcher.activity;
            }
            return this.getNext().match(matcher, i + len, seq);
        }
    }

    static final class Slice
    extends SliceNode {
        Slice(int[] buf) {
            super(buf);
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int[] buf = this.buffer;
            int len = buf.length;
            for (int j = 0; j < len; ++j) {
                if (i + j >= matcher.to) {
                    matcher.hitEnd = true;
                    return false;
                }
                if (buf[j] != seq.charAt(i + j)) {
                    return false;
                }
                ++matcher.activity;
            }
            return this.getNext().match(matcher, i + len, seq);
        }
    }

    static class SliceNode
    extends Node {
        int[] buffer;

        SliceNode(int[] buf) {
            this.buffer = buf;
        }

        @Override
        boolean study(TreeInfo info) {
            info.minLength += this.buffer.length;
            info.maxLength += this.buffer.length;
            return this.getNext().study(info);
        }
    }

    static final class HorizWS
    extends BmpCharProperty {
        HorizWS() {
        }

        @Override
        boolean isSatisfiedBy(int cp) {
            return cp == 9 || cp == 32 || cp == 160 || cp == 5760 || cp == 6158 || cp >= 8192 && cp <= 8202 || cp == 8239 || cp == 8287 || cp == 12288;
        }
    }

    static final class VertWS
    extends BmpCharProperty {
        VertWS() {
        }

        @Override
        boolean isSatisfiedBy(int cp) {
            return cp >= 10 && cp <= 13 || cp == 133 || cp == 8232 || cp == 8233;
        }
    }

    static final class Ctype
    extends BmpCharProperty {
        final int ctype;

        Ctype(int ctype) {
            this.ctype = ctype;
        }

        @Override
        boolean isSatisfiedBy(int ch) {
            return ch < 128 && ASCII.isType(ch, this.ctype);
        }
    }

    static final class Utype
    extends CharProperty {
        final UnicodeProp uprop;

        Utype(UnicodeProp uprop) {
            this.uprop = uprop;
        }

        @Override
        boolean isSatisfiedBy(int ch) {
            return this.uprop.is(ch);
        }
    }

    static final class Category
    extends CharProperty {
        final int typeMask;

        Category(int typeMask) {
            this.typeMask = typeMask;
        }

        @Override
        boolean isSatisfiedBy(int ch) {
            return (this.typeMask & 1 << Character.getType(ch)) != 0;
        }
    }

    static final class Script
    extends CharProperty {
        final Character.UnicodeScript script;

        Script(Character.UnicodeScript script) {
            this.script = script;
        }

        @Override
        boolean isSatisfiedBy(int ch) {
            return this.script == Character.UnicodeScript.of(ch);
        }
    }

    static final class Block
    extends CharProperty {
        final Character.UnicodeBlock block;

        Block(Character.UnicodeBlock block) {
            this.block = block;
        }

        @Override
        boolean isSatisfiedBy(int ch) {
            return this.block == Character.UnicodeBlock.of(ch);
        }
    }

    static final class SingleU
    extends CharProperty {
        final int lower;

        SingleU(int lower) {
            this.lower = lower;
        }

        @Override
        boolean isSatisfiedBy(int ch) {
            return this.lower == ch || this.lower == Character.toLowerCase(Character.toUpperCase(ch));
        }
    }

    static final class SingleI
    extends BmpCharProperty {
        final int lower;
        final int upper;

        SingleI(int lower, int upper) {
            this.lower = lower;
            this.upper = upper;
        }

        @Override
        boolean isSatisfiedBy(int ch) {
            return ch == this.lower || ch == this.upper;
        }
    }

    static final class Single
    extends BmpCharProperty {
        final int c;

        Single(int c) {
            this.c = c;
        }

        @Override
        boolean isSatisfiedBy(int ch) {
            return ch == this.c;
        }
    }

    static final class SingleS
    extends CharProperty {
        final int c;

        SingleS(int c) {
            this.c = c;
        }

        @Override
        boolean isSatisfiedBy(int ch) {
            return ch == this.c;
        }
    }

    private static abstract class BmpCharProperty
    extends CharProperty {
        private BmpCharProperty() {
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (i < matcher.to) {
                if (this.isSatisfiedBy(seq.charAt(i))) {
                    ++matcher.activity;
                    return this.getNext().match(matcher, i + 1, seq);
                }
                return false;
            }
            matcher.hitEnd = true;
            return false;
        }
    }

    private static abstract class CharProperty
    extends Node {
        private CharProperty() {
        }

        abstract boolean isSatisfiedBy(int var1);

        CharProperty complement() {
            return new CharProperty(){

                @Override
                boolean isSatisfiedBy(int ch) {
                    return !this.isSatisfiedBy(ch);
                }
            };
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (i < matcher.to) {
                int ch = Character.codePointAt(seq, i);
                if (this.isSatisfiedBy(ch)) {
                    int count = Character.charCount(ch);
                    matcher.activity += count;
                    return this.getNext().match(matcher, i + count, seq);
                }
                return false;
            }
            matcher.hitEnd = true;
            return false;
        }

        @Override
        boolean study(TreeInfo info) {
            ++info.minLength;
            ++info.maxLength;
            return this.getNext().study(info);
        }
    }

    static final class LineEnding
    extends Node {
        LineEnding() {
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (i < matcher.to) {
                char ch = seq.charAt(i);
                if (ch == '\n' || ch == '\u000b' || ch == '\f' || ch == '\u0085' || ch == '\u2028' || ch == '\u2029') {
                    return this.getNext().match(matcher, i + 1, seq);
                }
                if (ch == '\r') {
                    if (++i < matcher.to && seq.charAt(i) == '\n') {
                        ++i;
                    }
                    return this.getNext().match(matcher, i, seq);
                }
            } else {
                matcher.hitEnd = true;
            }
            return false;
        }

        @Override
        boolean study(TreeInfo info) {
            ++info.minLength;
            info.maxLength += 2;
            return this.getNext().study(info);
        }
    }

    static final class UnixDollar
    extends Node {
        boolean multiline;

        UnixDollar(boolean mul) {
            this.multiline = mul;
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int endIndex;
            int n = endIndex = matcher.anchoringBounds ? matcher.to : matcher.getTextLength();
            if (i < endIndex) {
                char ch = seq.charAt(i);
                if (ch == '\n') {
                    if (!this.multiline && i != endIndex - 1) {
                        return false;
                    }
                    if (this.multiline) {
                        return this.getNext().match(matcher, i, seq);
                    }
                } else {
                    return false;
                }
            }
            matcher.hitEnd = true;
            matcher.requireEnd = true;
            return this.getNext().match(matcher, i, seq);
        }

        @Override
        boolean study(TreeInfo info) {
            this.getNext().study(info);
            return info.deterministic;
        }
    }

    static final class Dollar
    extends Node {
        boolean multiline;

        Dollar(boolean mul) {
            this.multiline = mul;
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            char ch;
            int endIndex;
            int n = endIndex = matcher.anchoringBounds ? matcher.to : matcher.getTextLength();
            if (!this.multiline) {
                if (i < endIndex - 2) {
                    return false;
                }
                if (i == endIndex - 2) {
                    ch = seq.charAt(i);
                    if (ch != '\r') {
                        return false;
                    }
                    ch = seq.charAt(i + 1);
                    if (ch != '\n') {
                        return false;
                    }
                }
            }
            if (i < endIndex) {
                ch = seq.charAt(i);
                if (ch == '\n') {
                    if (i > 0 && seq.charAt(i - 1) == '\r') {
                        return false;
                    }
                    if (this.multiline) {
                        return this.getNext().match(matcher, i, seq);
                    }
                } else if (ch == '\r' || ch == '\u0085' || (ch | '\u0001') == 8233) {
                    if (this.multiline) {
                        return this.getNext().match(matcher, i, seq);
                    }
                } else {
                    return false;
                }
            }
            matcher.hitEnd = true;
            matcher.requireEnd = true;
            return this.getNext().match(matcher, i, seq);
        }

        @Override
        boolean study(TreeInfo info) {
            this.getNext().study(info);
            return info.deterministic;
        }
    }

    static final class LastMatch
    extends Node {
        LastMatch() {
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (i != matcher.oldLast) {
                return false;
            }
            return this.getNext().match(matcher, i, seq);
        }
    }

    static final class UnixCaret
    extends Node {
        UnixCaret() {
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            char ch;
            int startIndex = matcher.from;
            int endIndex = matcher.to;
            if (!matcher.anchoringBounds) {
                startIndex = 0;
                endIndex = matcher.getTextLength();
            }
            if (i == endIndex) {
                matcher.hitEnd = true;
                return false;
            }
            if (i > startIndex && (ch = seq.charAt(i - 1)) != '\n') {
                return false;
            }
            return this.getNext().match(matcher, i, seq);
        }
    }

    static final class Caret
    extends Node {
        Caret() {
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int startIndex = matcher.from;
            int endIndex = matcher.to;
            if (!matcher.anchoringBounds) {
                startIndex = 0;
                endIndex = matcher.getTextLength();
            }
            if (i == endIndex) {
                matcher.hitEnd = true;
                return false;
            }
            if (i > startIndex) {
                char ch = seq.charAt(i - 1);
                if (ch != '\n' && ch != '\r' && (ch | '\u0001') != 8233 && ch != '\u0085') {
                    return false;
                }
                if (ch == '\r' && seq.charAt(i) == '\n') {
                    return false;
                }
            }
            return this.getNext().match(matcher, i, seq);
        }
    }

    static final class End
    extends Node {
        End() {
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int endIndex;
            int n = endIndex = matcher.anchoringBounds ? matcher.to : matcher.getTextLength();
            if (i == endIndex) {
                matcher.hitEnd = true;
                return this.getNext().match(matcher, i, seq);
            }
            return false;
        }
    }

    static final class Begin
    extends Node {
        Begin() {
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int fromIndex;
            int n = fromIndex = matcher.anchoringBounds ? matcher.from : 0;
            if (i == fromIndex && this.getNext().match(matcher, i, seq)) {
                matcher.first = i;
                matcher.setGroup0(seq, i, matcher.last);
                return true;
            }
            return false;
        }
    }

    static final class StartS
    extends Start {
        StartS(Node node) {
            super(node);
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (i > matcher.to - this.minLength) {
                matcher.hitEnd = true;
                return false;
            }
            int guard = matcher.to - this.minLength;
            while (i <= guard) {
                if (this.getNext().match(matcher, i, seq)) {
                    matcher.first = i;
                    matcher.setGroup0(seq, matcher.first, matcher.last);
                    return true;
                }
                if (i == guard) break;
                if (!Character.isHighSurrogate(seq.charAt(i++)) || i >= seq.length() || !Character.isLowSurrogate(seq.charAt(i))) continue;
                ++i;
            }
            matcher.hitEnd = true;
            return false;
        }
    }

    static class Start
    extends Node {
        int minLength;

        Start(Node node) {
            this.setNext(node);
            TreeInfo info = new TreeInfo();
            this.getNext().study(info);
            this.minLength = info.minLength;
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (i > matcher.to - this.minLength) {
                matcher.hitEnd = true;
                return false;
            }
            int guard = matcher.to - this.minLength;
            while (i <= guard) {
                if (this.getNext().match(matcher, i, seq)) {
                    matcher.first = i;
                    matcher.setGroup0(seq, matcher.first, matcher.last);
                    return true;
                }
                ++i;
            }
            matcher.hitEnd = true;
            return false;
        }

        @Override
        boolean study(TreeInfo info) {
            this.getNext().study(info);
            info.maxValid = false;
            info.deterministic = false;
            return false;
        }
    }

    static class LastNode
    extends Node {
        LastNode() {
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (matcher.acceptMode == 1 && i != matcher.to) {
                return false;
            }
            matcher.last = i;
            matcher.setGroup0(seq, matcher.first, matcher.last);
            return true;
        }
    }

    static class Navigator
    extends Node {
        protected int localIndex;

        Navigator(int localIndex) {
            this.localIndex = localIndex;
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            return this.getNext(matcher).match(matcher, i, seq);
        }

        Node getNext(Matcher matcher) {
            if (matcher.nextNodes[this.localIndex] != null) {
                return matcher.nextNodes[this.localIndex];
            }
            return this.getNext();
        }

        void setNext(Matcher matcher, Node next) {
            matcher.nextNodes[this.localIndex] = next;
        }
    }

    public static abstract class CustomNode
    extends Node {
        @Override
        protected abstract boolean match(Matcher var1, int var2, CharSequence var3);

        protected boolean matchNext(Matcher matcher, int i, CharSequence seq) {
            return this.getNext().match(matcher, i, seq);
        }

        protected Object retrieveData(Matcher matcher) {
            return matcher.data.get(this.getClass());
        }

        protected void storeData(Matcher matcher, Object data) {
            matcher.data.put(this.getClass(), data);
        }

        protected abstract int minLength();

        protected abstract int maxLength();

        protected abstract boolean isMaxValid();

        protected abstract boolean isDeterministic();

        @Override
        boolean study(TreeInfo info) {
            info.minLength += this.minLength();
            info.maxLength += this.maxLength();
            if (!this.isMaxValid()) {
                info.maxValid = false;
            }
            info.deterministic &= this.isDeterministic();
            return this.getNext().study(info);
        }
    }

    static class Node {
        private Node next = accept;
        private Node previous;

        Node getNext() {
            return this.next;
        }

        Node getPrevious() {
            return this.previous;
        }

        void setNext(Node next) {
            this.next = next;
            next.previous = this;
        }

        Node() {
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            matcher.last = i;
            return true;
        }

        boolean study(TreeInfo info) {
            if (this.getNext() != null) {
                return this.getNext().study(info);
            }
            return info.deterministic;
        }
    }

    private static final class BitClass
    extends BmpCharProperty {
        final boolean[] bits;

        BitClass() {
            this.bits = new boolean[256];
        }

        private BitClass(boolean[] bits) {
            this.bits = bits;
        }

        BitClass add(int c, int flags) {
            assert (c >= 0 && c <= 255);
            if ((flags & 2) != 0) {
                if (ASCII.isAscii(c)) {
                    this.bits[ASCII.toUpper((int)c)] = true;
                    this.bits[ASCII.toLower((int)c)] = true;
                } else if ((flags & 0x40) != 0) {
                    this.bits[Character.toLowerCase((int)c)] = true;
                    this.bits[Character.toUpperCase((int)c)] = true;
                }
            }
            this.bits[c] = true;
            return this;
        }

        @Override
        boolean isSatisfiedBy(int ch) {
            return ch < 256 && this.bits[ch];
        }
    }

    static final class TreeInfo {
        int minLength;
        int maxLength;
        boolean maxValid;
        boolean deterministic;
        Map<Integer, Boolean> recursive = new HashMap<Integer, Boolean>();

        TreeInfo() {
            this.reset();
        }

        void reset() {
            this.minLength = 0;
            this.maxLength = 0;
            this.maxValid = true;
            this.deterministic = true;
        }
    }
}

