/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.data.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.teammoeg.caupona.CPTags;
import com.teammoeg.caupona.data.IDataRecipe;
import com.teammoeg.caupona.data.InvalidRecipeException;
import com.teammoeg.caupona.data.SerializeUtil;
import com.teammoeg.caupona.data.recipes.CookIngredients;
import com.teammoeg.caupona.data.recipes.IConditionalRecipe;
import com.teammoeg.caupona.data.recipes.IngredientCondition;
import com.teammoeg.caupona.data.recipes.PanPendingContext;
import com.teammoeg.caupona.data.recipes.conditions.Conditions;
import com.teammoeg.caupona.util.FloatemTagStack;
import com.teammoeg.caupona.util.Utils;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class SauteedRecipe
extends IDataRecipe
implements IConditionalRecipe {
    public static Set<CookIngredients> cookables;
    public static List<SauteedRecipe> sorted;
    public static RegistryObject<RecipeType<Recipe<?>>> TYPE;
    public static RegistryObject<RecipeSerializer<?>> SERIALIZER;
    List<IngredientCondition> allow;
    List<IngredientCondition> deny;
    int priority = 0;
    public int time;
    public Item output;
    public boolean removeNBT = false;
    public float count = 2.0f;

    public static boolean isCookable(ItemStack stack) {
        FloatemTagStack s = new FloatemTagStack(stack);
        return stack.m_204117_(CPTags.Items.COOKABLE) || cookables.stream().anyMatch(e -> e.fits(s));
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TYPE.get();
    }

    public SauteedRecipe(ResourceLocation id) {
        super(id);
    }

    public SauteedRecipe(ResourceLocation id, JsonObject data) {
        super(id);
        if (data.has("allow")) {
            this.allow = SerializeUtil.parseJsonList(data.get("allow"), Conditions::of);
            Conditions.checkConditions(this.allow);
        }
        if (data.has("deny")) {
            this.deny = SerializeUtil.parseJsonList(data.get("deny"), Conditions::of);
            Conditions.checkConditions(this.deny);
        }
        if (data.has("priority")) {
            this.priority = data.get("priority").getAsInt();
        }
        this.time = data.get("time").getAsInt();
        this.output = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(data.get("output").getAsString()));
        if (this.output == null) {
            throw new InvalidRecipeException();
        }
        if (data.has("removeNBT")) {
            this.removeNBT = data.get("removeNBT").getAsBoolean();
        }
        if (data.has("ingredientPerDish")) {
            this.count = data.get("ingredientPerDish").getAsFloat();
        }
    }

    public SauteedRecipe(ResourceLocation id, FriendlyByteBuf data) {
        super(id);
        this.allow = SerializeUtil.readList(data, Conditions::of);
        this.deny = SerializeUtil.readList(data, Conditions::of);
        this.priority = data.m_130242_();
        this.time = data.m_130242_();
        this.output = (Item)data.readRegistryIdUnsafe(ForgeRegistries.ITEMS);
        this.removeNBT = data.readBoolean();
        this.count = data.readFloat();
    }

    public SauteedRecipe(ResourceLocation id, List<IngredientCondition> allow, List<IngredientCondition> deny, int priority, int time, Item output, boolean removeNBT, float count) {
        super(id);
        this.allow = allow;
        this.deny = deny;
        this.priority = priority;
        this.time = time;
        this.output = output;
        this.removeNBT = removeNBT;
        this.count = count;
    }

    public void write(FriendlyByteBuf data) {
        SerializeUtil.writeList(data, this.allow, Conditions::write);
        SerializeUtil.writeList(data, this.deny, Conditions::write);
        data.m_130130_(this.priority);
        data.m_130130_(this.time);
        data.writeRegistryIdUnsafe(ForgeRegistries.ITEMS, (Object)this.output);
        data.writeBoolean(this.removeNBT);
        data.writeFloat(this.count);
    }

    public boolean matches(PanPendingContext ctx) {
        if (this.allow != null) {
            if (!this.allow.stream().allMatch(ctx::compute)) {
                return false;
            }
        }
        if (this.deny != null) {
            if (this.deny.stream().anyMatch(ctx::compute)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void serializeRecipeData(JsonObject json) {
        if (this.allow != null && !this.allow.isEmpty()) {
            json.add("allow", (JsonElement)SerializeUtil.toJsonList(this.allow, IngredientCondition::serialize));
        }
        if (this.deny != null && !this.deny.isEmpty()) {
            json.add("deny", (JsonElement)SerializeUtil.toJsonList(this.deny, IngredientCondition::serialize));
        }
        if (this.priority != 0) {
            json.addProperty("priority", (Number)this.priority);
        }
        json.addProperty("time", (Number)this.time);
        json.addProperty("output", Utils.getRegistryName(this.output).toString());
        if (this.removeNBT) {
            json.addProperty("removeNBT", Boolean.valueOf(this.removeNBT));
        }
        json.addProperty("ingredientPerDish", (Number)Float.valueOf(this.count));
    }

    public Stream<CookIngredients> getAllNumbers() {
        return Stream.concat(this.allow == null ? Stream.empty() : this.allow.stream().flatMap(IngredientCondition::getAllNumbers), this.deny == null ? Stream.empty() : this.deny.stream().flatMap(IngredientCondition::getAllNumbers));
    }

    public Stream<ResourceLocation> getTags() {
        return Stream.concat(this.allow == null ? Stream.empty() : this.allow.stream().flatMap(IngredientCondition::getTags), this.deny == null ? Stream.empty() : this.deny.stream().flatMap(IngredientCondition::getTags));
    }

    public int getPriority() {
        return this.priority;
    }

    @Override
    public List<IngredientCondition> getAllow() {
        return this.allow;
    }

    @Override
    public List<IngredientCondition> getDeny() {
        return this.deny;
    }
}

