/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.data;

import com.google.common.base.Stopwatch;
import com.mojang.datafixers.util.Pair;
import com.teammoeg.caupona.data.recipes.AspicMeltingRecipe;
import com.teammoeg.caupona.data.recipes.BoilingRecipe;
import com.teammoeg.caupona.data.recipes.BowlContainingRecipe;
import com.teammoeg.caupona.data.recipes.CountingTags;
import com.teammoeg.caupona.data.recipes.DissolveRecipe;
import com.teammoeg.caupona.data.recipes.DoliumRecipe;
import com.teammoeg.caupona.data.recipes.FluidFoodValueRecipe;
import com.teammoeg.caupona.data.recipes.FoodValueRecipe;
import com.teammoeg.caupona.data.recipes.SauteedRecipe;
import com.teammoeg.caupona.data.recipes.SpiceRecipe;
import com.teammoeg.caupona.data.recipes.StewCookingRecipe;
import com.teammoeg.caupona.data.recipes.baseconditions.BaseConditions;
import com.teammoeg.caupona.data.recipes.conditions.Conditions;
import com.teammoeg.caupona.data.recipes.numbers.Numbers;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecipeReloadListener
implements ResourceManagerReloadListener {
    ReloadableServerResources data;
    public static final Logger logger = LogManager.getLogger((String)"Caupona recipe generator");
    RecipeManager clientRecipeManager;
    static int generated_fv = 0;

    public RecipeReloadListener(ReloadableServerResources dpr) {
        this.data = dpr;
    }

    public void m_6213_(@Nonnull ResourceManager resourceManager) {
        RecipeReloadListener.buildRecipeLists(this.data.m_206887_());
    }

    @SubscribeEvent
    public static void onTagsUpdated(TagsUpdatedEvent event) {
        if (FoodValueRecipe.recipeset != null) {
            FoodValueRecipe.recipeset.forEach(FoodValueRecipe::clearCache);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onRecipesUpdated(RecipesUpdatedEvent event) {
        RecipeReloadListener.buildRecipeLists(event.getRecipeManager());
    }

    private static FoodValueRecipe addCookingTime(Item i, ItemStack iis, Set<Item> added, List<SmokingRecipe> irs, boolean force) {
        if (FoodValueRecipe.recipes.containsKey(i)) {
            return FoodValueRecipe.recipes.get(i);
        }
        added.add(i);
        for (SmokingRecipe sr : irs) {
            if (sr.m_7527_().size() <= 0 || !((Ingredient)sr.m_7527_().get(0)).test(iis)) continue;
            SimpleContainer fake = new SimpleContainer(3);
            fake.m_6836_(0, iis);
            ItemStack reslt = sr.m_5874_((Container)fake, (RegistryAccess)RegistryAccess.m_206165_((Registry)BuiltInRegistries.f_257047_));
            if (DissolveRecipe.recipes.stream().anyMatch(e -> e.test(reslt))) continue;
            if (added.contains(reslt.m_41720_())) break;
            FoodValueRecipe ret = RecipeReloadListener.addCookingTime(reslt.m_41720_(), reslt, added, irs, true);
            FoodProperties of = reslt.getFoodProperties(null);
            if (of != null && of.m_38744_() > ret.heal) {
                ret.effects = of.m_38749_();
                ret.heal = of.m_38744_();
                ret.sat = of.m_38745_();
                ret.setRepersent(iis);
            }
            FoodValueRecipe.recipes.put(i, ret);
            ret.processtimes.put(i, sr.m_43753_() + ret.processtimes.getOrDefault(reslt.m_41720_(), 0));
            return ret;
        }
        if (force) {
            FoodProperties of = iis.getFoodProperties(null);
            FoodValueRecipe ret = FoodValueRecipe.recipes.computeIfAbsent(i, e -> new FoodValueRecipe(new ResourceLocation("caupona", "food/generated/" + generated_fv++), 0, 0.0f, iis, (Item)e));
            if (of != null && of.m_38744_() > ret.heal) {
                ret.effects = of.m_38749_();
                ret.heal = of.m_38744_();
                ret.sat = of.m_38745_();
                ret.setRepersent(iis);
            }
            return ret;
        }
        return null;
    }

    public static void buildRecipeLists(RecipeManager recipeManager) {
        Collection recipes = recipeManager.m_44051_();
        if (recipes.size() == 0) {
            return;
        }
        logger.info("Building recipes...");
        Stopwatch sw = Stopwatch.createStarted();
        Conditions.clearCache();
        Numbers.clearCache();
        BaseConditions.clearCache();
        BowlContainingRecipe.recipes = RecipeReloadListener.filterRecipes(recipes, BowlContainingRecipe.class, BowlContainingRecipe.TYPE).collect(Collectors.toMap(e -> e.fluid, UnaryOperator.identity()));
        FoodValueRecipe.recipes = RecipeReloadListener.filterRecipes(recipes, FoodValueRecipe.class, FoodValueRecipe.TYPE).flatMap(t -> t.processtimes.keySet().stream().map(i -> new Pair(i, t))).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
        List irs = recipeManager.m_44013_(RecipeType.f_44110_);
        DissolveRecipe.recipes = RecipeReloadListener.filterRecipes(recipes, DissolveRecipe.class, DissolveRecipe.TYPE).collect(Collectors.toList());
        BoilingRecipe.recipes = RecipeReloadListener.filterRecipes(recipes, BoilingRecipe.class, BoilingRecipe.TYPE).collect(Collectors.toMap(e -> e.before, UnaryOperator.identity()));
        FluidFoodValueRecipe.recipes = RecipeReloadListener.filterRecipes(recipes, FluidFoodValueRecipe.class, FluidFoodValueRecipe.TYPE).collect(Collectors.toMap(e -> e.f, UnaryOperator.identity()));
        StewCookingRecipe.sorted = RecipeReloadListener.filterRecipes(recipes, StewCookingRecipe.class, StewCookingRecipe.TYPE).collect(Collectors.toList());
        StewCookingRecipe.sorted.sort((t2, t1) -> t1.getPriority() - t2.getPriority());
        StewCookingRecipe.cookables = StewCookingRecipe.sorted.stream().flatMap(StewCookingRecipe::getAllNumbers).collect(Collectors.toSet());
        SauteedRecipe.sorted = RecipeReloadListener.filterRecipes(recipes, SauteedRecipe.class, SauteedRecipe.TYPE).collect(Collectors.toList());
        SauteedRecipe.sorted.sort((t2, t1) -> t1.getPriority() - t2.getPriority());
        SauteedRecipe.cookables = SauteedRecipe.sorted.stream().flatMap(SauteedRecipe::getAllNumbers).collect(Collectors.toSet());
        CountingTags.tags = Stream.concat(Stream.concat(RecipeReloadListener.filterRecipes(recipes, CountingTags.class, CountingTags.TYPE).flatMap(r -> r.tag.stream()), StewCookingRecipe.sorted.stream().flatMap(StewCookingRecipe::getTags)), SauteedRecipe.sorted.stream().flatMap(SauteedRecipe::getTags)).collect(Collectors.toSet());
        DoliumRecipe.recipes = RecipeReloadListener.filterRecipes(recipes, DoliumRecipe.class, DoliumRecipe.TYPE).collect(Collectors.toList());
        DoliumRecipe.recipes.sort(((Comparator)(c1, c2) -> Integer.compare(c2.items.size(), c1.items.size())).thenComparing((c1, c2) -> Integer.compare(c2.items.stream().reduce(0, (a, b) -> a + (Integer)b.getSecond(), (a, b) -> a + b), c1.items.stream().reduce(0, (a, b) -> a + (Integer)b.getSecond(), (a, b) -> a + b))));
        AspicMeltingRecipe.recipes = RecipeReloadListener.filterRecipes(recipes, AspicMeltingRecipe.class, AspicMeltingRecipe.TYPE).collect(Collectors.toList());
        SpiceRecipe.recipes = RecipeReloadListener.filterRecipes(recipes, SpiceRecipe.class, SpiceRecipe.TYPE).collect(Collectors.toList());
        HashSet<Item> is = new HashSet<Item>();
        for (Item i : ForgeRegistries.ITEMS) {
            ItemStack iis = new ItemStack((ItemLike)i);
            if (FoodValueRecipe.recipes.containsKey(i) || DissolveRecipe.recipes.stream().anyMatch(e -> e.test(iis))) continue;
            RecipeReloadListener.addCookingTime(i, iis, is, irs, false);
        }
        FoodValueRecipe.recipeset = new HashSet<FoodValueRecipe>(FoodValueRecipe.recipes.values());
        sw.stop();
        logger.info("Recipes built, cost {}", (Object)sw);
    }

    static <R extends Recipe<?>> Stream<R> filterRecipes(Collection<Recipe<?>> recipes, Class<R> recipeClass, RegistryObject<RecipeType<Recipe<?>>> recipeType) {
        return recipes.stream().filter(iRecipe -> iRecipe.m_6671_() == recipeType.get()).map(recipeClass::cast);
    }
}

