/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.data;

import com.google.gson.JsonElement;
import com.teammoeg.caupona.data.Deserializer;
import com.teammoeg.caupona.data.Writeable;
import com.teammoeg.caupona.util.CacheMap;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;

public abstract class CachedDataDeserializer<T extends Writeable, U extends JsonElement> {
    private HashMap<String, Deserializer<U, T>> deserializers = new HashMap();
    private CacheMap<T> cache = new CacheMap();

    public void register(String name, Deserializer<U, T> des) {
        this.deserializers.put(name, des);
    }

    public void register(String name, Function<U, T> rjson, Function<FriendlyByteBuf, T> rpacket) {
        this.register(name, new Deserializer<U, T>(rjson, rpacket));
    }

    public T of(U jsonElement) {
        return (T)((Writeable)this.cache.of(this.internalOf(jsonElement)));
    }

    public Deserializer<U, T> getDeserializer(String type) {
        return this.deserializers.get(type);
    }

    protected abstract T internalOf(U var1);

    public T of(FriendlyByteBuf buffer) {
        return (T)((Writeable)this.cache.of(this.getDeserializer(buffer.m_130277_()).read(buffer)));
    }

    public void clearCache() {
        this.cache.clear();
    }
}

