/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.blocks.pan;

import com.teammoeg.caupona.CPBlockEntityTypes;
import com.teammoeg.caupona.CPBlocks;
import com.teammoeg.caupona.CPConfig;
import com.teammoeg.caupona.CPItems;
import com.teammoeg.caupona.blocks.foods.IFoodContainer;
import com.teammoeg.caupona.blocks.pan.GravyBoatBlock;
import com.teammoeg.caupona.blocks.pan.PanContainer;
import com.teammoeg.caupona.blocks.stove.IStove;
import com.teammoeg.caupona.data.recipes.FoodValueRecipe;
import com.teammoeg.caupona.data.recipes.PanPendingContext;
import com.teammoeg.caupona.data.recipes.SauteedRecipe;
import com.teammoeg.caupona.data.recipes.SpiceRecipe;
import com.teammoeg.caupona.item.DishItem;
import com.teammoeg.caupona.network.CPBaseBlockEntity;
import com.teammoeg.caupona.util.IInfinitable;
import com.teammoeg.caupona.util.SauteedFoodInfo;
import com.teammoeg.caupona.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class PanBlockEntity
extends CPBaseBlockEntity
implements MenuProvider,
IInfinitable,
IFoodContainer {
    public int process;
    public int processMax;
    public boolean working = false;
    public boolean operate = false;
    public boolean rsstate = false;
    boolean isInfinite = false;
    boolean removesNBT;
    public Item preout = Items.f_41852_;
    public ItemStack sout = ItemStack.f_41583_;
    public SauteedFoodInfo current;
    public int oamount;
    public ItemStackHandler inv = new ItemStackHandler(12){

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot < 9) {
                return SauteedRecipe.isCookable(stack);
            }
            if (slot == 9) {
                return stack.m_150930_(Items.f_42399_);
            }
            if (slot == 11) {
                return SpiceRecipe.isValid(stack);
            }
            return false;
        }

        public int getSlotLimit(int slot) {
            if (slot < 9) {
                return 1;
            }
            return super.getSlotLimit(slot);
        }
    };
    public IItemHandler bowl = new IItemHandler(){

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot < 9 || slot == 10) {
                return stack;
            }
            return PanBlockEntity.this.inv.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 9 || slot == 11) {
                return ItemStack.f_41583_;
            }
            if (slot < 9 && PanBlockEntity.this.inv.isItemValid(slot, PanBlockEntity.this.inv.getStackInSlot(slot))) {
                return ItemStack.f_41583_;
            }
            ItemStack item = PanBlockEntity.this.inv.extractItem(slot, amount, simulate);
            if (slot == 10 && !item.m_41619_() && PanBlockEntity.this.sout.m_41619_()) {
                PanBlockEntity.this.syncData();
            }
            return item;
        }

        public int getSlots() {
            return PanBlockEntity.this.inv.getSlots();
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return PanBlockEntity.this.inv.getStackInSlot(slot);
        }

        public int getSlotLimit(int slot) {
            return PanBlockEntity.this.inv.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot < 9 || slot == 10) {
                return false;
            }
            return PanBlockEntity.this.inv.isItemValid(slot, stack);
        }
    };
    RangedWrapper ingredient = new RangedWrapper((IItemHandlerModifiable)this.inv, 0, 10){

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }
    };
    LazyOptional<IItemHandler> up = LazyOptional.of(() -> this.ingredient);
    LazyOptional<IItemHandler> side = LazyOptional.of(() -> this.bowl);

    public PanBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)CPBlockEntityTypes.PAN.get(), pWorldPosition, pBlockState);
    }

    @Override
    public void handleMessage(short type, int data) {
        if (type == 0) {
            this.operate = true;
        }
        if (type == 1) {
            if (data == 1) {
                this.rsstate = false;
            } else if (data == 2) {
                this.rsstate = true;
            }
        }
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean isClient) {
        this.working = nbt.m_128471_("working");
        this.operate = nbt.m_128471_("operate");
        this.rsstate = nbt.m_128471_("rsstate");
        this.process = nbt.m_128451_("process");
        this.processMax = nbt.m_128451_("processMax");
        this.sout = nbt.m_128441_("sout") ? ItemStack.m_41712_((CompoundTag)nbt.m_128469_("sout")) : ItemStack.f_41583_;
        this.inv.deserializeNBT(nbt.m_128469_("items"));
        if (!isClient) {
            this.isInfinite = nbt.m_128471_("inf");
            this.oamount = nbt.m_128451_("amount");
            this.current = nbt.m_128441_("cur") ? new SauteedFoodInfo(nbt.m_128469_("cur")) : null;
            this.removesNBT = nbt.m_128471_("removeNbt");
        }
        this.preout = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(nbt.m_128461_("out")));
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean isClient) {
        nbt.m_128379_("working", this.working);
        nbt.m_128379_("operate", this.operate);
        nbt.m_128379_("rsstate", this.rsstate);
        nbt.m_128405_("process", this.process);
        nbt.m_128405_("processMax", this.processMax);
        nbt.m_128365_("sout", (Tag)this.sout.serializeNBT());
        nbt.m_128365_("items", (Tag)this.inv.serializeNBT());
        if (!isClient) {
            nbt.m_128405_("amount", this.oamount);
            nbt.m_128379_("inf", this.isInfinite);
            if (this.current != null) {
                nbt.m_128365_("cur", (Tag)this.current.save());
            }
            nbt.m_128379_("removeNbt", this.removesNBT);
        }
        nbt.m_128359_("out", Utils.getRegistryName(this.preout).toString());
    }

    private ItemStack tryAddSpice(ItemStack fs) {
        ItemStack ospi;
        ItemStack spi = ospi = this.inv.getStackInSlot(11);
        SpiceRecipe spice = SpiceRecipe.find(spi);
        if (this.m_58900_().m_60713_((Block)CPBlocks.LEAD_PAN.get()) && spice != null && spice.canReactLead) {
            spi = CPItems.getSapa();
            spice = SpiceRecipe.find(spi);
        }
        if (spice != null && SpiceRecipe.getMaxUse(ospi) >= fs.m_41613_()) {
            SauteedFoodInfo si = DishItem.getInfo(fs);
            if (!this.isInfinite) {
                this.inv.setStackInSlot(11, SpiceRecipe.handle(ospi, fs.m_41613_()));
            }
            si.addSpice(spice.effect, spi);
            DishItem.setInfo(fs, si);
        }
        return fs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void tick() {
        if (this.f_58857_.f_46443_) return;
        this.working = false;
        if (this.processMax > 0) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_7495_());
            if (!(blockEntity instanceof IStove)) return;
            IStove stove = (IStove)blockEntity;
            int rh = stove.requestHeat();
            this.process += rh;
            if (rh > 0) {
                this.working = true;
                this.syncData();
            }
            if (this.process < this.processMax) return;
            this.process = 0;
            this.processMax = 0;
            this.doWork();
            this.m_6596_();
            return;
        } else if (!this.sout.m_41619_()) {
            this.operate = false;
            if (!this.inv.getStackInSlot(10).m_41619_()) return;
            if (!this.isInfinite) {
                this.inv.setStackInSlot(10, this.tryAddSpice(this.sout.m_41620_(1)));
            } else {
                this.inv.setStackInSlot(10, this.tryAddSpice(ItemHandlerHelper.copyStackWithSize((ItemStack)this.sout, (int)1)));
            }
            this.m_6596_();
            return;
        } else {
            this.prepareWork();
        }
    }

    private void prepareWork() {
        if (this.rsstate && !this.operate && this.f_58857_.m_276867_(this.f_58858_)) {
            this.operate = true;
        }
        if (this.operate) {
            IStove stove;
            this.operate = false;
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_7495_());
            if (!(blockEntity instanceof IStove) || !(stove = (IStove)blockEntity).canEmitHeat()) {
                return;
            }
            this.make();
        }
    }

    private void doWork() {
        ItemStack is = new ItemStack((ItemLike)this.preout, this.oamount);
        if (!this.removesNBT) {
            DishItem.setInfo(is, this.current);
        }
        this.removesNBT = false;
        this.current = null;
        this.oamount = 0;
        this.preout = Items.f_41852_;
        this.sout = is;
    }

    private void make() {
        ItemStack is;
        int itms = 0;
        for (int i = 0; i < 9; ++i) {
            Direction[] is2 = this.inv.getStackInSlot(i);
            if (is2.m_41619_()) continue;
            if (SauteedRecipe.isCookable((ItemStack)is2)) {
                ++itms;
                continue;
            }
            return;
        }
        if (itms <= 0) {
            return;
        }
        BlockPos oilProvidingPos = null;
        for (Direction d : Utils.horizontals) {
            int oil;
            BlockPos bp = this.m_58899_().m_121945_(d);
            BlockState bs = this.m_58904_().m_8055_(bp);
            if (!bs.m_60713_((Block)CPBlocks.GRAVY_BOAT.get()) || (oil = GravyBoatBlock.getOil(bs)) <= 0) continue;
            oilProvidingPos = bp;
            break;
        }
        if (oilProvidingPos == null) {
            return;
        }
        if (this.inv.getStackInSlot(9).m_41619_()) {
            return;
        }
        NonNullList interninv = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
        block2: for (int i = 0; i < 9; ++i) {
            ItemStack is3 = this.inv.getStackInSlot(i);
            if (is3.m_41619_()) continue;
            for (int j = 0; j < 9; ++j) {
                ItemStack ois = (ItemStack)interninv.get(j);
                if (ois.m_41619_()) {
                    interninv.set(j, (Object)is3.m_41777_());
                    continue block2;
                }
                if (!ItemStack.m_150942_((ItemStack)ois, (ItemStack)is3)) continue;
                ois.m_41764_(ois.m_41613_() + is3.m_41613_());
                continue block2;
            }
        }
        int tpt = 0;
        SauteedFoodInfo current = new SauteedFoodInfo();
        for (int i = 0; i < 9 && !(is = (ItemStack)interninv.get(i)).m_41619_(); ++i) {
            current.addItem(is);
            FoodValueRecipe fvr = FoodValueRecipe.recipes.get(is.m_41720_());
            if (fvr == null) continue;
            tpt += fvr.processtimes.getOrDefault(is.m_41720_(), 0).intValue();
        }
        interninv.clear();
        current.completeAll();
        current.recalculateHAS();
        PanPendingContext ctx = new PanPendingContext(current);
        float tcount = 0.0f;
        Item preout = Items.f_41852_;
        int processMax = 0;
        boolean removesNBT = false;
        for (SauteedRecipe cr : SauteedRecipe.sorted) {
            if (!cr.matches(ctx)) continue;
            processMax = Math.max(cr.time, tpt);
            preout = cr.output;
            removesNBT = cr.removeNBT;
            tcount = cr.count;
            break;
        }
        if (preout == Items.f_41852_) {
            return;
        }
        if (tcount <= 0.0f) {
            tcount = 2.0f;
        }
        int cook = Mth.m_14167_((float)((float)itms / tcount));
        if (this.inv.getStackInSlot(9).m_41613_() < cook) {
            return;
        }
        GravyBoatBlock.drawOil(this.m_58904_(), oilProvidingPos, 1);
        for (int i = 0; i < 9; ++i) {
            ItemStack is4 = this.inv.getStackInSlot(i);
            if (is4.m_41619_()) continue;
            this.inv.setStackInSlot(i, is4.getCraftingRemainingItem());
        }
        this.process = 0;
        this.processMax = 0;
        tpt = Math.max((Integer)CPConfig.SERVER.fryTimeBase.get(), tpt);
        current.setParts(cook);
        current.completeAll();
        current.recalculateHAS();
        this.current = current;
        this.preout = preout;
        this.processMax = processMax;
        this.removesNBT = removesNBT;
        this.inv.getStackInSlot(9).m_41774_(cook);
        this.oamount = cook;
        if (this.m_58900_().m_60713_((Block)CPBlocks.STONE_PAN.get())) {
            tpt *= 2;
        }
        processMax = tpt;
        this.syncData();
    }

    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new PanContainer(pContainerId, pInventory, this);
    }

    public Component m_5446_() {
        return Utils.translate("container.caupona.pan.title");
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == Direction.UP) {
                return this.up.cast();
            }
            return this.side.cast();
        }
        return super.getCapability(cap, side);
    }

    public ItemStackHandler getInv() {
        return this.inv;
    }

    @Override
    public boolean setInfinity() {
        this.isInfinite = !this.isInfinite;
        return this.isInfinite;
    }

    @Override
    public ItemStack getInternal(int num) {
        ItemStack result = this.inv.extractItem(10, 1, true);
        return result;
    }

    @Override
    public void setInternal(int num, ItemStack is) {
        this.inv.extractItem(10, 1, false);
        is = this.inv.insertItem(9, is, false);
        this.syncData();
        Utils.dropToWorld(this.m_58904_(), is, this.m_58899_());
    }

    @Override
    public int getSlots() {
        return 1;
    }

    @Override
    public boolean accepts(int num, ItemStack is) {
        return is.m_150930_(Items.f_42399_);
    }
}

