/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.blocks.hypocaust;

import com.teammoeg.caupona.CPBlockEntityTypes;
import com.teammoeg.caupona.CPConfig;
import com.teammoeg.caupona.CPTags;
import com.teammoeg.caupona.blocks.hypocaust.BathHeatingBlockEntity;
import com.teammoeg.caupona.blocks.stove.IStove;
import com.teammoeg.caupona.util.LazyTickWorker;
import com.teammoeg.caupona.util.Utils;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class FireboxBlockEntity
extends BathHeatingBlockEntity {
    LazyTickWorker process;
    int heat;
    private int r;

    public FireboxBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)CPBlockEntityTypes.HYPOCAUST_FIREBOX.get(), pWorldPosition, pBlockState);
        this.r = (Integer)CPConfig.SERVER.bathRange.get();
        this.process = new LazyTickWorker(Mth.m_14167_((float)((float)((Integer)CPConfig.SERVER.bathPath.get()).intValue() / 2.0f)), () -> {
            Set<BlockPos> pss = this.getAll();
            for (BlockPos pos : pss) {
                BlockEntity patt2051$temp = this.f_58857_.m_7702_(pos);
                if (!(patt2051$temp instanceof BathHeatingBlockEntity)) continue;
                BathHeatingBlockEntity bath = (BathHeatingBlockEntity)patt2051$temp;
                bath.setHeat(this.heat);
            }
            return true;
        });
    }

    @Override
    public void handleMessage(short type, int data) {
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean isClient) {
        super.readCustomNBT(nbt, isClient);
        this.heat = nbt.m_128451_("heatSpeed");
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean isClient) {
        super.writeCustomNBT(nbt, isClient);
        nbt.m_128405_("heatSpeed", this.heat);
    }

    private boolean dist(BlockPos crn, BlockPos orig) {
        return Mth.m_14040_((int)(crn.m_123341_() - orig.m_123341_())) <= this.r && Mth.m_14040_((int)(crn.m_123343_() - orig.m_123343_())) <= this.r;
    }

    public void findNext(Level l, BlockPos crn, BlockPos orig, Set<BlockPos> pos) {
        if (this.dist(crn, orig) && pos.add(crn)) {
            for (Direction dir : Utils.horizontals) {
                BlockPos act = crn.m_121945_(dir);
                if (!l.m_46749_(act) || !l.m_8055_(act).m_204336_(CPTags.Blocks.HYPOCAUST_HEAT_CONDUCTOR)) continue;
                this.findNext(l, act, orig, pos);
            }
        }
    }

    public Set<BlockPos> getAll() {
        HashSet<BlockPos> poss = new HashSet<BlockPos>();
        this.findNext(this.m_58904_(), this.m_58899_(), this.m_58899_(), poss);
        return poss;
    }

    @Override
    public void tick() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_7495_());
        if (blockEntity instanceof IStove) {
            IStove stove = (IStove)blockEntity;
            int nh = stove.requestHeat();
            if (this.heat != nh) {
                this.process.enqueue();
                this.heat = nh;
            }
        } else if (this.heat != 0) {
            this.process.enqueue();
            this.heat = 0;
        }
        this.process.tick();
        this.m_6596_();
        super.tick();
    }

    @Override
    public int getHeat() {
        return Math.max(((BathHeatingBlockEntity)this).heat, this.heat);
    }
}

