/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona;

import com.teammoeg.caupona.CPBlockEntityTypes;
import com.teammoeg.caupona.CPCommonBootStrap;
import com.teammoeg.caupona.CPItems;
import com.teammoeg.caupona.CPWorldGen;
import com.teammoeg.caupona.blocks.CPHorizontalBlock;
import com.teammoeg.caupona.blocks.decoration.BaseColumnBlock;
import com.teammoeg.caupona.blocks.decoration.CPButtonBlock;
import com.teammoeg.caupona.blocks.decoration.CPDoorBlock;
import com.teammoeg.caupona.blocks.decoration.CPPressurePlateBlock;
import com.teammoeg.caupona.blocks.decoration.CPRoadBlock;
import com.teammoeg.caupona.blocks.decoration.CPRoadSideBlock;
import com.teammoeg.caupona.blocks.decoration.CPStandingSignBlock;
import com.teammoeg.caupona.blocks.decoration.CPTrapDoorBlock;
import com.teammoeg.caupona.blocks.decoration.CPWallSignBlock;
import com.teammoeg.caupona.blocks.decoration.ChimneyFluteBlock;
import com.teammoeg.caupona.blocks.decoration.ColumnCapitalBlock;
import com.teammoeg.caupona.blocks.decoration.LacunarBlock;
import com.teammoeg.caupona.blocks.decoration.SpokedFenceBlock;
import com.teammoeg.caupona.blocks.decoration.mosaic.MosaicBlock;
import com.teammoeg.caupona.blocks.decoration.mosaic.MosaicItem;
import com.teammoeg.caupona.blocks.decoration.mosaic.TessellationWorkBenchBlock;
import com.teammoeg.caupona.blocks.dolium.CounterDoliumBlock;
import com.teammoeg.caupona.blocks.foods.BowlBlock;
import com.teammoeg.caupona.blocks.foods.DishBlock;
import com.teammoeg.caupona.blocks.fumarole.FumaroleBoulderBlock;
import com.teammoeg.caupona.blocks.fumarole.FumaroleVentBlock;
import com.teammoeg.caupona.blocks.fumarole.PumiceBloomBlock;
import com.teammoeg.caupona.blocks.hypocaust.CaliductBlock;
import com.teammoeg.caupona.blocks.hypocaust.FireboxBlock;
import com.teammoeg.caupona.blocks.hypocaust.WolfStatueBlock;
import com.teammoeg.caupona.blocks.pan.GravyBoatBlock;
import com.teammoeg.caupona.blocks.pan.PanBlock;
import com.teammoeg.caupona.blocks.plants.BushLogBlock;
import com.teammoeg.caupona.blocks.plants.CPStripPillerBlock;
import com.teammoeg.caupona.blocks.plants.FruitBlock;
import com.teammoeg.caupona.blocks.plants.FruitsLeavesBlock;
import com.teammoeg.caupona.blocks.plants.SilphiumBlock;
import com.teammoeg.caupona.blocks.plants.SnailBaitBlock;
import com.teammoeg.caupona.blocks.plants.SnailBlock;
import com.teammoeg.caupona.blocks.plants.WalnutFruitBlock;
import com.teammoeg.caupona.blocks.pot.StewPot;
import com.teammoeg.caupona.blocks.stove.ChimneyPotBlock;
import com.teammoeg.caupona.blocks.stove.KitchenStove;
import com.teammoeg.caupona.blocks.stove.KitchenStoveBlockEntity;
import com.teammoeg.caupona.item.CPBlockItem;
import com.teammoeg.caupona.item.CPSignItem;
import com.teammoeg.caupona.item.DishItem;
import com.teammoeg.caupona.util.MaterialType;
import com.teammoeg.caupona.util.TabType;
import com.teammoeg.caupona.worldgen.DefaultTreeGrower;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class CPBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"caupona");
    public static final String[] woods = new String[]{"walnut"};
    public static final MaterialType[] all_materials = new MaterialType[]{new MaterialType("mud").makeCounter(1), new MaterialType("stone_brick").makeCounter(2).makeHypocaust(), new MaterialType("stone").setBase(() -> Blocks.f_50069_.m_49966_()).makePillar().makeRoad(), new MaterialType("sandstone").setBase(() -> Blocks.f_50062_.m_49966_()).makeRoad(), new MaterialType("brick").makeCounter(2).makeHypocaust(), new MaterialType("mixed_bricks").makeDecoration(), new MaterialType("opus_incertum").makeCounter(2).makeDecoration().makeHypocaust(), new MaterialType("opus_latericium").makeCounter(2).makeDecoration().makeHypocaust(), new MaterialType("opus_reticulatum").makeDecoration(), new MaterialType("felsic_tuff_bricks").makeDecoration(), new MaterialType("felsic_tuff").makeDecoration().makePillar().makeRoad(), new MaterialType("polished_felsic_tuff").makeDecoration(), new MaterialType("quartz").makePillar(), new MaterialType("calcite").makePillar()};
    public static final List<RegistryObject<KitchenStove>> stoves = new ArrayList<RegistryObject<KitchenStove>>();
    public static final List<Block> signs = new ArrayList<Block>();
    public static final Map<String, RegistryObject<Block>> stoneBlocks = new HashMap<String, RegistryObject<Block>>();
    public static final List<Block> chimney = new ArrayList<Block>();
    public static final List<Block> dolium = new ArrayList<Block>();
    public static final List<Block> dishes = new ArrayList<Block>();
    public static final List<Block> caliduct = new ArrayList<Block>();
    public static final List<Block> firebox = new ArrayList<Block>();
    public static final List<RegistryObject<Block>> leaves = new ArrayList<RegistryObject<Block>>();
    public static final RegistryObject<FumaroleBoulderBlock> FUMAROLE_BOULDER = CPBlocks.decoblock("fumarole_boulder", () -> new FumaroleBoulderBlock(CPBlocks.getStoneProps().m_60971_(CPBlocks::isntSolid).m_60955_().m_60960_(CPBlocks::isntSolid)));
    public static final RegistryObject<FumaroleVentBlock> FUMAROLE_VENT = CPBlocks.maindecoblock("fumarole_vent", () -> new FumaroleVentBlock(CPBlocks.getStoneProps().m_60913_(4.5f, 10.0f).m_60971_(CPBlocks::isntSolid).m_60955_().m_60960_(CPBlocks::isntSolid)));
    public static final RegistryObject<Block> PUMICE = CPBlocks.block("pumice", CPBlocks.getStoneProps(), TabType.DECORATION);
    public static final RegistryObject<PumiceBloomBlock> PUMICE_BLOOM = CPBlocks.maindecoblock("pumice_bloom", () -> new PumiceBloomBlock(CPBlocks.getStoneProps().m_60955_()));
    public static final RegistryObject<GravyBoatBlock> GRAVY_BOAT = BLOCKS.register("gravy_boat", () -> new GravyBoatBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56744_).m_60966_().m_60955_().m_60960_(CPBlocks::isntSolid).m_60971_(CPBlocks::isntSolid)));
    public static final BlockSetType WALNUT_TYPE = new BlockSetType("walnut");
    public static final WoodType WALNUT = WoodType.m_61844_((WoodType)new WoodType("caupona:walnut", WALNUT_TYPE));
    public static final RegistryObject<WolfStatueBlock> WOLF = CPBlocks.maindecoblock("wolf_statue", () -> new WolfStatueBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60918_(SoundType.f_154663_).m_60999_().m_60913_(3.5f, 10.0f).m_60955_()));
    public static final RegistryObject<PanBlock> STONE_PAN = CPBlocks.mainblock("stone_griddle", () -> new PanBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60918_(SoundType.f_56742_).m_60913_(3.5f, 10.0f).m_60955_()));
    public static final RegistryObject<TessellationWorkBenchBlock> T_BENCH = CPBlocks.mainblock("tessellation_workbench", () -> new TessellationWorkBenchBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283919_).m_60918_(SoundType.f_56742_).m_60913_(3.5f, 10.0f).m_60955_().m_60999_()));
    public static final RegistryObject<PanBlock> COPPER_PAN = CPBlocks.mainblock("copper_frying_pan", () -> new PanBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60918_(SoundType.f_154663_).m_60913_(3.5f, 10.0f).m_60955_()));
    public static final RegistryObject<PanBlock> IRON_PAN = CPBlocks.mainblock("iron_frying_pan", () -> new PanBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60918_(SoundType.f_56743_).m_60913_(3.5f, 10.0f).m_60955_()));
    public static final RegistryObject<PanBlock> LEAD_PAN = CPBlocks.mainblock("lead_frying_pan", () -> new PanBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60918_(SoundType.f_56743_).m_60913_(3.5f, 10.0f).m_60955_()));
    public static final RegistryObject<DishBlock> DISH = BLOCKS.register("dish", () -> new DishBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56736_).m_60966_().m_60955_().m_60924_(CPBlocks::isntSolid).m_60960_(CPBlocks::isntSolid).m_60971_(CPBlocks::isntSolid)));
    public static final RegistryObject<StewPot> STEW_POT = CPBlocks.mainblock("stew_pot", () -> new StewPot(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283750_).m_60918_(SoundType.f_56742_).m_60999_().m_60913_(3.5f, 10.0f).m_60955_(), CPBlockEntityTypes.STEW_POT));
    public static final RegistryObject<StewPot> STEW_POT_LEAD = CPBlocks.mainblock("lead_stew_pot", () -> new StewPot(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283750_).m_60918_(SoundType.f_56742_).m_60999_().m_60913_(3.5f, 10.0f).m_60955_(), CPBlockEntityTypes.STEW_POT));
    public static final RegistryObject<BowlBlock> BOWL = BLOCKS.register("bowl", () -> new BowlBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56736_).m_60966_().m_60955_().m_60924_(CPBlocks::isntSolid).m_60960_(CPBlocks::isntSolid).m_60971_(CPBlocks::isntSolid), CPBlockEntityTypes.BOWL));
    public static final RegistryObject<MosaicBlock> MOSAIC = CPBlocks.baseblock("mosaic", () -> new MosaicBlock(CPBlocks.getStoneProps()), b -> new MosaicItem(CPItems.createProps()));
    public static final RegistryObject<SilphiumBlock> SILPHIUM = CPBlocks.mainblock("silphium_block", () -> new SilphiumBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_280170_().m_60910_().m_60966_().m_60918_(SoundType.f_56740_).m_222979_(BlockBehaviour.OffsetType.XZ).m_278183_().m_278166_(PushReaction.DESTROY)));
    public static final RegistryObject<Block> WALNUT_FRUIT = CPBlocks.mainblock("walnut_fruits", () -> new WalnutFruitBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60910_().m_60977_().m_222979_(BlockBehaviour.OffsetType.XZ).m_60966_().m_60918_(SoundType.f_56758_).m_278183_()));
    public static final RegistryObject<Block> SNAIL_MUCUS = CPBlocks.block("snail_mucus", BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60977_().m_60966_().m_60918_(SoundType.f_56758_).m_60955_().m_60971_(CPBlocks::isntSolid), TabType.MAIN_AND_DECORATION);
    public static final RegistryObject<SnailBlock> SNAIL = CPBlocks.baseblock("snail_block", () -> new SnailBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60910_().m_60977_().m_222979_(BlockBehaviour.OffsetType.XZ).m_60966_().m_60918_(SoundType.f_56758_).m_60971_(CPBlocks::isntSolid)), x -> new CPBlockItem((Block)x, CPItems.createProps(), TabType.MAIN));
    public static final RegistryObject<SnailBaitBlock> SNAIL_BAIT = CPBlocks.baseblock("snail_bait", () -> new SnailBaitBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60910_().m_60977_().m_222979_(BlockBehaviour.OffsetType.XZ).m_60966_().m_60918_(SoundType.f_56758_).m_60971_(CPBlocks::isntSolid)), x -> new CPBlockItem((Block)x, CPItems.createProps(), TabType.MAIN));
    public static final RegistryObject<Block> LEAD_BLOCK = CPBlocks.block("lead_block", BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60918_(SoundType.f_56743_).m_60913_(3.5f, 10.0f).m_60999_(), TabType.DECORATION);

    private static void registerBush(String wood, Supplier<AbstractTreeGrower> growth) {
        CPBlocks.decoblock(wood + "_log", () -> new BushLogBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60978_(2.0f).m_60955_().m_60918_(SoundType.f_56736_)));
        RegistryObject<Block> a = CPBlocks.decoblock(wood + "_fruits", () -> new FruitBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_222979_(BlockBehaviour.OffsetType.XZ).m_60910_().m_60977_().m_60966_().m_60918_(SoundType.f_56758_)));
        leaves.add(CPCommonBootStrap.asCompositable(CPBlocks.decoblock(wood + "_leaves", () -> CPBlocks.leaves(SoundType.f_56740_, a)), 0.3f));
        CPCommonBootStrap.asCompositable(CPBlocks.maindecoblock(wood + "_sapling", () -> new SaplingBlock((AbstractTreeGrower)growth.get(), BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60910_().m_60977_().m_60966_().m_60918_(SoundType.f_56740_))), 0.3f);
    }

    private static void registerWood(String wood, WoodType wt, Supplier<AbstractTreeGrower> growth, RegistryObject<Block> f) {
        RegistryObject<Block> planks = CPCommonBootStrap.asFlamable(CPBlocks.block(wood + "_planks", BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_278183_(), TabType.DECORATION), 5, 20);
        CPBlocks.decoblock(wood + "_button", () -> new CPButtonBlock(BlockBehaviour.Properties.m_284310_().m_60910_().m_60978_(0.5f).m_60918_(SoundType.f_56736_).m_278183_(), WALNUT_TYPE, 30, true));
        CPBlocks.decoblock(wood + "_door", () -> new CPDoorBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60978_(3.0f).m_60918_(SoundType.f_56736_).m_60955_().m_278183_(), WALNUT_TYPE));
        CPCommonBootStrap.asFlamable(CPBlocks.decoblock(wood + "_fence", () -> new FenceBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_278183_())), 5, 20);
        CPCommonBootStrap.asFlamable(CPBlocks.decoblock(wood + "_fence_gate", () -> new FenceGateBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_278183_(), WALNUT)), 5, 20);
        leaves.add(CPCommonBootStrap.asCompositable(CPBlocks.decoblock(wood + "_leaves", () -> CPBlocks.leaves(SoundType.f_56740_, f)), 0.3f));
        RegistryObject<Block> sl = CPCommonBootStrap.asFlamable(CPBlocks.decoblock("stripped_" + wood + "_log", () -> CPBlocks.log(null)), 5, 5);
        CPCommonBootStrap.asFlamable(CPBlocks.decoblock(wood + "_log", () -> CPBlocks.log(sl)), 5, 5);
        CPBlocks.decoblock(wood + "_pressure_plate", () -> new CPPressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60910_().m_60978_(0.5f).m_60918_(SoundType.f_56736_).m_278183_(), WALNUT_TYPE));
        CPCommonBootStrap.asCompositable(CPBlocks.maindecoblock(wood + "_sapling", () -> new SaplingBlock((AbstractTreeGrower)growth.get(), BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60910_().m_60977_().m_60966_().m_60918_(SoundType.f_56740_).m_278183_())), 0.3f);
        RegistryObject s = BLOCKS.register(wood + "_sign", () -> new CPStandingSignBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60910_().m_60978_(1.0f).m_60918_(SoundType.f_56736_).m_278183_(), wt));
        RegistryObject ws = BLOCKS.register(wood + "_wall_sign", () -> new CPWallSignBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60910_().m_60978_(1.0f).m_60918_(SoundType.f_56736_).m_278183_(), wt));
        CPItems.ITEMS.register(wood + "_sign", () -> new CPSignItem(new Item.Properties().m_41487_(16), (Block)s.get(), (Block)ws.get(), TabType.DECORATION));
        CPCommonBootStrap.asFlamable(CPBlocks.decoblock(wood + "_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_278183_())), 5, 20);
        CPCommonBootStrap.asFlamable(CPBlocks.decoblock(wood + "_stairs", () -> new StairBlock(() -> ((Block)((Block)planks.get())).m_49966_(), BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_))), 5, 20);
        CPBlocks.decoblock(wood + "_trapdoor", () -> new CPTrapDoorBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60978_(3.0f).m_60918_(SoundType.f_56736_).m_60955_().m_60922_(CPBlocks::never).m_278183_(), WALNUT_TYPE));
        RegistryObject<Block> sw = CPCommonBootStrap.asFlamable(CPBlocks.decoblock("stripped_" + wood + "_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_278183_())), 5, 5);
        CPCommonBootStrap.asFlamable(CPBlocks.decoblock(wood + "_wood", () -> new CPStripPillerBlock(sw, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_278183_())), 5, 5);
    }

    static RegistryObject<KitchenStove> stove(String name, BlockBehaviour.Properties props, RegistryObject<BlockEntityType<KitchenStoveBlockEntity>> tile) {
        RegistryObject bl = BLOCKS.register(name, () -> new KitchenStove(props, tile));
        stoves.add((RegistryObject<KitchenStove>)bl);
        CPItems.ITEMS.register(name, () -> new CPBlockItem((Block)bl.get(), CPItems.createProps(), TabType.MAIN_AND_DECORATION));
        return bl;
    }

    static <T extends Block> RegistryObject<T> mainblock(String name, Supplier<T> bl) {
        RegistryObject blx = BLOCKS.register(name, bl);
        CPItems.ITEMS.register(name, () -> new CPBlockItem((Block)blx.get(), CPItems.createProps(), TabType.MAIN));
        return blx;
    }

    static <T extends Block> RegistryObject<T> decoblock(String name, Supplier<T> bl) {
        RegistryObject blx = BLOCKS.register(name, bl);
        CPItems.ITEMS.register(name, () -> new CPBlockItem((Block)blx.get(), CPItems.createProps(), TabType.DECORATION));
        return blx;
    }

    static <T extends Block> RegistryObject<T> maindecoblock(String name, Supplier<T> bl) {
        RegistryObject blx = BLOCKS.register(name, bl);
        CPItems.ITEMS.register(name, () -> new CPBlockItem((Block)blx.get(), CPItems.createProps(), TabType.MAIN_AND_DECORATION));
        return blx;
    }

    static <T extends Block> RegistryObject<T> baseblock(String name, Supplier<T> bl, Function<T, Item> toitem) {
        RegistryObject blx = BLOCKS.register(name, bl);
        CPItems.ITEMS.register(name, () -> (Item)toitem.apply((Block)blx.get()));
        return blx;
    }

    static RegistryObject<Block> block(String name, BlockBehaviour.Properties props, TabType tab) {
        RegistryObject blx = BLOCKS.register(name, () -> new Block(props));
        CPItems.ITEMS.register(name, () -> new CPBlockItem((Block)blx.get(), CPItems.createProps(), tab));
        return blx;
    }

    private static LeavesBlock leaves(SoundType p_152615_, RegistryObject<Block> fruit) {
        return new FruitsLeavesBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60978_(0.2f).m_60977_().m_60918_(p_152615_).m_60955_().m_60922_(CPBlocks::ocelotOrParrot).m_60960_(CPBlocks::isntSolid).m_60971_(CPBlocks::isntSolid).m_278183_(), fruit);
    }

    private static RotatedPillarBlock log(RegistryObject<Block> st) {
        if (st == null) {
            return new RotatedPillarBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_278183_());
        }
        return new CPStripPillerBlock(st, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_278183_());
    }

    private static BlockBehaviour.Properties getStoneProps() {
        return BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60918_(SoundType.f_56742_).m_60999_().m_60913_(2.0f, 6.0f);
    }

    private static BlockBehaviour.Properties getStoveProps() {
        return BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60918_(SoundType.f_56742_).m_60999_().m_60913_(3.5f, 10.0f).m_60955_().m_60953_(s -> (Boolean)s.m_61143_((Property)KitchenStove.LIT) != false ? 9 : 0).m_60924_(CPBlocks::isntSolid).m_60960_(CPBlocks::isntSolid);
    }

    private static BlockBehaviour.Properties getTransparentProps() {
        return BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_60999_().m_60913_(3.5f, 10.0f).m_60955_();
    }

    private static boolean isntSolid(BlockState state, BlockGetter reader, BlockPos pos) {
        return false;
    }

    private static Boolean never(BlockState p_50779_, BlockGetter p_50780_, BlockPos p_50781_, EntityType<?> p_50782_) {
        return false;
    }

    private static Boolean ocelotOrParrot(BlockState p_50822_, BlockGetter p_50823_, BlockPos p_50824_, EntityType<?> p_50825_) {
        return p_50825_ == EntityType.f_20505_ || p_50825_ == EntityType.f_20508_;
    }

    static {
        for (MaterialType type : all_materials) {
            String name = type.getName();
            if (type.isDecorationMaterial()) {
                RegistryObject<Block> base = CPBlocks.block(name, CPBlocks.getStoneProps(), TabType.DECORATION);
                stoneBlocks.put(name, base);
                type.setBase(() -> ((Block)base.get()).m_49966_());
                CPBlocks.decoblock(name + "_slab", () -> new SlabBlock(CPBlocks.getStoneProps()));
                CPBlocks.decoblock(name + "_stairs", () -> new StairBlock(type.getBase(), CPBlocks.getStoneProps()));
                CPBlocks.decoblock(name + "_wall", () -> new WallBlock(CPBlocks.getStoneProps()));
            }
            if (type.isCounterMaterial()) {
                CPBlocks.stove(name + "_kitchen_stove", CPBlocks.getStoveProps(), type.getCounterGrade() == 1 ? CPBlockEntityTypes.STOVE_T1 : CPBlockEntityTypes.STOVE_T2);
                CPBlocks.maindecoblock(name + "_chimney_flue", () -> new ChimneyFluteBlock(CPBlocks.getTransparentProps()));
                CPBlocks.maindecoblock(name + "_chimney_pot", () -> new ChimneyPotBlock(CPBlocks.getTransparentProps()));
                CPBlocks.decoblock(name + "_counter", () -> new CPHorizontalBlock(CPBlocks.getStoneProps()));
                CPBlocks.maindecoblock(name + "_counter_with_dolium", () -> new CounterDoliumBlock(CPBlocks.getTransparentProps()));
            }
            if (type.isHypocaustMaterial()) {
                CPBlocks.mainblock(name + "_caliduct", () -> new CaliductBlock(CPBlocks.getTransparentProps()));
                CPBlocks.mainblock(name + "_hypocaust_firebox", () -> new FireboxBlock(CPBlocks.getTransparentProps()));
            }
            if (type.isPillarMaterial()) {
                CPBlocks.decoblock(name + "_column_fluted_plinth", () -> new BaseColumnBlock(CPBlocks.getTransparentProps().m_60913_(2.0f, 6.0f), true));
                CPBlocks.decoblock(name + "_column_fluted_shaft", () -> new BaseColumnBlock(CPBlocks.getTransparentProps().m_60913_(2.0f, 6.0f), false));
                CPBlocks.decoblock(name + "_column_shaft", () -> new BaseColumnBlock(CPBlocks.getTransparentProps().m_60913_(2.0f, 6.0f), false));
                CPBlocks.decoblock(name + "_column_plinth", () -> new BaseColumnBlock(CPBlocks.getTransparentProps().m_60913_(2.0f, 6.0f), true));
                CPBlocks.decoblock(name + "_ionic_column_capital", () -> new ColumnCapitalBlock(CPBlocks.getTransparentProps().m_60913_(2.0f, 6.0f), true));
                CPBlocks.decoblock(name + "_tuscan_column_capital", () -> new ColumnCapitalBlock(CPBlocks.getTransparentProps().m_60913_(2.0f, 6.0f), false));
                CPBlocks.decoblock(name + "_acanthine_column_capital", () -> new ColumnCapitalBlock(CPBlocks.getTransparentProps().m_60913_(2.0f, 6.0f), true));
                CPBlocks.decoblock(name + "_lacunar_tile", () -> new LacunarBlock(CPBlocks.getTransparentProps().m_60913_(2.0f, 6.0f).m_60971_(CPBlocks::isntSolid)));
                CPBlocks.decoblock(name + "_spoked_fence", () -> new SpokedFenceBlock(CPBlocks.getTransparentProps().m_60913_(2.0f, 6.0f)));
            }
            if (!type.isRoadMaterial()) continue;
            CPBlocks.decoblock(name + "_road_side", () -> new CPRoadSideBlock(CPBlocks.getTransparentProps().m_60924_(CPBlocks::isntSolid).m_60960_(CPBlocks::isntSolid).m_60913_(2.0f, 6.0f)));
            CPBlocks.decoblock(name + "_road", () -> new CPRoadBlock(CPBlocks.getTransparentProps().m_60924_(CPBlocks::isntSolid).m_60960_(CPBlocks::isntSolid).m_60913_(2.0f, 6.0f)));
        }
        CPBlocks.registerWood("walnut", WALNUT, DefaultTreeGrower.supply(CPWorldGen.WALNUT), WALNUT_FRUIT);
        CPBlocks.registerBush("fig", DefaultTreeGrower.supply(CPWorldGen.FIG));
        CPBlocks.registerBush("wolfberry", DefaultTreeGrower.supply(CPWorldGen.WOLFBERRY));
        for (String s : CPItems.dishes) {
            CPBlocks.baseblock(s, () -> new DishBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56736_).m_60966_().m_60955_().m_60924_(CPBlocks::isntSolid).m_60960_(CPBlocks::isntSolid).m_60971_(CPBlocks::isntSolid)), b -> new DishItem((DishBlock)b, CPItems.createSoupProps()));
        }
    }
}

