/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.fabric.api.permissions.v0;

import com.mojang.authlib.GameProfile;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import me.lucko.fabric.api.permissions.v0.OfflinePermissionCheckEvent;
import me.lucko.fabric.api.permissions.v0.PermissionCheckEvent;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public interface Permissions {
    @NotNull
    public static TriState getPermissionValue(@NotNull class_2172 source, @NotNull String permission) {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(permission, "permission");
        return ((PermissionCheckEvent)PermissionCheckEvent.EVENT.invoker()).onPermissionCheck(source, permission);
    }

    public static boolean check(@NotNull class_2172 source, @NotNull String permission, boolean defaultValue) {
        return Permissions.getPermissionValue(source, permission).orElse(defaultValue);
    }

    public static boolean check(@NotNull class_2172 source, @NotNull String permission, int defaultRequiredLevel) {
        return Permissions.getPermissionValue(source, permission).orElseGet(() -> source.method_9259(defaultRequiredLevel));
    }

    public static boolean check(@NotNull class_2172 source, @NotNull String permission) {
        return Permissions.getPermissionValue(source, permission).orElse(false);
    }

    @NotNull
    public static Predicate<class_2168> require(@NotNull String permission, boolean defaultValue) {
        Objects.requireNonNull(permission, "permission");
        return player -> Permissions.check((class_2172)player, permission, defaultValue);
    }

    @NotNull
    public static Predicate<class_2168> require(@NotNull String permission, int defaultRequiredLevel) {
        Objects.requireNonNull(permission, "permission");
        return player -> Permissions.check((class_2172)player, permission, defaultRequiredLevel);
    }

    @NotNull
    public static Predicate<class_2168> require(@NotNull String permission) {
        Objects.requireNonNull(permission, "permission");
        return player -> Permissions.check((class_2172)player, permission);
    }

    @NotNull
    public static TriState getPermissionValue(@NotNull class_1297 entity, @NotNull String permission) {
        Objects.requireNonNull(entity, "entity");
        return Permissions.getPermissionValue((class_2172)entity.method_5671(entity.method_37908() instanceof class_3218 ? (class_3218)entity.method_37908() : null), permission);
    }

    public static boolean check(@NotNull class_1297 entity, @NotNull String permission, boolean defaultValue) {
        Objects.requireNonNull(entity, "entity");
        return Permissions.check((class_2172)entity.method_5671(entity.method_37908() instanceof class_3218 ? (class_3218)entity.method_37908() : null), permission, defaultValue);
    }

    public static boolean check(@NotNull class_1297 entity, @NotNull String permission, int defaultRequiredLevel) {
        Objects.requireNonNull(entity, "entity");
        return Permissions.check((class_2172)entity.method_5671(entity.method_37908() instanceof class_3218 ? (class_3218)entity.method_37908() : null), permission, defaultRequiredLevel);
    }

    public static boolean check(@NotNull class_1297 entity, @NotNull String permission) {
        Objects.requireNonNull(entity, "entity");
        return Permissions.check((class_2172)entity.method_5671(entity.method_37908() instanceof class_3218 ? (class_3218)entity.method_37908() : null), permission);
    }

    @NotNull
    public static CompletableFuture<TriState> getPermissionValue(@NotNull UUID uuid, @NotNull String permission) {
        Objects.requireNonNull(uuid, "uuid");
        Objects.requireNonNull(permission, "permission");
        return ((OfflinePermissionCheckEvent)OfflinePermissionCheckEvent.EVENT.invoker()).onPermissionCheck(uuid, permission);
    }

    public static CompletableFuture<Boolean> check(@NotNull UUID uuid, @NotNull String permission, boolean defaultValue) {
        return Permissions.getPermissionValue(uuid, permission).thenApplyAsync(state -> state.orElse(defaultValue));
    }

    public static CompletableFuture<Boolean> check(@NotNull UUID uuid, @NotNull String permission) {
        return Permissions.getPermissionValue(uuid, permission).thenApplyAsync(state -> state.orElse(false));
    }

    public static CompletableFuture<Boolean> check(@NotNull GameProfile profile, @NotNull String permission, boolean defaultValue) {
        Objects.requireNonNull(profile, "profile");
        return Permissions.check(profile.getId(), permission, defaultValue);
    }

    public static CompletableFuture<Boolean> check(@NotNull GameProfile profile, @NotNull String permission) {
        Objects.requireNonNull(profile, "profile");
        return Permissions.check(profile.getId(), permission);
    }

    public static CompletableFuture<Boolean> check(@NotNull GameProfile profile, @NotNull String permission, int defaultRequiredLevel, @NotNull MinecraftServer server) {
        Objects.requireNonNull(profile, "profile");
        Objects.requireNonNull(server, "server");
        BooleanSupplier permissionLevelCheck = () -> server.method_3835(profile) >= defaultRequiredLevel;
        return Permissions.getPermissionValue(profile.getId(), permission).thenApplyAsync(state -> state.orElseGet(permissionLevelCheck));
    }
}

