/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.molangcompiler.core.ast;

import gg.moonflower.molangcompiler.api.exception.MolangException;
import gg.moonflower.molangcompiler.core.ast.Node;
import gg.moonflower.molangcompiler.core.compiler.BytecodeCompiler;
import gg.moonflower.molangcompiler.core.compiler.MolangBytecodeEnvironment;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.MethodNode;

@ApiStatus.Internal
public record NegateNode(Node value) implements Node
{
    @Override
    public String toString() {
        return "!" + this.value;
    }

    @Override
    public boolean isConstant() {
        return this.value.isConstant();
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public float evaluate(MolangBytecodeEnvironment environment) throws MolangException {
        return this.value.evaluate(environment) == 0.0f ? 1.0f : 0.0f;
    }

    @Override
    public void writeBytecode(MethodNode method, MolangBytecodeEnvironment environment, @Nullable Label breakLabel, @Nullable Label continueLabel) throws MolangException {
        if (environment.optimize() && this.isConstant()) {
            BytecodeCompiler.writeFloatConst(method, this.evaluate(environment));
            return;
        }
        Label label_right = new Label();
        Label label_end = new Label();
        this.value.writeBytecode(method, environment, breakLabel, continueLabel);
        method.visitInsn(11);
        method.visitInsn(149);
        method.visitJumpInsn(153, label_right);
        method.visitInsn(12);
        method.visitJumpInsn(167, label_end);
        method.visitLabel(label_right);
        method.visitInsn(11);
        method.visitLabel(label_end);
    }
}

