/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.molangcompiler.api.bridge;

import java.util.function.Consumer;
import java.util.function.Supplier;

public interface MolangVariable {
    public float getValue();

    public void setValue(float var1);

    public MolangVariable copy();

    default public MolangVariable immutable() {
        return new MolangVariable(){

            @Override
            public float getValue() {
                return MolangVariable.this.getValue();
            }

            @Override
            public void setValue(float value) {
            }

            @Override
            public MolangVariable copy() {
                return this;
            }

            @Override
            public MolangVariable immutable() {
                return this;
            }

            public String toString() {
                return "ImmutableMolangVariable[value=" + this.getValue() + "]";
            }
        };
    }

    public static MolangVariable of(final Supplier<Float> getter, final Consumer<Float> setter) {
        return new MolangVariable(){

            @Override
            public float getValue() {
                return ((Float)getter.get()).floatValue();
            }

            @Override
            public void setValue(float value) {
                setter.accept(Float.valueOf(value));
            }

            @Override
            public MolangVariable copy() {
                return this;
            }

            public String toString() {
                return "DynamicMolangVariable[value=" + this.getValue() + "]";
            }
        };
    }

    public static MolangVariable create() {
        return MolangVariable.create(0.0f);
    }

    public static MolangVariable create(final float initialValue) {
        final float[] value = new float[]{initialValue};
        return new MolangVariable(){

            @Override
            public float getValue() {
                return value[0];
            }

            @Override
            public void setValue(float v) {
                value[0] = v;
            }

            @Override
            public MolangVariable copy() {
                return MolangVariable.create(initialValue);
            }

            public String toString() {
                return "MolangVariable[value=" + this.getValue() + "]";
            }
        };
    }
}

