/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.molangcompiler.api;

import gg.moonflower.molangcompiler.api.MolangEnvironment;
import gg.moonflower.molangcompiler.api.MolangExpression;
import gg.moonflower.molangcompiler.api.bridge.MolangJavaFunction;
import gg.moonflower.molangcompiler.api.bridge.MolangVariable;
import gg.moonflower.molangcompiler.api.bridge.MolangVariableProvider;
import gg.moonflower.molangcompiler.api.object.MolangObject;
import java.util.function.Supplier;

public interface MolangEnvironmentBuilder<V extends MolangEnvironment> {
    public MolangEnvironmentBuilder<V> loadLibrary(String var1, MolangObject var2);

    public MolangEnvironmentBuilder<V> unloadLibrary(String var1);

    public MolangEnvironmentBuilder<V> setQuery(String var1, MolangExpression var2);

    default public MolangEnvironmentBuilder<V> setQuery(String name, float value) {
        return this.setQuery(name, MolangExpression.of(value));
    }

    default public MolangEnvironmentBuilder<V> setQuery(String name, Supplier<Float> value) {
        return this.setQuery(name, MolangExpression.lazy(value));
    }

    default public MolangEnvironmentBuilder<V> setQuery(String name, int params, MolangJavaFunction function) {
        return this.setQuery((String)(params < 0 ? name : name + "$" + params), MolangExpression.function(params, function));
    }

    public MolangEnvironmentBuilder<V> setGlobal(String var1, MolangExpression var2);

    default public MolangEnvironmentBuilder<V> setGlobal(String name, float value) {
        return this.setGlobal(name, MolangExpression.of(value));
    }

    default public MolangEnvironmentBuilder<V> setGlobal(String name, Supplier<Float> value) {
        return this.setGlobal(name, MolangExpression.lazy(value));
    }

    default public MolangEnvironmentBuilder<V> setGlobal(String name, int params, MolangJavaFunction function) {
        return this.setGlobal((String)(params < 0 ? name : name + "$" + params), MolangExpression.function(params, function));
    }

    public MolangEnvironmentBuilder<V> setVariable(String var1, MolangExpression var2);

    default public MolangEnvironmentBuilder<V> setVariable(String name, MolangVariable value) {
        return this.setVariable(name, MolangExpression.of(value));
    }

    default public MolangEnvironmentBuilder<V> setVariable(String name, float value) {
        return this.setVariable(name, MolangExpression.of(value));
    }

    default public MolangEnvironmentBuilder<V> setVariable(String name, Supplier<Float> value) {
        return this.setVariable(name, MolangExpression.lazy(value));
    }

    public MolangEnvironmentBuilder<V> removeQuery(String var1);

    public MolangEnvironmentBuilder<V> removeGlobal(String var1);

    public MolangEnvironmentBuilder<V> removeVariable(String var1);

    public MolangEnvironmentBuilder<V> clearLibraries();

    public MolangEnvironmentBuilder<V> clearQuery();

    public MolangEnvironmentBuilder<V> clearGlobal();

    public MolangEnvironmentBuilder<V> clearVariable();

    public MolangEnvironmentBuilder<V> copy(MolangEnvironment var1);

    default public MolangEnvironmentBuilder<V> setVariables(MolangVariableProvider provider) {
        provider.addMolangVariables(new MolangVariableProvider.Context(){

            @Override
            public void addVariable(String name, MolangVariable value) {
                MolangEnvironmentBuilder.this.setVariable(name, value);
            }

            @Override
            public void addQuery(String name, MolangExpression value) {
                MolangEnvironmentBuilder.this.setQuery(name, value);
            }

            @Override
            public void addQuery(String name, float value) {
                MolangEnvironmentBuilder.this.setQuery(name, value);
            }

            @Override
            public void addQuery(String name, Supplier<Float> value) {
                MolangEnvironmentBuilder.this.setQuery(name, value);
            }

            @Override
            public void addQuery(String name, int params, MolangJavaFunction function) {
                MolangEnvironmentBuilder.this.setQuery(name, params, function);
            }

            @Override
            public void removeQuery(String name) {
                MolangEnvironmentBuilder.this.removeQuery(name);
            }

            @Override
            public void removeVariable(String name) {
                MolangEnvironmentBuilder.this.removeVariable(name);
            }
        });
        return this;
    }

    public V create();

    default public V create(float thisValue) {
        V environment = this.create();
        environment.setThisValue(thisValue);
        return environment;
    }
}

