/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.bil.util.command;

import de.tomalbrc.bil.util.command.ParsedCommand;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.jetbrains.annotations.Nullable;

public final class CommandParser {
    private static final ParsedCommand[] EMPTY_COMMAND_ARRAY = new ParsedCommand[0];

    public static ParsedCommand[] parse(String commandString) {
        return CommandParser.parse(commandString, null);
    }

    public static ParsedCommand[] parse(String commandString, @Nullable String prefix) {
        String[] commands = commandString.trim().split("(\r\n|\r|\n)", -1);
        ObjectArrayList list = new ObjectArrayList(commands.length);
        for (String command : commands) {
            String sanitized = CommandParser.sanitizeCommand(command, prefix);
            if (sanitized == null) continue;
            list.add((Object)new ParsedCommand(sanitized));
        }
        return (ParsedCommand[])list.toArray((Object[])EMPTY_COMMAND_ARRAY);
    }

    @Nullable
    private static String sanitizeCommand(String command, @Nullable String prefix) {
        if (((String)(command = ((String)command).trim())).isEmpty()) {
            return null;
        }
        if (((String)command).charAt(0) == '/' && ((String)(command = ((String)command).substring(1))).isEmpty()) {
            return null;
        }
        if (prefix != null) {
            command = prefix + (String)command;
        }
        return command;
    }
}

