/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.bil.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.Type;
import java.util.UUID;

public class CachedUuidDeserializer
implements JsonDeserializer<UUID> {
    private static final Object2ObjectOpenHashMap<String, UUID> UUID_CACHE = new Object2ObjectOpenHashMap();

    public static UUID get(String name) {
        return (UUID)UUID_CACHE.get((Object)name);
    }

    public static UUID put(String name, UUID uuid) {
        return (UUID)UUID_CACHE.put((Object)name, (Object)uuid);
    }

    public UUID deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
        String string = element.getAsString();
        UUID uuid = (UUID)UUID_CACHE.get((Object)string);
        if (uuid != null) {
            return uuid;
        }
        try {
            uuid = UUID.fromString(string);
        }
        catch (IllegalArgumentException exception) {
            uuid = UUID.randomUUID();
        }
        UUID_CACHE.put((Object)string, (Object)uuid);
        return uuid;
    }
}

