/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.bil.file.loader;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import de.tomalbrc.bil.core.model.Model;
import de.tomalbrc.bil.file.bbmodel.BbElement;
import de.tomalbrc.bil.file.bbmodel.BbFace;
import de.tomalbrc.bil.file.bbmodel.BbKeyframe;
import de.tomalbrc.bil.file.bbmodel.BbModel;
import de.tomalbrc.bil.file.bbmodel.BbOutliner;
import de.tomalbrc.bil.file.extra.BbModelUtils;
import de.tomalbrc.bil.file.extra.BbVariablePlaceholders;
import de.tomalbrc.bil.file.importer.BbModelImporter;
import de.tomalbrc.bil.file.loader.ModelLoader;
import de.tomalbrc.bil.json.BbVariablePlaceholdersDeserializer;
import de.tomalbrc.bil.json.ChildEntryDeserializer;
import de.tomalbrc.bil.json.DataPointValueDeserializer;
import de.tomalbrc.bil.json.JSON;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import net.minecraft.class_2960;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2i;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BbModelLoader
implements ModelLoader {
    protected static Gson GSON = JSON.GENERIC_BUILDER.registerTypeAdapter(BbOutliner.ChildEntry.class, (Object)new ChildEntryDeserializer()).registerTypeAdapter(BbKeyframe.DataPointValue.class, (Object)new DataPointValueDeserializer()).registerTypeAdapter(BbVariablePlaceholders.class, (Object)new BbVariablePlaceholdersDeserializer()).setLenient().create();

    private void rescaleUV(Vector2i res, BbElement element) {
        for (Map.Entry entry : element.faces.entrySet()) {
            BbFace face = (BbFace)entry.getValue();
            for (int i = 0; i < face.uv.size(); ++i) {
                face.uv.set(i, Float.valueOf(face.uv.get(i).floatValue() * 16.0f / (float)res.get(i % 2)));
            }
        }
    }

    private void inflateElement(BbElement element) {
        element.from.sub(element.inflate, element.inflate, element.inflate);
        element.to.add(element.inflate, element.inflate, element.inflate);
    }

    protected void postProcess(BbModel model) {
        for (BbElement element : model.elements) {
            if (element.type != BbElement.ElementType.CUBE) continue;
            this.rescaleUV(model.resolution, element);
            this.inflateElement(element);
            BbOutliner parent = BbModelUtils.getParent(model, element);
            if (parent == null) continue;
            element.from.sub((Vector3fc)parent.origin);
            element.to.sub((Vector3fc)parent.origin);
        }
        for (BbOutliner parent : BbModelUtils.modelOutliner(model)) {
            BbElement element;
            Vector3f min = new Vector3f();
            Vector3f max = new Vector3f();
            for (BbOutliner.ChildEntry childEntry : parent.children) {
                if (childEntry.isNode() || (element = BbModelUtils.getElement(model, childEntry.uuid)) == null || element.type != BbElement.ElementType.CUBE) continue;
                min.min((Vector3fc)element.from);
                max.max((Vector3fc)element.to);
            }
            for (BbOutliner.ChildEntry childEntry : parent.children) {
                if (childEntry.isNode() || (element = BbModelUtils.getElement(model, childEntry.uuid)) == null || element.type != BbElement.ElementType.CUBE) continue;
                Vector3f diff = min.sub((Vector3fc)max, new Vector3f()).absolute();
                float m = diff.get(diff.maxComponent());
                float scale = Math.min(1.0f, 24.0f / m);
                parent.scale = 1.0f / scale;
                element.from.mul(scale).add(8.0f, 8.0f, 8.0f);
                element.to.mul(scale).add(8.0f, 8.0f, 8.0f);
                element.origin.sub((Vector3fc)parent.origin).mul(scale).add(8.0f, 8.0f, 8.0f);
            }
        }
    }

    @Override
    public Model load(InputStream input, @NotNull String name) throws JsonParseException {
        Model model;
        InputStreamReader reader = new InputStreamReader(input);
        try {
            BbModel model2 = (BbModel)GSON.fromJson((Reader)reader, BbModel.class);
            if (!name.isEmpty()) {
                model2.modelIdentifier = name;
            }
            if (model2.modelIdentifier == null) {
                model2.modelIdentifier = model2.name;
            }
            model2.modelIdentifier = ModelLoader.normalizedModelId(model2.modelIdentifier);
            this.postProcess(model2);
            model = new BbModelImporter(model2).importModel();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable throwable3) {
                throw new JsonParseException("Failed to parse: " + name, throwable3);
            }
        }
        ((Reader)reader).close();
        return model;
    }

    @Override
    public Model loadResource(class_2960 resourceLocation) throws IllegalArgumentException, JsonParseException {
        String path = String.format("/model/%s/%s.bbmodel", resourceLocation.method_12836(), resourceLocation.method_12832());
        InputStream input = BbModelLoader.class.getResourceAsStream(path);
        if (input == null) {
            throw new IllegalArgumentException("Model doesn't exist: " + path);
        }
        return this.load(input, resourceLocation.method_12832());
    }

    public static Model load(class_2960 resourceLocation) {
        return new BbModelLoader().loadResource(resourceLocation);
    }

    public static Model load(String path) {
        Model model;
        FileInputStream input = new FileInputStream(path);
        try {
            model = new BbModelLoader().load(input, FilenameUtils.getBaseName((String)path));
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)input).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exception) {
                throw new IllegalArgumentException("Model doesn't exist: " + path);
            }
        }
        ((InputStream)input).close();
        return model;
    }
}

