/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.bil.file.importer;

import de.tomalbrc.bil.core.model.Animation;
import de.tomalbrc.bil.core.model.Frame;
import de.tomalbrc.bil.core.model.Model;
import de.tomalbrc.bil.core.model.Node;
import de.tomalbrc.bil.core.model.Pose;
import de.tomalbrc.bil.core.model.Variant;
import de.tomalbrc.bil.file.bbmodel.BbAnimation;
import de.tomalbrc.bil.file.bbmodel.BbAnimator;
import de.tomalbrc.bil.file.bbmodel.BbElement;
import de.tomalbrc.bil.file.bbmodel.BbKeyframe;
import de.tomalbrc.bil.file.bbmodel.BbModel;
import de.tomalbrc.bil.file.bbmodel.BbOutliner;
import de.tomalbrc.bil.file.bbmodel.BbTexture;
import de.tomalbrc.bil.file.extra.BbModelUtils;
import de.tomalbrc.bil.file.extra.BbResourcePackGenerator;
import de.tomalbrc.bil.file.extra.ResourcePackModel;
import de.tomalbrc.bil.file.importer.ModelImporter;
import de.tomalbrc.bil.file.importer.Sampler;
import de.tomalbrc.bil.json.CachedUuidDeserializer;
import de.tomalbrc.bil.util.command.CommandParser;
import de.tomalbrc.bil.util.command.ParsedCommand;
import gg.moonflower.molangcompiler.api.MolangEnvironment;
import gg.moonflower.molangcompiler.api.MolangRuntime;
import gg.moonflower.molangcompiler.api.exception.MolangRuntimeException;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_241;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BbModelImporter
implements ModelImporter<BbModel> {
    protected final BbModel model;

    public BbModelImporter(BbModel model) {
        this.model = model;
    }

    protected Object2ObjectOpenHashMap<UUID, Node> makeNodeMap() {
        Object2ObjectOpenHashMap nodeMap = new Object2ObjectOpenHashMap();
        ObjectArraySet textures = new ObjectArraySet();
        textures.addAll(this.model.textures);
        for (BbOutliner.ChildEntry entry : this.model.outliner) {
            if (!entry.isNode()) continue;
            this.createBones(null, null, (Collection<BbOutliner.ChildEntry>)this.model.outliner, (Object2ObjectOpenHashMap<UUID, Node>)nodeMap);
        }
        BbResourcePackGenerator.makeTextures(this.model, (Collection<BbTexture>)textures);
        return nodeMap;
    }

    protected class_2960 generateModel(BbOutliner outliner) {
        List<BbElement> elements = BbModelUtils.elementsForOutliner(this.model, outliner, BbElement.ElementType.CUBE);
        ResourcePackModel.Builder builder = new ResourcePackModel.Builder(this.model.modelIdentifier).withTextures(this.makeDefaultTextureMap()).withElements(elements).addDisplayTransform("head", ResourcePackModel.DEFAULT_TRANSFORM);
        return BbResourcePackGenerator.addItemModel(this.model, outliner.uuid.toString(), builder.build());
    }

    protected void createBones(Node parent, BbOutliner parentOutliner, Collection<BbOutliner.ChildEntry> children, Object2ObjectOpenHashMap<UUID, Node> nodeMap) {
        for (BbOutliner.ChildEntry entry : children) {
            if (!entry.isNode()) continue;
            BbOutliner outliner = entry.outliner;
            class_2960 modelPath = null;
            if (outliner.hasModel() && outliner.export && !outliner.isHitbox()) {
                modelPath = this.generateModel(outliner);
            }
            Vector3f localPos = parentOutliner != null ? outliner.origin.sub((Vector3fc)parentOutliner.origin, new Vector3f()) : new Vector3f((Vector3fc)outliner.origin);
            Quaternionf localRot = this.createQuaternion(outliner.rotation);
            Node.Transform tr = new Node.Transform(localPos.div(16.0f), localRot, outliner.scale);
            if (parent != null) {
                tr.mul(parent.transform());
            } else {
                tr.mul(new Matrix4f().rotateY((float)Math.PI));
            }
            Node node = new Node(Node.NodeType.BONE, parent, tr, outliner.name, outliner.uuid, modelPath);
            nodeMap.put((Object)outliner.uuid, (Object)node);
            List<BbElement> locatorElements = BbModelUtils.elementsForOutliner(this.model, outliner, BbElement.ElementType.LOCATOR);
            for (BbElement locator : locatorElements) {
                Vector3f localPos2 = locator.position.sub((Vector3fc)outliner.origin, new Vector3f());
                Node.Transform locatorTransform = new Node.Transform(localPos2.div(16.0f), this.createQuaternion(locator.rotation), 1.0f);
                locatorTransform.mul(node.transform());
                Node locatorNode = new Node(Node.NodeType.LOCATOR, node, locatorTransform, locator.name, locator.uuid, null);
                nodeMap.put((Object)locator.uuid, (Object)locatorNode);
            }
            this.createBones(node, outliner, outliner.children, nodeMap);
        }
    }

    protected Quaternionf createQuaternion(Vector3f eulerAngles) {
        return new Quaternionf().rotateZ((float)Math.PI / 180 * eulerAngles.z).rotateY((float)Math.PI / 180 * eulerAngles.y).rotateX((float)Math.PI / 180 * eulerAngles.x);
    }

    protected Reference2ObjectOpenHashMap<UUID, Pose> defaultPose(Object2ObjectOpenHashMap<UUID, Node> nodeMap) {
        Reference2ObjectOpenHashMap res = new Reference2ObjectOpenHashMap();
        for (Map.Entry entry : nodeMap.entrySet()) {
            Node bone = (Node)entry.getValue();
            if (bone.modelData() == null) continue;
            res.put((Object)bone.uuid(), (Object)Pose.of(bone.transform().globalTransform().scale(bone.transform().scale())));
        }
        return res;
    }

    @NotNull
    protected Reference2ObjectOpenHashMap<UUID, Variant> variants() {
        return new Reference2ObjectOpenHashMap();
    }

    protected List<Node> nodePath(Node child) {
        ObjectArrayList nodePath = new ObjectArrayList();
        while (child != null) {
            nodePath.addFirst(child);
            child = child.parent();
        }
        return nodePath;
    }

    @NotNull
    protected Reference2ObjectOpenHashMap<UUID, Pose> poses(BbAnimation animation, Object2ObjectOpenHashMap<UUID, Node> nodeMap, MolangEnvironment environment, float time) throws MolangRuntimeException {
        Reference2ObjectOpenHashMap poses = new Reference2ObjectOpenHashMap();
        for (Map.Entry entry : nodeMap.entrySet()) {
            Matrix4f matrix4f = new Matrix4f().rotateY((float)Math.PI);
            List<Node> nodePath = this.nodePath((Node)entry.getValue());
            for (Node node : nodePath) {
                BbAnimator animator = animation.animators != null ? animation.animators.get(node.uuid()) : null;
                Vector3fc origin = node.transform().origin();
                Triple triple = animator == null ? Triple.of((Object)new Vector3f(), (Object)new Vector3f(), (Object)new Vector3f(1.0f)) : Sampler.sample(animator.keyframes, this.model.animationVariablePlaceholders, environment, time);
                Quaternionf localRot = this.createQuaternion(((Vector3f)triple.getMiddle()).mul(-1.0f, -1.0f, 1.0f)).mul(node.transform().rotation());
                Vector3f localPos = ((Vector3f)triple.getLeft()).mul(-1.0f, 1.0f, 1.0f).div(16.0f).add(origin);
                matrix4f.translate((Vector3fc)localPos);
                matrix4f.rotate((Quaternionfc)localRot);
                matrix4f.scale((Vector3fc)triple.getRight());
            }
            poses.put((Object)((UUID)entry.getKey()), (Object)Pose.of(matrix4f.scale(((Node)entry.getValue()).transform().scale())));
        }
        return poses;
    }

    @Nullable
    protected Frame.Variant frameVariant(BbAnimation anim, float t) {
        return null;
    }

    @Nullable
    protected Frame.Commands frameCommands(BbAnimation anim, float t) {
        UUID effectsUUID = CachedUuidDeserializer.get("effects");
        if (effectsUUID != null && anim.animators.containsKey(effectsUUID) && anim.animators.get((Object)effectsUUID).type == BbAnimator.Type.effect) {
            BbAnimator animator = anim.animators.get(effectsUUID);
            for (BbKeyframe kf : animator.keyframes) {
                float difference = (float)class_3532.method_15386((float)(kf.time / 0.05f)) * 0.05f;
                if (difference != t || kf.channel != BbKeyframe.Channel.timeline) continue;
                String key = "script";
                String script = kf.dataPoints.getFirst().get(key).getStringValue();
                if (script.isEmpty()) continue;
                ParsedCommand[] cmds = CommandParser.parse(kf.dataPoints.getFirst().get(key).getStringValue());
                return new Frame.Commands(cmds, null);
            }
        }
        return null;
    }

    @Nullable
    protected class_3414 frameSound(BbAnimation anim, float t) {
        UUID effectsUUID = CachedUuidDeserializer.get("effects");
        if (effectsUUID != null && anim.animators.containsKey(effectsUUID) && anim.animators.get((Object)effectsUUID).type == BbAnimator.Type.effect) {
            BbAnimator animator = anim.animators.get(effectsUUID);
            for (BbKeyframe kf : animator.keyframes) {
                float difference = (float)class_3532.method_15386((float)(kf.time / 0.05f)) * 0.05f;
                if (difference != t || kf.channel != BbKeyframe.Channel.sound) continue;
                return (class_3414)((class_6880.class_6883)class_7923.field_41172.method_10223(class_2960.method_60654((String)kf.dataPoints.getFirst().get("effect").getStringValue())).orElseThrow()).comp_349();
            }
        }
        return null;
    }

    protected Animation.LoopMode convertLoopMode(BbAnimation.LoopMode loopMode) {
        return switch (loopMode) {
            default -> throw new MatchException(null, null);
            case BbAnimation.LoopMode.ONCE -> Animation.LoopMode.ONCE;
            case BbAnimation.LoopMode.HOLD -> Animation.LoopMode.HOLD;
            case BbAnimation.LoopMode.LOOP -> Animation.LoopMode.LOOP;
        };
    }

    @NotNull
    protected Object2ObjectOpenHashMap<String, Animation> animations(Object2ObjectOpenHashMap<UUID, Node> nodeMap) {
        Object2ObjectOpenHashMap res = new Object2ObjectOpenHashMap();
        float step = 0.05f;
        if (this.model.animations != null) {
            this.model.animations.forEach(anim -> {
                try {
                    int frameCount = Math.round(anim.length / step) + 1;
                    Frame[] frames = new Frame[frameCount];
                    for (int i = 0; i < frameCount; ++i) {
                        float time = (float)i * step;
                        Object env = MolangRuntime.runtime().setQuery("life_time", time).setQuery("anim_time", time).create();
                        Reference2ObjectOpenHashMap<UUID, Pose> poses = this.poses((BbAnimation)anim, nodeMap, (MolangEnvironment)env, time);
                        frames[i] = new Frame(time, poses, this.frameVariant((BbAnimation)anim, time), this.frameCommands((BbAnimation)anim, time), this.frameSound((BbAnimation)anim, time));
                    }
                    int startDelay = (int)(NumberUtils.isParsable((String)anim.startDelay) ? NumberUtils.createFloat((String)anim.startDelay).floatValue() : 0.0f);
                    int loopDelay = (int)(NumberUtils.isParsable((String)anim.loopDelay) ? NumberUtils.createFloat((String)anim.loopDelay).floatValue() : 0.0f);
                    ReferenceOpenHashSet affectedBones = new ReferenceOpenHashSet();
                    Animation animation = new Animation(frames, startDelay, loopDelay, frameCount, this.convertLoopMode(anim.loop), (ReferenceOpenHashSet<UUID>)affectedBones, false);
                    res.put((Object)anim.name, (Object)animation);
                }
                catch (MolangRuntimeException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return res;
    }

    protected Int2ObjectOpenHashMap<BbTexture> makeDefaultTextureMap() {
        Int2ObjectOpenHashMap textureMap = new Int2ObjectOpenHashMap();
        ObjectArrayList<BbTexture> textures = this.model.textures;
        int texturesSize = textures.size();
        for (int i = 0; i < texturesSize; ++i) {
            BbTexture texture = (BbTexture)textures.get(i);
            textureMap.put(i, (Object)texture);
        }
        return textureMap;
    }

    @NotNull
    private class_241 size() {
        return new class_241(0.5f, 1.0f);
    }

    @Override
    public Model importModel() {
        Object2ObjectOpenHashMap<UUID, Node> nodeMap = this.makeNodeMap();
        Reference2ObjectOpenHashMap<UUID, Pose> defaultPose = this.defaultPose(nodeMap);
        Object2ObjectOpenHashMap<String, Animation> animations = this.animations(nodeMap);
        Reference2ObjectOpenHashMap<UUID, Variant> variants = this.variants();
        return new Model(nodeMap, defaultPose, variants, animations, this.size());
    }
}

