/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.bil.file.extra;

import de.tomalbrc.bil.file.bbmodel.BbElement;
import de.tomalbrc.bil.file.bbmodel.BbFace;
import de.tomalbrc.bil.file.bbmodel.BbTexture;
import de.tomalbrc.bil.file.extra.BbResourcePackGenerator;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import org.joml.Vector3f;

public class ResourcePackModel {
    public static DisplayTransform DEFAULT_TRANSFORM = new DisplayTransform(new Vector3f(0.0f, 180.0f, 0.0f), null, null);
    private final String parent;
    private final Map<String, class_2960> textures;
    private final List<BbElement> elements;
    private final Map<String, DisplayTransform> display;

    ResourcePackModel(String parent, Map<String, class_2960> textures, List<BbElement> elements, Map<String, DisplayTransform> transformMap) {
        Object2ObjectArrayMap map;
        this.parent = parent;
        this.textures = textures;
        this.elements = elements;
        this.display = transformMap == null ? (map = new Object2ObjectArrayMap()) : transformMap;
    }

    public byte[] getBytes() {
        return BbResourcePackGenerator.gson.toJson((Object)this).getBytes(StandardCharsets.UTF_8);
    }

    public record DisplayTransform(Vector3f rotation, Vector3f translation, Vector3f scale) {
    }

    public static class Builder {
        final String modelId;
        String parent = null;
        Map<String, class_2960> textureMap = null;
        List<BbElement> elements = null;
        Map<String, DisplayTransform> transformMap = new Object2ObjectArrayMap();

        public Builder(String modelId) {
            this.modelId = modelId;
        }

        public Builder withParent(String parent) {
            this.parent = parent;
            return this;
        }

        public Builder withTextures(Int2ObjectOpenHashMap<BbTexture> intTextureMap) {
            this.textureMap = new Object2ObjectLinkedOpenHashMap();
            if (intTextureMap != null) {
                for (Int2ObjectMap.Entry entry : intTextureMap.int2ObjectEntrySet()) {
                    String pngSuffix = ((BbTexture)entry.getValue()).name.endsWith(".png") ? ((BbTexture)entry.getValue()).name.substring(0, ((BbTexture)entry.getValue()).name.length() - 4) : ((BbTexture)entry.getValue()).name;
                    this.textureMap.put(String.valueOf(entry.getIntKey()), class_2960.method_60655((String)"bil", (String)("item/" + this.modelId + "/" + pngSuffix)));
                }
            }
            return this;
        }

        public Builder withElements(List<BbElement> elements) {
            this.elements = elements;
            return this;
        }

        public Builder addDisplayTransform(String transformName, DisplayTransform transform) {
            this.transformMap.put(transformName, transform);
            return this;
        }

        public ResourcePackModel build() {
            Object2ObjectLinkedOpenHashMap optimizedTextureMap = new Object2ObjectLinkedOpenHashMap();
            if (this.elements != null) {
                for (BbElement element : this.elements) {
                    for (Map.Entry bbFaceEntry : element.faces.entrySet()) {
                        String n = String.valueOf(((BbFace)bbFaceEntry.getValue()).texture);
                        optimizedTextureMap.put(n, this.textureMap.get(n));
                    }
                }
            }
            return new ResourcePackModel(this.parent, (Map<String, class_2960>)optimizedTextureMap, this.elements, this.transformMap);
        }
    }
}

