/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.bil.core.model;

import com.mojang.brigadier.CommandDispatcher;
import de.tomalbrc.bil.core.holder.base.AbstractAnimationHolder;
import de.tomalbrc.bil.core.model.Pose;
import de.tomalbrc.bil.util.command.ParsedCommand;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;

public record Frame(float time, Reference2ObjectOpenHashMap<UUID, Pose> poses, @Nullable Variant variant, @Nullable Commands commands, @Nullable class_3414 soundEffect) {
    public boolean requiresUpdates() {
        return this.variant != null || this.commands != null || this.soundEffect != null;
    }

    public void runEffects(AbstractAnimationHolder holder) {
        CommandDispatcher dispatcher = holder.getServer().method_3734().method_9235();
        class_2168 source = holder.createCommandSourceStack().method_9206(2).method_9217();
        if (this.soundEffect != null) {
            class_1297 entity = source.method_9228();
            if (entity != null) {
                entity.method_43077(this.soundEffect);
            } else {
                holder.getLevel().method_8396(null, class_2338.method_49638((class_2374)source.method_9222()), this.soundEffect, class_3419.field_15250, 1.0f, 1.0f);
            }
        }
        if (this.variant != null && Frame.satisfiesConditions(this.variant.conditions, (CommandDispatcher<class_2168>)dispatcher, source)) {
            holder.getVariantController().setVariant(this.variant.uuid);
        }
        if (this.commands != null && this.commands.commands.length > 0 && Frame.satisfiesConditions(this.commands.conditions, (CommandDispatcher<class_2168>)dispatcher, source)) {
            for (ParsedCommand command : this.commands.commands) {
                command.execute((CommandDispatcher<class_2168>)dispatcher, source);
            }
        }
    }

    private static boolean satisfiesConditions(ParsedCommand[] conditions, CommandDispatcher<class_2168> dispatcher, class_2168 source) {
        if (conditions != null) {
            for (ParsedCommand condition : conditions) {
                if (condition.execute(dispatcher, source) > 0) continue;
                return false;
            }
        }
        return true;
    }

    public record Variant(UUID uuid, @Nullable ParsedCommand[] conditions) {
    }

    public record Commands(ParsedCommand[] commands, @Nullable ParsedCommand[] conditions) {
    }
}

