/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.bil.core.holder.base;

import de.tomalbrc.bil.util.IChunkMap;
import de.tomalbrc.bil.util.Utils;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_3218;
import net.minecraft.class_3244;
import net.minecraft.class_8609;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractElementHolder
extends ElementHolder {
    protected final class_3218 level;
    private class_3244[] watchingPlayers;
    private boolean elementsInitialized;
    private boolean isDataLoaded;

    protected AbstractElementHolder(class_3218 level) {
        this.level = level;
        this.watchingPlayers = Utils.EMPTY_CONNECTION_ARRAY;
    }

    protected abstract void initializeElements();

    protected abstract void onAsyncTick();

    protected abstract void onDataLoaded();

    protected abstract boolean shouldSkipTick();

    public void setAttachment(@Nullable HolderAttachment attachment) {
        if (attachment != null && !this.elementsInitialized) {
            this.elementsInitialized = true;
            this.initializeElements();
        }
        super.setAttachment(attachment);
    }

    public boolean startWatching(class_3244 player) {
        if (!this.isDataLoaded) {
            this.isDataLoaded = true;
            this.onDataLoaded();
        }
        return super.startWatching(player);
    }

    public final void tick() {
        if (this.getAttachment() == null || this.shouldSkipTick()) {
            return;
        }
        this.onTick();
        this.updatePosition();
        IChunkMap.scheduleAsyncTick(this);
    }

    public final void asyncTick() {
        this.watchingPlayers = this.getWatchingPlayers().toArray(this.watchingPlayers);
        this.onAsyncTick();
        for (VirtualElement element : this.getElements()) {
            element.tick();
        }
    }

    public void sendPacket(class_2596<? extends class_2602> packet) {
        if (this.getServer().method_18854()) {
            super.sendPacket(packet);
        } else {
            for (class_3244 conn : this.watchingPlayers) {
                if (conn == null) continue;
                Utils.sendPacketNoFlush((class_8609)conn, packet);
            }
        }
    }

    public class_3218 getLevel() {
        return this.level;
    }

    public MinecraftServer getServer() {
        return this.level.method_8503();
    }
}

