/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.common.world.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import mekanism.additions.common.config.AdditionsConfig;
import mekanism.additions.common.config.MekanismAdditionsConfig;
import mekanism.additions.common.entity.baby.BabyType;
import mekanism.additions.common.registries.AdditionsBiomeModifierSerializers;
import mekanism.common.Mekanism;
import mekanism.common.util.RegistryUtils;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.MobSpawnSettingsBuilder;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.registries.ForgeRegistries;

public record BabyEntitySpawnBiomeModifier(BabyType babyType, AdditionsConfig.SpawnConfig spawnConfig) implements BiomeModifier
{
    public BabyEntitySpawnBiomeModifier(BabyType babyType) {
        this(babyType, MekanismAdditionsConfig.additions.getConfig(babyType));
    }

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.REMOVE && this.spawnConfig.shouldSpawn.get()) {
            ResourceLocation biomeName = ForgeRegistries.BIOMES.getKey((Object)((Biome)biome.get()));
            if (!((List)this.spawnConfig.biomeBlackList.get()).contains(biomeName)) {
                EntityType parent = this.spawnConfig.parentTypeProvider.getEntityType();
                MobSpawnSettingsBuilder mobSpawnSettings = builder.getMobSpawnSettings();
                List monsterSpawns = mobSpawnSettings.getSpawner(MobCategory.MONSTER);
                for (MobSpawnSettings.SpawnerData spawner : this.spawnConfig.getSpawnersToAdd(monsterSpawns)) {
                    mobSpawnSettings.m_48376_(MobCategory.MONSTER, spawner);
                    MobSpawnSettings.MobSpawnCost parentCost = mobSpawnSettings.getCost(parent);
                    if (parentCost == null) {
                        Mekanism.logger.debug("Adding spawn rate for '{}' in biome '{}', with weight: {}, minSize: {}, maxSize: {}", new Object[]{RegistryUtils.getName((EntityType)spawner.f_48404_), biomeName, spawner.m_142631_(), spawner.f_48405_, spawner.f_48406_});
                        continue;
                    }
                    double spawnCostPerEntity = parentCost.f_48386_() * this.spawnConfig.spawnCostPerEntityPercentage.get();
                    double maxSpawnCost = parentCost.f_48385_() * this.spawnConfig.maxSpawnCostPercentage.get();
                    mobSpawnSettings.m_48370_(spawner.f_48404_, spawnCostPerEntity, maxSpawnCost);
                    Mekanism.logger.debug("Adding spawn rate for '{}' in biome '{}', with weight: {}, minSize: {}, maxSize: {}, spawnCostPerEntity: {}, maxSpawnCost: {}", new Object[]{RegistryUtils.getName((EntityType)spawner.f_48404_), biomeName, spawner.m_142631_(), spawner.f_48405_, spawner.f_48406_, spawnCostPerEntity, maxSpawnCost});
                }
            }
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)AdditionsBiomeModifierSerializers.SPAWN_BABIES.get();
    }

    public static Codec<BabyEntitySpawnBiomeModifier> makeCodec() {
        return RecordCodecBuilder.create(builder -> builder.group((App)BabyType.CODEC.fieldOf("babyType").forGetter(BabyEntitySpawnBiomeModifier::babyType)).apply((Applicative)builder, BabyEntitySpawnBiomeModifier::new));
    }
}

