/*
 * Decompiled with CFR 0.152.
 */
package me.cg360.mod.bridging.raytrace;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import me.cg360.mod.bridging.BridgingMod;
import me.cg360.mod.bridging.util.GameSupport;
import me.cg360.mod.bridging.util.Path;
import me.cg360.mod.bridging.util.PlacementAxisMode;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class PathTraversalHandler {
    private static final float MIN_DISTANCE = 1.0f;
    private static final double DIRECTION_SIMILARITY_THRESHOLD = 0.1;

    public static Tuple<BlockPos, Direction> getClosestAssistTarget(Player player) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return null;
        }
        List<BlockPos> path = PathTraversalHandler.getViewBlockPath(player);
        Vec3 viewDirection = player.m_20252_(1.0f);
        List<Direction> validSides = PathTraversalHandler.getValidAssistSides(viewDirection);
        Direction validDirection = null;
        BlockPos validPos = null;
        for (BlockPos pos : path) {
            Optional<Direction> firstValidDirection;
            if (!PathTraversalHandler.isBridgingPlacementAllowedAt(pos)) continue;
            Vec3 collideMin = Vec3.m_82528_((Vec3i)pos);
            Vec3 collideMax = Vec3.m_272021_((Vec3i)pos, (double)1.0, (double)1.0, (double)1.0);
            if (player.m_20191_().m_82335_(collideMin, collideMax) || (firstValidDirection = validSides.stream().filter(dir -> PathTraversalHandler.canSideBeBuiltOffOf(pos, dir)).findFirst()).isEmpty()) continue;
            validDirection = firstValidDirection.get();
            validPos = pos;
            break;
        }
        if (validDirection == null || validPos == null) {
            return null;
        }
        return new Tuple(validPos, validDirection);
    }

    public static List<BlockPos> getViewBlockPath(Player player) {
        if (player == null) {
            return new ArrayList<BlockPos>();
        }
        float eyeOffset = player.m_20236_(player.m_20089_());
        Vec3 viewOrigin = player.m_20182_().m_82520_(0.0, (double)eyeOffset, 0.0);
        Vec3 viewDirection = player.m_20252_(1.0f);
        Vec3 nearVec = viewDirection.m_82490_(1.0);
        Vec3 farVec = viewDirection.m_82490_(GameSupport.getReach());
        BlockPos startPos = BlockPos.m_274446_((Position)viewOrigin.m_82549_(nearVec));
        BlockPos endPos = BlockPos.m_274446_((Position)viewOrigin.m_82549_(farVec));
        return Path.calculateBresenhamVoxels(startPos, endPos);
    }

    private static List<Direction> getValidAssistSides(Vec3 viewDirection) {
        LinkedList<Direction> validSides = new LinkedList<Direction>();
        for (Direction direction : Direction.values()) {
            Vec3 directionNormal = Vec3.m_82528_((Vec3i)direction.m_122436_());
            double similarity = viewDirection.m_82526_(directionNormal);
            if (similarity < 0.1) continue;
            validSides.add(direction.m_122424_());
        }
        return validSides;
    }

    private static boolean canSideBeBuiltOffOf(BlockPos placementTarget, Direction checkSide) {
        PlacementAxisMode mode;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return false;
        }
        PlacementAxisMode baseMode = BridgingMod.getConfig().getSupportedBridgeAxes();
        if (GameSupport.isControllerCrouching() ? !(mode = BridgingMod.getConfig().getSupportedBridgeAxesWhenCrouched().getPlacementAxisMode(baseMode)).isDirectionEnabled(checkSide) : !baseMode.isDirectionEnabled(checkSide)) {
            return false;
        }
        BlockPos blockPlacingOffOf = placementTarget.m_121955_(checkSide.m_122436_());
        if (level.m_46859_(blockPlacingOffOf)) {
            return false;
        }
        if (level.m_8055_(blockPlacingOffOf).m_60734_() instanceof LiquidBlock) {
            return false;
        }
        return !level.m_8055_(blockPlacingOffOf).m_247087_();
    }

    private static boolean isBridgingPlacementAllowedAt(BlockPos placementTarget) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return false;
        }
        BlockState target = level.m_8055_(placementTarget);
        return BridgingMod.getConfig().isNonSolidReplaceEnabled() ? target.m_247087_() : target.m_60795_();
    }
}

