/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.utils.mode;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.silentchaos512.scalinghealth.capability.DifficultySourceCapability;
import net.silentchaos512.scalinghealth.capability.IDifficultySource;
import net.silentchaos512.scalinghealth.utils.config.SHDifficulty;
import net.silentchaos512.scalinghealth.utils.mode.AreaDifficultyMode;
import net.silentchaos512.scalinghealth.utils.serialization.SerializationUtils;

public class AreaDifficultyModes {

    public static class ServerWide
    extends AreaDifficultyMode {
        public static final ServerWide INSTANCE = new ServerWide();
        public static final Codec<ServerWide> CODEC = Codec.unit((Object)INSTANCE);

        @Override
        public double getDifficulty(Level world, BlockPos pos) {
            return DifficultySourceCapability.getOverworldCap().map(IDifficultySource::getDifficulty).orElse(Float.valueOf(0.0f)).floatValue();
        }

        @Override
        public String getName() {
            return "server_wide";
        }
    }

    public static class DistanceAndTime
    extends AreaDifficultyMode {
        public static final Codec<DistanceAndTime> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Average.CODEC.fieldOf("average").forGetter(dt -> dt.time), (App)Distance.CODEC.fieldOf("distance").forGetter(dt -> dt.distance)).apply((Applicative)inst, DistanceAndTime::new));
        private final Average time;
        private final Distance distance;

        public DistanceAndTime(Average time, Distance distance) {
            this.time = time;
            this.distance = distance;
        }

        @Override
        public double getDifficulty(Level world, BlockPos pos) {
            return this.time.getDifficulty(world, pos) + this.distance.getDifficulty(world, pos);
        }

        @Override
        public String getName() {
            return "distance_and_time";
        }
    }

    public static class Distance
    extends AreaDifficultyMode {
        public static final Codec<Distance> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)SerializationUtils.positiveDouble().fieldOf("distanceFactor").forGetter(r -> r.distanceFactor), (App)Codec.BOOL.optionalFieldOf("fromOrigin", (Object)false).forGetter(a -> a.fromOrigin)).apply((Applicative)inst, Distance::new));
        private static final BlockPos ADJUSTED_ZERO = BlockPos.f_121853_.m_6630_(65);
        private final boolean fromOrigin;
        private final double distanceFactor;
        private final Supplier<BlockPos> center;
        private BlockPos worldSpawn;

        public Distance(double distanceFactor, boolean fromOrigin) {
            this.distanceFactor = distanceFactor;
            this.fromOrigin = fromOrigin;
            this.center = fromOrigin ? () -> ADJUSTED_ZERO : () -> this.worldSpawn;
        }

        @Override
        public double getDifficulty(Level world, BlockPos pos) {
            if (this.worldSpawn == null) {
                this.worldSpawn = new BlockPos(world.m_6106_().m_6789_(), world.m_6106_().m_6527_(), world.m_6106_().m_6526_());
            }
            return Math.sqrt(pos.m_123331_((Vec3i)this.center.get())) * this.distanceFactor;
        }

        @Override
        public String getName() {
            return "distance";
        }
    }

    public static class Extrema
    extends AreaDifficultyMode.RadialMode {
        public static final Codec<Extrema> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)SerializationUtils.positiveInt(64).fieldOf("radius").forGetter(AreaDifficultyMode.RadialMode::getRadius), (App)Codec.BOOL.optionalFieldOf("min", (Object)true).forGetter(a -> a.min)).apply((Applicative)inst, Extrema::new));
        private final BinaryOperator<Double> extremaFct;
        private final boolean min;

        public Extrema(int radius, boolean min) {
            super(radius);
            this.min = min;
            this.extremaFct = min ? Math::min : Math::max;
        }

        @Override
        public double getDifficulty(Level world, BlockPos pos) {
            double extrema = 0.0;
            for (Tuple<BlockPos, IDifficultySource> tuple : SHDifficulty.allPlayerSources((LevelAccessor)world, (Vec3i)pos, this.getRadius())) {
                extrema = (Double)this.extremaFct.apply(Double.valueOf(((IDifficultySource)tuple.m_14419_()).getDifficulty()), extrema);
            }
            return extrema;
        }

        @Override
        public String getName() {
            return "extrema";
        }
    }

    public static class Average
    extends AreaDifficultyMode.RadialMode {
        public static final Codec<Average> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)SerializationUtils.positiveInt(64).fieldOf("radius").forGetter(AreaDifficultyMode.RadialMode::getRadius), (App)Codec.BOOL.optionalFieldOf("weighted", (Object)true).forGetter(a -> a.weighted)).apply((Applicative)inst, Average::new));
        public final boolean weighted;

        public Average(int radius, boolean weighted) {
            super(radius);
            this.weighted = weighted;
        }

        @Override
        public double getDifficulty(Level world, BlockPos pos) {
            return this.weighted ? this.getWeightedAverage(world, pos) : this.getAverage(world, pos);
        }

        public double getAverage(Level world, BlockPos pos) {
            List<Pair<IDifficultySource, BlockPos>> sources = SHDifficulty.positionedPlayerSources((LevelAccessor)world, (Vec3i)pos, this.getRadius());
            if (sources.isEmpty()) {
                return 0.0;
            }
            return sources.stream().map(p -> Float.valueOf(((IDifficultySource)p.getFirst()).getDifficulty())).reduce(Float::sum).orElse(Float.valueOf(0.0f)).floatValue() / (float)sources.size();
        }

        public double getWeightedAverage(Level world, BlockPos pos) {
            double total = 0.0;
            int totalWeight = 0;
            int rSq = this.getRadius() * this.getRadius();
            for (Pair<IDifficultySource, BlockPos> p : SHDifficulty.positionedPlayerSources((LevelAccessor)world, (Vec3i)pos, this.getRadius())) {
                int distanceSq = (int)pos.m_123331_((Vec3i)p.getSecond());
                int weight = 1 - distanceSq / rSq;
                total += (double)((float)weight * ((IDifficultySource)p.getFirst()).getDifficulty());
                totalWeight += weight;
            }
            return totalWeight <= 0 ? 0.0 : total / (double)totalWeight;
        }

        @Override
        public String getName() {
            return "average";
        }
    }
}

