/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.utils.config;

import net.minecraft.world.entity.player.Player;
import net.silentchaos512.scalinghealth.capability.IPlayerData;
import net.silentchaos512.scalinghealth.capability.PlayerDataCapability;
import net.silentchaos512.scalinghealth.config.EvalVars;
import net.silentchaos512.scalinghealth.resources.mechanics.PlayerMechanics;
import net.silentchaos512.scalinghealth.resources.mechanics.SHMechanics;
import net.silentchaos512.scalinghealth.utils.config.EnabledFeatures;
import net.silentchaos512.scalinghealth.utils.config.SHItems;
import net.silentchaos512.utils.MathUtils;

public final class SHPlayers {
    private SHPlayers() {
        throw new IllegalAccessError("Utility class");
    }

    private static PlayerMechanics getMechanics() {
        return SHMechanics.getMechanics().playerMechanics();
    }

    public static IPlayerData getPlayerData(Player entity) {
        return (IPlayerData)entity.getCapability(PlayerDataCapability.INSTANCE).orElseThrow(() -> new IllegalStateException("Could not access capability"));
    }

    public static int startingHealth() {
        return SHPlayers.getMechanics().startingHp;
    }

    public static int minHealth() {
        return SHPlayers.getMechanics().minHealth;
    }

    public static int maxHealth() {
        return SHPlayers.getMechanics().maxHealth;
    }

    public static int minHeartCrystals() {
        return (SHPlayers.minHealth() - SHPlayers.startingHealth()) / (2 * SHItems.heartCrystalIncreaseAmount());
    }

    public static int maxHeartCrystals() {
        if (SHPlayers.maxHealth() == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (SHPlayers.maxHealth() - SHPlayers.startingHealth()) / (2 * SHItems.heartCrystalIncreaseAmount());
    }

    public static double maxAttackDamage() {
        return SHPlayers.getMechanics().maxAttackDamage;
    }

    public static int maxPowerCrystals() {
        return (int)((SHPlayers.maxAttackDamage() - 1.0) / SHItems.powerCrystalIncreaseAmount());
    }

    public static int clampExtraHearts(int value) {
        return MathUtils.clamp((int)value, (int)((SHPlayers.minHealth() - SHPlayers.startingHealth()) / 2), (int)((SHPlayers.maxHealth() - SHPlayers.startingHealth()) / 2));
    }

    public static int clampedHpFromHeartCrystals(int crystals) {
        int clampedCrystals = MathUtils.clamp((int)crystals, (int)SHPlayers.minHeartCrystals(), (int)SHPlayers.maxHeartCrystals());
        return clampedCrystals * SHItems.heartCrystalIncreaseAmount();
    }

    public static int clampPowerCrystals(int value) {
        return MathUtils.clamp((int)value, (int)0, (int)SHPlayers.maxPowerCrystals());
    }

    public static int getCrystalsAfterDeath(Player player) {
        float healthDifference = player.m_21233_() - (float)MathUtils.clamp((int)((int)EvalVars.apply(player, SHPlayers.getMechanics().healthOnDeath.get())), (int)SHPlayers.minHealth(), (int)SHPlayers.maxHealth());
        int crystalDifference = (int)healthDifference / (2 * SHItems.heartCrystalIncreaseAmount());
        return SHPlayers.getPlayerData(player).getHeartCrystals() - crystalDifference;
    }

    public static int levelsPerHp() {
        return SHPlayers.getMechanics().levelsPerHp;
    }

    public static int hpPerLevel() {
        return SHPlayers.getMechanics().hpPerLevel;
    }

    public static int fullHeartsFromXp(int levels) {
        if (SHPlayers.hpPerLevel() == 0 || SHPlayers.levelsPerHp() == 0) {
            return 0;
        }
        return EnabledFeatures.healthXpEnabled() ? levels / SHPlayers.levelsPerHp() * SHPlayers.hpPerLevel() : 0;
    }
}

