/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.utils.config;

import com.mojang.datafixers.util.Pair;
import com.udojava.evalex.Expression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.lib.util.MCMathUtils;
import net.silentchaos512.scalinghealth.capability.DifficultyAffectedCapability;
import net.silentchaos512.scalinghealth.capability.DifficultySourceCapability;
import net.silentchaos512.scalinghealth.capability.IDifficultyAffected;
import net.silentchaos512.scalinghealth.capability.IDifficultySource;
import net.silentchaos512.scalinghealth.config.EvalVars;
import net.silentchaos512.scalinghealth.resources.mechanics.DifficultyMechanics;
import net.silentchaos512.scalinghealth.resources.mechanics.SHMechanics;
import net.silentchaos512.scalinghealth.utils.EntityGroup;
import net.silentchaos512.scalinghealth.utils.mode.AreaDifficultyMode;
import net.silentchaos512.utils.MathUtils;

public final class SHDifficulty {
    private SHDifficulty() {
        throw new IllegalAccessError("Utility class");
    }

    private static DifficultyMechanics getMechanics() {
        return SHMechanics.getMechanics().difficultyMechanics();
    }

    public static IDifficultyAffected affected(ICapabilityProvider entity) {
        return (IDifficultyAffected)entity.getCapability(DifficultyAffectedCapability.INSTANCE).orElseGet(DifficultyAffectedCapability::new);
    }

    public static IDifficultySource source(ICapabilityProvider source) {
        return (IDifficultySource)source.getCapability(DifficultySourceCapability.INSTANCE).orElseGet(DifficultySourceCapability::new);
    }

    public static void setSourceDifficulty(Player player, double difficulty) {
        IDifficultySource source = SHDifficulty.source((ICapabilityProvider)player);
        if (!MathUtils.doublesEqual((double)source.getDifficulty(), (double)difficulty)) {
            source.setDifficulty((float)difficulty);
            SHDifficulty.source((ICapabilityProvider)player.m_9236_()).setDifficulty((float)difficulty);
        }
    }

    public static double getDifficultyOf(Entity entity) {
        if (entity instanceof Player) {
            return SHDifficulty.source((ICapabilityProvider)entity).getDifficulty();
        }
        return SHDifficulty.affected((ICapabilityProvider)entity).affectiveDifficulty();
    }

    public static List<Pair<IDifficultySource, BlockPos>> positionedPlayerSources(LevelAccessor world, Vec3i center, long radius) {
        return SHDifficulty.playersInRange(world, center, radius).map(player -> Pair.of((Object)SHDifficulty.source((ICapabilityProvider)player), (Object)player.m_20183_())).collect(Collectors.toList());
    }

    public static Collection<Tuple<BlockPos, IDifficultySource>> allPlayerSources(LevelAccessor world, Vec3i center, long radius) {
        ArrayList<Tuple<BlockPos, IDifficultySource>> list = new ArrayList<Tuple<BlockPos, IDifficultySource>>();
        SHDifficulty.playersInRange(world, center, radius).forEach(player -> list.add(new Tuple((Object)player.m_20183_(), (Object)SHDifficulty.source((ICapabilityProvider)player))));
        return list;
    }

    public static Stream<? extends Player> playersInRange(LevelAccessor world, Vec3i center, long radius) {
        if (radius <= 0L) {
            return world.m_6907_().stream();
        }
        return world.m_6907_().stream().filter(p -> MCMathUtils.distanceSq((Entity)p, (Vec3i)center) < (double)(radius * radius));
    }

    public static int groupSearchRadius() {
        return SHMechanics.getMechanics().difficultyMechanics().groupBonusRadius;
    }

    public static double areaDifficulty(Level world, BlockPos pos) {
        return SHDifficulty.areaDifficulty(world, pos, true);
    }

    public static double areaDifficulty(Level world, BlockPos pos, boolean groupBonus) {
        return SHDifficulty.clamp(SHDifficulty.areaMode().getDifficulty(world, pos) * SHDifficulty.locationMultiplier(world, pos) * SHDifficulty.lunarMultiplier(world) * (groupBonus ? SHDifficulty.groupMultiplier(world, pos) : 1.0));
    }

    public static double locationMultiplier(Level world, BlockPos pos) {
        Holder biome = world.m_204166_(pos);
        if (!biome.m_203633_()) {
            return 1.0;
        }
        return SHDifficulty.getMechanics().multipliers.getScale(world, (Biome)world.m_204166_(pos).m_203334_());
    }

    public static double lunarMultiplier(Level world) {
        return world.m_46472_() != Level.f_46428_ || world.m_46461_() ? 1.0 : SHDifficulty.getMechanics().multipliers.getLunarMultiplier(world.m_6042_().m_63936_(world.m_8044_()));
    }

    public static double groupMultiplier(Level world, BlockPos pos) {
        return EvalVars.apply(world, pos, null, SHDifficulty.getMechanics().groupBonus.get());
    }

    public static AreaDifficultyMode areaMode() {
        return SHDifficulty.getMechanics().mode;
    }

    public static double clamp(double difficulty) {
        return Mth.m_14008_((double)difficulty, (double)SHDifficulty.minValue(), (double)SHDifficulty.maxValue());
    }

    public static double minValue() {
        return SHDifficulty.getMechanics().minValue;
    }

    public static double maxValue() {
        return SHDifficulty.getMechanics().maxValue;
    }

    public static double changePerSecond() {
        return SHDifficulty.getMechanics().changePerSecond;
    }

    public static double idleModifier() {
        return SHDifficulty.getMechanics().idleMultiplier;
    }

    public static boolean afkMessage() {
        return SHDifficulty.getMechanics().afkMessage;
    }

    public static double timeBeforeAfk() {
        return SHDifficulty.getMechanics().timeBeforeAfk;
    }

    public static double getDifficultyAfterDeath(Player player) {
        return EvalVars.apply(player, SHDifficulty.getMechanics().mutators.onPlayerDeath().get());
    }

    public static void applyKillMutator(LivingEntity killed, Player killer) {
        if (killed instanceof Player) {
            SHDifficulty.setSourceDifficulty(killer, EvalVars.apply(killer, SHDifficulty.getMechanics().mutators.onPlayerKilled().get()));
            return;
        }
        if (SHDifficulty.affected((ICapabilityProvider)killed).isBlight()) {
            SHDifficulty.setSourceDifficulty(killer, EvalVars.apply(killer, SHDifficulty.getMechanics().mutators.onBlightKilled().get()));
        }
        for (Pair<List<ResourceLocation>, Supplier<Expression>> p : SHDifficulty.getMechanics().mutators.byEntity()) {
            if (!((List)p.getFirst()).contains(ForgeRegistries.ENTITY_TYPES.getKey((Object)killed.m_6095_()))) continue;
            SHDifficulty.setSourceDifficulty(killer, EvalVars.apply(killer, (Expression)((Supplier)p.getSecond()).get()));
            return;
        }
        if (EntityGroup.from(killed, true) == EntityGroup.PEACEFUL) {
            SHDifficulty.setSourceDifficulty(killer, EvalVars.apply(killer, SHDifficulty.getMechanics().mutators.onPeacefulKilled().get()));
        } else {
            SHDifficulty.setSourceDifficulty(killer, EvalVars.apply(killer, SHDifficulty.getMechanics().mutators.onHostileKilled().get()));
        }
    }

    public static double diffOnPlayerSleep(Player entity) {
        return EvalVars.apply(entity, SHDifficulty.getMechanics().mutators.onPlayerSleep().get());
    }

    public static boolean sleepWarningMessage() {
        return SHDifficulty.getMechanics().sleepWarningMessage;
    }

    public static List<? extends String> getDamageBlacklistedMods() {
        return SHMechanics.getMechanics().damageScalingMechanics().modBlackList;
    }
}

