/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.resources.mechanics;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.silentchaos512.scalinghealth.resources.mechanics.DamageScalingMechanics;
import net.silentchaos512.scalinghealth.resources.mechanics.DifficultyMechanics;
import net.silentchaos512.scalinghealth.resources.mechanics.ItemMechanics;
import net.silentchaos512.scalinghealth.resources.mechanics.MobMechanics;
import net.silentchaos512.scalinghealth.resources.mechanics.PlayerMechanics;
import net.silentchaos512.scalinghealth.resources.mechanics.SHMechanics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="scalinghealth")
public class SHMechanicListener
extends SimpleJsonResourceReloadListener {
    private static SHMechanicListener currentInstance = null;
    private static SHMechanicListener reloadingInstance = null;
    public static final Logger LOGGER = LogManager.getLogger((String)"SHMechanicsListener");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final String FOLDER = "sh_mechanics";
    private SHMechanics shMechanics;

    public SHMechanicListener() {
        super(GSON, FOLDER);
        if (currentInstance == null) {
            currentInstance = this;
        } else {
            reloadingInstance = this;
        }
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profiler) {
        Function<String, JsonElement> getter = file -> map.entrySet().stream().filter(e -> ((ResourceLocation)e.getKey()).m_135827_().equals("scalinghealth") && ((ResourceLocation)e.getKey()).m_135815_().equals(file)).map(Map.Entry::getValue).findAny().orElse((JsonElement)JsonNull.INSTANCE);
        PlayerMechanics player = (PlayerMechanics)PlayerMechanics.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)getter.apply("player")).getOrThrow(false, SHMechanicListener.prefix("PlayerMechanics: "));
        ItemMechanics item = (ItemMechanics)ItemMechanics.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)getter.apply("items")).getOrThrow(false, SHMechanicListener.prefix("ItemMechanics: "));
        MobMechanics mob = (MobMechanics)MobMechanics.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)getter.apply("mobs")).getOrThrow(false, SHMechanicListener.prefix("MobMechanics: "));
        DifficultyMechanics difficulty = (DifficultyMechanics)DifficultyMechanics.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)getter.apply("difficulty")).getOrThrow(false, SHMechanicListener.prefix("DifficultyMechanics: "));
        DamageScalingMechanics ds = (DamageScalingMechanics)DamageScalingMechanics.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)getter.apply("damage_scaling")).getOrThrow(false, SHMechanicListener.prefix("DamageScalingMechanics: "));
        this.shMechanics = new SHMechanics(player, item, mob, difficulty, ds);
        LOGGER.debug("Finished Parsing SH Config!");
        if (this == reloadingInstance) {
            currentInstance = this;
            reloadingInstance = null;
        }
    }

    static SHMechanics getInstance() {
        if (currentInstance == null) {
            throw new RuntimeException("Tried to access SHMechanicsListener too early!");
        }
        return SHMechanicListener.currentInstance.shMechanics;
    }

    private static Consumer<String> prefix(String pre) {
        return s -> LOGGER.error(pre + s);
    }

    @SubscribeEvent
    public static void addListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new SHMechanicListener());
    }
}

