/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.resources.mechanics;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.udojava.evalex.Expression;
import java.util.function.Supplier;
import net.silentchaos512.scalinghealth.utils.serialization.SerializationUtils;

public class PlayerMechanics {
    public static final String FILE = "player";
    public static final Codec<PlayerMechanics> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)SerializationUtils.numberConstraintCodec(SerializationUtils.positiveInt(1), "startingHealth", SerializationUtils.positiveInt(1), "minHealth", SerializationUtils.positiveInt(), "maxHealth").forGetter(p -> new SerializationUtils.NumberConstraint<Integer, Integer, Integer>(p.startingHp, p.minHealth, p.maxHealth)), (App)SerializationUtils.EXPRESSION_CODEC.fieldOf("setOnDeath").forGetter(p -> p.healthOnDeath), (App)SerializationUtils.positiveDouble().fieldOf("maxAttackDamage").forGetter(p -> p.maxAttackDamage), (App)SerializationUtils.positiveInt(0).fieldOf("levelsPerHp").forGetter(p -> p.levelsPerHp), (App)SerializationUtils.positiveInt(0).fieldOf("hpPerLevel").forGetter(p -> p.hpPerLevel), (App)RegenMechanics.CODEC.fieldOf("regen").forGetter(p -> p.regenMechanics)).apply((Applicative)inst, PlayerMechanics::new));
    public final int startingHp;
    public final int minHealth;
    public final int maxHealth;
    public final Supplier<Expression> healthOnDeath;
    public final double maxAttackDamage;
    public final int levelsPerHp;
    public final int hpPerLevel;
    public final RegenMechanics regenMechanics;
    private static final RegenMechanics DEFAULT_REGEN = new RegenMechanics(20.0, 5.0, 0.1, false, 10, Integer.MAX_VALUE, 0, Integer.MAX_VALUE);
    public static final PlayerMechanics DEFAULT = new PlayerMechanics(new SerializationUtils.NumberConstraint<Integer, Integer, Integer>(20, 2, 200), () -> new Expression("maxHealth"), 50.0, 10, 1, DEFAULT_REGEN);

    private PlayerMechanics(SerializationUtils.NumberConstraint<Integer, Integer, Integer> nc, Supplier<Expression> healthOnDeath, double maxAttackDamage, int levelsPerHp, int hpPerLevel, RegenMechanics regenMechanics) {
        this.startingHp = (Integer)nc.starting;
        this.minHealth = (Integer)nc.min;
        this.maxHealth = (Integer)nc.max == 0 ? Integer.MAX_VALUE : (Integer)nc.max;
        this.healthOnDeath = healthOnDeath;
        this.maxAttackDamage = maxAttackDamage;
        this.levelsPerHp = levelsPerHp;
        this.hpPerLevel = hpPerLevel;
        this.regenMechanics = regenMechanics;
    }

    public static class RegenMechanics {
        private static final Codec<RegenMechanics> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)SerializationUtils.positiveDouble().fieldOf("initialDelay").forGetter(r -> r.initialDelay), (App)SerializationUtils.positiveDouble().fieldOf("tickDelay").forGetter(r -> r.tickDelay), (App)SerializationUtils.positiveDouble().fieldOf("exhaustion").forGetter(r -> r.exhaustion), (App)Codec.BOOL.fieldOf("proportionalToMaxHealth").forGetter(r -> r.proportionaltoMaxHp), (App)SerializationUtils.positiveInt().fieldOf("minFood").forGetter(r -> r.minFood), (App)SerializationUtils.positiveInt().fieldOf("maxFood").forGetter(r -> r.maxFood), (App)SerializationUtils.positiveInt().fieldOf("minHealth").forGetter(r -> r.regenMinHealth), (App)SerializationUtils.positiveInt().fieldOf("maxHealth").forGetter(r -> r.regenMaxHealth)).apply((Applicative)inst, RegenMechanics::new));
        public final double initialDelay;
        public final double tickDelay;
        public final double exhaustion;
        public final boolean proportionaltoMaxHp;
        public final int minFood;
        public final int maxFood;
        public final int regenMinHealth;
        public final int regenMaxHealth;

        private RegenMechanics(double initialDelay, double tickDelay, double exhaustion, boolean proportionaltoMaxHp, int minFood, int maxFood, int regenMinHealth, int regenMaxHealth) {
            this.initialDelay = initialDelay;
            this.tickDelay = tickDelay;
            this.exhaustion = exhaustion;
            this.proportionaltoMaxHp = proportionaltoMaxHp;
            this.minFood = minFood;
            this.maxFood = maxFood;
            this.regenMinHealth = regenMinHealth;
            this.regenMaxHealth = regenMaxHealth;
        }
    }
}

