/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.resources.mechanics;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.udojava.evalex.Expression;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.scalinghealth.utils.mode.AreaDifficultyMode;
import net.silentchaos512.scalinghealth.utils.mode.AreaDifficultyModes;
import net.silentchaos512.scalinghealth.utils.serialization.SerializationUtils;

public class DifficultyMechanics {
    public static final String FILE = "difficulty";
    public static final Codec<DifficultyMechanics> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)SerializationUtils.numberConstraintCodec(Codec.DOUBLE, "startingValue", Codec.DOUBLE, "minValue", Codec.DOUBLE, "maxValue").forGetter(d -> new SerializationUtils.NumberConstraint<Double, Double, Double>(d.starting, d.minValue, d.maxValue)), (App)Codec.DOUBLE.fieldOf("changePerSecond").forGetter(d -> d.changePerSecond), (App)AreaDifficultyMode.CODEC.fieldOf("mode").forGetter(d -> d.mode), (App)SerializationUtils.EXPRESSION_CODEC.fieldOf("groupBonus").forGetter(d -> d.groupBonus), (App)SerializationUtils.positiveInt().fieldOf("groupBonusRadius").forGetter(d -> d.groupBonusRadius), (App)Codec.DOUBLE.fieldOf("idleMultiplier").forGetter(d -> d.idleMultiplier), (App)Codec.BOOL.fieldOf("afkMessage").forGetter(d -> d.afkMessage), (App)Codec.INT.fieldOf("timeBeforeAfk").forGetter(d -> d.timeBeforeAfk), (App)Codec.BOOL.fieldOf("sleepWarningMessage").forGetter(d -> d.sleepWarningMessage), (App)Multipliers.CODEC.fieldOf("multipliers").forGetter(d -> d.multipliers), (App)Mutators.CODEC.fieldOf("mutators").forGetter(d -> d.mutators)).apply((Applicative)inst, DifficultyMechanics::new));
    public final double starting;
    public final double minValue;
    public final double maxValue;
    public final double changePerSecond;
    public final AreaDifficultyMode mode;
    public final Supplier<Expression> groupBonus;
    public final int groupBonusRadius;
    public final double idleMultiplier;
    public final boolean afkMessage;
    public final int timeBeforeAfk;
    public final boolean sleepWarningMessage;
    public final Multipliers multipliers;
    public final Mutators mutators;
    private static final Supplier<Expression> DEFAULT_EXPRESSION = Suppliers.memoize(() -> new Expression(FILE));
    private static final Mutators DEFAULT_MUTATORS = new Mutators(DEFAULT_EXPRESSION, DEFAULT_EXPRESSION, DEFAULT_EXPRESSION, DEFAULT_EXPRESSION, DEFAULT_EXPRESSION, DEFAULT_EXPRESSION, Collections.emptyList());
    private static final Multipliers DEFAULT_MULTIPLIERS = new Multipliers(Collections.emptyList(), Collections.emptyList());
    public static final DifficultyMechanics DEFAULT = new DifficultyMechanics(new SerializationUtils.NumberConstraint<Double, Double, Double>(0.0, 0.0, 250.0), 0.0011575, new AreaDifficultyModes.DistanceAndTime(new AreaDifficultyModes.Average(256, true), new AreaDifficultyModes.Distance(0.0025, false)), () -> new Expression("1 + 0.05 * (areaPlayerCount - 1)"), 128, 0.5, true, 120, true, DEFAULT_MULTIPLIERS, DEFAULT_MUTATORS);

    public DifficultyMechanics(SerializationUtils.NumberConstraint<Double, Double, Double> nc, double changePerSecond, AreaDifficultyMode mode, Supplier<Expression> groupBonus, int groupBonusRadius, double idleMultiplier, boolean afkMessage, int timeBeforeAfk, boolean sleepWarningMessage, Multipliers multipliers, Mutators mutators) {
        this.starting = (Double)nc.starting;
        this.minValue = (Double)nc.min;
        this.maxValue = (Double)nc.max == 0.0 ? 2.147483647E9 : (Double)nc.max;
        this.changePerSecond = changePerSecond;
        this.mode = mode;
        this.groupBonus = groupBonus;
        this.groupBonusRadius = groupBonusRadius;
        this.idleMultiplier = idleMultiplier;
        this.afkMessage = afkMessage;
        this.timeBeforeAfk = timeBeforeAfk;
        this.sleepWarningMessage = sleepWarningMessage;
        this.multipliers = multipliers;
        this.mutators = mutators;
    }

    public static class Multipliers {
        private static final Function<List<Double>, DataResult<List<Double>>> LUNAR_CYCLE = l -> {
            if (l.isEmpty()) {
                return DataResult.success(Collections.emptyList());
            }
            if (l.size() != 8) {
                return DataResult.error(() -> "Lunar cycles multiplier list must have exactly 8 entries!");
            }
            return DataResult.success((Object)l);
        };
        public static final Codec<Multipliers> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.DOUBLE.listOf().flatXmap(LUNAR_CYCLE, LUNAR_CYCLE).fieldOf("lunarMultipliers").forGetter(m -> m.lunarMultipliers), (App)Codec.mapPair((MapCodec)SerializationUtils.positiveDouble().fieldOf("scale"), (MapCodec)Codec.mapPair((MapCodec)ResourceLocation.f_135803_.listOf().optionalFieldOf("biomes", Collections.emptyList()), (MapCodec)ResourceLocation.f_135803_.listOf().optionalFieldOf("dimensions", Collections.emptyList()))).codec().listOf().fieldOf("locationMultipliers").forGetter(m -> m.locationMultipliers)).apply((Applicative)inst, Multipliers::new));
        private final List<Double> lunarMultipliers;
        private final List<Pair<Double, Pair<List<ResourceLocation>, List<ResourceLocation>>>> locationMultipliers;
        private final List<ResourceLocation> biomes;
        private final List<ResourceLocation> dimensions;
        private final Map<Pair<Level, Biome>, Double> scaleMap = new HashMap<Pair<Level, Biome>, Double>();

        public Multipliers(List<Double> lunarMultipliers, List<Pair<Double, Pair<List<ResourceLocation>, List<ResourceLocation>>>> locationMultipliers) {
            this.lunarMultipliers = lunarMultipliers;
            this.locationMultipliers = locationMultipliers;
            this.biomes = locationMultipliers.stream().flatMap(l -> ((List)((Pair)l.getSecond()).getFirst()).stream()).collect(Collectors.toList());
            this.dimensions = locationMultipliers.stream().flatMap(l -> ((List)((Pair)l.getSecond()).getSecond()).stream()).collect(Collectors.toList());
        }

        public double getLunarMultiplier(int phase) {
            return this.lunarMultipliers.isEmpty() ? 1.0 : this.lunarMultipliers.get(phase);
        }

        public double getScale(Level world, Biome biome) {
            Pair p = new Pair((Object)world, (Object)biome);
            if (this.scaleMap.containsKey(p)) {
                return this.scaleMap.get(p);
            }
            ResourceLocation dim = world.m_46472_().m_135782_();
            if (!this.dimensions.contains(dim) && !this.biomes.contains(ForgeRegistries.BIOMES.getKey((Object)biome))) {
                this.scaleMap.put((Pair<Level, Biome>)p, 1.0);
                return 1.0;
            }
            double scale = this.biomeAndDimMatch(world, biome) * this.biomeMatch(biome) * this.dimMatch(world);
            this.scaleMap.put((Pair<Level, Biome>)p, scale);
            return scale;
        }

        private double biomeAndDimMatch(Level w, Biome b) {
            ResourceLocation biome = ForgeRegistries.BIOMES.getKey((Object)b);
            ResourceLocation dim = w.m_46472_().m_135782_();
            return this.locationMultipliers.stream().filter(p -> ((List)((Pair)p.getSecond()).getFirst()).contains(biome)).filter(p -> ((List)((Pair)p.getSecond()).getSecond()).contains(dim)).map(Pair::getFirst).reduce((d1, d2) -> d1 * d2).orElse(1.0);
        }

        private double biomeMatch(Biome b) {
            ResourceLocation biome = ForgeRegistries.BIOMES.getKey((Object)b);
            return this.locationMultipliers.stream().filter(p -> ((List)((Pair)p.getSecond()).getFirst()).contains(biome)).filter(p -> ((List)((Pair)p.getSecond()).getSecond()).isEmpty()).map(Pair::getFirst).reduce((d1, d2) -> d1 * d2).orElse(1.0);
        }

        private double dimMatch(Level w) {
            ResourceLocation dim = w.m_46472_().m_135782_();
            return this.locationMultipliers.stream().filter(p -> ((List)((Pair)p.getSecond()).getSecond()).contains(dim)).filter(p -> ((List)((Pair)p.getSecond()).getFirst()).isEmpty()).map(Pair::getFirst).reduce((d1, d2) -> d1 * d2).orElse(1.0);
        }
    }

    public record Mutators(Supplier<Expression> onBlightKilled, Supplier<Expression> onHostileKilled, Supplier<Expression> onPeacefulKilled, Supplier<Expression> onPlayerKilled, Supplier<Expression> onPlayerDeath, Supplier<Expression> onPlayerSleep, List<Pair<List<ResourceLocation>, Supplier<Expression>>> byEntity) {
        private static final Function<ResourceLocation, DataResult<ResourceLocation>> ONLY_ENTITES = rl -> ForgeRegistries.ENTITY_TYPES.containsKey(rl) ? DataResult.success((Object)rl) : DataResult.error(() -> rl + " is not an entity!");
        public static final Codec<Mutators> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)SerializationUtils.EXPRESSION_CODEC.fieldOf("onBlightKilled").forGetter(m -> m.onBlightKilled), (App)SerializationUtils.EXPRESSION_CODEC.fieldOf("onHostileKilled").forGetter(m -> m.onHostileKilled), (App)SerializationUtils.EXPRESSION_CODEC.fieldOf("onPeacefulKilled").forGetter(m -> m.onPeacefulKilled), (App)SerializationUtils.EXPRESSION_CODEC.fieldOf("onPlayerKilled").forGetter(m -> m.onPlayerKilled), (App)SerializationUtils.EXPRESSION_CODEC.fieldOf("onPlayerDeath").forGetter(m -> m.onPlayerDeath), (App)SerializationUtils.EXPRESSION_CODEC.fieldOf("onPlayerSleep").forGetter(m -> m.onPlayerSleep), (App)Codec.mapPair((MapCodec)ResourceLocation.f_135803_.flatXmap(ONLY_ENTITES, ONLY_ENTITES).listOf().fieldOf("entities"), (MapCodec)SerializationUtils.EXPRESSION_CODEC.fieldOf("onKilled")).codec().listOf().fieldOf("byEntity").forGetter(m -> m.byEntity)).apply((Applicative)inst, Mutators::new));
    }
}

