/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.objects.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.silentchaos512.scalinghealth.ScalingHealth;
import net.silentchaos512.scalinghealth.capability.IPlayerData;
import net.silentchaos512.scalinghealth.capability.PetHealthCapability;
import net.silentchaos512.scalinghealth.resources.mechanics.SHMechanics;
import net.silentchaos512.scalinghealth.utils.ParticleUtils;
import net.silentchaos512.scalinghealth.utils.SoundUtils;
import net.silentchaos512.scalinghealth.utils.config.SHPlayers;

public abstract class StatBoosterItem
extends Item {
    private boolean usedForPet = false;

    public StatBoosterItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)(this.m_5524_() + ".desc")));
    }

    public Rarity m_41460_(ItemStack stack) {
        return Rarity.RARE;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand handIn) {
        ItemStack stack = player.m_21120_(handIn);
        if (this.usedForPet) {
            if (world.f_46443_) {
                this.usedForPet = false;
            }
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
        }
        boolean statIncreaseAllowed = this.isStatIncreaseAllowed(player);
        int levelRequirement = this.getLevelCost(player);
        if (player.f_36078_ < levelRequirement) {
            if (world.f_46443_) {
                String translationKey = "item.scalinghealth.stat_booster.notEnoughXP";
                player.m_213846_((Component)Component.m_237110_((String)translationKey, (Object[])new Object[]{levelRequirement}));
            }
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        if (!world.f_46443_) {
            boolean consumed = this.shouldConsume(player);
            if (consumed) {
                this.extraConsumeEffect(player);
            }
            if (!statIncreaseAllowed) {
                return this.useAsConsumable(world, player, stack, levelRequirement, consumed);
            }
            return this.useAsStatIncreaseItem(player, stack, levelRequirement);
        }
        if (this.shouldConsume(player) || this.isStatIncreaseAllowed(player)) {
            this.spawnParticlesAndPlaySound(player);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public void increasePetHp(Player player, TamableAnimal pet, ItemStack stack) {
        int levelRequirement = this.getLevelCost(player);
        if (player.f_36078_ < levelRequirement) {
            String translationKey = "item.scalinghealth.stat_booster.notEnoughXP";
            player.m_213846_((Component)Component.m_237110_((String)translationKey, (Object[])new Object[]{levelRequirement}));
            return;
        }
        this.usedForPet = true;
        pet.getCapability(PetHealthCapability.INSTANCE).ifPresent(data -> data.addHealth(SHMechanics.getMechanics().mobMechanics().pets().petsHealthCrystalGain(), pet));
        stack.m_41774_(1);
        StatBoosterItem.consumeLevels(player, levelRequirement);
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
    }

    protected abstract int getLevelCost(Player var1);

    protected abstract boolean isStatIncreaseAllowed(Player var1);

    protected abstract boolean shouldConsume(Player var1);

    protected abstract void extraConsumeEffect(Player var1);

    protected abstract void increaseStat(Player var1);

    protected abstract ParticleOptions getParticleType();

    protected abstract SoundEvent getSoundEffect();

    private InteractionResultHolder<ItemStack> useAsConsumable(Level world, Player player, ItemStack stack, int levelRequirement, boolean consumed) {
        if (consumed) {
            world.m_5594_(null, player.m_20183_(), SoundEvents.f_12321_, SoundSource.PLAYERS, 0.5f, 1.0f + 0.1f * (float)ScalingHealth.RANDOM.nextGaussian());
            stack.m_41774_(1);
            StatBoosterItem.consumeLevels(player, levelRequirement);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    private InteractionResultHolder<ItemStack> useAsStatIncreaseItem(Player player, ItemStack stack, int levelRequirement) {
        this.increaseStat(player);
        stack.m_41774_(1);
        StatBoosterItem.consumeLevels(player, levelRequirement);
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        IPlayerData.sendUpdatePacketTo(player);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    private void spawnParticlesAndPlaySound(Player player) {
        ScalingHealth.LOGGER.debug("StatBoosterItem effect!");
        ParticleUtils.spawn(this.getParticleType(), 40, (LivingEntity)player);
        SoundUtils.play(player, this.getSoundEffect());
    }

    private static void consumeLevels(Player player, int amount) {
        player.m_6749_(-amount);
        SHPlayers.getPlayerData(player).updateStats(player);
    }
}

