/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.objects.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.silentchaos512.scalinghealth.ScalingHealth;
import net.silentchaos512.scalinghealth.capability.IDifficultySource;
import net.silentchaos512.scalinghealth.objects.Registration;
import net.silentchaos512.scalinghealth.utils.ParticleUtils;
import net.silentchaos512.scalinghealth.utils.SoundUtils;
import net.silentchaos512.scalinghealth.utils.config.EnabledFeatures;
import net.silentchaos512.scalinghealth.utils.config.SHDifficulty;
import net.silentchaos512.scalinghealth.utils.config.SHItems;

public class DifficultyMutatorItem
extends Item {
    private final Type type;

    public DifficultyMutatorItem(Type type, Item.Properties properties) {
        super(properties);
        this.type = type;
    }

    private double getEffectAmount(@Nullable Level world) {
        if (world == null) {
            return 0.0;
        }
        switch (this.type) {
            case CURSED: {
                return SHItems.cursedHeartAffectAmount();
            }
            case ENCHANTED: {
                return SHItems.enchantedHeartAffectAmount();
            }
            case CHANCE: {
                int max = SHItems.chanceHeartAffectAmount();
                int v = (int)(Math.random() * (double)(max * 2 + 1) - (double)max);
                if (v == 0) {
                    return -max;
                }
                if (v > 0 && v != max) {
                    return -v;
                }
                return v;
            }
        }
        ScalingHealth.LOGGER.error("DifficultyMutatorItem invalid type: {}", (Object)this.type);
        return 0.0;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        double amount = this.getEffectAmount(world);
        if (this.type != Type.CHANCE) {
            String amountStr = (amount > 0.0 ? "+" : "") + String.format("%.1f", amount);
            list.add((Component)Component.m_237110_((String)"item.scalinghealth.difficulty_changer.effectDesc", (Object[])new Object[]{amountStr}));
        } else {
            list.add((Component)Component.m_237110_((String)"item.scalinghealth.difficulty_changer.effectDesc", (Object[])new Object[]{"?"}));
        }
    }

    public Rarity m_41460_(ItemStack stack) {
        return Rarity.EPIC;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!EnabledFeatures.difficultyEnabled()) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
        }
        IDifficultySource source = SHDifficulty.source((ICapabilityProvider)player);
        float change = (float)this.getEffectAmount(world);
        if (!world.f_46443_) {
            source.addDifficulty(change);
            stack.m_41774_(1);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        }
        switch (this.type) {
            case ENCHANTED: {
                this.enchantedHeartEffects(world, player);
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
            }
            case CURSED: {
                this.cursedHeartEffects(world, player);
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
            }
            case CHANCE: {
                this.chanceHeartEffects(world, player, (int)change);
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
            }
        }
        ScalingHealth.LOGGER.error("DifficultyMutatorItem invalid type: {}", (Object)this.type);
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    private void cursedHeartEffects(Level world, Player player) {
        if (world.f_46443_) {
            ParticleUtils.spawn((ParticleOptions)Registration.CURSED_HEART_PARTICLE.get(), 40, (LivingEntity)player);
            SoundUtils.play(player, (SoundEvent)Registration.CURSED_HEART_USE.get());
        }
    }

    private void enchantedHeartEffects(Level world, Player player) {
        if (world.f_46443_) {
            ParticleUtils.spawn((ParticleOptions)Registration.ENCHANTED_HEART_PARTICLE.get(), 40, (LivingEntity)player);
            SoundUtils.play(player, (SoundEvent)Registration.ENCHANTED_HEART_USE.get());
        }
    }

    private void chanceHeartEffects(Level world, Player player, int diffChange) {
        int max = SHItems.chanceHeartAffectAmount();
        if (diffChange == max) {
            this.cursedHeartEffects(world, player);
        } else if (diffChange == -max) {
            this.enchantedHeartEffects(world, player);
        } else {
            SoundUtils.play(player, (SoundEvent)Registration.ENCHANTED_HEART_USE.get());
            ParticleUtils.spawn((ParticleOptions)Registration.ENCHANTED_HEART_PARTICLE.get(), 40 * -diffChange / max, (LivingEntity)player);
        }
    }

    public static enum Type {
        ENCHANTED,
        CURSED,
        CHANCE;

    }
}

