/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.loot.conditions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.silentchaos512.scalinghealth.capability.IDifficultyAffected;
import net.silentchaos512.scalinghealth.objects.Registration;
import net.silentchaos512.scalinghealth.utils.config.SHDifficulty;

public class SHMobProperties
implements LootItemCondition {
    public static final ResourceLocation NAME = new ResourceLocation("scalinghealth", "mob_properties");
    private final LootContext.EntityTarget target;
    private final boolean isBlight;
    private final float minDifficulty;
    private final float maxDifficulty;

    public SHMobProperties(LootContext.EntityTarget target, boolean isBlight, float minDifficulty, float maxDifficulty) {
        this.target = target;
        this.isBlight = isBlight;
        this.minDifficulty = minDifficulty;
        this.maxDifficulty = maxDifficulty;
    }

    public static LootItemCondition.Builder builder(LootContext.EntityTarget target, boolean isBlight, float minDifficulty, float maxDifficulty) {
        return () -> new SHMobProperties(target, isBlight, minDifficulty, maxDifficulty);
    }

    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)Registration.MOB_PROPERTIES.get();
    }

    public boolean test(LootContext lootContext) {
        Entity entity = (Entity)lootContext.m_78953_(this.target.m_79003_());
        if (entity instanceof Mob) {
            IDifficultyAffected affected = SHDifficulty.affected((ICapabilityProvider)entity);
            float difficulty = affected.getDifficulty();
            return difficulty >= this.minDifficulty && difficulty <= this.maxDifficulty && (!this.isBlight || affected.isBlight());
        }
        return false;
    }

    public static class ThisSerializer
    implements Serializer<SHMobProperties> {
        public void serialize(JsonObject json, SHMobProperties value, JsonSerializationContext context) {
            json.add("entity", context.serialize((Object)value.target));
            json.addProperty("is_blight", Boolean.valueOf(value.isBlight));
            JsonObject difficultyObj = new JsonObject();
            difficultyObj.addProperty("min", (Number)Float.valueOf(value.minDifficulty));
            difficultyObj.addProperty("max", (Number)Float.valueOf(value.maxDifficulty));
            json.add("difficulty", (JsonElement)difficultyObj);
        }

        public SHMobProperties deserialize(JsonObject json, JsonDeserializationContext context) {
            LootContext.EntityTarget target = (LootContext.EntityTarget)GsonHelper.m_13836_((JsonObject)json, (String)"entity", (JsonDeserializationContext)context, LootContext.EntityTarget.class);
            boolean isBlight = GsonHelper.m_13855_((JsonObject)json, (String)"is_blight", (boolean)false);
            float minDifficulty = 0.0f;
            float maxDifficulty = Float.MAX_VALUE;
            if (json.has("difficulty")) {
                JsonElement difficulty = json.get("difficulty");
                if (difficulty.isJsonObject()) {
                    JsonObject jsonObject = difficulty.getAsJsonObject();
                    minDifficulty = GsonHelper.m_13820_((JsonObject)jsonObject, (String)"min", (float)minDifficulty);
                    maxDifficulty = GsonHelper.m_13820_((JsonObject)jsonObject, (String)"max", (float)maxDifficulty);
                } else {
                    minDifficulty = maxDifficulty = difficulty.getAsFloat();
                }
            }
            return new SHMobProperties(target, isBlight, minDifficulty, maxDifficulty);
        }
    }
}

