/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.event;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;
import net.silentchaos512.scalinghealth.ScalingHealth;
import net.silentchaos512.scalinghealth.network.ClientBlightMessage;
import net.silentchaos512.scalinghealth.network.Network;
import net.silentchaos512.scalinghealth.resources.mechanics.SHMechanics;
import net.silentchaos512.scalinghealth.utils.config.SHDifficulty;
import net.silentchaos512.scalinghealth.utils.config.SHMobs;

@Mod.EventBusSubscriber(modid="scalinghealth")
public final class BlightHandler {
    private BlightHandler() {
    }

    public static void applyBlightPotionEffects(Mob entity) {
        SHMechanics.getMechanics().mobMechanics().blight().blightEffects().forEach(e -> e.apply((LivingEntity)entity, SHDifficulty.getDifficultyOf((Entity)entity)));
    }

    private static void notifyPlayers(Component deathMessage, Mob blight, Player slayer) {
        ComponentContents componentContents = deathMessage.m_214077_();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents original = (TranslatableContents)componentContents;
            MutableComponent s = Component.m_237113_((String)("Blight " + blight.m_7755_().getString()));
            s.m_7383_().m_131140_(ChatFormatting.DARK_PURPLE);
            MutableComponent newMessage = Component.m_237110_((String)original.m_237508_(), (Object[])new Object[]{s});
            MutableComponent almostFinalMessage = Component.m_237113_((String)newMessage.getString());
            String message = newMessage.getString();
            if (message.contains("drowned")) {
                almostFinalMessage = message.startsWith("Blight Squid") ? Component.m_237113_((String)(almostFinalMessage.getString() + "... again")) : Component.m_237113_((String)(almostFinalMessage.getString() + "... gg"));
            } else if (message.contains("suffocated in a wall")) {
                almostFinalMessage = Component.m_237113_((String)(almostFinalMessage.getString() + " *slow clap*"));
            }
            MutableComponent finalMessage = almostFinalMessage;
            if (slayer != null) {
                finalMessage = almostFinalMessage.getString().contains("  ") ? Component.m_237113_((String)almostFinalMessage.getString().replace("  ", " " + slayer.m_7755_().getString() + " ")) : Component.m_237113_((String)(almostFinalMessage.getString() + slayer.m_7755_().getString()));
            }
            for (Player p : blight.m_9236_().m_6907_()) {
                p.m_213846_((Component)finalMessage);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBlightKilled(LivingDeathEvent event) {
        boolean isTamedAnimal;
        if (!(event.getEntity() instanceof Mob)) {
            return;
        }
        Mob blight = (Mob)event.getEntity();
        if (event.getSource() == null || !SHMobs.isBlight(blight) || event.getEntity().m_9236_().f_46443_) {
            return;
        }
        Entity entitySource = event.getSource().m_7639_();
        boolean bl = isTamedAnimal = entitySource instanceof TamableAnimal && ((TamableAnimal)entitySource).m_21824_();
        if (entitySource instanceof Player || isTamedAnimal) {
            Player actualKiller;
            Player player;
            if (isTamedAnimal) {
                player = (Player)((TamableAnimal)entitySource).m_269323_();
                actualKiller = (Mob)entitySource;
            } else {
                actualKiller = player = (Player)entitySource;
            }
            if (SHMobs.notifyBlightDeath() && player != null) {
                ScalingHealth.LOGGER.info("Blight {} was killed by {}", (Object)blight.m_7755_().getString(), (Object)actualKiller.m_7755_().getString());
                BlightHandler.notifyPlayers(event.getSource().m_6157_((LivingEntity)blight), blight, player);
            }
        } else {
            if (SHMobs.notifyBlightDeath()) {
                ScalingHealth.LOGGER.info("Blight {} has died", (Object)blight.m_7755_().getString());
            }
            BlightHandler.notifyPlayers(event.getSource().m_6157_((LivingEntity)blight), blight, null);
        }
    }

    @SubscribeEvent
    public static void startTrackingBlight(PlayerEvent.StartTracking event) {
        Mob mob;
        if (event.getTarget() instanceof Mob && SHDifficulty.affected((ICapabilityProvider)(mob = (Mob)event.getTarget())).isBlight()) {
            ServerPlayer sp = (ServerPlayer)event.getEntity();
            ClientBlightMessage msg = new ClientBlightMessage(mob.m_19879_());
            Network.channel.sendTo((Object)msg, sp.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    @SubscribeEvent
    public static void onBlightUpdate(LivingEvent.LivingTickEvent event) {
        LivingEntity blight = event.getEntity();
        if (!blight.m_9236_().f_46443_ && blight instanceof Mob && SHMobs.isBlight((Mob)blight) && blight.m_9236_().m_46467_() % 1000L == 0L) {
            BlightHandler.applyBlightPotionEffects((Mob)blight);
        }
    }
}

